// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_FloatingPointLiteral64.cc,v 1.2 1999/03/09 20:54:34 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_FloatingPointLiteral64.hh"
#include "IIR_FloatingSubtypeDefinition.hh"

IIRScram_FloatingPointLiteral64::~IIRScram_FloatingPointLiteral64() {}

void 
IIRScram_FloatingPointLiteral64::_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << value();
}


void 
IIRScram_FloatingPointLiteral64::_publish_cc() {
  _get_subtype()->_publish_cc_type_name();
  _cc_out << "(ObjectBase::VARIABLE,";
  _publish_cc_universal_value();
  _get_subtype()->_publish_cc_object_type_info();
  _cc_out << ")";
}

void
IIRScram_FloatingPointLiteral64::_publish_cc_universal_value() {
  _cc_out << "UniversalReal(" << value() << ")";
}

