#ifndef IIRSCRAM_FLOATING_POINT_LITERAL_HH
#define IIRSCRAM_FLOATING_POINT_LITERAL_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_FloatingPointLiteral.hh,v 1.2 1999/03/09 20:54:32 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_FloatingPointLiteral.hh"
template <class type> class set;
class IIR_TypeDefinition;

class IIRScram_FloatingPointLiteral : public IIRBase_FloatingPointLiteral {

public:
  void _publish_vhdl(ostream &);

  void _publish_cc();
  void _publish_cc_bounds();
  void _publish_cc_data();
  void _publish_cc_value();
  void _publish_cc_universal_value();
  void _publish_cc_initialization_value();
  void _publish_cc_elaborate();
  void _publish_cc_state_object_init();
  void _publish_cc_headers();

  void _type_check( set<IIR_TypeDefinition> * );
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)()=0);

  ostream &_print( ostream & );
  IIR_Boolean _is_floating_literal() { return TRUE; }
  IIR_Boolean _is_negative();
  IIR_Char* print(IIR_Int32);
  IIR_FP64 _get_value();
  IIR *_clone() { return this; }

protected:
  IIRScram_FloatingPointLiteral() {}
  virtual ~IIRScram_FloatingPointLiteral() = 0;
    
private:
};
#endif
