// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Radharamanan Radhakrishnan ramanan@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_EventAttribute.cc,v 1.4 1999/10/28 03:24:06 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_EventAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_EnumerationTypeDefinition.hh"
#include "StandardPackage.hh"

IIRScram_EventAttribute::~IIRScram_EventAttribute() {}


void 
IIRScram_EventAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  ASSERT( get_prefix()->_is_resolved() == TRUE );
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'EVENT ";
}


IIR_TextLiteral *
IIRScram_EventAttribute::_build_attribute_name() {
  char *name = "event";
  return IIR_Identifier::get( name, strlen(name) );
}


// The Event attribute is a boolean function valued attribute...
IIR_TypeDefinition *
IIRScram_EventAttribute::_get_subtype(){
  return StandardPackage::boolean_type;
}

IIR_Declaration *
IIRScram_EventAttribute::_get_implicit_declaration( char *decl_name,
						    IIR_TypeDefinition *decl_type ){
  ASSERT( decl_type == StandardPackage::boolean_type );

  return (IIR_Declaration*)_build_function_declaration( decl_name, decl_type );
}


void
IIRScram_EventAttribute::_publish_cc() {
  _publish_cc_signal_attribute("Event");
}


void
IIRScram_EventAttribute::_publish_cc_necessary_decl_in_state() {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );

  IIR_Declaration* decl;
  IIR* prefix = get_prefix();

  ASSERT((prefix->_is_signal() == TRUE) ||
	 (prefix->_is_attribute() == TRUE));
  
  if(prefix->_is_signal() == TRUE) {
    decl = ((IIR_Declaration*)prefix);
  }
  else {
    decl = ((IIR_Attribute*)prefix)->_get_implicit_declaration();      
  }

  if(!prefix->_is_published_attribute_in_state(IIR_Declaration::LAST_EVENT)) {
    if(decl->_is_scalar_type() == TRUE) {
      _cc_out << "  PhysicalType ";
    }
    else {
      decl->_get_subtype()->_publish_cc();
      _cc_out << "_lastevent ";
    }
    decl->_get_declarator()->_publish_cc();
    _cc_out << "_last_event;\n";
    prefix->_add_published_attribute_in_state(IIR_Declaration::LAST_EVENT);
  }

  if(!prefix->_is_published_attribute_in_state(IIR_Declaration::EVENT)) {
    if(decl->_is_scalar_type() == TRUE) {
      _cc_out << "  EnumerationType ";
    }
    else {
      decl->_get_subtype()->_publish_cc();
      _cc_out << "_event ";
    }
    decl->_get_declarator()->_publish_cc();
    _cc_out << "_event;\n";
    prefix->_add_published_attribute_in_state(IIR_Declaration::EVENT);
  }
}


void
IIRScram_EventAttribute::_publish_cc_init_fields_for_signals() {
  IIR_Char *old_current_publish_name = _current_publish_name;
  ostrstream recordName;

  if (get_prefix()->_get_subtype()->get_kind() == IIR_RECORD_TYPE_DEFINITION) {
    recordName << *(get_prefix()->_get_declarator());
    _current_publish_name = recordName.str();
    get_prefix()->_get_subtype()->_publish_cc_init_fields_for_signals();
  }

  _current_publish_name = old_current_publish_name;
}


// Initialization value of the signal, in UserState::initstate()
void
IIRScram_EventAttribute::_publish_cc_init_val() { 
  _cc_out << "true";
}


void
IIRScram_EventAttribute::_publish_cc_name_in_caps() {
  _cc_out << "EVENT";
}


void
IIRScram_EventAttribute::_publish_cc_attrib_type() {
  _cc_out << "function";
}


void
IIRScram_EventAttribute::_publish_cc_necessary_decl_init() {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );

  get_prefix()->_publish_cc_declarator();
  _cc_out << "_last_event = PhysicalType(ObjectBase::VARIABLE, 0, "
	  << "SavanttimeType_info);\n";
}


void
IIRScram_EventAttribute::_publish_cc_elaborate() {
  get_prefix()->_publish_cc_elaborate();
  _cc_out << "_event";
}


void
IIRScram_EventAttribute::_publish_cc_sigtype() {
  _cc_out << " I_EVENT;\n";
}


void
IIRScram_EventAttribute::_publish_cc_state_object_init() {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );

  IIR_Declaration* decl;
  IIR* prefix = get_prefix();

  ASSERT((prefix->_is_signal() == TRUE) ||
	 (prefix->_is_attribute() == TRUE));
  
  if(prefix->_is_signal() == TRUE) {
    decl = ((IIR_Declaration*)prefix);
  }
  else {
    decl = ((IIR_Attribute*)prefix)->_get_implicit_declaration();      
  }

  if(!prefix->_is_published_attribute_in_constructor(IIR_Declaration::LAST_EVENT)) {
    decl->_get_declarator()->_publish_cc();
    _cc_out << "_last_event(ObjectBase::VARIABLE";
    if(decl->_is_array_type() == TRUE) {
      _cc_out << ", ";
      decl->_get_subtype()->_publish_cc_range();
    }
    _cc_out << "),\n";
    prefix->_add_published_attribute_in_constructor(IIR_Declaration::LAST_EVENT);
  }

  if(!prefix->_is_published_attribute_in_constructor(IIR_Declaration::EVENT)) {
    decl->_get_declarator()->_publish_cc();
    _cc_out << "_event(ObjectBase::VARIABLE";
    if(decl->_is_array_type() == TRUE) {
      _cc_out << ", ";
      decl->_get_subtype()->_publish_cc_range();
    }
    _cc_out << "),\n";
    prefix->_add_published_attribute_in_constructor(IIR_Declaration::EVENT);
  }
}


void
IIRScram_EventAttribute::_publish_cc_init() {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );

  IIR_Declaration* decl;
  IIR* prefix = get_prefix();

  ASSERT((prefix->_is_signal() == TRUE) ||
	 (prefix->_is_attribute() == TRUE));
  
  if(prefix->_is_signal() == TRUE) {
    decl = ((IIR_Declaration*)prefix);
  }
  else {
    decl = ((IIR_Attribute*)prefix)->_get_implicit_declaration();      
  }

  if(!prefix->_is_published_attribute_in_initstate(IIR_Declaration::LAST_EVENT)) {
    decl->_get_declarator()->_publish_cc();
    _cc_out << "_last_event = ";

    if(decl->_is_scalar_type() == TRUE) {
      _cc_out << "PhysicalType(ObjectBase::VARIABLE";
      _cc_out << ", UniversalLongLongInteger(-1)";
      _cc_out << "SavanttimeType_info); ";    
    }
    else if((decl->_is_array_type() == TRUE) || (decl->_is_record_type() == TRUE)) {
      decl->_get_subtype()->_publish_cc_type_name();
      _cc_out << "_lastevent(ObjectBase::VARIABLE";
      if(decl->_is_array_type()) {
	_cc_out << ", ";
	decl->_get_subtype()->_publish_cc_range();
      }
      _cc_out << ", 1, new ElementAssociation(Others, new PhysicalType(ObjectBase::VARIABLE, UniversalLongLongInteger(-1), SavanttimeType_info))";
      _cc_out << "); ";    
    }
    _cc_out << "\n";
    prefix->_add_published_attribute_in_initstate(IIR_Declaration::LAST_EVENT);
  }
  if(!prefix->_is_published_attribute_in_initstate(IIR_Declaration::EVENT)) {
    decl->_get_declarator()->_publish_cc();
    _cc_out << "_event = ";

    if(decl->_is_scalar_type() == TRUE) {
      _cc_out << "EnumerationType(ObjectBase::VARIABLE";
      _cc_out << ", UniversalBoolean(0), SavantbooleanType_info";
      _cc_out << "); ";
    }
    else if((decl->_is_array_type() == TRUE) || (decl->_is_record_type() == TRUE)) {
      decl->_get_subtype()->_publish_cc_type_name();
      _cc_out << "_event(ObjectBase::VARIABLE";
      if(decl->_is_array_type()) {
	_cc_out << ", ";
	decl->_get_subtype()->_publish_cc_range();
      }
      _cc_out << ", 1, new ElementAssociation(Others, new EnumerationType(ObjectBase::VARIABLE, UniversalBoolean(0), SavantbooleanType_info))";
      _cc_out << ");";
    }
    _cc_out << "\n";
    prefix->_add_published_attribute_in_initstate(IIR_Declaration::EVENT);
  }
}

void
IIRScram_EventAttribute::_publish_cc_necessary_copying() {
}

void
IIRScram_EventAttribute::_publish_cc_read_or_write(const char *, const char *){
}

IIR*
IIRScram_EventAttribute::_clone() {
  IIR_EventAttribute *clone = new IIR_EventAttribute;
  IIR_Attribute::_clone(clone);
  return clone;
}
