#ifndef IIRSCRAM_ENUMERATION_TYPE_DEFINITION_HH
#define IIRSCRAM_ENUMERATION_TYPE_DEFINITION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_EnumerationTypeDefinition.hh,v 1.3 1999/08/02 12:50:03 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_EnumerationTypeDefinition.hh"
class IIR_EnumerationTypeDefinition;

class IIRScram_EnumerationTypeDefinition : public IIRBase_EnumerationTypeDefinition {

public:
  IIR_Boolean _is_discrete_type(){ return true;  }
  IIR_Boolean _is_enumeration_type(){ return true; }
  IIR_Boolean _is_character_type();

  void _publish_vhdl_type_decl(ostream &);

  void _publish_cc_universal_type();
  void _publish_cc_kernel_type();

  virtual void _publish_cc_data_members();

  virtual void _publish_cc_decl_constructors();
  virtual void _publish_cc_type_constructors();
  virtual void _publish_cc_subtype_constructors();

  virtual void _publish_cc_decl_cc();
  virtual void _publish_cc_range();
  virtual void _publish_cc_list();
  
  void _publish_cc_type_info();
  void _publish_cc_extern_type_info();
  void _publish_cc_type_string();
  
  ostream& _print(ostream&);

  //The following function publishes the function for the
  // `IMAGE attribute for integer Type definition
  virtual void _publish_cc_attribute_image();

  //The following function publishes the function for the
  // `VALUE attribute for integer Type definition
  virtual void _publish_cc_attribute_value();

  virtual IIR_TypeDefinition *_get_new_subtype();

  virtual IIR *_clone();
  virtual void _clone( IIR_EnumerationTypeDefinition * );

  IIR_Boolean _is_iir_enumeration_type_definition(){ return TRUE; }

  set<IIR_Declaration> *_find_declarations( IIR_TextLiteral * );
  set<IIR_Declaration> *_find_declarations( IIR_Name * );

  void _come_into_scope( symbol_table *, IIR_TypeDeclaration * );
  void _come_out_of_scope( symbol_table * );

protected:
  IIRScram_EnumerationTypeDefinition() {}
  virtual ~IIRScram_EnumerationTypeDefinition() = 0;
    
private:
};
#endif


