
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_EnumerationSubtypeDefinition.cc,v 1.2 1999/03/09 20:54:19 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_EnumerationSubtypeDefinition.hh"
#include "IIR_FunctionDeclaration.hh"

IIRScram_EnumerationSubtypeDefinition::~IIRScram_EnumerationSubtypeDefinition() {}

void 
IIRScram_EnumerationSubtypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  IIR_ScalarTypeDefinition::_publish_vhdl_decl(_vhdl_out);
}

IIR_Boolean
IIRScram_EnumerationSubtypeDefinition::_is_subtype() {
  return TRUE;
}


IIR *
IIRScram_EnumerationSubtypeDefinition::_clone(){
  IIR_EnumerationSubtypeDefinition *retval = new IIR_EnumerationSubtypeDefinition();
  _clone( retval );
  return retval;
}

void 
IIRScram_EnumerationSubtypeDefinition::_clone( IIR_EnumerationSubtypeDefinition *copy_into ){
  ASSERT( copy_into->get_kind() == IIR_ENUMERATION_SUBTYPE_DEFINITION );

  copy_into->set_resolution_function( get_resolution_function() );

  IIR_EnumerationTypeDefinition::_clone( copy_into );
}
