// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_CaseStatementAlternativeByChoices.cc,v 1.2 1999/03/09 20:53:15 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_CaseStatementAlternativeByChoices.hh"
#include "IIR_ChoiceList.hh"
#include "IIR_Choice.hh"
#include "error_func.hh"
#include "set.hh"

IIRScram_CaseStatementAlternativeByChoices::~IIRScram_CaseStatementAlternativeByChoices() {}


void
IIRScram_CaseStatementAlternativeByChoices::_publish_vhdl(ostream &_vhdl_out){
  _vhdl_out << "when ";
  choices._publish_vhdl(_vhdl_out);

  if (sequence_of_statements.first() != NULL) {
    _vhdl_out << " =>\n";
    sequence_of_statements._publish_vhdl(_vhdl_out);
  }
  else {
    _vhdl_out << ",";
  }
}


void 
IIRScram_CaseStatementAlternativeByChoices::_publish_cc(){
  // XXX this code assumes that each case choice is exactly one value.
  // It will have to be modified for ranges.
  
  choices._publish_cc();
  _cc_out << ") {\n ";
  sequence_of_statements._publish_cc();
  _cc_out << "}\n";
}


void 
IIRScram_CaseStatementAlternativeByChoices::
_type_check( set<IIR_TypeDefinition> *context_set ){
  IIR_Choice *current_choice;
  current_choice = choices.first();
  while( current_choice != NULL ){
    current_choice->_type_check( context_set );
    current_choice = choices.successor( current_choice );
  }
}


set<IIR_TypeDefinition> *
IIRScram_CaseStatementAlternativeByChoices::_get_rval_set( IIR_Boolean (IIR::*constraint_function)() ){
  set<IIR_TypeDefinition> *retval = NULL;
  IIR_Choice *current_choice;

  current_choice = choices.first();
  set<IIR_TypeDefinition> *choice_rval_set;
  while( current_choice != NULL ){
    choice_rval_set = current_choice->_get_rval_set( constraint_function );
    if( choice_rval_set == NULL ){
      report_undefined_symbol( current_choice );
      return NULL;
    }
    
    if( retval == NULL ){
      retval = choice_rval_set;
    }
    else{
      set<IIR_TypeDefinition> *intersect;
      intersect = set_intersect( choice_rval_set, retval );
      if( intersect->num_elements() > 0 ){
	delete retval;
	retval = intersect;
      }
      else{
	delete intersect;
      }
      delete choice_rval_set;
    }
    current_choice = choices.successor( current_choice );
  }
  return retval;
}


IIR_Boolean 
IIRScram_CaseStatementAlternativeByChoices::_is_resolved(){
  IIR_Boolean retval = TRUE;
  IIR_Choice *current_choice = choices.first();
  while( current_choice != NULL ){
    if( current_choice->_is_resolved() == FALSE ){
      retval = FALSE;
      break;
    }
    current_choice = choices.successor( current_choice );
  }
  return retval;
}


IIR*
IIRScram_CaseStatementAlternativeByChoices::_clone() {
  IIR_Choice *node, *choiceclone;
  IIR_CaseStatementAlternativeByChoices *clone;
  clone = new IIR_CaseStatementAlternativeByChoices;
  IIRScram_CaseStatementAlternative::_clone(clone);

  node = choices.first();
  while (NULL != node) {
    choiceclone = (IIR_Choice*)node->_clone();
    clone->choices.append(choiceclone);
    node = choices.successor(node);
  }
  return clone;
}
