
#ifndef IIRSCRAM_BLOCK_STATEMENT_HH
#define IIRSCRAM_BLOCK_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_BlockStatement.hh,v 
// 
//---------------------------------------------------------------------------

#include "IIRBase_BlockStatement.hh"

class IIR_List;
class IIR_SignalDeclaration;

class IIRScram_BlockStatement : public IIRBase_BlockStatement {

public:
  void _publish_vhdl(ostream &);
  void _type_check();

  //  void _publish_cc_binding_name(ostream& outstream = _cc_out);
  void _publish_cc();
  void _publish_cc_declarations();
  void _publish_cc_elaborate();
  void _publish_cc_headerfile();
  void _publish_cc_class_includes();
  void _publish_cc_class();
  void _publish_cc_ccfile();
  void _publish_cc_headerfiles_for_cc();
  void _publish_cc_constructor();
  void _publish_cc_constructor_with_no_arguments();
  void _publish_cc_constructor_with_arguments();
  void _publish_cc_instantiate();
  void _publish_cc_createNetInfo();
  void _publish_cc_connect();
  void _publish_cc_signal_objects_init(int flag);
  void _publish_cc_blocks_elaborate();
  void _publish_connect();
  void _publish_createNetInfo();
  void _publish_cc_elaborate_Add(IIR_AssociationElement *, IIR_Label *);
  void _publish_cc_elaborate_addChild(IIR_AssociationElement *, IIR_Label *);

  void _publish_cc_type_info();
  void _publish_cc_extern_type_info();
#ifdef PROCESS_GRAPH
  void _publish_cc_driver_info();
#endif

  set<IIR_Declaration> *_find_declarations( IIR_Name * );

  void _set_implicit_guard_signal( IIR_SignalDeclaration * );
  IIR_SignalDeclaration *_get_implicit_guard_signal(  );

  //  void _make_interface_visible( symbol_table * );

  IIR_List *_get_statement_list();
  IIR_GenericList *_get_generic_list();

  IIR_Boolean _is_block_statement() { return TRUE; };

  IIR_AssociationList *_get_generic_map_aspect() {
    return &generic_map_aspect;
  }

  void _make_interface_visible( symbol_table *sym_tab );
  void _type_check_instantiate_statements();

  static IIR* guard_expr;
protected:
  
  IIRScram_BlockStatement();
  virtual ~IIRScram_BlockStatement() = 0;
    
private:
  IIR_SignalDeclaration *my_implicit_guard_signal;
};

#endif
