#ifndef IIRSCRAM_ATTRIBUTE_SPECIFICATION_HH
#define IIRSCRAM_ATTRIBUTE_SPECIFICATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_AttributeSpecification.hh,v 1.2 1999/03/09 20:53:06 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_AttributeSpecification.hh"

class IIRScram_AttributeSpecification : public IIRBase_AttributeSpecification {

public:
  void _publish_vhdl_decl(ostream &);

  void _publish_cc();
  void _publish_cc_decl();
  void _publish_cc_decl_with_constructor();
  void _publish_cc_state_object_init();
  void _publish_cc_headers();
  void _publish_cc_bounds();

  void _type_check( IIR_DeclarationList &declarative_region );

  IIR_Boolean _is_specification(){
    return TRUE;
  }

  // This holds the the declaration of the attribute that is being
  // specified...
  void _set_declaration( IIR_Declaration *);
  IIR_Declaration *_get_declaration();
  IIR_TypeDefinition *_get_subtype();
  declaration_type _get_type();

  void _set_entity_constraint( IIR_Boolean (IIR_Declaration::*constraining_function )() ){
    _my_constraining_function = constraining_function;
  }

  IIR_Boolean (IIR_Declaration::*_get_entity_constraint() )() {
    return _my_constraining_function;
  }

  IIR_Boolean _is_iir_attribute_specification(){ return TRUE; }

protected:
  IIRScram_AttributeSpecification(){ 
    _my_constraining_function = 0; 
    attribute_declaration = NULL;
  }

  virtual ~IIRScram_AttributeSpecification() = 0;
    
private:
  IIR_Declaration *attribute_declaration;
  void _publish_cc_decl_constructor_args();
  IIR_Boolean (IIR_Declaration::*_my_constraining_function )();
};
#endif
