#ifndef IIRSCRAM_ASSOCIATION_ELEMENT_HH
#define IIRSCRAM_ASSOCIATION_ELEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajase@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_AssociationElement.hh,v 1.2 1999/03/09 20:52:58 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_AssociationElement.hh"

template <class type> class set;
class IIR_List;
class IIRScram_AssociationElement : public IIRBase_AssociationElement {

public:
  virtual void _publish_vhdl_without_formals(ostream &);
  
  virtual void _publish_cc();
  virtual void _publish_cc_state_object_init();
  virtual void _publish_cc_subprogram_arguments();
  IIR_Boolean _is_association(){ return TRUE; }
  IIR_Boolean _is_named();
  IIR_Boolean _is_positional();
  IIR_Boolean _is_by_others();
  
  void _get_list_of_input_signals(set<IIR_Declaration>* list);

  virtual IIR* _get_actual();
  virtual void _set_actual( IIR* );

  // This is overloaded in "IIR_AssociationElementByExpression".
  virtual IIR_Boolean _is_resolved(){ return TRUE; }

  virtual IIR_Int32 _get_number_of_element_associations();
  virtual void _publish_cc_generic_map_aspect();
  virtual void _publish_cc_generic_map_aspect_for_conc_stmts();

  IIR_Declaration *_find_formal_declaration();

  virtual IIR_Boolean _is_globally_static_for_array();
  virtual IIR_Boolean _is_globally_static_for_record();
  virtual IIR_Boolean _is_globally_static_for_function();

protected:
  IIRScram_AssociationElement() {}
  virtual ~IIRScram_AssociationElement() = 0;
    
private:
};
#endif
