
#ifndef IIRBASE_TEXTLITERAL_HH
#define IIRBASE_TEXTLITERAL_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_TextLiteral.hh,v 1.2 1999/03/09 20:52:12 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_Literal.hh"
#include "IIRScram_String.hh"

class IIR_Identifier;
class IIR_TextLiteral;

class IIRBase_TextLiteral : public IIR_Literal {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:

  IIR_Kind get_kind() {return IIR_TEXT_LITERAL;}

  IIR_Char *get_kind_text() {return "IIR_TextLiteral";}

  IIR_Char *get_text();
  IIR_Int32 get_text_length();

  IIR_Char &operator[]( IIR_Int32 subscript );

  static int _cmp(IIR_TextLiteral *a, IIR_TextLiteral *b);
  static int _cmp(IIR_TextLiteral *a, char *b);
  //  static IIR_TextLiteral *_dup( IIR_TextLiteral *to_dup );

  ostream &_print( ostream &os );

  // This method converts an IIR_Identifier to a "c" type char *.  Any
  // non-printable characters are printed as integers with a \ in
  // front.  Memory is allocated and returned...
  char *_convert_to_c_string();
  char *_convert_to_library_name();
 
protected:  
  IIRBase_TextLiteral();
  virtual ~IIRBase_TextLiteral() = 0;

  IIRScram_String *text;
    
private:  
  void _check_bounds( IIR_Int32 subscript );
};

#endif
