/* a_basic.c */
void o_save_embedded(TOPLEVEL *w_current, OBJECT *object_list, FILE *fp);
void o_save_write_header(FILE *fp);
void o_save(TOPLEVEL *w_current, char *filename);
OBJECT *o_read(TOPLEVEL *w_current, OBJECT *object_list, char *filename);
void o_scale(TOPLEVEL *w_current, OBJECT *list, int x_scale, int y_scale);
/* f_basic.c */
void f_open(TOPLEVEL *w_current, char *filename);
void f_close(TOPLEVEL *w_current);
void f_save_close(TOPLEVEL *w_current, char *filename);
void f_save(TOPLEVEL *w_current, char *filename);
/* f_image.c */
void f_image_write_objects(TOPLEVEL *w_current, OBJECT *head, int start_x, int start_y, float scale, int color_mode);
void f_image_write(TOPLEVEL *w_current, char *filename, int width, int height, int color_mode);
void f_image_set_type(TOPLEVEL *w_current, int type);
/* f_print.c */
void f_print_set_color(FILE *fp, int color);
float f_print_header(TOPLEVEL *w_current, FILE *fp, int paper_size_x, int paper_size_y, int world_right, int world_bottom);
void f_print_footer(FILE *fp);
void f_print_objects(TOPLEVEL *w_current, FILE *fp, OBJECT *head, int start_x, int start_y, float scale);
void f_print(TOPLEVEL *w_current, char *filename);
void f_print_set_type(TOPLEVEL *w_current, int type);
/* g_basic.c */
int ORIG_g_read_file(char *filename);
int g_read_file(char *filename);
/* m_basic.c */
int mil_x(TOPLEVEL *w_current, int val);
int mil_y(TOPLEVEL *w_current, int val);
int pix_x(TOPLEVEL *w_current, int val);
int pix_y(TOPLEVEL *w_current, int val);
void WORLDtoSCREEN(TOPLEVEL *w_current, int x, int y, int *mil_x, int *mil_y);
int snap_grid(TOPLEVEL *w_current, int input);
void SCREENtoWORLD(TOPLEVEL *w_current, int mx, int my, int *x, int *y);
int SCREENabs(TOPLEVEL *w_current, int val);
int WORLDabs(TOPLEVEL *w_current, int val);
void set_window(TOPLEVEL *w_current, int xmin, int xmax, int ymin, int ymax);
int fix_x(TOPLEVEL *w_current, int in);
int fix_y(TOPLEVEL *w_current, int in);
int on_snap(int val);
int SCREENclip_change(TOPLEVEL *w_current, int *x1, int *y1, int *x2, int *y2);
int clip_nochange(TOPLEVEL *w_current, int x1, int y1, int x2, int y2);
int visible(TOPLEVEL *w_current, int wleft, int wtop, int wright, int wbottom);
void rotate_point(int x, int y, int angle, int *newx, int *newy);
void rotate_point_90(int x, int y, int angle, int *newx, int *newy);
void PAPERSIZEtoWORLD(int width, int height, int border, int *right, int *bottom);
int return_zoom_number(int zoom_factor);
/* o_arc_basic.c */
void get_arc_bounds(TOPLEVEL *w_current, OBJECT *object, int *left, int *top, int *right, int *bottom);
void world_get_arc_bounds(TOPLEVEL *w_current, OBJECT *object, int *left, int *top, int *right, int *bottom);
OBJECT *o_arc_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x, int y, int width, int height, int start_angle, int end_angle);
void o_arc_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_arc_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], char *version);
char *o_arc_save(char *buf, OBJECT *object);
int enter_number(void);
void o_arc_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_arc_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
OBJECT *o_arc_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_arc_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_arc_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
void o_arc_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_arc_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_arc_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_arc_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
/* o_attrib.c */
ATTRIB *o_attrib_search(ATTRIB *list, OBJECT *item);
ATTRIB *o_attrib_return_tail(ATTRIB *head);
ATTRIB *add_attrib_head(OBJECT *parent);
ATTRIB *o_attrib_add(TOPLEVEL *w_current, ATTRIB *list_head, OBJECT *item);
void o_attrib_free(TOPLEVEL *w_current, ATTRIB *current);
void o_attrib_attach(TOPLEVEL *w_current, OBJECT *parent_list, OBJECT *list, OBJECT *object);
void o_attrib_detach_test(TOPLEVEL *w_current, OBJECT *list, OBJECT *items);
void o_attrib_edit(OBJECT *list, OBJECT *item);
void o_attrib_select_draw(ATTRIB *list);
void o_attrib_unselect_draw(ATTRIB *list);
void o_attrib_free_all(TOPLEVEL *w_current, ATTRIB *list);
void o_attrib_print(ATTRIB *attributes);
ATTRIB *o_attrib_copy(ATTRIB *list);
void o_attrib_delete(ATTRIB *a_current);
void o_attrib_remove(ATTRIB *list, ATTRIB *remove);
void o_attrib_detach_all(TOPLEVEL *w_current, OBJECT *object_list, OBJECT *main_head);
OBJECT *o_read_attribs(TOPLEVEL *w_current, FILE *fp, OBJECT *object_to_get_attribs, char *version);
void o_save_attribs(FILE *fp, ATTRIB *attribs);
int o_attrib_get_name_value(char *string, char *name, char *value);
void o_attrib_free_current(TOPLEVEL *w_current);
void o_attrib_set_show(TOPLEVEL *w_current, int flag);
void o_attrib_set_visible(TOPLEVEL *w_current, int flag);
void o_attrib_set_string(TOPLEVEL *w_current, char *string);
char *o_attrib_search_name(OBJECT *list, char *name, int counter);
char *o_attrib_search_name2(OBJECT *list, char *name, OBJECT **return_found);
char *o_attrib_search_name_partial(OBJECT *object, char *name, int counter);
char *o_attrib_search_toplevel(OBJECT *list, char *name, int counter);
OBJECT *o_attrib_return_parent(ATTRIB *attribute);
ATTRIB *o_attrib_copy_all(TOPLEVEL *w_current, OBJECT *attached_to, ATTRIB *attributes);
void o_attrib_reattach(ATTRIB *attributes);
void o_attrib_set_color(TOPLEVEL *w_current, ATTRIB *attributes);
char *o_attrib_search_special(OBJECT *o_current);
char *o_attrib_search_name_single(OBJECT *object, char *name, OBJECT **return_found);
char *o_attrib_search_name_single_count(OBJECT *object, char *name, int counter);
char *o_attrib_search_slot(OBJECT *object, OBJECT **return_found);
char *o_attrib_search_numslots(OBJECT *object, OBJECT **return_found);
char *o_attrib_search_default_slot(OBJECT *object);
char *o_attrib_search_pin_number(OBJECT *object, int pin_number, OBJECT **return_found);
char *o_attrib_search_slot_number(OBJECT *object, int slotnumber);
void o_attrib_slot_update(TOPLEVEL *w_current, OBJECT *object);
void o_attrib_slot_copy(TOPLEVEL *w_current, OBJECT *original, OBJECT *target);
int o_attrib_count_toplevel(TOPLEVEL *w_current, char *name);
char *o_attrib_search_toplevel_all(PAGE *page_head, char *name);
/* o_basic.c */
int inside_region(int left, int top, int right, int bottom, int x, int y);
void o_redraw_single(TOPLEVEL *w_current, OBJECT *o_current);
void o_recalc(TOPLEVEL *w_current, OBJECT *object_list);
/* o_box_basic.c */
void get_box_bounds(TOPLEVEL *w_current, LINEPTS *points, int *left, int *top, int *right, int *bottom);
void world_get_box_bounds(TOPLEVEL *w_current, LINEPTS *points, int *left, int *top, int *right, int *bottom);
OBJECT *o_box_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x1, int y1, int x2, int y2);
void o_box_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_box_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], char *version);
char *o_box_save(char *buf, OBJECT *object);
void o_box_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_box_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
OBJECT *o_box_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_box_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_box_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
void o_box_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_box_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_box_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_box_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
/* o_bus_basic.c */
void get_bus_bounds(TOPLEVEL *w_current, LINEPTS *points, int *left, int *top, int *right, int *bottom);
void world_get_bus_bounds(TOPLEVEL *w_current, LINEPTS *points, int *left, int *top, int *right, int *bottom);
OBJECT *o_bus_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x1, int y1, int x2, int y2);
void o_bus_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_bus_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], char *version);
char *o_bus_save(char *buf, OBJECT *object);
void o_bus_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_bus_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
OBJECT *o_bus_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_bus_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_bus_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
void o_bus_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_bus_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_bus_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_bus_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
int o_bus_orientation(OBJECT *object);
void o_bus_consolidate_lowlevel(OBJECT *object, OBJECT *del_object, int orient);
int o_bus_consolidate_segments(TOPLEVEL *w_current, OBJECT *object);
void o_bus_consolidate(TOPLEVEL *w_current);
void o_bus_modify(TOPLEVEL *w_current, OBJECT *object, int x, int y, int whichone);
/* o_circle_basic.c */
int dist(int x1, int y1, int x2, int y2);
void get_circle_bounds(TOPLEVEL *w_current, CIRCLE *circle, int *left, int *top, int *right, int *bottom);
void world_get_circle_bounds(TOPLEVEL *w_current, CIRCLE *circle, int *left, int *top, int *right, int *bottom);
OBJECT *o_circle_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x, int y, int radius);
void o_circle_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_circle_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], char *version);
char *o_circle_save(char *buf, OBJECT *object);
void o_circle_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_circle_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
OBJECT *o_circle_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_circle_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_circle_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
void o_circle_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_circle_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_circle_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_circle_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
/* o_complex_basic.c */
void get_complex_bounds(TOPLEVEL *w_current, OBJECT *complex, int *left, int *top, int *right, int *bottom);
void world_get_complex_bounds(TOPLEVEL *w_current, OBJECT *complex, int *left, int *top, int *right, int *bottom);
OBJECT *add_head(void);
OBJECT *o_complex_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x, int y, int angle, int mirror, char *clib, char *basename, int selectable);
OBJECT *o_complex_add_embedded(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x, int y, int angle, char *clib, char *basename, int selectable);
void o_complex_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_complex_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], char *version);
char *o_complex_save(char *buf, OBJECT *object);
void o_complex_set_filename(TOPLEVEL *w_current, char *clib, char *basename);
void o_complex_free_filename(TOPLEVEL *w_current);
void o_complex_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
OBJECT *o_complex_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
OBJECT *o_complex_copy_embedded(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_complex_delete(TOPLEVEL *w_current, OBJECT *delete);
void o_complex_world_translate(TOPLEVEL *w_current, int x1, int y1, OBJECT *complex);
void o_complex_world_translate_toplevel(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
void o_complex_set_color(TOPLEVEL *w_current, int color, OBJECT *complex);
OBJECT *o_complex_return_pin(OBJECT *o_list, int counter);
void o_complex_rotate_lowlevel(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, int angle_change, OBJECT *object);
void o_complex_mirror_lowlevel(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
/* o_conn.c */
CONN *o_conn_return_tail(CONN *head);
CONN *o_conn_add_head(OBJECT *parent, int x, int y);
CONN *o_conn_add(CONN *list_head, OBJECT *item, OBJECT *responsible, int type, int x, int y);
void o_conn_free(CONN *current);
void o_conn_free_all(CONN *list);
void o_conn_print(CONN *conn);
void o_conn_print_hash_func(gpointer key, gpointer value, gpointer user_data);
void o_conn_print_hash(GHashTable *conn_table);
void o_conn_delete(CONN *c_current);
char *o_conn_return_key(int x, int y);
CONN *o_conn_search(CONN *conn_list, OBJECT *o_current);
int o_conn_is_bus(CONN *conn_list);
int o_conn_is_net(CONN *conn_list);
int o_conn_is_pin(CONN *conn_list);
int o_conn_has_bus_midpoint(CONN *conn_list);
void o_conn_makeup(GHashTable *conn_table, char *key, OBJECT *o_current);
void o_conn_update_cues_info(CONN *conn_list);
OBJECT *o_conn_find_midpoint(OBJECT *object_list, int x, int y);
void o_conn_update_net(PAGE *p_current, OBJECT *o_current, int x, int y);
void o_conn_update_bus(PAGE *p_current, OBJECT *o_current, int x, int y);
void o_conn_update_pin(PAGE *p_current, OBJECT *o_current, int x, int y);
void o_conn_update(PAGE *p_current, OBJECT *o_current);
void o_conn_update_all(PAGE *p_current, OBJECT *object_list);
int o_conn_query_table(GHashTable *conn_table, int x, int y);
OBJECT *o_conn_return_bus_object(GHashTable *conn_table, int x, int y);
int o_conn_disconnect_func(gpointer key, gpointer value, gpointer user_data);
void o_conn_disconnect_update(PAGE *p_current);
void o_conn_disconnect(PAGE *p_current);
void o_conn_print_busmidpoint(TOPLEVEL *w_current, OBJECT *bus_object, FILE *fp, int x, int y, int other_wx, int other_wy);
void o_conn_image_busmidpoint(TOPLEVEL *w_current, OBJECT *bus_object, int x, int y, int other_wx, int other_wy);
/* o_image.c */
void o_image_init(void);
void o_image_create(int x, int y, int color_mode);
void o_image_close(void);
int o_image_write(char *filename);
int o_image_geda2gd_color(int color);
/* o_line_basic.c */
void get_line_bounds(TOPLEVEL *w_current, LINEPTS *points, int *left, int *top, int *right, int *bottom);
void world_get_line_bounds(TOPLEVEL *w_current, LINEPTS *points, int *left, int *top, int *right, int *bottom);
int o_line_visible(TOPLEVEL *w_current, LINEPTS *points, int *x1, int *y1, int *x2, int *y2);
OBJECT *o_line_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x1, int y1, int x2, int y2);
void o_line_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_line_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], char *version);
char *o_line_save(char *buf, OBJECT *object);
void o_line_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_line_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
OBJECT *o_line_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_line_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_line_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
void o_line_scale_world(TOPLEVEL *w_current, int x_scale, int y_scale, OBJECT *object);
void o_line_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_line_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_line_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_line_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
/* o_list.c */
OBJECT *o_list_copy_to(TOPLEVEL *w_current, OBJECT *list_head, OBJECT *selected, int flag);
OBJECT *o_list_copy_all(TOPLEVEL *w_current, OBJECT *src_list_head, OBJECT *dest_list_head, int flag);
OBJECT *o_list_search(OBJECT *list, OBJECT *current);
void o_list_delete(TOPLEVEL *w_current, OBJECT *list, OBJECT *delete);
void o_list_delete_rest(TOPLEVEL *w_current, OBJECT *list);
/* o_net_basic.c */
void get_net_bounds(TOPLEVEL *w_current, LINEPTS *points, int *left, int *top, int *right, int *bottom);
void world_get_net_bounds(TOPLEVEL *w_current, LINEPTS *points, int *left, int *top, int *right, int *bottom);
OBJECT *o_net_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x1, int y1, int x2, int y2);
void o_net_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_net_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], char *version);
char *o_net_save(char *buf, OBJECT *object);
void o_net_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_net_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
OBJECT *o_net_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_net_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_net_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
void o_net_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_net_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_net_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_net_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
int o_net_orientation(OBJECT *object);
void o_net_consolidate_lowlevel(OBJECT *object, OBJECT *del_object, int orient);
int o_net_consolidate_segments(TOPLEVEL *w_current, OBJECT *object);
void o_net_consolidate(TOPLEVEL *w_current);
void o_net_modify(TOPLEVEL *w_current, OBJECT *object, int x, int y, int whichone);
/* o_pin_basic.c */
void get_pin_bounds(TOPLEVEL *w_current, LINEPTS *points, int *left, int *top, int *right, int *bottom);
void world_get_pin_bounds(TOPLEVEL *w_current, LINEPTS *points, int *left, int *top, int *right, int *bottom);
OBJECT *o_pin_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x1, int y1, int x2, int y2);
void o_pin_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_pin_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], char *version);
char *o_pin_save(char *buf, OBJECT *object);
void o_pin_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_pin_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
OBJECT *o_pin_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_pin_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_pin_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
void o_pin_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_pin_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_pin_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_pin_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
/* o_text_basic.c */
void get_text_bounds(TOPLEVEL *w_current, OBJECT *o_current, int *left, int *top, int *right, int *bottom);
void world_get_text_bounds(TOPLEVEL *w_current, OBJECT *o_current, int *left, int *top, int *right, int *bottom);
OBJECT *o_text_add_head(void);
void o_text_init(void);
void o_text_print_set(void);
OBJECT *o_text_load_font(TOPLEVEL *w_current, char needed_char);
int o_text_width(TOPLEVEL *w_current, char *string, int size);
OBJECT *o_text_create_string(TOPLEVEL *w_current, OBJECT *object_list, char *string, int size, int color, int x, int y, int angle);
OBJECT *o_text_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x, int y, int angle, char *string, int size, int visibility, int show_name_value);
void o_text_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_text_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], char string[], char *version);
void o_text_set_info_font(char buf[]);
char *o_text_save(char *buf, OBJECT *object);
void o_text_recreate(TOPLEVEL *w_current, OBJECT *o_current);
void o_text_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_text_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *o_current);
OBJECT *o_text_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_text_freeallfonts(TOPLEVEL *w_current);
void o_text_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_text_rotate_lowlevel(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_text_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, int angle_change, OBJECT *object);
void o_text_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, int angle_change, OBJECT *object);
void o_text_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_text_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
/* s_attrib.c */
int s_attrib_add_entry(char *new_attrib);
void s_attrib_print(void);
int s_attrib_uniq(char *name);
void s_attrib_free(void);
void s_attrib_init(void);
char *s_attrib_get(int counter);
/* s_basic.c */
void error_if_called(void);
void exit_if_null(void *ptr);
OBJECT *return_tail(OBJECT *head);
OBJECT *return_head(OBJECT *tail);
OBJECT *s_basic_init_object(char *name);
OBJECT *s_basic_link_object(OBJECT *new_node, OBJECT *ptr);
void print_struct_forw(OBJECT *ptr);
void print_struct_back(OBJECT *ptr);
void print_struct(OBJECT *ptr);
void s_delete(TOPLEVEL *w_current, OBJECT *o_current);
void s_delete_list_fromstart(TOPLEVEL *w_current, OBJECT *start);
void string_toupper(char *in, char *out);
void string_tolower(char *in, char *out);
int colornametovalue(char *string);
char *remove_nl(char *string);
char *remove_string(char *string, int start, int end);
char *insert_string(char *string, int start, char *insert_string);
char *expand_env_variables(char *string);
/* s_clib.c */
int s_clib_return_num(void);
int s_clib_add_entry(char *new_path);
int s_clib_search_for_dirname(char *dir_name);
char *s_clib_cache_search(char *basename);
int s_clib_cache_add(char *clib_path, char *basename);
char *s_clib_search_dirs(char *basename);
char *s_clib_search(char *basename);
void s_clib_print(void);
void s_clib_cache_free(void);
void s_clib_free(void);
void s_clib_init(void);
char *s_clib_getdir(int index);
char *s_clib_getfiles(char *directory, int flag, int new_current);
int s_clib_uniq(char *path);
/* s_color.c */
void s_color_init(void);
int s_color_request(int color_index, char *color_name, char *outline_color_name, char *ps_color_string, int image_red, int image_green, int image_blue);
void s_color_destroy_all(void);
char *s_color_ps_string(int color);
int s_color_image_int(int color);
void s_color_gdcolor_init(void);
int s_color_get_name(int index, char *string);
/* s_hierarchy.c */
void s_hierarchy_load_all(TOPLEVEL *w_current, char *filename);
/* s_log.c */
void s_log_init(char *cwd, char *filename);
void s_log_message(const gchar *format, ...);
void s_log_close(void);
/* s_nethash.c */
NETHASH *o_nethash_return_tail(NETHASH *head);
NETHASH *o_nethash_add_head(OBJECT *parent);
NETHASH *o_nethash_add(NETHASH *list_head, OBJECT *object, int type);
void o_nethash_free(NETHASH *current);
void o_nethash_free_all(NETHASH *list);
void o_nethash_print(NETHASH *nethash);
void o_nethash_print_hash_func(gpointer key, gpointer value, gpointer user_data);
void o_nethash_print_hash(GHashTable *nethash_table);
void o_nethash_delete(NETHASH *nh_current);
NETHASH *o_nethash_search(NETHASH *nethash_list, OBJECT *o_current);
void o_nethash_add_new(GHashTable *nethash_table, OBJECT *o_current, char *new_key, int type);
NETHASH *o_nethash_query_table(GHashTable *nethash_table, char *key);
/* s_page.c */
PAGE *s_page_return_tail(PAGE *head);
void s_page_free(TOPLEVEL *w_current, PAGE *p_current);
void s_page_free_all(TOPLEVEL *w_current, PAGE *p_tail);
PAGE *s_page_add(TOPLEVEL *w_current, PAGE *p_tail, char *page_filename);
void s_page_print(PAGE *p_list);
void s_page_add_head(TOPLEVEL *w_current);
void s_page_free_head(TOPLEVEL *w_current, PAGE *p_head);
void s_page_delete(void);
PAGE *s_page_new(TOPLEVEL *w_current, char *page_filename);
void s_page_setup(PAGE *p_current);
int s_page_check_changed(PAGE *p_head);
void s_page_clear_changed(PAGE *p_head);
void s_page_goto(TOPLEVEL *w_current, PAGE *p_new);
PAGE *s_page_search(TOPLEVEL *w_current, char *filename);
int s_page_search_row(TOPLEVEL *w_current, PAGE *p_findme);
void s_page_print_all(TOPLEVEL *w_current);
void s_page_save_all(TOPLEVEL *w_current);
/* s_papersizes.c */
int s_papersizes_add_entry(char *new_papersize, int width, int height);
void s_papersizes_print(void);
int s_papersizes_uniq(char *name);
void s_papersizes_free(void);
void s_papersizes_init(void);
char *s_papersizes_get(int counter);
void s_papersizes_get_size(char *string, int *width, int *height);
/* s_scratch.c */
void s_scratch_string_init(void);
void s_scratch_string_free(void);
int s_scratch_string_fill(char *string);
/* s_slib.c */
int s_slib_add_entry(char *new_path);
int s_slib_search_for_dirname(char *dir_name);
char *s_slib_search_dirs(char *basename);
char *s_slib_search_lowlevel(char *basename);
char *s_slib_getbasename(char *rawname);
char *s_slib_search(char *filename, int flag);
void s_slib_free(void);
void s_slib_init(void);
char *s_slib_getdir(int index);
char *s_slib_getfiles(char *directory, int flag);
void s_slib_print(void);
int s_slib_uniq(char *path);
void s_slib_print_dirs(void);
/* s_stroke.c */
/* u_basic.c */
char *u_basic_strdup(const char *p);
char *u_basic_strdup_multiple(const char *str, ...);
