/*$Id: e_elemnt.cc,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * Base class for elements of a circuit
 */
#include "l_denoise.h"
#include "u_xprobe.h"
#include "e_aux.h"
#include "ap.h"
#include "bm.h" // includes e_elemnt.h
/*--------------------------------------------------------------------------*/
bool ELEMENT::skip_dev_type(CS& cmd)
{
  return cmd.pmatch(dev_type());
}
/*--------------------------------------------------------------------------*/
COMPONENT_COMMON* ELEMENT::parse_func_type(CS& cmd)
{
  COMPONENT_COMMON* rv;
  rv = EVAL_BM_COND_BASE::parse_func_type(cmd);
  if (rv) return rv;
  rv = EVAL_BM_ACTION_BASE::parse_func_type(cmd);
  return rv;
}
/*--------------------------------------------------------------------------*/
void ELEMENT::parse_more_nodes(CS& cmd, int gotnodes)
{
  int inports = is_2port();
  parse_nodes(cmd, 2*inports+2, 2*inports+2, gotnodes);
}
/*--------------------------------------------------------------------------*/
void ELEMENT::parse(CS& cmd)
{
  parse_Label(cmd);
  int gotnodes = parse_nodes(cmd,numnodes(),0);
  skip_dev_type(cmd); // (redundant)
  COMPONENT_COMMON* c = parse_func_type(cmd);
  parse_more_nodes(cmd, gotnodes);
  if (!c){ // number first
    EVAL_BM_VALUE tc; // temporary common
    tc.parse(cmd);
    {if (tc.has_ext_args()){
      c = new EVAL_BM_VALUE(tc);
      attach_common(c);
      // BUG:: info will get lost if there is more
    }else{
      set_value(tc.value());
    }}
    skip_dev_type(cmd); // (redundant)
    c = parse_func_type(cmd);
  }
  if (c){
    c->parse(cmd);
    attach_common(c);
  }
  cmd.check(bDANGER, "what's this?");
}
/*--------------------------------------------------------------------------*/
void ELEMENT::print(OMSTREAM where, int /*detail*/)const
{
  where << short_label();
  printnodes(where, numnodes());
  if (!has_common() || value() != 0){
    where << ' ' << value();
  }
  if (has_common()){
    common()->print(where);
  }
  where << '\n';
}
/*--------------------------------------------------------------------------*/
double ELEMENT::tr_amps()const
{
  //return loss * tr_outvolts() + m0.c1 * tr_involts() + m0.c0;
  return dn_sum(loss * tr_outvolts(),dn_sum(m0.c1 * tr_involts(), m0.c0));
}
/*--------------------------------------------------------------------------*/
double ELEMENT::tr_outvolts()const
{
  //return n[OUT1].v0() - n[OUT2].v0();
  return dn_diff(n[OUT1].v0(), n[OUT2].v0());
}
/*--------------------------------------------------------------------------*/
COMPLEX ELEMENT::ac_outvolts()const
{
  return n[OUT1].vac() - n[OUT2].vac();
}
/*--------------------------------------------------------------------------*/
double ELEMENT::probe_tr_num(const std::string& what)const
{
  CS cmd(what);
  {if (cmd.pmatch("Vo")){
    return tr_outvolts();
  }else if (cmd.pmatch("VI")){
    return tr_involts();
  }else if (cmd.pmatch("I")){
    return tr_amps();
  }else if (cmd.pmatch("P")){
    return tr_amps() * tr_outvolts();
  }else if (cmd.pmatch("PD")){
    double p = tr_amps() * tr_outvolts();
    return (p > 0.) ? p : 0.;
  }else if (cmd.pmatch("PS")){
    double p = tr_amps() * tr_outvolts();
    return (p < 0.) ? -p : 0.;
  }else if (cmd.pmatch("INput")){
    untested();
    return y0.x;
  }else if (cmd.pmatch("F")){
    if (y0.f0 == LINEAR){
      untested();
      return y0.x * y0.f1;
    }else{
      return y0.f0;
    }
  }else if (cmd.pmatch("NV")){
    return value();
  }else if (cmd.pmatch("EV")){
    return y0.f1;
  }else if (cmd.pmatch("Y")){
    return m0.c1;
  }else if (cmd.pmatch("EIV")){
    untested();
    return m0.x;
  }else if (cmd.pmatch("IOFfset")){
    return m0.c0;
  }else if (cmd.pmatch("IPassive")){
    untested();
    return m0.c1 * tr_involts();
  }else if (cmd.pmatch("ILoss")){
    untested();
    return loss * tr_outvolts();
//  }else if (cmd.pmatch("DIdt")){
//    double i0  = (m0.c1  * m0.x  + m0.c0);
//    double it1 = (mt1.f1 * mt1.x + mt1.c0);
//    return  (i0 - it1) / (time0 - time1);
//  }else if (cmd.pmatch("DTNew")){
//    return timef - time0;
//  }else if (cmd.pmatch("DTOld")){
//    return time0 - time1;
//  }else if (cmd.pmatch("TIMEF")){
//    return timef;
//  }else if (cmd.pmatch("TIME")){
//    return time0;
//  }else if (cmd.pmatch("TIMEO")){
//    return time1;
  }else if (cmd.pmatch("R")){
    return (m0.c1!=0.) ? 1/m0.c1 : DBL_MAX;
  }else if (cmd.pmatch("Z")){
    return port_impedance(n[OUT1], n[OUT2], lu, (m0.c1+loss));
  }else if (cmd.pmatch("ZRAW")){
    return port_impedance(n[OUT1], n[OUT2], lu, 0.);
  }else{
    untested();
    return NOT_VALID;
  }}
}
/*--------------------------------------------------------------------------*/
XPROBE ELEMENT::probe_ac_ext(const std::string& what)const
{
  CS cmd(what);
  COMPLEX admittance = (is_source()) ? COMPLEX(0.) : acg;
  COMPLEX source =     (is_source()) ? acg : COMPLEX(0.);

  {if (cmd.pmatch("V")){			/* volts */
    return XPROBE(ac_outvolts());
  }else if (cmd.pmatch("I")){			/* amps */
    return XPROBE(ac_involts() * admittance + source + ac_outvolts() * loss);
  }else if (cmd.pmatch("P")){			/* complex "power" */
    COMPLEX i = ac_involts() * admittance + source + ac_outvolts() * loss;
    return XPROBE(ac_outvolts() * std::conj(i), mtREAL, 10.);
  }else if (cmd.pmatch("NV")){			/* nominal value */
    untested();
    return XPROBE(value());
  }else if (cmd.pmatch("EV")){			/* effective value */
    return XPROBE(ev);
  }else if (cmd.pmatch("Y")){			/* admittance */
    untested();
    return XPROBE(admittance, mtREAL);
  }else if (cmd.pmatch("R")){			/* complex "resistance" */
    {if (admittance == 0.){
      untested();
      return XPROBE(DBL_MAX);
    }else{
      untested();
      return XPROBE(1. / admittance);
    }}
  }else if (cmd.pmatch("Z")){			/* port impedance */
    return XPROBE(port_impedance(n[OUT1], n[OUT2], acx, admittance));
  }else if (cmd.pmatch("ZRAW")){		/* port impedance, raw */
    return XPROBE(port_impedance(n[OUT1], n[OUT2], acx, COMPLEX(0.)));
  }else{ 					/* bad parameter */
    return XPROBE();
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
