/*$Id: e_compon.cc,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * Base class for elements of a circuit
 */
#include "l_stlextra.h"
#include "ap.h"
#include "e_compon.h"
/*--------------------------------------------------------------------------*/
//	const MODEL_CARD* COMPONENT_COMMON::attach_model()const;
//	COMPONENT_COMMON& COMPONENT_COMMON::parse_modelname(CS& cmd)
//
//		COMPONENT::COMPONENT();
//		COMPONENT::COMPONENT(const COMPONENT& proto);
//	int	COMPONENT::parse_nodes(CS&,int,int,int);
//	void	COMPONENT::printnodes(int,int)const;
//	void	COMPONENT::set(............);
//	void	COMPONENT::set(............);
//	void	COMPONENT::tr_eval();
//	void	COMPONENT::ac_eval();
//	void	COMPONENT::attach_common(const COMPONENT_COMMON *);
//	void	COMPONENT::detach_common();
//	bool	COMPONENT::conv_trace()const;
static	int	name2number(CS&);
/*--------------------------------------------------------------------------*/
const MODEL_CARD* COMPONENT_COMMON::attach_model()const
{
  std::list<CARD*>::const_iterator mi =
    find_ptr(root_model_list.begin(), root_model_list.end(), _modelname);
  {if (mi == root_model_list.end()){
    untested();
    error(bERROR, "can't find model: " + modelname() + '\n');
    _model = 0;
  }else{
    _model = dynamic_cast<const MODEL_CARD*>(*mi);
    if (!_model){
      untested();
      error(bERROR, modelname() + " is not a .model\n");
    }
  }}
  return _model;
}
/*--------------------------------------------------------------------------*/
COMPONENT_COMMON& COMPONENT_COMMON::parse_modelname(CS& cmd)
{
  return set_modelname(cmd.ctos(TOKENTERM));
}
/*--------------------------------------------------------------------------*/
COMPONENT::COMPONENT()
  :CARD(),
   _common(0),
   y0(),
   y1(),
   y2(),
   ev(0.),
   _converged(false),
   _queued_for_eval(-1)
{
  assert(y0.x == 0. && y0.f0 == 0. && y0.f1 == 0.);
  assert(y1 == y0);
  assert(y2 == y0);
}
/*--------------------------------------------------------------------------*/
COMPONENT::COMPONENT(const COMPONENT& p)
  :CARD(p),
   _common(0), 
   y0(),
   y1(),
   y2(),
   ev(0.),
   _converged(p._converged),
   _queued_for_eval(-1)
{
  attach_common(p._common);
  assert(_common == p._common);
  assert(y0.x == 0. && y0.f0 == 0. && y0.f1 == 0.);
  assert(y1 == y0);
  assert(y2 == y0);
}
/*--------------------------------------------------------------------------*/
/* parse_nodes: parse circuit connections from input string
 * n array must hold at least numnodes+1
 * fills in the rest of the array with INVALIDNODE
 * returns the number of nodes actually read
 */
int COMPONENT::parse_nodes(CS& cmd, int numnodes, int minfill, int start)
{
  int count = 0;
  if (start < numnodes){
    int paren = cmd.skiplparen();
    for (int ii = start;  ii < numnodes;  ++ii){
      n[ii].t = n[ii].e = name2number(cmd);
      if (n[ii].e != INVALIDNODE){
	count = ii+1;
      }else{
	if (ii <= minfill){
	  untested();
	  cmd.warn(bDANGER, "need mode nodes");
	  n[ii].t = n[ii].e = 0;
	}
      }
    }
    n[numnodes].t = n[numnodes].e = INVALIDNODE;
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.warn(bWARNING, "need )");
    }
  }
  return count;
}
/*--------------------------------------------------------------------------*/
/* printnodes: print a node list
 */
void COMPONENT::printnodes(OMSTREAM where, int numnodes, int start)const
{
  for (int ii = start;  ii < numnodes  &&  n[ii].e != INVALIDNODE;  ++ii){
    where << "  " << n[ii].e;
  }
}
/*--------------------------------------------------------------------------*/
/* set: set values, used in model building, 2 node version
 */
COMPONENT& COMPONENT::set(const std::string& Label, CARD *Owner,
			  const COMPONENT_COMMON *Common, double Value,
			  const node_t& N0, const node_t& N1)
{
  set_Label(Label);
  set_owner(Owner);
  set_value(Value);
  attach_common(Common);
  y0.f1 = value();
  y0.x = y0.f0 = 0.;
  n[0] = N0;
  n[1] = N1;
  return *this;
}
/*--------------------------------------------------------------------------*/
/* set: set values, used in model building, 4 node version
 */
COMPONENT& COMPONENT::set(const std::string& Label, CARD *Parent,
			  const COMPONENT_COMMON *Common, double Value,
			  const node_t& N0, const node_t& N1,
			  const node_t& N2, const node_t& N3)
{
  set(Label, Parent, Common, Value, N0, N1);
  n[2] = N2;
  n[3] = N3;
  return *this;
}
/*--------------------------------------------------------------------------*/
void COMPONENT::tr_eval()
{
  {if (has_common() && common()->has_tr_eval()){
    common()->tr_eval(this);
  }else{
    y0.f1 = value();
    y0.f0 = y0.x * y0.f1;
  }}
  _converged = conv_check();
}
/*--------------------------------------------------------------------------*/
void COMPONENT::ac_eval()
{
  {if (has_common() && common()->has_ac_eval()){
    common()->ac_eval(this);
  }else{
    ev = y0.f1;
  }}
}
/*--------------------------------------------------------------------------*/
void COMPONENT::attach_common(const COMPONENT_COMMON *c)
{
  {if (!c){
    // there is no new common.  probably a simple element
    detach_common();
  }else if (!has_common()){
    // no old one, but have a new one
    _common = c->attach();
  }else{ /* if (1 || *c != *common){*/
    // they are different
    detach_common();
    _common = c->attach();
#if 0
  }else{
    untested();
    // The one already attached matches the new one. 
    // use the old one and throw away the new one.
    // doesn't work.  always assume different as workaround
    delete c;
#endif
  }}
}
/*--------------------------------------------------------------------------*/
void COMPONENT::detach_common()
{
  if (has_common()){
    if (common()->detach() == 0){
      delete _common;
      _common = NULL;
    }
  }
}
/*--------------------------------------------------------------------------*/
/* conv_trace: check branch for convergence, with diagnostics
 */
bool COMPONENT::conv_trace()const
{
  bool isconverged = conv_check();

  if ((STATUS::iter[iSTEP] >= OPT::itl[OPT::TRACE]) && !isconverged){
    untested();
    error(bPICKY, long_label() + ": non-convergence\n");
    error(bPICKY, "(x) (%s,%s,%s)\n",
          ftos(y0.x, 0, 7, 0),
          ftos(y1.x, 0, 7, 0),
          ftos(y2.x, 0, 7, 0));
    error(bPICKY, "(f0) (%s,%s,%s)\n",
          ftos(y0.f0, 0, 7, 0),
          ftos(y1.f0, 0, 7, 0),
          ftos(y2.f0, 0, 7, 0));
    error(bPICKY, "(f1) (%s,%s,%s)\n",
	  ftos(y0.f1, 0, 7, 0),
	  ftos(y1.f1, 0, 7, 0),
	  ftos(y2.f1, 0, 7, 0));
  }else{
    untested();
  }
  return isconverged;
}
/*--------------------------------------------------------------------------*/
/* name2number: convert node name to node number
 * returns node number
 * cnt updated
 */
static int name2number(CS& cmd)
{
  int test = cmd.cursor();
  int node = cmd.ctoi();
  return  (test == cmd.cursor())  ?  INVALIDNODE  :  node;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
