/*$Id: d_mos6.h,v 14.19 1999/08/18 17:17:11 al Exp $ -*- C++ -*-
 * MOS model - Spice level 6
 */
#ifndef D_MOS6_H
#define D_MOS6_H
#include "d_mos123.h"
/*--------------------------------------------------------------------------*/
class MODEL_MOS6 : public MODEL_MOS123 {
private:
  explicit	MODEL_MOS6(const MODEL_MOS6& p):MODEL_MOS123(p){unreachable();}
  void		parse_params(CS&);
  void		post_parse();
public:
  explicit	MODEL_MOS6();
private: // override virtual
  void		print(OMSTREAM,int)const;
  void		tr_eval(COMPONENT*)const;
private:		/* strictly internal */
  enum {LEVEL=6};
private:		/* input parameters */
  double   kv;		/* Saturation voltage factor */
  double   nv;		/* Saturation voltage coeff. */
  double   kc;		/* Saturation current factor */
  double   nc;		/* Saturation current coeff. */
  double   nvth;	/* Threshold voltage coeff. */
  double   ps;		/* Sat. current modification  par. */
  double   gamma1;	/* Bulk threshold parameter 1 */
  double   sigma;	/* Static feedback effect par. */
  double   lambda1;	/* Channel length modulation param. 1 */
  bool	   calc_kc;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
