/*$Id: c_system.cc,v 14.12 1999/07/23 10:13:54 al Exp $ -*- C++ -*-
 * system calls: change directory, invoke another program, invoke editor, etc.
 */
#include "declare.h"	/* shell */
#include "l_lib.h"
#include "ap.h"
#include "c_comand.h"
// testing=nonstrict
/*--------------------------------------------------------------------------*/
//	void	CMD::edit(CS&);
//	void	CMD::system(CS&);
//	void	CMD::chdir(CS&);
/*--------------------------------------------------------------------------*/
/* cmd_edit: (command) invoke user defined editor on the netlist
 * if command has an argument, it edits that file instead
 * else actually edits a temporary file, and reads it back.
 */
void CMD::edit(CS& cmd)
{
  std::string editor(OS::getenv("EDITOR"));
  {if (editor.empty()){
    error(bERROR, "no editor defined\n");
  }else{
    {if (cmd.more()){
      OS::system(editor + ' ' + cmd.tail());
    }else{
      std::string temp_file(::tmpnam(0));
      {if (temp_file.empty()){
	untested();
	error(bERROR, "cannot create temp file\n");
      }else{
	cmdproc("save " + temp_file + " quiet");
	OS::system(editor + ' ' + temp_file);
	cmdproc("get " + temp_file + " quiet");
	OS::remove(temp_file);
      }}
    }}
  }}
}
/*--------------------------------------------------------------------------*/
void CMD::system(CS& cmd)
{
  if (cmd.more()){
    OS::system(cmd.tail());
  }else{
    shell();
  }
}
/*--------------------------------------------------------------------------*/
void CMD::chdir(CS& cmd)
{
  if (cmd.more()){
    OS::chdir(cmd.ctos(""));
  }
  IO::mstdout << OS::getcwd() << '\n';
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
