//  UMap.h version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
// UMap.h
// A class that provides mappings between local decoding and unicode.
// Gaspar Sinai <gsinai@gol.com>
// Tokyo 24 Aug 1997

#ifndef __umap_h_
#define __umap_h_

#include <iostream.h>
#include <fstream.h>
#include "UCommon.h"

typedef enum _UMapType { UMapDynamic, UMapStatic, UMapMMap, UMapUnicode } UMapType;

typedef struct _UMapCacheItemStruct
{
	char*			name;
	UMapType		mapType;

	int			fd;
	unsigned char*		buf;
	int			buflen;
	UCS2			decodeHighMin;
	UCS2			decodeHighMax;
	UCS2			decodeLowMin;
	UCS2			decodeLowMax;
	UCS2*			decodeMatrix;

	UCS2			encodeHighMin;
	UCS2			encodeHighMax;
	UCS2			encodeLowMin;
	UCS2			encodeLowMax;
	UCS2*			encodeMatrix;
} UMapCacheItemStruct;

class UMapCacheItem
{
public:
				UMapCacheItem (const UMapCacheItem &clone);
				UMapCacheItem (const UMapCacheItemStruct *clone);
				~UMapCacheItem();

	UMapCacheItemStruct	*cacheItem;

};

//
// When you create an istance of this class it will become the default
// map.
//
class UMap 
{
public:
	enum 			UStatus { OK, ERROR };
	enum 			UId { DEFAULT=-1 };

				UMap ();
				UMap (const char *name);
				UMap (const UMap &map);
				UMap (	
					char	*name,
					UMapType	isStatic,
					UCS2	decode_high_min, 
					UCS2	decode_high_max, 
					UCS2	decode_low_min, 
					UCS2	decode_low_max, 
					UCS2*	decode_matrix, 

					UCS2	encode_high_min, 
					UCS2	encode_high_max, 
					UCS2	encode_low_min, 
					UCS2	encode_low_max, 
					UCS2*	encode_matrix);
				~UMap ();

	// This guy gets the stuff from the cache,  user defined and if
        // not found default path.
	UStatus			rename (const char *name);

	// 0 return value indicates that it can not code/decode
	UCS2 			decode (const UCS2 in);
	UCS2 			encode (const UCS2 in);

	UCS2			decodeResultMax();
	UCS2			encodeResultMax();

	char*			getName ();

protected:
	UStatus 			load (
					char	*name,
					UMapType mapType,

					UCS2	decode_high_min, 
					UCS2	decode_high_max, 
					UCS2	decode_low_min, 
					UCS2	decode_low_max, 
					UCS2*	decode_matrix, 

					UCS2	encode_high_min, 
					UCS2	encode_high_max, 
					UCS2	encode_low_min, 
					UCS2	encode_low_max, 
					UCS2*	encode_matrix); 

	UStatus 			load (UMapCacheItemStruct *cacheItem);

	UStatus			load (const char* name);
	UStatus			load (const char* nameIn, ifstream* file, 
					const char* filename=0);

	static char*		DEFAULT_NAME;
	static char*		DEFAULT_PATH;

	UMapCacheItemStruct     *cacheItem;
	// The cache is local 
};

#endif /* __umap_h_ */
