//  UTextDialog.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#include "UTextDialog.h"

#define MARGIN 20
#define BUTTON_MARGIN 20

UTextDialog::UTextDialog (UShell* transient_, 
	UStyle style_, int frameSize_) :
	UDialog (transient_, frameSize_)
{
	dialogStyle = style_;
	setUp();
}

UTextDialog::UTextDialog (UTop* top_, 
	UStyle style_, int frameSize_) :
	UDialog (top_, frameSize_)
{
	dialogStyle = style_;
	setUp ();
}

void 
UTextDialog::setUp()
{
	button[BOK] = 0;
	button[BCANCEL] = 0;
	switch (dialogStyle)
	{
	case BCANCEL:
		button[BCANCEL] = new UTextButton (this, "OK");
		break;
	case BOK:
		button[BCANCEL] = new UTextButton (this, "CANCEL");
		button[BOK] = new UTextButton (this, "OK");
		break;
	}
	lastButton = BCANCEL;
	label = new UTextLabel (this, "TextLabel", UTextLine::CENTER);
}

UTextDialog::~UTextDialog ()
{
}

const UBestSize&
UTextDialog::getBestSize ()
{
	UBestSize	tbbs;
	UBestSize	bbs[2];

// Wait till menu pops down to prevent lock.
#ifdef DEBUG
	UEvent		event;

	XFlush (top->display);
	while (XPending (top->display) !=0)
	{
		UNextEvent (top, &event);
		UDispatchEvent (top, &event);
	}

#endif
	bbs[BOK].width=0;
	bbs[BOK].height=0;
	bbs[BCANCEL].width=10;
	bbs[BCANCEL].height=10;
	switch (dialogStyle)
	{
	case BCANCEL:
		bbs[BCANCEL] = button[BCANCEL]->getBestSize ();
		bbs[BCANCEL].width += BUTTON_MARGIN;
		
		break;
	case BOK:
		bbs[BOK] = button[BOK]->getBestSize ();
		bbs[BCANCEL] = button[BCANCEL]->getBestSize ();
		bbs[BOK].width += BUTTON_MARGIN;
		bbs[BCANCEL].width += BUTTON_MARGIN;
		if (bbs[BOK].width<bbs[BCANCEL].width)
		{
			bbs[BOK].width=bbs[BCANCEL].width;
		}
		else
		{
			bbs[BCANCEL].width=bbs[BOK].width;
		}
		break;
	}
	tbbs = label->getBestSize ();
	bestSize.width =  (bbs[0].width + bbs[1].width + MARGIN > 
	   tbbs.width) ? bbs[0].width + bbs[1].width + MARGIN : tbbs.width;
	bestSize.width += MARGIN * 2;
	bestSize.height = (bbs[0].height >  bbs[1].height) ?
		bbs[0].height : bbs[1].height;

	label->place (MARGIN, MARGIN, MARGIN, MARGIN*2 + bestSize.height);
	switch (dialogStyle)
	{
	case BCANCEL:
		button[BCANCEL]->place ((bestSize.width-bbs[BCANCEL].width)/2,
			-bbs[BCANCEL].height-MARGIN,
			-(bestSize.width+bbs[BCANCEL].width)/2, MARGIN);
		
		break;
	case BOK:
		button[BOK]->place (MARGIN, -bestSize.height-MARGIN,
			-MARGIN-bbs[BCANCEL].width, MARGIN);
		button[BCANCEL]->place (-MARGIN-bbs[BCANCEL].width, 
			-bestSize.height-MARGIN, MARGIN, MARGIN);
		break;
	}

	bestSize.height += tbbs.height + MARGIN * 3;
	return bestSize;
}

UDialog::UValue
UTextDialog::getValue()
{
	UDialog::getValue();
	if (lastButton==BOK) return (UDialog::OK);
	return  (UDialog::CANCEL);
}

void
UTextDialog::setButtonFont (UFont* font_)
{
	switch (dialogStyle)
	{
	case BCANCEL:
		button[BCANCEL]->setFont (font_);
		break;
	case BOK:
		button[BOK]->setFont (font_);
		button[BCANCEL]->setFont (font_);
		break;
	}
}

void
UTextDialog::setButtonText (UStyle button_, const char* utf8_)
{
	button[button_]->setText (utf8_);
}

void
UTextDialog::setTextFont (UFont* font_)
{
	label->setFont (font_);
}

void
UTextDialog::setText (const char* utf8_)
{
	label->setText (utf8_);
}

void	
UTextDialog::eventUp (UEvent* event)
{
	switch (event->type)
	{
	case UEvent::ACTIVATED:
		if (event->client !=0 && event->client==button[BCANCEL])
		{
			lastButton = BCANCEL;
			hide ();
			return;
		}
		if (event->client !=0 && event->client==button[BOK])
		{
			lastButton = BOK;
			hide ();
			return;
		}
		break;
	default:
		break;
	}
}
