//  USeparator.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "USeparator.h"
#include <iostream.h>

USeparator::USeparator  (UFrame* parent_, int height_) 
	: UComponent(parent_->top, parent_->top->display)
{
	XGCValues	gcv;

	height = height_;
	parent = parent_;
	top = parent->top;
	rectangle.width = 2;
	rectangle.height = height;
	rectangle.x = 0;
	rectangle.y = 0;

	if (rectangle.width<=parent->getFrameSize()*2)
		rectangle.width =  parent->getFrameSize()*2;

	window = XCreateSimpleWindow (top->display,
		parent->window, rectangle.x, rectangle.y,
		rectangle.width, rectangle.height,
		0, parent->getBackground().getPixel(), 
		parent->getBackground().getPixel());

	if (rectangle.width<=parent->getFrameSize()*2)
		rectangle.width =  parent->getFrameSize()*2;

	gcv.background = parent->getBackground().getPixel();
	gcv.foreground = parent->getBackground().getPixel();
	lightGC = XCreateGC (UTOP->display, window, 
		GCForeground | GCBackground, &gcv);
	darkGC = XCreateGC (UTOP->display, window, 
		GCForeground | GCBackground, &gcv);
	
	XMapRaised (UTOP->display, window);
	select (ExposureMask);
	
	setBackground (parent->getBackground());
	placement.margin = 0;

	// The best width is no width at all :)
	bestSize.width = 2;
	bestSize.height = height;

	// You have to do it if you dont inherit frame
	UTOP->addComponent (this);
	parent->addChild (this);
}

USeparator::~USeparator()
{
	XFreeGC (top->display, lightGC);
	XFreeGC (top->display, darkGC);
	XDestroyWindow (top->display, window);
	UTOP->deleteComponent (this);
	parent->deleteChild (this);
}

void 
USeparator::setBackground (const UColor& color)
{
	background = color;
	XSetWindowBackground (background.getDisplay(), window,
		background.getPixel());
	light = background;
	light.lighter ();
	XSetForeground (UTOP->display, lightGC, light.getPixel());

	dark = background;
	dark.darker ();
	XSetForeground (UTOP->display, darkGC, dark.getPixel());

	XClearArea (UTOP->display, window, 0, 0, rectangle.width,
		rectangle.height, True);
}

void 
USeparator::setBackground (const char* color)
{
	background = color;
	setBackground (background);
}
void
USeparator::eventDown (UEvent* event)
{
	XRectangle 	rect;

	switch (event->type)
	{
		case UEvent::TIMER:
			break;
		case UEvent::X:
		switch (event->xevent.type)
		{
		case Expose:
			rect.x = event->xevent.xexpose.x;
			rect.y = event->xevent.xexpose.y;
			rect.width = event->xevent.xexpose.width;
			rect.height = event->xevent.xexpose.height;
			redraw (rect.x, rect.y, rect.width, rect.height);
			break;

		case GraphicsExpose:
			rect.x = event->xevent.xgraphicsexpose.x;
			rect.y = event->xevent.xgraphicsexpose.y;
			rect.width = event->xevent.xgraphicsexpose.width;
			rect.height = event->xevent.xgraphicsexpose.height;
			redraw (rect.x, rect.y, rect.width, rect.height);
			break;
		default:
			parent->eventUp (event);
		}
	default:
		break;
	}
}

void
USeparator::resize (int width_, int height_)
{
	if (rectangle.width == width_ 
		&& rectangle.height ==height_) return;

	XClearArea (top->display, window, 0, 0, 
		rectangle.width, rectangle.height, False);

	rectangle.width = (width_>2)? width_ : 2;
	rectangle.height = (height_>2)? height_ : 2;
	
	XResizeWindow (top->display, window, 
		rectangle.width, rectangle.height);

	redraw (0, 0, width_, height_);
	bestSize.width = 2;
	bestSize.height = height_;
}

void
USeparator::move (int x, int y)
{
	if (rectangle.x == x && rectangle.y ==y) return;
	rectangle.x = x;
	rectangle.y = y;
	XMoveWindow (top->display, window, rectangle.x, rectangle.y);
}

void
USeparator::redraw (int x, int y, int width_, int height_)
{
	int	i;
	if (!isShown(this)) return;
	for (i=0; i<height_/2; i++)
	{
		XDrawLine (UTOP->display, window, darkGC, 
			0, i, rectangle.width,  i);
	}
	while (i<height_)
	{
		XDrawLine (UTOP->display, window, lightGC, 
			0, i, rectangle.width,  i);
		i++;
	}
}

int
USeparator::isA (UComponent::UType type_)
{
	if (type_ == UComponent::SEPARATOR) return 1;
	return UComponent::isA (type_);
}

