//  Translate.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#include "Translate.h"
#include <string.h>
#include <iostream.h>

static int initialized=0;

#ifdef USE_GETTEXT
extern "C"
{
#include <libintl.h>
}
#endif
#include <stdlib.h>

const char*
Translate (const char* text)
{
#ifdef USE_GETTEXT
	if (initialized) return gettext (text);
	return text;
#else
	return text;
#endif
}

int
InitTranslate (const char* bindIn, const char* domain)
{
	initialized =1;
#ifdef USE_GETTEXT
	bindtextdomain (bindIn, domain);
	textdomain (bindIn);
	return 0;
#else
	return 0;
#endif
}

int
TranslateLocale (const char* lang_)
{
	static char*	lang=0;

	if (!initialized) return 0;

#if 0
	setlocale (LC_MESSAGES, lang_);
#endif

	if (lang!=0 && !strcmp (lang+strlen("LANGUAGE="), lang_)) return 0;

	// putenv just eats it...
	//if (lang) delete lang;
	lang = new char[strlen ("LANGUAGE=") + strlen (lang_) + 1];
	strcpy (lang, "LANG=");
	strcat (lang, lang_);
	putenv (lang);
	strcpy (lang, "LANGUAGE=");
	strcat (lang, lang_);
	putenv (lang);
	//textdomain ("messages");

	return 0;
}

