//  stripumap.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
// Simple demo to convert
//

#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <UMap.h>
#include <X11/Xlib.h>
#include <UCommon.h>

void 		usage();

#define LINE_LENGTH	4096

int
main (int argc, char *argv[])
{
	UMap*		map;
	Display*	display;
	char		*umaps;
	XFontStruct	*font;
	int		dascent;
	int		ddescent;
	XCharStruct	overall;
	int		ddirection;
	char*		umap_name;
	unsigned short 	*decode_matrix;
	int		decode_high_min;
	int		decode_high_max;
	int		decode_low_min;
	int		decode_low_max;

	unsigned short 	*encode_matrix;
	int		encode_high_min;
	int		encode_high_max;
	int		encode_low_min;
	int		encode_low_max;

	int		newLine;
	UCS2		coded;
	UCS2		pos;
	char		hex[256];
	XChar2b		char2BBuf[1];
	int		cellIndex;

	unsigned short	high, low;

	if (argc < 3 || argc > 4)
	{
		usage();
		exit (1);
	}

        if ((umaps=getenv ("YUDITDATA"))!=0)
        {
                USetMapPath (umaps);
        }
        else
        {
                USetMapPath (DATA_DIR);
        }

	map = new UMap ();
	CHECKNULL (map);
	if (map->rename (argv[1]) != UMap::OK)
	{
		cerr << "error: can not load umap '" << argv[1] << "'\n";
		exit (1);
	}

	display = XOpenDisplay(NULL);
	if (display == NULL)
	{
		cerr << "error: XOpenDisplay could not open.\n";
		exit (1);
	}
	font = XLoadQueryFont (display, argv[2]);
	if (font == 0)
	{
		cerr << "error: can not load font '" << argv[2] << "'\n";
		exit (1);
	}
	umap_name = argv[1];
	if (argc == 4)
	{
		umap_name = argv[3];
	}
	decode_high_min = decode_low_min = 255;
	decode_high_max = decode_low_max  = 0;
	encode_high_min = encode_low_min = 255;
	encode_high_max = encode_low_max  = 0;
	encode_matrix = new unsigned short[65536];
	CHECKNULL (encode_matrix);
	decode_matrix = new unsigned short[65536];
	CHECKNULL (decode_matrix);

	// make new encode matrix
	for (high = 0; high < 256; high++)
	{
		for (low = 0; low < 256; low++)
		{
			pos = (high << 8) + low;
			encode_matrix[pos] = 0;
			coded = map->encode (pos);
			// check if font exists
			if (coded != 0)
			{
				overall.width = 0;
				char2BBuf[0].byte1 = coded >> 8;
				char2BBuf[0].byte2 = coded & 0xff;
				if (font->per_char == 0)
				{
				   	XQueryTextExtents16 (display,
						font->fid, char2BBuf, 1,
						&ddirection, &dascent, 
						&ddescent, &overall);
				}
				else
				{
					cellIndex = (char2BBuf[0].byte1 -font->min_byte1)
					* (font->max_char_or_byte2-font->min_char_or_byte2+1)
					+ char2BBuf[0].byte2 -font->min_char_or_byte2;
					overall.width = font->per_char[cellIndex].width;
				}
				if (overall.width > 0 && font->direction==0)
				{
					encode_matrix[pos] = coded;
					if (high < encode_high_min) 
						encode_high_min = high;
					if (low < encode_low_min) 
						encode_low_min = low;
					if (high > encode_high_max) 
						encode_high_max = high;
					if (low > encode_low_max) 
						encode_low_max = low;
				}
			}
		}
	}
	// make new decode matrix
	for (high = 0; high < 256; high++)
	{
		for (low = 0; low < 256; low++)
		{
			pos = (high << 8) + low;
			decode_matrix[pos] = 0;
			coded = map->decode (pos);
			// check if font exists
			if (coded != 0)
			{
				char2BBuf[0].byte1 = pos >> 8;
				char2BBuf[0].byte2 = pos & 0xff;
				overall.width = 0;
				if (font->per_char == 0)
				{
				   	XQueryTextExtents16 (display,
						font->fid, char2BBuf, 1,
						&ddirection, &dascent, 
						&ddescent, &overall);
				}
				else
				{
					cellIndex = (char2BBuf[0].byte1 -font->min_byte1)
					* (font->max_char_or_byte2-font->min_char_or_byte2+1)
					+ char2BBuf[0].byte2 -font->min_char_or_byte2;
					overall.width = font->per_char[cellIndex].width;
				}
				if (overall.width > 0 && font->direction==0)
				{
					decode_matrix[pos] = coded;
					if (high < decode_high_min) 
						decode_high_min = high;
					if (low < decode_low_min) 
						decode_low_min = low;
					if (high > decode_high_max) 
						decode_high_max = high;
					if (low > decode_low_max) 
						decode_low_max = low;
				}
			}
		}
	}
	// Write results
	cout << "/*\n";
	cout << " * <<<<<<<<<<< DO NOT EDIT >>>>>>>>>>>>\n";
	cout << " * This file has been generated automatically.\n";
	cout << " * This file is a subset of " << argv[1] << ".\n";
	cout << " * The subset was created using X11 font " << argv[2] << "\n";
	cout << " */\n\n";
	cout << "static char umap_name[]=\"" << umap_name << "\";\n\n";
	cout << "/* Decoding local code into unicode. Array Boundaries */\n";
	cout << "static unsigned short decode_high_min=" 
		<< decode_high_min << ";\n";
	cout << "static unsigned short decode_high_max=" 
		<< decode_high_max << ";\n";
	cout << "static unsigned short decode_low_min=" 
		<< decode_low_min << ";\n";
	cout << "static unsigned short decode_low_max=" 
		<< decode_low_max << ";\n\n";
	cout << "static unsigned short decode_matrix[]={";

	newLine = 0;
	for (high = decode_high_min; high <= decode_high_max; high++)
	{
		for (low = decode_low_min; low <= decode_low_max; low++)
		{
			pos = (high << 8) + low;
			if (newLine % 8 == 0)
			{
				cout << "\n";
			}
			newLine++;
			sprintf (hex, " 0x%x,", decode_matrix[pos]);
			cout << hex;
		}
	}
	cout << " };\n\n";
	cout << "/* Encoding local code into unicode. Array Boundaries */\n";
	cout << "static unsigned short encode_high_min=" 
		<< encode_high_min << ";\n";
	cout << "static unsigned short encode_high_max=" 
		<< encode_high_max << ";\n";
	cout << "static unsigned short encode_low_min=" 
		<< encode_low_min << ";\n";
	cout << "static unsigned short encode_low_max=" 
		<< encode_low_max << ";\n\n";
	cout << "static unsigned short encode_matrix[]={";

	newLine = 0;
	for (high = encode_high_min; high <= encode_high_max; high++)
	{
		for (low = encode_low_min; low <= encode_low_max; low++)
		{
			pos = (high << 8) + low;
			if (newLine % 8 == 0)
			{
				cout << "\n";
			}
			newLine++;
			sprintf (hex, " 0x%x,", encode_matrix[pos]);
			cout << hex;
		}
	}
	cout << " };\n\n";
	XCloseDisplay (display);
	exit (0);
}

void
usage ()
{
	cerr << "usage: stripumap encoding X11font [new-name]\n";
	cerr << "       Strip down umap to match X11 font.\n";
}
