;;; x-symbol-xmas21.el --- make package x-symbol work with XEmacs-21.X

;; Copyright (C) 1998-1999 Free Software Foundation, Inc.
;;
;; Author: Christoph Wedler <wedler@fmi.uni-passau.de>
;; Maintainer: (Please use `M-x x-symbol-package-bug' to contact the maintainer)
;; Version: $Id: x-symbol-xmas21.el,v 3.3 1999/01/18 14:17:44 wedler Exp wedler $
;; Keywords: WYSIWYG, LaTeX, HTML, wp, math, internationalization
;; X-URL: http://www.fmi.uni-passau.de/~wedler/x-symbol/

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; If you want to use package x-symbol, please visit the URL (use
;; \\[x-symbol-package-web]) and read the info (use \\[x-symbol-package-info]).

;;; Code:

(provide 'x-symbol-xmas21)


;;;===========================================================================
;;;  Fixing non X-Symbol induced annoyances
;;;===========================================================================

(defun x-symbol-paren-reset-mode ()
  (make-local-variable 'paren-mode)
  (setq paren-mode nil))
(add-hook 'list-mode-hook 'x-symbol-paren-reset-mode)


;;;===========================================================================
;;;  Autoloads
;;;===========================================================================

(autoload 'browse-url "browse-url" nil t)


;;;===========================================================================
;;;  Bug workarounds
;;;===========================================================================

;; Workaround for XEmacs bug (since XEmacs-20) with char syntax `inherit': the
;; following should be executed before(!) the AucTeX's syntax table is created.
(unless (featurep 'mule)
  (modify-syntax-entry ?\237 "\\" (standard-syntax-table))
  (modify-syntax-entry ?\236 "\\" (standard-syntax-table))
  (modify-syntax-entry ?\235 "\\" (standard-syntax-table))
  (modify-syntax-entry ?\234 "\\" (standard-syntax-table))
  (modify-syntax-entry ?\233 "\\" (standard-syntax-table))
  (modify-syntax-entry ?\232 "\\" (standard-syntax-table))
  ;; Add appropriately if more csets (fonts) are added.
  )

;;; Local IspellPersDict: .ispell_xsymb
;;; x-symbol-xmas21.el ends here
