/* 
   Main file
   --------------------------------------------------------------------
   VCHE - Virtual Console Hex Editor

   Copyright (C) 1998, 1999 Diego Javier Grigna <diego@grigna.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "common.h"

int fd;            /* File descriptor of the file we are viewing/editing */
struct stat stbuf; /* stat structure of that file                        */

static void usage( char *progname);

int main( int argc, char *argv[])
{
#if defined(VCHE_NC)
 WINDOW *w;
#endif
 char *progname;

 progname = *argv++;

 if( argc < 2) {
     usage( progname);
     return 1;
 }
 
 init();

#if defined(VCHE_VC) || defined(VCHE_RAW)
 term_raw();
#endif

 ll_file_init();

#if defined(VCHE_VC)
 lib_save_screen();
#endif

#if defined(VCHE_NC)
 w =
#endif
 lib_message( " Loading filelist... ", 0);

 argc--;

 while( argc-- > 0)
        ll_file_insert( *argv++);

#if defined(VCHE_VC)
 lib_load_screen();
#elif defined(VCHE_NC)
 delwin( w);
#endif

 if( !ll_file_qty) {
     fprintf( stderr, "No input files!\n");
     do_exit( 1);
 }

 ll_file_current     = ll_file_head;
 ll_file_browse_top  = ll_file_head;
 ll_file_browse_curr = ll_file_head;
 ll_file_browse_pos  = 0;

 hex_mainloop( flags.edit);

 return 0;
}

static void usage( char *progname)
{
 fprintf( stderr, "\nVCHE"
#if defined(VCHE_VC)
 " (Virtual Console Hex Editor) "
#elif defined(VCHE_RAW)
 "-RAW (Virtual Console Hex Editor - Run AnyWhere version) "
#elif defined(VCHE_NC)
 "-NC (Virtual Console Hex Editor - NCURSES Version) "
#endif
 "Release " VCHE_VERSION "\n\nUsage:\n\t%s [filename ..]\n\n", progname);
}

