#   include	"config.h"

#   include	"bmintern.h"
#   include	<string.h>
#   include	<tiffio.h>
#   include	<debugon.h>

BitmapFileType	bmTiffFile=
    {
    bmWriteTiffFile,
    bmCanWriteTiffFile,
    bmReadTiffFile,
    "tiff",
    "*.tiff",
    "tiffFile",
    "Tagged Image Format ( *.tiff )",
    };

BitmapFileType	bmTifFile=
    {
    bmWriteTiffFile,
    bmCanWriteTiffFile,
    bmReadTiffFile,
    "tif",
    "*.tif",
    "tifFile",
    "Tagged Image Format ( *.tif )",
    };

BitmapFileType	bmBmpFile=
    {
    bmWriteBmpFile,
    bmCanWriteBmpFile,
    bmReadBmpFile,
    "bmp",
    "*.bmp",
    "bmpFile",
    "Microsoft Bitmap ( *.bmp )",
    };

BitmapFileType	bmIcoFile=
    {
    bmWriteIcoFile,
    bmCanWriteIcoFile,
    bmReadIcoFile,
    "ico",
    "*.ico",
    "icoFile",
    "Microsoft Icon ( *.ico )",
    };

BitmapFileType	bmXwdFile=
    {
    NULL, /* bmWriteXwdFile, */
    NULL, /* bmCanWriteXwdFile, */
    bmReadXwdFile,
    "xwd",
    "*.xwd",
    "xwdFile",
    "X-Window Dump ( *.xwd )",
    };

BitmapFileType	bmJpgFile=
    {
    bmWriteJpegFile,
    bmCanWriteJpegFile,
    bmReadJpegFile,
    "jpg",
    "*.jpg",
    "jpgFile",
    "JPEG ( *.jpg )",
    };

BitmapFileType	bmJpegFile=
    {
    bmWriteJpegFile,
    bmCanWriteJpegFile,
    bmReadJpegFile,
    "jpeg",
    "*.jpeg",
    "jpegFile",
    "JPEG ( *.jpeg )",
    };

BitmapFileType	bmGifFile=
    {
    bmWriteGifFile,
    bmCanWriteGifFile,
    bmReadGifFile,
    "gif",
    "*.gif",
    "gifFile",
    "Compuserve GIF ( *.gif )",
    };

BitmapFileType	bmEpsFile=
    {
    bmWriteEpsFile,
    bmCanWriteEpsFile,
    NULL, /* bmReadEpsFile, */
    "eps",
    "*.eps",
    "epsFile",
    "Encapsulated Postscript ( *.eps )",
    };

BitmapFileType	bmXbmFile=
    {
    bmWriteXbmFile,
    bmCanWriteXbmFile,
    bmReadXbmFile,
    "xbm",
    "*.xbm",
    "xbmFile",
    "X-Windows bitmap ( *.xbm )",
    };

BitmapFileType	bmPngFile=
    {
    bmWritePngFile,
    bmCanWritePngFile,
    bmReadPngFile,
    "png",
    "*.png",
    "pngFile",
    "Portable Network Graphics ( *.png )",
    };

BitmapFileType	bmPcxFile=
    {
    bmWritePcxFile,
    bmCanWritePcxFile,
    bmReadPcxFile,
    "pcx",
    "*.pcx",
    "pcxFile",
    "Zsoft PC Paintbrush ( *.pcx )",
    };

BitmapFileType	bmXpmFile=
    {
    bmWriteXpmFile,
    bmCanWriteXpmFile,
    bmReadXpmFile,
    "xpm",
    "*.xpm",
    "xpmFile",
    "X11 Pixmap ( *.xpm )",
    };

BitmapFileType	bmPgmFile=
    {
    bmWritePbmFile,
    bmCanWritePbmFile,
    bmReadPbmFile,
    "pgm",
    "*.pgm",
    "pgmFile",
    "Portable Gray Map ( *.pgm )",
    };

BitmapFileType	bmPbmFile=
    {
    bmWritePbmFile,
    bmCanWritePbmFile,
    bmReadPbmFile,
    "pbm",
    "*.pbm",
    "pbmFile",
    "Portable Bitmap ( *.pbm )",
    };

BitmapFileType * bmFileTypes[]=
    {
    &bmTiffFile,
    &bmTifFile,
    &bmBmpFile,
    &bmIcoFile,
    &bmXwdFile,
    &bmGifFile,
    &bmEpsFile,
    &bmJpegFile,
    &bmJpgFile,
    &bmXbmFile,
    &bmPngFile,
    &bmPcxFile,
    &bmXpmFile,
    &bmPgmFile,
    &bmPbmFile,
    };

BitmapFileFormat	bmFileFormats[]=
    {
	{ "TIFF  No compression", "tiffPlainFile",
			    COMPRESSION_NONE,		&bmTiffFile },
	{ "TIFF  CCITT run length", "tiffCcittRleFile",
			    COMPRESSION_CCITTRLE,	&bmTiffFile },
	{ "TIFF  Fax 3 format", "tiffFax3File",
			    COMPRESSION_CCITTFAX3,	&bmTiffFile },
	{ "TIFF  Fax 4 format", "tiffFax4File",
			    COMPRESSION_CCITTFAX4,	&bmTiffFile },
	{ "TIFF  Lempel-Ziv & Welch", "tiffLzwFile",
			    COMPRESSION_LZW,		&bmTiffFile },
	{ "TIFF  NeXT 2-bit RLE", "tiffNextFile",
			    COMPRESSION_NEXT,		&bmTiffFile },
	{ "TIFF  Run length, aligned", "tiffRleFile",
			    COMPRESSION_CCITTRLEW,	&bmTiffFile },
	{ "TIFF  Packbits", "tiffPackbitsFile",
			    COMPRESSION_PACKBITS,	&bmTiffFile },
	{ "TIFF  Thunderscan", "tiffThunderFile",
			    COMPRESSION_THUNDERSCAN,	&bmTiffFile },
	{ "TIFF  JPEG", "tiffJpegFile",
			    COMPRESSION_JPEG,		&bmTiffFile },
	{ "BMP  Microsoft Windows 3.x bitmap", "bmp3File",
			    40,				&bmBmpFile },
	{ "XWD  X/11 Window dump", "xwd11File",
			    11,				&bmXwdFile },
	{ "XWD  X/10 Window dump", "xwd10File",
			    10,				&bmXwdFile },
	{ "GIF  Compuserve GIF", "gif87File",
			    87,				&bmGifFile },
	{ "EPS  Encapsulated Postscript", "eps1File",
			    1,				&bmEpsFile },
	{ "JPG  Independent JPEG Group (.jpg)", "jpg1File",
			    1,				&bmJpgFile },
	{ "JPEG  Independent JPEG Group (.jpeg)", "jpeg1File",
			    1,				&bmJpegFile },
	{ "XBM  X/11 Bitmap File", "xbm11File",
			    11,				&bmXbmFile },
	{ "PNG  Portable Network Graphics", "png1File",
			    0,				&bmPngFile },
	{ "ICO  Microsoft 3.x Windows Icon", "ico3File",
			    40,				&bmIcoFile },
	{ "PCX  Zsoft PC Paintbrush file", "pcx1File",
			    0,				&bmPcxFile },
	{ "XPM  X11 Pixmap File", "xpm1File",
			    0,				&bmXpmFile },
	{ "PGM  Gray Map (Text)", "pgm2File",
			    2,				&bmPgmFile },
	{ "PGM  Gray Map (Raw)", "pgm5File",
			    5,				&bmPgmFile },
	{ "PBM  Bitmap (Text)", "pgm1File",
			    1,				&bmPbmFile },
	{ "PBM  Bitmap (Raw)", "pgm4File",
			    4,				&bmPbmFile },
    };

int	bmNumberOfFileFormats= sizeof(bmFileFormats)/sizeof(BitmapFileFormat);
int	bmNumberOfFileTypes= sizeof(bmFileTypes)/sizeof(BitmapFileType *);

/************************************************************************/
/*  Translation back and forth between color encoding and string.	*/
/************************************************************************/
const char *	bmcoStrings[]=
    {
    "black on white",
    "white on black",
    "RGB",
    "RGB palette",
    0
    };

const char *	bmcoIntToString( int colorEncodingInt )
    {
    if  ( colorEncodingInt >= 0						&&
	  colorEncodingInt < sizeof( bmcoStrings )/sizeof(char *) -1	)
	{ return bmcoStrings[colorEncodingInt]; }

    LDEB(colorEncodingInt); return (char *)0;
    }

int		bmcoStringToInt( const char * colorEncodingString )
    {
    int	i;

    for ( i= 0; i < sizeof( bmcoStrings )/sizeof(char *) -1; i++ )
	{
	if  ( ! strcmp( colorEncodingString, bmcoStrings[i] ) )
	    { return i;	}
	}

    SDEB(colorEncodingString); return -1;
    }

/************************************************************************/
/*  Translation back and forth between resolution unit and string.	*/
/************************************************************************/
const char *	bmunStrings[]=
    {
    "cm",
    "inch",
    "point",
    0
    };

const char *	bmunIntToString( int unitInt )
    {
    if  ( unitInt >= 0						&&
	  unitInt < sizeof( bmcoStrings )/sizeof(char *) -1	)
	{ return bmunStrings[unitInt]; }

    LDEB(unitInt); return (char *)0;
    }

int		bmunStringToInt( const char * unitString )
    {
    int	i;

    for ( i= 0; i < sizeof( bmunStrings )/sizeof(char *) -1; i++ )
	{
	if  ( ! strcmp( unitString, bmunStrings[i] ) )
	    { return i;	}
	}

    SDEB(unitString); return -1;
    }

/************************************************************************/
/*  Initialise a BitmapDescription.					*/
/************************************************************************/
void bmInitDescription	( BitmapDescription *	bd )
    {
    bd->bdBufferLength= 0;
    bd->bdBytesPerRow= 0;
    bd->bdPixelsWide= 0;
    bd->bdPixelsHigh= 0;
    bd->bdBitsPerSample= 0;
    bd->bdSamplesPerPixel= 0;
    bd->bdBitsPerPixel= 0;
    bd->bdXResolution= 0;
    bd->bdYResolution= 0;
    bd->bdUnit= BMunILLEGALVALUE;
    bd->bdColorEncoding= BMcoILLEGALVALUE;

    bd->bdHasAlpha= 0;

    /********************************************/
    /*  Or any other member of the union.	*/
    /********************************************/
    bd->bdColorCount= 0;
    bd->bdRGB8Palette= (RGB8Color *)0;
    }

/************************************************************************/
/*  Clean a BitmapDescription.						*/
/************************************************************************/
void bmCleanDescription	( BitmapDescription *	bd )
    {
    switch( bd->bdColorEncoding )
	{
	case BMcoRGB8PALETTE:
	    if  ( bd->bdRGB8Palette )
		{ free( bd->bdRGB8Palette );	}
	    break;
	default:
	    break;
	}
    }


/************************************************************************/
/*  Copy a BitmapDescription.						*/
/************************************************************************/
int bmCopyDescription	(	BitmapDescription *		to,
				const BitmapDescription *	from )
    {
    switch( from->bdColorEncoding )
	{
	case BMcoRGB8PALETTE:
	    *to= *from;
	    to->bdRGB8Palette= malloc( to->bdColorCount* sizeof(RGB8Color) );
	    if  ( ! to->bdRGB8Palette )
		{ XDEB(to->bdRGB8Palette); return -1;	}

	    memcpy( to->bdRGB8Palette, from->bdRGB8Palette, 
				    from->bdColorCount* sizeof( RGB8Color ) );
	    break;
	default:
	    *to= *from;
	    break;
	}

    return 0;
    }

/************************************************************************/
/*  Byte masks								*/
/************************************************************************/
unsigned char	Bmc1Masks[8]=
    { 0x80, 0x40, 0x20, 0x10, 0x8, 0x4, 0x2, 0x1 };

unsigned char	Bmc7Masks[8]=
    { 0x7f, 0xbf, 0xdf, 0xef, 0xf7, 0xfb, 0xfd, 0xfe };

