#   include	<stddef.h>
#   include	<stdlib.h>

#   include	<appWinMeta.h>
#   include	<appPs.h>
#   include	<sioEndian.h>

#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	<debugon.h>

#   ifndef	M_PI
#	define	M_PI	3.14159265358979323846
#   endif

# if 0
#    define	WMFDEB(x)	(x)
# else
#    define	WMFDEB(x)	/*nothing*/
# endif

static void appMetaCleanDeviceContextX11(	DeviceContextX11 *	dcx,
						AppDrawingData *	add )
    {
    appMetaCleanDeviceContext( &dcx->dcxDeviceContext );

    if  ( dcx->dcxGc )
	{ XFreeGC( add->addDisplay, dcx->dcxGc ); }

    return;
    }

static int appMetaInitDeviceContextX11(	DeviceContextX11 *	dcx,
					AppDrawingData *	add,
					AppColors *		ac,
					Window			pixmap,
					int			objectCount,
					int			xExt,
					int			yExt,
					int			twipsWide,
					int			twipsHigh,
					int			pixelsWide,
					int			pixelsHigh )
    {
    int			screen= DefaultScreen( add->addDisplay );
    GC			gc;

    gc= XCreateGC( add->addDisplay, pixmap, 0L, (XGCValues *)0 );
    if  ( ! gc )
	{ XDEB(gc); return -1;	}

    if  ( appMetaInitDeviceContext( &dcx->dcxDeviceContext, objectCount,
					xExt, yExt, twipsWide, twipsHigh ) )
	{ LDEB(objectCount); return -1;	}

    dcx->dcxScreen= screen;
    dcx->dcxDrawable= pixmap;
    dcx->dcxGc= gc;
    dcx->dcxPhysicalFont= (AppPhysicalFont *)0;

    dcx->dcxPixelsWide= pixelsWide;
    dcx->dcxPixelsHigh= pixelsHigh;

    XSetForeground( add->addDisplay, gc,
				    BlackPixel( add->addDisplay, screen ) );

    if  ( appColorRgb( &dcx->dcxPenColor, ac,
		    dcx->dcxDeviceContext.dcPen.lpColor.rgb8Red,
		    dcx->dcxDeviceContext.dcPen.lpColor.rgb8Green,
		    dcx->dcxDeviceContext.dcPen.lpColor.rgb8Blue ) )
	{ LDEB(1); return -1;	}

    if  ( appColorRgb( &dcx->dcxBrushColor, ac,
		    dcx->dcxDeviceContext.dcBrush.lbColor.rgb8Red,
		    dcx->dcxDeviceContext.dcBrush.lbColor.rgb8Green,
		    dcx->dcxDeviceContext.dcBrush.lbColor.rgb8Blue ) )
	{ LDEB(1); return -1;	}

    if  ( appColorRgb( &dcx->dcxBkColor, ac,
		    dcx->dcxDeviceContext.dcBkColor.rgb8Red,
		    dcx->dcxDeviceContext.dcBkColor.rgb8Green,
		    dcx->dcxDeviceContext.dcBkColor.rgb8Blue ) )
	{ LDEB(1); return -1;	}

    if  ( appColorRgb( &dcx->dcxTextColor, ac,
		    dcx->dcxDeviceContext.dcTextColor.rgb8Red,
		    dcx->dcxDeviceContext.dcTextColor.rgb8Green,
		    dcx->dcxDeviceContext.dcTextColor.rgb8Blue ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

static int appMetaSelectBrushObjectX11(	DeviceContextX11 *	dcx,
					AppColors *		ac,
					AppDrawingData *	add,
					int			ob )
    {
    DeviceContext *	dc= &(dcx->dcxDeviceContext);
    LogicalBrush *	lb= &(dc->dcObjects[ob].mfoLogicalBrush);

    WMFDEB(DEBFUN( "SelectObject( ob= %d ) ", ob ));
    WMFDEB(DEBFUN( "BRUSH" ));

    switch( lb->lbStyle )
	{
	case BS_SOLID:
	    dcx->dcxDeviceContext.dcFillInsides= 1;

	    WMFDEB(DEBFUN( " SOLID r= %d, g= %d, b=%d\n",
					    lb->lbColor.rgb8Red,
					    lb->lbColor.rgb8Green,
					    lb->lbColor.rgb8Blue ));

	    if  ( appColorRgb( &dcx->dcxBrushColor, ac,
					    lb->lbColor.rgb8Red,
					    lb->lbColor.rgb8Green,
					    lb->lbColor.rgb8Blue ) )
		{ LDEB(1);  return -1;	}

	    XSetForeground( add->addDisplay, dcx->dcxGc,
						    dcx->dcxBrushColor.pixel );
	    break;
	case BS_HOLLOW:
	    dcx->dcxDeviceContext.dcFillInsides= 0;

	    WMFDEB(DEBFUN( " HOLLOW\n" ));
	    break;

	case BS_HATCHED:
	case BS_PATTERN:
	default:
	    WMFDEB(DEBFUN( "\n" ));
	    dcx->dcxDeviceContext.dcFillInsides= 0;
	    LDEB(lb->lbStyle); return -1;
	}

    dcx->dcxDeviceContext.dcBrush= *lb;

    return 0;
    }

static int appMetaSelectFontObjectX11(	DeviceContextX11 *	dcx,
					AppColors *		ac,
					AppDrawingData *	add,
					DocumentFontList *	dfl,
					int			ob )
    {
    DeviceContext *	dc= &(dcx->dcxDeviceContext);
    LogicalFont *	lf= &(dc->dcObjects[ob].mfoLogicalFont);

    if  ( lf->lfPrivateFont < 0 )
	{
	lf->lfPrivateFont= appOpenDocumentFont( add, dfl,
						    lf->lfTextAttribute );

	if  ( lf->lfPrivateFont < 0 )
	    { SLDEB(lf->lfFaceName,lf->lfPrivateFont); return 0;	}
	}

    if  ( lf->lfPrivateFont >= 0 )
	{
	dcx->dcxPhysicalFont=
			add->addPhysicalFontList.apflFonts+ lf->lfPrivateFont;

	XSetFont( add->addDisplay, dcx->dcxGc,
				    dcx->dcxPhysicalFont->apfFontStruct->fid );
	}
    else{ dcx->dcxPhysicalFont= (AppPhysicalFont *)0;	}

    dc->dcFont= *lf;

    return 0;
    }

static int appMetaSelectPenObjectX11(	DeviceContextX11 *	dcx,
					AppColors *		ac,
					AppDrawingData *	add,
					int			ob )
    {
    DeviceContext *	dc= &(dcx->dcxDeviceContext);
    LogicalPen *	lp= &(dc->dcObjects[ob].mfoLogicalPen);

    static char	dash[]= { 3, 2 };
    static char	dot[]= { 1, 2 };
    static char	dashdot[]= { 2, 2, 1, 2 };
    static char	dashdotdot[]= { 2, 2, 1, 2, 1, 2 };

    WMFDEB(DEBFUN( "SelectObject( ob= %d ) PEN Width= %d ",
							ob, lp->lpWidth ));

    switch( lp->lpStyle )
	{
	case PS_SOLID:
	    WMFDEB(DEBFUN( "SOLID\n" ));
	  solid:
	    dcx->dcxDeviceContext.dcDrawBorders= 1;

	    XSetLineAttributes( add->addDisplay, dcx->dcxGc,
		    DCX_W( lp->lpWidth, dcx ), LineSolid, CapButt, JoinMiter );
	    break;

	case PS_INSIDEFRAME:
	    WMFDEB(DEBFUN( "INSIDEFRAME\n" ));

	    dcx->dcxDeviceContext.dcDrawBorders= 1;

	    XSetLineAttributes( add->addDisplay, dcx->dcxGc,
		    DCX_W( lp->lpWidth, dcx ), LineSolid, CapButt, JoinMiter );
	    break;

	case PS_DASH:
	    WMFDEB(DEBFUN( "DASH\n" ));

	    if  ( lp->lpWidth > 1 )
		{ goto solid;	}

	    dcx->dcxDeviceContext.dcDrawBorders= 1;

	    XSetLineAttributes( add->addDisplay, dcx->dcxGc,
				1, LineOnOffDash, CapButt, JoinMiter );

	    XSetDashes( add->addDisplay, dcx->dcxGc, 0,
						dash, sizeof( dash ) );
	    break;

	case PS_DOT:
	    WMFDEB(DEBFUN( "DOT\n" ));

	    if  ( lp->lpWidth > 1 )
		{ goto solid;	}

	    dcx->dcxDeviceContext.dcDrawBorders= 1;

	    XSetLineAttributes( add->addDisplay, dcx->dcxGc,
				    1, LineOnOffDash, CapButt, JoinMiter );

	    XSetDashes( add->addDisplay, dcx->dcxGc, 0,
						dot, sizeof( dot ) );
	    break;

	case PS_DASHDOT:
	    WMFDEB(DEBFUN( "DASHDOT\n" ));

	    if  ( lp->lpWidth > 1 )
		{ goto solid;	}

	    dcx->dcxDeviceContext.dcDrawBorders= 1;

	    XSetLineAttributes( add->addDisplay, dcx->dcxGc,
				    1, LineOnOffDash, CapButt, JoinMiter );

	    XSetDashes( add->addDisplay, dcx->dcxGc, 0,
						dashdot, sizeof( dashdot ) );
	    break;

	case PS_DASHDOTDOT:
	    WMFDEB(DEBFUN( "DASHDOTDOT\n" ));

	    if  ( lp->lpWidth > 1 )
		{ goto solid;	}

	    dcx->dcxDeviceContext.dcDrawBorders= 1;

	    XSetLineAttributes( add->addDisplay, dcx->dcxGc,
				    1, LineOnOffDash, CapButt, JoinMiter );

	    XSetDashes( add->addDisplay, dcx->dcxGc, 0,
					    dashdotdot, sizeof( dashdotdot ) );
	    break;

	case PS_NULL:
	    WMFDEB(DEBFUN( "NULL\n" ));
	    dcx->dcxDeviceContext.dcDrawBorders= 0;
	    break;

	default:
	    WMFDEB(DEBFUN( "????\n" ));
	    dcx->dcxDeviceContext.dcDrawBorders= 0;
	    break;
	}

    if  ( dcx->dcxDeviceContext.dcDrawBorders )
	{
	if  ( appColorRgb( &dcx->dcxPenColor, ac,
					    lp->lpColor.rgb8Red,
					    lp->lpColor.rgb8Green,
					    lp->lpColor.rgb8Blue ) )
		{ LDEB(1);  return -1;	}

	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxPenColor.pixel );
	}

    dcx->dcxDeviceContext.dcPen= *lp;

    return 0;
    }

static int appMetaGetPointsX11(	DeviceContextX11 *	dcx,
				int			count,
				SimpleInputStream *	sis )
    {
    DeviceContext *	dc= &(dcx->dcxDeviceContext);
    XPoint *		xp;

    int			done;

    xp= (XPoint *)realloc( dc->dcPoints, (count+ 1)* sizeof(XPoint) );
    if  ( ! xp )
	{ LXDEB(count,xp); return -1;	}
    dc->dcPoints= xp;

    for ( done= 0; done < count; xp++, done++ )
	{
	int	x= sioEndianGetLeInt16( sis );
	int	y= sioEndianGetLeInt16( sis );

	xp->x= DCX_X( x, dcx );
	xp->y= DCX_Y( y, dcx );
	}

    return 0;
    }

static int appMetaGetCountAndPointsX11(	DeviceContextX11 *	dcx,
					int *			pCount,
					SimpleInputStream *	sis,
					int			recordSize )
    {
    int				count;

    count= sioEndianGetLeInt16( sis );

    if  ( 2* count != recordSize- 4 )
	{ LLDEB(2*count,recordSize-4); return -1;	}

    if  ( appMetaGetPointsX11( dcx, count, sis ) )
	{ LDEB(count); return -1;	}

    *pCount= count; return 0;
    }

static int appMetaSelectObjectX11(	DeviceContextX11 *	dcx,
					AppColors *		ac,
					AppDrawingData *	add,
					DocumentFontList *	dfl,
					int			recordSize,
					SimpleInputStream *	sis )
    {
    DeviceContext *	dc= &(dcx->dcxDeviceContext);

    int			ob;

    ob= sioEndianGetLeInt16( sis );

    if  ( ob < 0 || ob >= dc->dcObjectCount )
	{ LLDEB(ob,dc->dcObjectCount); return -1;	}

    switch( dc->dcObjects[ob].mfoType )
	{
	case MFtypePEN:
	    if  ( appMetaSelectPenObjectX11( dcx, ac, add, ob ) )
		{ LDEB(ob); return -1;	}
	    break;
	case MFtypeBRUSH:
	    if  ( appMetaSelectBrushObjectX11( dcx, ac, add, ob ) )
		{ LDEB(ob); return -1;	}
	    break;
	case MFtypeFONT:
	    WMFDEB(DEBFUN( "SelectObject( ob= %d ) ", ob ));
	    WMFDEB(DEBFUN( "FONT\n" ));
	    if  ( appMetaSelectFontObjectX11( dcx, ac, add, dfl, ob ) )
		{ LDEB(ob); return -1;	}
	    break;
	default:
	    WMFDEB(DEBFUN( "SelectObject( ob= %d ) ", ob ));
	    WMFDEB(DEBFUN( "type= %d\n", dc->dcObjects[ob].mfoType ));
	    break;
	}

    return 0;
    }

/************************************************************************/

static int appMetaBitmapImageX11(	AppBitmapImage **	pAbi,
					SimpleInputStream *	sis,
					int			expectBytes,
					DeviceContextX11 *	dcx,
					AppColors *		ac,
					AppDrawingData *	add,
					int			srcX,
					int			srcY,
					int			srcXExt,
					int			srcYExt,
					int			dstX,
					int			dstY,
					int			dstXExt,
					int			dstYExt )
    {
    DeviceContext *	dc= &(dcx->dcxDeviceContext);
    AppBitmapImage *	abi= (AppBitmapImage *)malloc( sizeof(AppBitmapImage) );
    int			done;

    BitmapDescription *	bd;
    XImage *		xim= (XImage *)0;

    if  ( ! abi )
	{ XDEB(abi); return -1;	}
    appInitBitmapImage( abi );

    if  ( srcX != 0 || srcY != 0 )
	{ LLDEB(srcX,srcY); return 0;	}

    done= bmBmpReadDib( &abi->abiBitmap, &abi->abiBuffer, sis );
    if  ( done < 0 || done > expectBytes )
	{
	LLDEB(done,expectBytes);
	appCleanBitmapImage( abi ); free( abi );
	return -1;
	}

    while( done < expectBytes )
	{ sioInGetCharacter( sis ); done++;	}

    if  ( srcXExt != abi->abiBitmap.bdPixelsWide	||
	  srcYExt != abi->abiBitmap.bdPixelsHigh	)
	{
	LLDEB(srcXExt,abi->abiBitmap.bdPixelsWide);
	LLDEB(srcYExt,abi->abiBitmap.bdPixelsHigh);
	appCleanBitmapImage( abi ); free( abi );
	return 0;
	}

    if  ( appImgMakeImage( add->addDisplay, dcx->dcxScreen,
				    &xim, dstXExt, dstYExt, ac, abi ) )
	{ LDEB(1); appCleanBitmapImage( abi ); free( abi ); return -1; }

    XPutImage( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
			    xim, srcX, srcY, dstX, dstY, dstXExt, dstYExt );
    XDestroyImage( xim );

    if  ( dstX == 0				&&
	  dstY == 0				&&
	  dstXExt == dcx->dcxPixelsWide		&&
	  dstYExt == dcx->dcxPixelsHigh		)
	{
	bd= &(abi->abiBitmap);
	bd->bdUnit= BMunINCH;
	bd->bdXResolution= ( 72* 20* bd->bdPixelsWide )/ dc->dcTwipsWide;
	bd->bdYResolution= ( 72* 20* bd->bdPixelsHigh )/ dc->dcTwipsHigh;

	if  ( *pAbi )
	    { appCleanBitmapImage( *pAbi ); free( *pAbi ); }

	*pAbi= abi;
	}
    else{
	LLDEB(dstX,dstY);
	LLDEB(dstXExt,dcx->dcxPixelsWide);
	LLDEB(dstYExt,dcx->dcxPixelsHigh);
	appCleanBitmapImage( abi ); free( abi );
	}

    return 0;
    }

static int appMeta_RoundRectX11(	SimpleInputStream *	sis,
					int			recordSize,
					AppDrawingData *	add,
					DeviceContextX11 *	dcx )
    {
    int		y0;
    int		x0;
    int		y1;
    int		x1;

    int		h;
    int		w;

    int		swap;

    XArc	arcs[4];
    XSegment	segments[4];
    XPoint	points[12];

    h= sioEndianGetLeInt16( sis );
    w= sioEndianGetLeInt16( sis );

    y1= sioEndianGetLeInt16( sis );
    x1= sioEndianGetLeInt16( sis );
    y0= sioEndianGetLeInt16( sis );
    x0= sioEndianGetLeInt16( sis );

    WMFDEB(DEBFUN("RoundRect(%d..%d,%d..%d, w= %d,h= %d\n",
					    x0,x1,y0,y1, w, h ));

    y0= DCX_Y( y0, dcx );
    x0= DCX_X( x0, dcx );
    y1= DCX_Y( y1, dcx );
    x1= DCX_X( x1, dcx );

    h= DCX_H( h, dcx );
    w= DCX_W( w, dcx );

    if  ( x1 < x0 )
	{ swap= x0; x0= x1; x1= swap; }
    if  ( y1 < y0 )
	{ swap= y0; y0= y1; y1= swap; }

    if  ( h < 0 )
	{ h= -h;	}
    if  ( w < 0 )
	{ w= -w;	}

    points[0].x= x0;
    points[0].y= y0+ h/ 2;

    arcs[0].x= x0;
    arcs[0].y= y0;
    arcs[0].width= w;
    arcs[0].height= h;
    arcs[0].angle1= 64*  180;
    arcs[0].angle2= 64*  -90;

    points[1].x= x0+ w/ 2;
    points[1].y= y0+ h/ 2;
    points[2].x= x0+ w/ 2;
    points[2].y= y0;

    segments[0].x1= x0+ w/2;
    segments[0].y1= y0;
    segments[0].x2= x1- w/2;
    segments[0].y2= y0;

    points[3].x= x1- w/ 2;
    points[3].y= y0;

    arcs[1].x= x1- w;
    arcs[1].y= y0;
    arcs[1].width= w;
    arcs[1].height= h;
    arcs[1].angle1= 64*   90;
    arcs[1].angle2= 64*  -90;

    points[4].x= x1- w/ 2;
    points[4].y= y0+ h/ 2;
    points[5].x= x1;
    points[5].y= y0+ w/ 2;

    segments[1].x1= x1;
    segments[1].y1= y0+ h/2;
    segments[1].x2= x1;
    segments[1].y2= y1- h/2;

    points[6].x= x1;
    points[6].y= y1- w/ 2;

    arcs[2].x= x1- w;
    arcs[2].y= y1- h;
    arcs[2].width= w;
    arcs[2].height= h;
    arcs[2].angle1= 64*    0;
    arcs[2].angle2= 64*  -90;

    points[7].x= x1- w/ 2;
    points[7].y= y1- h/ 2;
    points[8].x= x1- w/ 2;
    points[8].y= y1;

    segments[2].x1= x1- w/2;
    segments[2].y1= y1;
    segments[2].x2= x0+ w/2;
    segments[2].y2= y1;

    points[9].x= x0+ w/ 2;
    points[9].y= y1;

    arcs[3].x= x0;
    arcs[3].y= y1- h;
    arcs[3].width= w;
    arcs[3].height= h;
    arcs[3].angle1= 64*  -90;
    arcs[3].angle2= 64*  -90;

    points[10].x= x0+ w/ 2;
    points[10].y= y1- h/ 2;
    points[11].x= x0;
    points[11].y= y1- h/ 2;

    segments[3].x1= x0;
    segments[3].y1= y1- h/2;
    segments[3].x2= x0;
    segments[3].y2= y0+ h/2;

    if  ( dcx->dcxDeviceContext.dcFillInsides )
	{
	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxBrushColor.pixel );

	XFillArcs( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc, arcs, 4 );
	XFillPolygon( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
					points, 12, Convex, CoordModeOrigin );
	}

    if  ( dcx->dcxDeviceContext.dcDrawBorders )
	{
	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxPenColor.pixel );

	XDrawArcs( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
								arcs, 4 );
	XDrawSegments( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
								segments, 4 );
	}

    return 0;
    }

static void appMetaGetArcX11(	SimpleInputStream *	sis,
				DeviceContextX11 *	dcx,
				char *			fun,
				int *			pY0,
				int *			pX0,
				int *			pY1,
				int *			pX1,
				int *			pa1,
				int *			pa2 )

    {
    int		y0;
    int		x0;
    int		y1;
    int		x1;

    int		ys;
    int		xs;
    int		ye;
    int		xe;

    int		ym;
    int		xm;
    int		h;
    int		w;

    double	as;
    double	ae;

    int		swap;

    ye= sioEndianGetLeInt16( sis );
    xe= sioEndianGetLeInt16( sis );
    ys= sioEndianGetLeInt16( sis );
    xs= sioEndianGetLeInt16( sis );

    y1= sioEndianGetLeInt16( sis );
    x1= sioEndianGetLeInt16( sis );
    y0= sioEndianGetLeInt16( sis );
    x0= sioEndianGetLeInt16( sis );

    WMFDEB(DEBFUN("%s(%d..%d,%d..%d, (%d,%d), (%d,%d)\n", fun,
					    x0,x1,y0,y1, xs,ys,xe,ye));
    y0= DCX_Y( y0, dcx );
    x0= DCX_X( x0, dcx );
    y1= DCX_Y( y1, dcx );
    x1= DCX_X( x1, dcx );

    ys= DCX_Y( ys, dcx );
    xs= DCX_X( xs, dcx );
    ye= DCX_Y( ye, dcx );
    xe= DCX_X( xe, dcx );

    ym= ( y1+ y0 )/2;
    xm= ( x1+ x0 )/2;

    if  ( x1 < x0 )
	{
	xs= 2* xm- xs;
	xe= 2* xm- xe;
	swap= x0; x0= x1; x1= swap;
	}
    if  ( y1 < y0 )
	{
	ys= 2* ym- ys;
	ye= 2* ym- ye;
	swap= y0; y0= y1; y1= swap;
	}

    h= y1- y0;
    w= x1- x0;

    as= -atan2(	(double) w* ( ys- ym ), (double) h* ( xs- xm ) );
    ae= -atan2(	(double) w* ( ye- ym ), (double) h* ( xe- xm ) );

    as= ( 180* as )/ M_PI;
    ae= ( 180* ae )/ M_PI;

    as= 64* as;
    ae= 64* ae;

    ae -= as;

    *pY0= y0;
    *pX0= x0;
    *pY1= y1;
    *pX1= x1;
    *pa1= (int)as;
    *pa2= (int)ae;

    return;
    }

static int appMeta_ArcX11(	SimpleInputStream *	sis,
				int			recordSize,
				AppDrawingData *	add,
				DeviceContextX11 *	dcx )
    {
    int		y0;
    int		x0;
    int		y1;
    int		x1;

    int		a1;
    int		a2;

    appMetaGetArcX11( sis, dcx, "Arc", &y0, &x0, &y1, &x1, &a1, &a2 );

    if  ( dcx->dcxDeviceContext.dcDrawBorders )
	{
	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxPenColor.pixel );

	XDrawArc( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
					    x0, y0, x1- x0, y1- y0, a1, a2 );
	}

    return 0;
    }

static int appMeta_PieX11(	SimpleInputStream *	sis,
				int			recordSize,
				AppDrawingData *	add,
				DeviceContextX11 *	dcx )
    {
    int		y0;
    int		x0;
    int		y1;
    int		x1;

    int		a1;
    int		a2;

    appMetaGetArcX11( sis, dcx, "Pie", &y0, &x0, &y1, &x1, &a1, &a2 );

    if  ( dcx->dcxDeviceContext.dcFillInsides )
	{
	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxBrushColor.pixel );

	XFillArc( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
					    x0, y0, x1- x0, y1- y0, a1, a2 );
	}

    if  ( dcx->dcxDeviceContext.dcDrawBorders )
	{
	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxPenColor.pixel );

	XDrawArc( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
					    x0, y0, x1- x0, y1- y0, a1, a2 );
	}

    return 0;
    }

static int appMeta_EllipseX11(	SimpleInputStream *	sis,
				int			recordSize,
				AppDrawingData *	add,
				DeviceContextX11 *	dcx )
    {
    int		y0;
    int		x0;
    int		y1;
    int		x1;

    int		swap;

    y1= sioEndianGetLeInt16( sis );
    x1= sioEndianGetLeInt16( sis );
    y0= sioEndianGetLeInt16( sis );
    x0= sioEndianGetLeInt16( sis );

    WMFDEB(DEBFUN("Ellipse(%d..%d,%d..%d)\n", x0,x1,y0,y1));

    x0= DCX_X( x0, dcx );
    y0= DCX_Y( y0, dcx );
    x1= DCX_X( x1, dcx );
    y1= DCX_Y( y1, dcx );

    if  ( x1 < x0 )
	{ swap= x0; x0= x1; x1= swap; }
    if  ( y1 < y0 )
	{ swap= y0; y0= y1; y1= swap; }

    if  ( dcx->dcxDeviceContext.dcDrawBorders )
	{
	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxPenColor.pixel );

	XDrawArc( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
				    x0, y0, x1- x0, y1- y0, 64* 0, 64* 360 );
	}

    if  ( dcx->dcxDeviceContext.dcFillInsides )
	{
	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxBrushColor.pixel );

	XFillArc( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
				    x0, y0, x1- x0, y1- y0, 64* 0, 64* 360 );
	}

    return 0;
    }

static int appMeta_RectangleX11(	SimpleInputStream *	sis,
					AppDrawingData *	add,
					DeviceContextX11 *	dcx )
    {
    LogicalPen *	lp= &(dcx->dcxDeviceContext.dcPen);

    int			y0;
    int			x0;
    int			y1;
    int			x1;

    int			swap;

    y1= sioEndianGetLeInt16( sis );
    x1= sioEndianGetLeInt16( sis );
    y0= sioEndianGetLeInt16( sis );
    x0= sioEndianGetLeInt16( sis );

    WMFDEB(DEBFUN("Rectangle(%d..%d,%d..%d)\n", x0,x1,y0,y1));

    x0= DCX_X( x0, dcx );
    y0= DCX_Y( y0, dcx );
    x1= DCX_X( x1, dcx );
    y1= DCX_Y( y1, dcx );

    if  ( x1 < x0 )
	{ swap= x0; x0= x1; x1= swap; }
    if  ( y1 < y0 )
	{ swap= y0; y0= y1; y1= swap; }

    if  ( dcx->dcxDeviceContext.dcFillInsides )
	{
	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxBrushColor.pixel );

	XFillRectangle( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
						    x0, y0, x1- x0, y1- y0 );
	}

    if  ( lp->lpStyle == PS_INSIDEFRAME )
	{ x1 -= 2; y1 -= 2; }

    if  ( dcx->dcxDeviceContext.dcDrawBorders )
	{
	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxPenColor.pixel );

	XDrawRectangle( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
						    x0, y0, x1- x0, y1- y0 );
	}

    return 0;
    }

static int appMeta_PolyLineX11(	SimpleInputStream *	sis,
				int			recordSize,
				AppDrawingData *	add,
				DeviceContextX11 *	dcx )
    {
    int			count;
    DeviceContext *	dc= &(dcx->dcxDeviceContext);

    if  ( appMetaGetCountAndPointsX11( dcx, &count, sis, recordSize ) )
	{ LDEB(recordSize); return -1;	}

    WMFDEB(DEBFUN("PolyLine( count=%d, ... )\n", count ));

    XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxPenColor.pixel );

    XDrawLines( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
				    dc->dcPoints, count, CoordModeOrigin );

    return 0;
    }

static int appMeta_PolygonX11(	SimpleInputStream *	sis,
				int			recordSize,
				AppDrawingData *	add,
				DeviceContextX11 *	dcx )
    {
    DeviceContext *	dc= &(dcx->dcxDeviceContext);
    int			count;

    if  ( appMetaGetCountAndPointsX11( dcx, &count, sis, recordSize ) )
	{ LDEB(recordSize); return -1;	}

    WMFDEB(DEBFUN("Polygon( count=%d, ... )\n", count ));

    if  ( dcx->dcxDeviceContext.dcDrawBorders )
	{
	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxPenColor.pixel );

	XDrawLines( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
				dc->dcPoints, count, CoordModeOrigin );
	}

    if  ( dcx->dcxDeviceContext.dcFillInsides )
	{
	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxBrushColor.pixel );

	XFillPolygon( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
			    dc->dcPoints, count, Complex, CoordModeOrigin );
	}

    return 0;
    }

static void appMetaDrawString(		int			x0,
					int			y0,
					int			count,
					AppDrawingData *	add,
					DeviceContextX11 *	dcx )
    {
    AppPhysicalFont *	apf= dcx->dcxPhysicalFont;
    DeviceContext *	dc= &(dcx->dcxDeviceContext);

    if  ( ! apf )
	{ XDEB(apf); return;	}

    XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxTextColor.pixel );

    y0 += (int)( 0.6* apf->apfFontStruct->ascent );

    XDrawString( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc, x0, y0,
						(char *)dc->dcString, count );

    if  ( dc->dcFont.lfTextAttribute.taIsUnderlined )
	{
	int	w;

	w= XTextWidth( apf->apfFontStruct, (const char *)dc->dcString, count );

	XFillRectangle( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
				x0, y0+ apf->apfUnderLinePositionPixels,
				w, apf->apfUnderlineThicknessPixels );
	}
    }

static int appMeta_ExtTextOutX11(	SimpleInputStream *	sis,
					int			recordSize,
					AppDrawingData *	add,
					DeviceContextX11 *	dcx )
    {
    int		x0;
    int		y0;
    int		count;
    int		style;

    int		h1;
    int		w1;
    int		y1;
    int		x1;

    if  ( appMeta_ExtTextOut( sis, recordSize, &x0, &y0, &count, &style,
			    &y1, &y1, &w1, &h1, &(dcx->dcxDeviceContext) ) )
	{ LDEB(1); return -1;	}

    x0= DCX_X( x0, dcx );
    y0= DCX_Y( y0, dcx );

    x1= DCX_X( x1, dcx );
    y1= DCX_Y( y1, dcx );

    w1= DCX_W( w1, dcx );
    h1= DCX_H( h1, dcx );

    appMetaDrawString( x0, y0, count, add, dcx );

    return 0;
    }

static int appMeta_TextOutX11(	SimpleInputStream *	sis,
				int			recordSize,
				AppDrawingData *	add,
				DeviceContextX11 *	dcx )
    {
    int		x0;
    int		y0;
    int		count;

    if  ( appMeta_TextOut( sis, recordSize,
				&x0, &y0, &count, &(dcx->dcxDeviceContext) ) )
	{ LDEB(1); return -1;	}

    x0= DCX_X( x0, dcx );
    y0= DCX_Y( y0, dcx );

    appMetaDrawString( x0, y0, count, add, dcx );

    return 0;
    }

static int appMeta_LineToX11(	SimpleInputStream *	sis,
				int			recordSize,
				AppDrawingData *	add,
				DeviceContextX11 *	dcx )
    {
    int		x0= dcx->dcxDeviceContext.dcX;
    int		y0= dcx->dcxDeviceContext.dcY;
    int		y1;
    int		x1;

    y1= sioEndianGetLeInt16( sis );
    x1= sioEndianGetLeInt16( sis );

    WMFDEB(DEBFUN("LineTo( x:%d->%d, y:%d->%d )\n", x0, x1, y0, y1 ));

    dcx->dcxDeviceContext.dcX= x1;
    dcx->dcxDeviceContext.dcY= y1;

    x0= DCX_X( x0, dcx );
    y0= DCX_Y( y0, dcx );
    x1= DCX_X( x1, dcx );
    y1= DCX_Y( y1, dcx );

    XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxPenColor.pixel );

    XDrawLine( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
							    x0, y0, x1, y1 );

    return 0;
    }

static int appMeta_PatBltX11(	SimpleInputStream *	sis,
				int			recordSize,
				AppDrawingData *	add,
				DeviceContextX11 *	dcx )
    {
    long	rop;

    int		h0;
    int		w0;
    int		y0;
    int		x0;

    int		x1;
    int		y1;

    int		swap;

    rop= sioEndianGetLeInt32( sis );
    h0= sioEndianGetLeInt16( sis );
    w0= sioEndianGetLeInt16( sis );
    y0= sioEndianGetLeInt16( sis );
    x0= sioEndianGetLeInt16( sis );

    WMFDEB(DEBFUN("PatBlt([%d+%d,%d+%d], rop=0x%lx )\n", x0,w0,y0,h0, rop ));

    x1= x0+ w0;
    y1= y0+ h0;

    x0= DCX_X( x0, dcx );
    y0= DCX_Y( y0, dcx );

    x1= DCX_X( x1, dcx );
    y1= DCX_Y( y1, dcx );

    if  ( x1 < x0 )
	{ swap= x0; x0= x1; x1= swap; }
    if  ( y1 < y0 )
	{ swap= y0; y0= y1; y1= swap; }

    if  ( dcx->dcxDeviceContext.dcFillInsides )
	{
	XSetForeground( add->addDisplay, dcx->dcxGc, dcx->dcxBrushColor.pixel );

	XFillRectangle( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
						    x0, y0, x1- x0, y1- y0 );
	}

    return 0;
    }

static int appMeta_PolyPolygonX11(	SimpleInputStream *	sis,
					int			recordSize,
					AppDrawingData *	add,
					DeviceContextX11 *	dcx )
    {
    DeviceContext *	dc= &(dcx->dcxDeviceContext);

    int			count;
    int			i;

    int *		counts;

    if  ( appMeta_GetCounts( sis, recordSize, &count, &counts,
						&(dcx->dcxDeviceContext ) ) )
	{ LDEB(1); return -1;	}

    WMFDEB(DEBFUN("PolyPolygon( count=%d, ... )\n", count ));

    for ( i= 0; i < count; i++ )
	{
	if  ( appMetaGetPointsX11( dcx, counts[i], sis ) )
	    { LDEB(counts[i]); return -1;	}

	if  ( dcx->dcxDeviceContext.dcDrawBorders )
	    {
	    XSetForeground( add->addDisplay, dcx->dcxGc,
						    dcx->dcxPenColor.pixel );

	    XDrawLines( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
				dc->dcPoints, counts[i], CoordModeOrigin );
	    }

	if  ( dcx->dcxDeviceContext.dcFillInsides )
	    {
	    XSetForeground( add->addDisplay, dcx->dcxGc,
						    dcx->dcxBrushColor.pixel );

	    XFillPolygon( add->addDisplay, dcx->dcxDrawable, dcx->dcxGc,
			dc->dcPoints, counts[i], Complex, CoordModeOrigin );
	    }
	}

    return 0;
    }

int appMetaPlayFileX11(	SimpleInputStream *	sis,
			void **			pPrivate,
			AppColors *		ac,
			DocumentFontList *	dfl,
			AppDrawingData *	add,
			Pixmap			pixmap,
			int			xExt,
			int			yExt,
			int			pixelsWide,
			int			pixelsHigh,
			int			twipsWide,
			int			twipsHigh,
			Window			win )
    {
    AppBitmapImage *	abi= (AppBitmapImage *)0;

    int			ob;

    {
    int		fileType;
    int		headerSize;
    int		windowsVersion;
    long	fileSize;
    int		objectCount;
    long	maxRecordSize;
    int		parameterCount;

    DeviceContextX11	dcx;

    fileType= sioEndianGetLeInt16( sis );
    headerSize= sioEndianGetLeInt16( sis );
    windowsVersion= sioEndianGetLeInt16( sis );
    fileSize= sioEndianGetLeInt32( sis );
    objectCount= sioEndianGetLeInt16( sis );
    maxRecordSize= sioEndianGetLeInt32( sis );
    parameterCount= sioEndianGetLeInt16( sis );

    if  ( appMetaInitDeviceContextX11( &dcx, add, ac, pixmap, objectCount,
		xExt, yExt, twipsWide, twipsHigh, pixelsWide, pixelsHigh ) )
	{ LDEB(1); return -1;	}

    XSetForeground( add->addDisplay, dcx.dcxGc,
				WhitePixel( add->addDisplay, dcx.dcxScreen ) );
    XFillRectangle( add->addDisplay, dcx.dcxDrawable, dcx.dcxGc, 0, 0,
					dcx.dcxPixelsWide, dcx.dcxPixelsHigh );

    WMFDEB(DEBFUN( "X11 METAFILE ...\n" ));

    for (;;)
	{
	long		rop;

	int		x0;
	int		y0;
	int		w0;
	int		h0;

	int		x1;
	int		y1;
	int		w1;
	int		h1;

	int		done;
	int		ignore;

	long		recordSize;
	int		function;

	recordSize= sioEndianGetLeInt32( sis );
	function= sioEndianGetLeInt16( sis );

	switch( function )
	    {
	    case WINMETA_OffsetWindowOrg:
		y0= sioEndianGetLeInt16( sis );
		x0= sioEndianGetLeInt16( sis );

		WMFDEB(DEBFUN("OffsetWindowOrg(yWinOrg+=%d,xWinOrg+=%d)\n",
							    y0,x0 ));
		dcx.dcxDeviceContext.dcOrgY += y0;
		dcx.dcxDeviceContext.dcOrgX += x0;

		continue;
	    case WINMETA_SetWindowOrg:
		y0= sioEndianGetLeInt16( sis );
		x0= sioEndianGetLeInt16( sis );

		WMFDEB(DEBFUN("SetWindowOrg(yWinOrg=%d,xWinOrg=%d)\n",
							    y0,x0 ));
		dcx.dcxDeviceContext.dcOrgY= y0;
		dcx.dcxDeviceContext.dcOrgX= x0;

		continue;
	    case WINMETA_SetWindowExt:
		y0= sioEndianGetLeInt16( sis );
		x0= sioEndianGetLeInt16( sis );

		WMFDEB(DEBFUN("SetWindowExt(yExt=%d,xExt=%d)\n", y0, x0 ));

		dcx.dcxDeviceContext.dcExtY= y0;
		dcx.dcxDeviceContext.dcExtX= x0;

		continue;
	    case WINMETA_SaveDC:
		WMFDEB(DEBFUN("SaveDC()\n"));
		continue;
	    case WINMETA_RestoreDC:
		ignore= sioEndianGetLeInt16( sis );
		WMFDEB(DEBFUN("RestoreDC(%d)\n",ignore));
		if  ( ignore != -1 )
		    { LDEB(ignore); return -1;	}
		continue;
	    case WINMETA_SetMapperFlags:
		rop= sioEndianGetLeInt32( sis );
		WMFDEB(DEBFUN("WINMETA_SetMapperFlags(0x%lx)\n",rop));
		continue;
	    case WINMETA_IntersectClipRect:
		h0= sioEndianGetLeInt16( sis );
		w0= sioEndianGetLeInt16( sis );
		y0= sioEndianGetLeInt16( sis );
		x0= sioEndianGetLeInt16( sis );
		WMFDEB(DEBFUN("IntersectClipRect([%d+%d,%d+%d])\n",
							    x0,w0,y0,h0 ));
		continue;
	    case WINMETA_StretchBlt:
		rop= sioEndianGetLeInt32( sis );
		h0= sioEndianGetLeInt16( sis );
		w0= sioEndianGetLeInt16( sis );
		y0= sioEndianGetLeInt16( sis );
		x0= sioEndianGetLeInt16( sis );
		h1= sioEndianGetLeInt16( sis );
		w1= sioEndianGetLeInt16( sis );
		y1= sioEndianGetLeInt16( sis );
		x1= sioEndianGetLeInt16( sis );

		WMFDEB(DEBFUN("StretchBlt([%d+%d,%d+%d]->[%d+%d,%d+%d],..)\n",
				x0,w0,y0,h0, x1,w1,y1,h1 ));

		x1= DCX_X( x1, &dcx );
		y1= DCX_Y( y1, &dcx );

		w1= DCX_W( w1, &dcx );
		h1= DCX_H( h1, &dcx );

		if  ( appMetaBitmapImageX11( &abi, sis, 2*(recordSize-3-2-8*1),
			    &dcx, ac, add, x0, y0, w0, h0, x1, y1, w1, h1 ) )
		    { LDEB(1); return -1; }

		continue;
	    case WINMETA_StretchDIBits:
		rop= sioEndianGetLeInt32( sis );
		ignore= sioEndianGetLeInt16( sis );
		/*  source	*/
		h0= sioEndianGetLeInt16( sis );
		w0= sioEndianGetLeInt16( sis );
		y0= sioEndianGetLeInt16( sis );
		x0= sioEndianGetLeInt16( sis );
		/*  destination	*/
		h1= sioEndianGetLeInt16( sis );
		w1= sioEndianGetLeInt16( sis );
		y1= sioEndianGetLeInt16( sis );
		x1= sioEndianGetLeInt16( sis );

		WMFDEB(DEBFUN(
			"StretchDIBits([%d+%d,%d+%d]->[%d+%d,%d+%d],..)\n",
			x0,w0,y0,h0, x1,w1,y1,h1 ));

		x1= DCX_X( x1, &dcx );
		y1= DCX_Y( y1, &dcx );

		w1= DCX_W( w1, &dcx );
		h1= DCX_H( h1, &dcx );

		if  ( appMetaBitmapImageX11( &abi, sis, 2*(recordSize-3-2-9*1),
			    &dcx, ac, add, x0, y0, w0, h0, x1, y1, w1, h1 ) )
		    { LDEB(1); return -1; }

		continue;

	    case WINMETA_SelectObject:
		if  ( appMetaSelectObjectX11( &dcx, ac, add, dfl,
							    recordSize, sis ) )
		    { LDEB(recordSize); return -1;	}
		continue;

	    case WINMETA_CreateBrushIndirect:
		if  ( appMetaCreateBrushIndirect(
				&(dcx.dcxDeviceContext), recordSize, sis ) )
		    { LDEB(recordSize); return -1;	}
		continue;

	    case WINMETA_CreatePenIndirect:
		if  ( appMetaCreatePenIndirect(
				&(dcx.dcxDeviceContext), recordSize, sis ) )
		    { LDEB(recordSize); return -1;	}
		continue;

	    case WINMETA_CreatePatternBrush:
		if  ( appMetaCreatePatternBrush(
				&(dcx.dcxDeviceContext), recordSize, sis ) )
		    { LDEB(recordSize); return -1;	}
		continue;

	    case WINMETA_CreatePalette:
		if  ( appMetaCreatePalette(
				&(dcx.dcxDeviceContext), recordSize, sis ) )
		    { LDEB(recordSize); return -1;	}
		continue;

	    case WINMETA_CreateFontIndirect:
		if  ( appMetaCreateFontIndirect(
			    &(dcx.dcxDeviceContext), dfl, recordSize, sis ) )
		    { LDEB(1); return -1;	}
		continue;

	    case WINMETA_DeleteObject:
		ob= sioEndianGetLeInt16( sis );

		if  ( appMetaDeleteObject( &(dcx.dcxDeviceContext), ob ) )
		    { LDEB(1); return -1;	}
		continue;

	    case WINMETA_SetBkColor:
		appMetaGetColor( sis, &(dcx.dcxDeviceContext.dcBkColor) );

		WMFDEB(DEBFUN("SetBkColor( r=%d, g=%d, b= %d )\n",
			    dcx.dcxDeviceContext.dcBkColor.rgb8Red,
			    dcx.dcxDeviceContext.dcBkColor.rgb8Green,
			    dcx.dcxDeviceContext.dcBkColor.rgb8Blue ));

		if  ( appColorRgb( &dcx.dcxBkColor, ac,
			    dcx.dcxDeviceContext.dcBkColor.rgb8Red,
			    dcx.dcxDeviceContext.dcBkColor.rgb8Green,
			    dcx.dcxDeviceContext.dcBkColor.rgb8Blue ) )
		    { LDEB(1);  return -1;	}

		continue;

	    case WINMETA_SetTextColor:
		appMetaGetColor( sis, &(dcx.dcxDeviceContext.dcTextColor) );

		WMFDEB(DEBFUN("SetTextColor( r=%d, g=%d, b= %d )\n",
			    dcx.dcxDeviceContext.dcTextColor.rgb8Red,
			    dcx.dcxDeviceContext.dcTextColor.rgb8Green,
			    dcx.dcxDeviceContext.dcTextColor.rgb8Blue ));

		if  ( appColorRgb( &dcx.dcxTextColor, ac,
			    dcx.dcxDeviceContext.dcTextColor.rgb8Red,
			    dcx.dcxDeviceContext.dcTextColor.rgb8Green,
			    dcx.dcxDeviceContext.dcTextColor.rgb8Blue ) )
		    { LDEB(1);  return -1;	}

		continue;

	    case WINMETA_SetBkMode:
		WMFDEB(DEBFUN("SetBkMode(...)\n"));
		if  ( recordSize == 4 )
		    {
		    dcx.dcxDeviceContext.dcBkMode= sioEndianGetLeInt16( sis );
		    continue;
		    }
		if  ( recordSize == 5 )
		    {
		    dcx.dcxDeviceContext.dcBkMode= sioEndianGetLeInt32( sis );
		    continue;
		    }
		XLDEB(function,recordSize); return -1;

	    case WINMETA_SetTextCharExtra:
		WMFDEB(DEBFUN("SetTextCharExtra(...)\n"));
		dcx.dcxDeviceContext.dcExtraTextSpacing=
						sioEndianGetLeInt16( sis );
		continue;

	    case WINMETA_SetTextAlign:
		WMFDEB(DEBFUN("SetTextAlign(...)\n"));
		if  ( recordSize == 4 )
		    {
		    dcx.dcxDeviceContext.dcTextAlignment=
						    sioEndianGetLeInt16( sis );
		    continue;
		    }
		if  ( recordSize == 5 )
		    {
		    dcx.dcxDeviceContext.dcTextAlignment=
						    sioEndianGetLeInt32( sis );
		    continue;
		    }
		XLDEB(function,recordSize); return -1;

	    case WINMETA_SetTextJustification:
		WMFDEB(DEBFUN("SetTextJustification(...)\n"));

		dcx.dcxDeviceContext.dcJustificationAmount=
						sioEndianGetLeInt16( sis );
		dcx.dcxDeviceContext.dcJustificationSpaces=
						sioEndianGetLeInt16( sis );
		continue;

	    case WINMETA_SetStretchBltMode:
		switch( recordSize )
		    {
		    case 4:
			dcx.dcxDeviceContext.dcStretchBltMode=
						    sioEndianGetLeInt16( sis );
			break;
		    case 5:
			dcx.dcxDeviceContext.dcStretchBltMode=
						    sioEndianGetLeInt32( sis );
			break;
		    default:
			LDEB(recordSize); return -1;
		    }
		WMFDEB(DEBFUN("SetStretchBltMode(%ld)\n",
					dcx.dcxDeviceContext.dcStretchBltMode));
		continue;

	    case WINMETA_PolyLine:
		if  ( appMeta_PolyLineX11( sis, recordSize, add, &dcx ) )
		    { LDEB(1); return -1;	}
		continue;

	    case WINMETA_Polygon:
		if  ( appMeta_PolygonX11( sis, recordSize, add, &dcx ) )
		    { LDEB(1); return -1;	}
		continue;

	    case WINMETA_Rectangle:
		if  ( appMeta_RectangleX11( sis, add, &dcx ) )
		    { LDEB(1); return -1;	}
		continue;

	    case WINMETA_LineTo:
		if  ( appMeta_LineToX11( sis, recordSize, add, &dcx ) )
		    { LDEB(1); return -1;	}
		continue;

	    case WINMETA_MoveTo:
		y0= sioEndianGetLeInt16( sis );
		x0= sioEndianGetLeInt16( sis );

		WMFDEB(DEBFUN("MoveTo( x=%d, y=%d )\n", x0, y0 ));

		dcx.dcxDeviceContext.dcX= x0;
		dcx.dcxDeviceContext.dcY= y0;

		continue;

	    case WINMETA_ExtTextOut:
		if  ( appMeta_ExtTextOutX11( sis, recordSize, add, &dcx ) )
		    { LDEB(recordSize); return -1;	}
		continue;

	    case WINMETA_TextOut:
		if  ( appMeta_TextOutX11( sis, recordSize, add, &dcx ) )
		    { LDEB(recordSize); return -1;	}
		continue;

	    case WINMETA_Escape:
		WMFDEB(DEBFUN("Escape(...)\n"));
		goto skipArguments;

	    case WINMETA_PatBlt:
		if  ( appMeta_PatBltX11( sis, recordSize, add, &dcx ) )
		    { LDEB(recordSize); return -1;	}
		continue;

	    case WINMETA_SetPolyFillMode:
		WMFDEB(DEBFUN("SetPolyFillMode(...)\n"));
		goto skipArguments;

	    case WINMETA_RoundRect:
		if  ( appMeta_RoundRectX11( sis, recordSize, add, &dcx ) )
		    { LDEB(1); return -1;	}
		continue;

	    case WINMETA_Pie:
		if  ( appMeta_PieX11( sis, recordSize, add, &dcx ) )
		    { LDEB(1); return -1;	}
		continue;

	    case WINMETA_Arc:
		if  ( appMeta_ArcX11( sis, recordSize, add, &dcx ) )
		    { LDEB(1); return -1;	}
		continue;

	    case WINMETA_Ellipse:
		if  ( appMeta_EllipseX11( sis, recordSize, add, &dcx ) )
		    { LDEB(1); return -1;	}
		continue;

	    case WINMETA_SetMapMode:
		dcx.dcxDeviceContext.dcMapMode= sioEndianGetLeInt16( sis );
		WMFDEB(DEBFUN("SetMapMode(%d)\n",
					    dcx.dcxDeviceContext.dcMapMode ));
		continue;
	    case WINMETA_SetROP2:
		if  ( recordSize == 5 )
		    {
		    dcx.dcxDeviceContext.dcROP2= sioEndianGetLeInt32( sis );
		    WMFDEB(DEBFUN("SetROP2(%ld)\n",
					(long)dcx.dcxDeviceContext.dcROP2 ));
		    continue;
		    }
		if  ( recordSize == 4 )
		    {
		    dcx.dcxDeviceContext.dcROP2= sioEndianGetLeInt16( sis );
		    WMFDEB(DEBFUN("SetROP2(%ld)\n",
					(long)dcx.dcxDeviceContext.dcROP2 ));
		    continue;
		    }
		XLDEB(function,recordSize); return -1;
	    case WINMETA_SelectPalette:
		ob= sioEndianGetLeInt16( sis );
		WMFDEB(DEBFUN("SelectPalette(%d)\n", ob ));
		continue;
	    case WINMETA_RealizePalette:
		WMFDEB(DEBFUN("RealizePalette()\n"));
		continue;
	    case WINMETA_PolyPolygon:
		if  ( appMeta_PolyPolygonX11( sis, recordSize, add, &dcx ) )
		    { LDEB(1); return -1;	}
		continue;

	    case WINMETA_ScaleViewportExt:
		x0= sioEndianGetLeInt16( sis );
		y0= sioEndianGetLeInt16( sis );
		x1= sioEndianGetLeInt16( sis );
		y1= sioEndianGetLeInt16( sis );

		WMFDEB(DEBFUN("ScaleViewportExt(%d..%d,%d..%d)\n",
								x0,x1,y0,y1));
		break;
	    case 0:
		if  ( recordSize != 3 )
		    { XLDEB(function,recordSize); return -1;	}
		break;
	    skipArguments:
		for ( done= 3; done < recordSize; done++ )
		    { ignore= sioEndianGetLeInt16( sis ); }
		continue;
	    default:
		XLDEB(function,recordSize);
		/*
		for ( done= 3; done < recordSize; done++ )
		    { ignore= sioEndianGetLeInt16( sis ); }
		continue;
		*/
		return -1;
	    }

	break;
	}

    appMetaCleanDeviceContextX11( &dcx, add );
    }

    *pPrivate= (void *)abi;

    return 0;
    }
