/************************************************************************/
/*  Make/Manage puldowns that are usable.				*/
/************************************************************************/

#   include	<X11/Intrinsic.h>

extern void appPulldownSetWidth(	Widget		w,
					Dimension	newWidth	);

extern void appMakePulldownList(	Widget *	pPulldown,
					Widget *	pMenu,
					Widget		parentForm );

extern void appEmptyPulldownList(	Widget	pulldown	);

extern Widget appPulldownMakeOption(	Widget		pulldown,
					const char *	label,
					int		width,
					XtCallbackProc	callBack,
					void *		target );

/************************************************************************/
/*  Use the text of a menu option as the title of a tool.		*/
/************************************************************************/

extern void appSetShellTitle(	Widget			shell,
				Widget			option,
				const char *		applicationName );

/************************************************************************/
/*  Event handler to set minimum size.					*/
/************************************************************************/

extern void appSetSizeAsMinimum(	Widget			w,
					void *			through,
					XEvent *		event,
					Boolean *		pRefused );

extern void appFixSize(			Widget			w,
					void *			through,
					XEvent *		event,
					Boolean *		pRefused );

/************************************************************************/
/*  Names of the X11 events.						*/
/************************************************************************/
extern char * APP_X11EventNames[];

/************************************************************************/
/*  Attach a dialog to its subject.					*/
/************************************************************************/

extern int appSetRelativeArgs(	Arg *		al,
				Widget		relative );

extern void appDialogRelative(	Widget		relative,
				Widget		dialog );

extern void appSetRelativeCallback(		Widget		relative,
						Widget		dialog );

/************************************************************************/
/*  Move the keyboard focus to a modal dialog.				*/
/************************************************************************/

extern void appSetFocusCallback(		Widget		dialog );
