/************************************************************************/
/*  Application, Main module.						*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<locale.h>

#   include	<Xm/Xm.h>
#   include	<Xm/PanedW.h>
#   include	<Xm/RowColumn.h>
#   include	<Xm/AtomMgr.h>
#   include	<Xm/ToggleB.h>
#   include	<Xm/Form.h>
#   include	<Xm/Label.h>

#   include	<Xm/Protocols.h>
#   include	<Xm/MwmUtil.h>

#   include	<appSystem.h>

#   include	<appFrame.h>
#   include	"appUnit.h"
#   include	"appPaper.h"
#   include	"appGeoString.h"
#   include	<debugon.h>

/************************************************************************/
/*  Hide the application window if shown as an 'about' window.		*/
/************************************************************************/
void appAppFileHide(	Widget		option,
			XtPointer	voidea,
			XtPointer	call_data	 )
    {
    EditApplication *		ea= (EditApplication *)voidea;

    ea->eaMainVisibleAsAbout= 0;

    if  ( ea->eaVisibleDocumentCount > 0 )
	{ XtUnmapWidget( ea->eaTopWidget ); }

    return;
    }

/************************************************************************/
/*  Minimise the application.						*/
/************************************************************************/
void appAppFileMini(	Widget		option,
			XtPointer	voidea,
			XtPointer	call_data	 )
    {
    EditApplication *		ea= (EditApplication *)voidea;
    Window			win= XtWindow( ea->eaTopWidget );

    XtVaSetValues( ea->eaTopWidget, XmNinitialState, IconicState, NULL );
    XIconifyWindow( ea->eaDisplay, win, ea->eaScreen );

    return;
    }

static void appAppWmClose(	Widget		option,
				XtPointer	voidea,
				XtPointer	call_data	 )
    {
    EditApplication *		ea= (EditApplication *)voidea;

    if  ( ea->eaMainVisibleAsAbout )
	{ appAppFileHide( option, voidea, call_data );	}
    else{
	appQuitApplication( option, ea->eaTopWidget, ea, call_data );
	}
    }

/************************************************************************/
/*  Quit the application.						*/
/************************************************************************/

void appQuitApplication(	Widget			option,
				Widget			relative,
				EditApplication *	ea,
				XtPointer		call_data	 )
    {
    EditDocument *		ed;

    int				i;
    int				past= ea->eaOpenCount;

    int				rcc;
    int				changedCount= 0;

    for ( i= 0; i < past; i++ )
	{
	ed= ea->eaOpenDocuments[i];

	if  ( ed->edHasBeenChanged )
	    { changedCount++;	}
	}

    if  ( changedCount == 0 )
	{
	if  ( ea->eaDisplay )
	    { appDiscardImagePixmaps( ea );	}

	exit( 0 );
	}

    if  ( changedCount > 1 )
	{
	rcc= appRunReallyQuitDialog( option, relative, ea, call_data );

	switch( rcc )
	    {
	    case AQDrespCANCEL:
		return;
	    case AQDrespNO:
		if  ( ea->eaDisplay )
		    { appDiscardImagePixmaps( ea );	}
		exit( 0 ); return;
	    default:
		LDEB(rcc); return;
	    case AQDrespYES:
		break;
	    }
	}

    for ( i= past- 1; i >= 0; i-- )
	{
	ed= ea->eaOpenDocuments[i];

	if  ( ed->edHasBeenChanged )
	    {
	    appMakeDocVisible( ea, ed );
	    appRunReallyCloseDialog( option, ea, ed, call_data );
	    }
	}

    past= ea->eaOpenCount;
    for ( i= 0; i < past; i++ )
	{
	ed= ea->eaOpenDocuments[i];

	if  ( ed->edHasBeenChanged )
	    { break;	}
	}

    if  ( i >= past )
	{
	if  ( ea->eaDisplay )
	    { appDiscardImagePixmaps( ea );	}

	exit( 0 );
	}

    return;
    }

void appAppFileQuit(	Widget		option,
			XtPointer	voidea,
			XtPointer	call_data	 )
    {
    EditApplication *	ea= (EditApplication *)voidea;

    appQuitApplication( option, ea->eaTopWidget, ea, call_data );
    }

/************************************************************************/
/*									*/
/*  Open a new document.						*/
/*									*/
/************************************************************************/

void appAppFileNew(	Widget		option,
			XtPointer	voidea,
			XtPointer	call_data	 )
    {
    EditApplication *		ea= (EditApplication *)voidea;
    const char *		filename= (const char *)0;

    if  ( appNewDocument( ea, filename ) )
	{ SDEB(filename); }

    return;
    }

/************************************************************************/
/*									*/
/*  Make a document the current Document.				*/
/*									*/
/************************************************************************/

static void appHighlightCurrentDocument( EditApplication *	ea,
					EditDocument *		ed,
					int			current )
    {
    WidgetList		children;
    Cardinal		childCount;
    int			j;

    Pixel		pix;

    if  ( current )
	{ pix= ea->eaCurrentDocMenuPixel;	}
    else{ pix= ea->eaOtherDocMenuPixel;		}

    XtVaSetValues( ed->edMenuBar,
			XmNbackground,	pix,
			NULL );

    XtVaGetValues( ed->edMenuBar,
			XmNchildren,		&children,
			XmNnumChildren,		&childCount,
			NULL );

    for ( j= childCount- 1; j >= 0; j-- )
	{
	XtVaSetValues( children[j],
			XmNbackground,	pix,
			NULL );
	}

    return;
    }

void appSetCurrentDocument(	EditApplication *	ea,
				EditDocument *		ed	)
    {
    if  ( ea->eaCurrentDocument )
	{ appHighlightCurrentDocument( ea, ea->eaCurrentDocument, 0 ); }

    ea->eaCurrentDocument= ed;

    appHighlightCurrentDocument( ea, ea->eaCurrentDocument, 1 );
    }

/************************************************************************/
/*  Remember whether a document has been changed.			*/
/************************************************************************/
static void appSetWindowsItemState(	Widget		menu,
					EditDocument *	ed,
					int		changed )
    {
    WidgetList		children;
    Cardinal		childCount;

    int			j;

    XtVaGetValues( menu,
			XmNchildren,		&children,
			XmNnumChildren,		&childCount,
			NULL );

    for ( j= childCount- 1; j >= 0; j-- )
	{
	void *	voided= (void *)0;

	XtVaGetValues( children[j],
			XmNuserData,	&voided,
			NULL );

	if  ( voided == (void *)ed )
	    { XmToggleButtonSetState( children[j], changed, False ); }
	}

    return;
    }

void appDocumentChanged(	EditApplication *	ea,
				EditDocument *		ed,
				int			changed	)
    {
    changed= changed != 0;

    if  ( ed->edHasBeenChanged != changed )
	{
	int		i;

	for ( i= 0; i < ea->eaOpenCount; i++ )
	    {
	    if  ( ea->eaOpenDocuments[i] == ed )
		{ continue;	}

	    appSetWindowsItemState( ea->eaOpenDocuments[i]->edWindowMenu,
								ed, changed );
	    }

	appSetWindowsItemState( ea->eaWinMenu, ed, changed );

	ed->edHasBeenChanged= changed;
	}
    }

/************************************************************************/
/*  Count the number of visible documents.				*/
/************************************************************************/
void appDocVisible(	EditApplication *	ea,
			EditDocument *		ed,
			int			visible	)
    {
    int	from;

    if  ( visible )
	{ from= ea->eaVisibleDocumentCount++;	}
    else{ from= ea->eaVisibleDocumentCount--;	}

    if  ( ea->eaVisibleDocumentCount == 0 )
	{ XtMapWidget( ea->eaTopWidget ); }
    else{
	if  ( ! ea->eaMainVisibleAsAbout )
	    { XtUnmapWidget( ea->eaTopWidget );	}
	}

    if  ( ea->eaVisibleDocumentCountChanged )
	{
	(*ea->eaVisibleDocumentCountChanged)
				    ( ea, from, ea->eaVisibleDocumentCount );
	}
    }

/************************************************************************/
/*  Remove a reference to a document.					*/
/************************************************************************/
static void appRemoveWindowsOption(	Widget			menu,
					EditDocument *		oldEd )
    {
    WidgetList		children;
    Cardinal		childCount;

    int			i;

    XtVaGetValues( menu,
			XmNchildren,		&children,
			XmNnumChildren,		&childCount,
			NULL );

    for ( i= childCount- 1; i >= 0; i-- )
	{
	void *	voided= (void *)0;

	XtVaGetValues( children[i],
			XmNuserData,	&voided,
			NULL );

	if  ( voided == (void *)oldEd )
	    { XtDestroyWidget( children[i] );	}
	}
    }

static void appRenameWindowsOption(	Widget			menu,
					EditDocument *		ed,
					XmString		titleString )
    {
    WidgetList		children;
    Cardinal		childCount;

    int			i;

    XtVaGetValues( menu,
			XmNchildren,		&children,
			XmNnumChildren,		&childCount,
			NULL );

    for ( i= childCount- 1; i >= 0; i-- )
	{
	void *	voided= (void *)0;

	XtVaGetValues( children[i],
			XmNuserData,	&voided,
			NULL );

	if  ( voided == (void *)ed )
	    {
	    XtVaSetValues( children[i],
				XmNlabelString,	titleString,
				NULL );
	    }
	}
    }

void appRemoveDocument(	EditApplication *	ea,
			EditDocument *		ed	)
    {
    int		i;
    int		count= 0;

    for ( i= 0; i < ea->eaOpenCount; i++ )
	{
	if  ( ea->eaOpenDocuments[i] == ed )
	    { continue;	}

	appRemoveWindowsOption( ea->eaOpenDocuments[i]->edWindowMenu, ed );
	ea->eaOpenDocuments[count++]= ea->eaOpenDocuments[i];
	}

    appRemoveWindowsOption( ea->eaWinMenu, ed );

    ea->eaOpenCount= count;

    if  ( ea->eaCurrentDocument == ed )
	{ ea->eaCurrentDocument= (EditDocument *)0;	}

    if  ( ed->edIsVisible )
	{
	ed->edIsVisible= 0;
	appDocVisible( ea, ed, ed->edIsVisible );
	}

    return;
    }

void appRenameDocumentOptions(	EditApplication *	ea,
				EditDocument *		ed,
				char *			title )
    {
    int		i;
    XmString	titleString;

    titleString= XmStringCreateLocalized( title );

    for ( i= 0; i < ea->eaOpenCount; i++ )
	{
	if  ( ea->eaOpenDocuments[i] == ed )
	    { continue;	}

	appRenameWindowsOption( ea->eaOpenDocuments[i]->edWindowMenu,
							    ed, titleString );
	}

    appRenameWindowsOption( ea->eaWinMenu, ed, titleString );

    XmStringFree( titleString );

    return;
    }

/************************************************************************/
/*  Remember a reference to a document.					*/
/************************************************************************/
static void appAppSetWindowsOption(	Widget			menu,
					EditDocument *		ed,
					XmString		labelString )
    {
    Widget		windowsOption;

    Arg			al[20];
    int			ac= 0;

    XtSetArg( al[ac], XmNlabelString,		labelString ); ac++;
    XtSetArg( al[ac], XmNvisibleWhenOff,	True ); ac++;
    XtSetArg( al[ac], XmNuserData,		ed ); ac++;

    windowsOption= XmCreateToggleButton( menu, WIDGET_NAME, al, ac );

    XtAddCallback( windowsOption, XmNvalueChangedCallback,
						    appDocToFront, ed );
    XtManageChild( windowsOption );

    XmToggleButtonSetState( windowsOption, ed->edHasBeenChanged, False );
    }

void appSetDocument(	EditApplication *	ea,
			EditDocument *		newEd,
			const char *		title	)
    {
    EditDocument **	fresh;
    XmString		labelString;

    int			i;

    Arg			al[20];
    int			ac= 0;

    fresh= (EditDocument **)realloc( ea->eaOpenDocuments,
			( ea->eaOpenCount+ 1 )* sizeof(EditDocument *) );
    if  ( ! fresh )
	{ XDEB(fresh); return;	}

    fresh[ea->eaOpenCount]= newEd;
    ea->eaOpenDocuments= fresh;

    labelString= XmStringCreateLocalized( (char *)title );

    XtSetArg( al[ac], XmNlabelString, labelString ); ac++;

    for ( i= 0; i < ea->eaOpenCount; i++ )
	{
	XmString	otherLabel;

	appAppSetWindowsOption( ea->eaOpenDocuments[i]->edWindowMenu,
							newEd, labelString );

	otherLabel= XmStringCreateLocalized(
				    ea->eaOpenDocuments[i]->edTitle );

	appAppSetWindowsOption( newEd->edWindowMenu,
					ea->eaOpenDocuments[i], otherLabel );

	XmStringFree( otherLabel );
	}

    appAppSetWindowsOption( ea->eaWinMenu, newEd, labelString );

    XmStringFree( labelString );

    ea->eaOpenCount++;

    return;
    }

/************************************************************************/
/*									*/
/*  Generic Editor main.						*/
/*									*/
/*  1)  Make an application shell.					*/
/*  1b) Obtain resource values.						*/
/*  2)  Remember X11 properties.					*/
/*  3)  Remember Window manager properties.				*/
/*									*/
/************************************************************************/
# define xx(x)	x,x

static float OneDotTwo= 1.2;

static XtResource	APP_ApplicationResourceTable[]=
    {
	{ xx("unit"), XtRString, sizeof(char *),
		    offsetof(EditApplication,eaUnitString),
		    XtRString, "inch" },
	{ xx("paper"), XtRString, sizeof(char *),
		    offsetof(EditApplication,eaPaperString),
		    XtRString, "letter" },
	{ xx("leftMargin"), XtRString, sizeof(char *),
		    offsetof(EditApplication,eaLeftMarginString),
		    XtRString, "90pt" },
	{ xx("rightMargin"), XtRString, sizeof(char *),
		    offsetof(EditApplication,eaRightMarginString),
		    XtRString, "90pt" },
	{ xx("topMargin"), XtRString, sizeof(char *),
		    offsetof(EditApplication,eaTopMarginString),
		    XtRString, "72pt" },
	{ xx("bottomMargin"), XtRString, sizeof(char *),
		    offsetof(EditApplication,eaBottomMarginString),
		    XtRString, "72pt" },
	{ xx("magnification"), XtRFloat, sizeof(float),
		    offsetof(EditApplication,eaMagnification),
		    XtRFloat, (void *)&OneDotTwo },

	{ xx("author"), XtRString, sizeof(char *),
		    offsetof(EditApplication,eaAuthor),
		    XtRString, (char *)0 },

	{ xx("sessionManagement"), XtRBool, sizeof(Bool),
		    offsetof(EditApplication,eaSessionManagement),
		    XtRString, "False" },

	{ xx("afmDirectory"), XtRString, sizeof(char *),
		    offsetof(EditApplication,eaAfmDirectory),
		    XtRString, AFMDIR },
	{ xx("defaultFont"), XtRString, sizeof(char *),
		    offsetof(EditApplication,eaDefaultFont),
		    XtRString, "Helvetica,,,10" },
	{ xx("faxCommand"), XtRString, sizeof(char *),
		    offsetof(EditApplication,eaFaxCommand),
		    XtRString, (char *)0 },
    };

int appMain(	EditApplication *	ea,
		int			argc,
		char *			argv[]	)
    {
    int				arg;

    AppDocSelectionType *	adst;
    AppAppSelectionType *	aast;
    int				i;

    Arg				al[20];
    int				ac= 0;

    Pixmap			pixmap= (Pixmap)0;

    int				paperFormat;
    int				width;
    int				height;

    Widget			pictureLabel= (Widget)0;
    Widget			label;
    XmString			labelString;

    MwmHints			hints;

    setlocale( LC_ALL, "" );

    XtSetLanguageProc( NULL, NULL, NULL );

    /*  1  */
    hints.flags= MWM_HINTS_FUNCTIONS|MWM_HINTS_DECORATIONS;
    hints.functions=	MWM_FUNC_MOVE		|
			MWM_FUNC_MINIMIZE	|
			MWM_FUNC_CLOSE		;
    hints.decorations=	MWM_DECOR_BORDER	|
			MWM_DECOR_TITLE		|
			MWM_DECOR_MENU		|
			MWM_DECOR_MINIMIZE	;
    ac= 0;
    XtSetArg( al[ac], XmNinput,			True ); ac++;
    XtSetArg( al[ac], XmNallowShellResize,	True ); ac++;
    XtSetArg( al[ac], XmNmwmDecorations,	hints.decorations ); ac++;
    XtSetArg( al[ac], XmNmwmFunctions,		hints.functions ); ac++;

    ea->eaTopWidget= XtAppInitialize( &(ea->eaContext),
					ea->eaApplicationName,
					NULL, 0, &argc, argv, NULL, al, ac );

    /*  1b  */
    XtGetApplicationResources( ea->eaTopWidget, ea->eaResourceData,
			ea->eaResourceTable, ea->eaResourceCount,
			NULL, 0 );

    XtGetApplicationResources( ea->eaTopWidget, &(ea->eaFileMessageResources),
			ea->eaFileMessageResourceTable,
			ea->eaFileMessageResourceCount,
			NULL, 0 );

    appInitDocumentGeometry( &(ea->eaDefaultDocumentGeometry) );
    XtGetApplicationResources( ea->eaTopWidget, (void *)ea,
		APP_ApplicationResourceTable,
		XtNumber(APP_ApplicationResourceTable),
		NULL, 0 );

    ea->eaUnitInt= appUnitTypeInt( ea->eaUnitString );
    if  ( ea->eaUnitInt < 0 )
	{ SDEB(ea->eaUnitString); ea->eaUnitInt= UNITtyINCH; }

    paperFormat= appPaperGetByMnemonic( ea->eaPaperString );
    if  ( paperFormat >= 0 )
	{
	if  ( ! appPaperGetInformation( paperFormat,
				&width, &height, (const char **)0 ) )
	    {
	    ea->eaDefaultDocumentGeometry.dgPaperWideTwips= width;
	    ea->eaDefaultDocumentGeometry.dgPaperHighTwips= height;
	    }
	else{ SDEB(ea->eaPaperString);	}
	}
    else{
	if  ( ! appGeoRectangleFromString( ea->eaPaperString, ea->eaUnitInt,
							    &width, &height ) )
	    {
	    ea->eaDefaultDocumentGeometry.dgPaperWideTwips= width;
	    ea->eaDefaultDocumentGeometry.dgPaperHighTwips= height;
	    }
	else{ SDEB(ea->eaPaperString);	}
	}

    if  ( ea->eaLeftMarginString )
	{
	if  ( appGeoLengthFromString( ea->eaLeftMarginString, ea->eaUnitInt,
			&ea->eaDefaultDocumentGeometry.dgLeftMarginTwips ) )
	    { SDEB(ea->eaLeftMarginString);	}
	}

    if  ( ea->eaRightMarginString )
	{
	if  ( appGeoLengthFromString( ea->eaRightMarginString, ea->eaUnitInt,
			&ea->eaDefaultDocumentGeometry.dgRightMarginTwips ) )
	    { SDEB(ea->eaRightMarginString);	}
	}

    if  ( ea->eaTopMarginString )
	{
	if  ( appGeoLengthFromString( ea->eaTopMarginString, ea->eaUnitInt,
			&ea->eaDefaultDocumentGeometry.dgTopMarginTwips ) )
	    { SDEB(ea->eaTopMarginString);	}
	}

    if  ( ea->eaBottomMarginString )
	{
	if  ( appGeoLengthFromString( ea->eaBottomMarginString, ea->eaUnitInt,
			&ea->eaDefaultDocumentGeometry.dgBottomMarginTwips ) )
	    { SDEB(ea->eaBottomMarginString);	}
	}

    /*  2  */
    ea->eaDisplay= XtDisplay( ea->eaTopWidget );
    ea->eaScreen= DefaultScreen( ea->eaDisplay );
    ea->eaScreenPixelsWide= DisplayWidth( ea->eaDisplay, ea->eaScreen );
    ea->eaScreenPixelsHigh= DisplayHeight( ea->eaDisplay, ea->eaScreen );
    ea->eaInputMethod= XOpenIM( ea->eaDisplay, NULL, NULL, NULL );
    ea->eaDocumentCursor= (Cursor)0;

    /*  3  */
    ea->eaCloseAtom= XmInternAtom( ea->eaDisplay, "WM_DELETE_WINDOW", False );

    if  ( ea->eaSessionManagement )
	{
	ea->eaSaveAtom= XmInternAtom( ea->eaDisplay,
						"WM_SAVE_YOURSELF", False );
	}

    ea->eaArgc= argc;
    ea->eaArgv= argv;

    if  ( ea->eaCloseAtom )
	{
	XtVaSetValues( ea->eaTopWidget,
			    XmNdeleteResponse,		XmDO_NOTHING,
			    NULL );

	XmAddWMProtocolCallback( ea->eaTopWidget, ea->eaCloseAtom,
						appAppWmClose, (void *)ea );
	}

    ac= 0;
    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		0 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	0 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		0 ); ac++;
    ea->eaMainWindow= XmCreatePanedWindow( ea->eaTopWidget, WIDGET_NAME, al, ac );

    ac= 0;
    ea->eaMenuBar= XmCreateMenuBar( ea->eaMainWindow, WIDGET_NAME, al, ac );

    ea->eaFileMenu= appMakeMenu( &(ea->eaFileMenuButton), ea, ea->eaMenuBar,
			*(ea->eaAppFileMenuText), 0,
			ea->eaAppFileMenuItems, ea->eaAppFileMenuItemCount,
			(void *)ea );

    ea->eaWinMenu= appMakeMenu( &(ea->eaWinMenuButton), ea, ea->eaMenuBar,
			*(ea->eaAppWinMenuText), 0,
			ea->eaAppWinMenuItems, ea->eaAppWinMenuItemCount,
			(void *)ea );

    if  ( ea->eaMakePrivateApplicationMenus )
	{ (*ea->eaMakePrivateApplicationMenus)( ea, ea->eaMenuBar ); }

    if  ( ea->eaAppHelpMenuItems )
	{
	ea->eaHelpMenu= appMakeMenu( &(ea->eaHelpMenuButton),
		    ea, ea->eaMenuBar,
		    *(ea->eaAppHelpMenuText), 1,
		    ea->eaAppHelpMenuItems, ea->eaAppHelpMenuItemCount,
		    (void *)ea );
	}

    if  ( ea->eaMainPicture )
	{
	ac= 0;
	XtSetArg( al[ac], XmNlabelType,		XmPIXMAP ); ac++;
	XtSetArg( al[ac], XmNrecomputeSize,	True ); ac++;
	XtSetArg( al[ac], XmNallowResize,	True ); ac++;

	pictureLabel= XmCreateLabel( ea->eaMainWindow, WIDGET_NAME, al, ac );
	XtManageChild( pictureLabel );
	}

    if  ( ea->eaNameAndVersion )
	{
	labelString= XmStringCreateLocalized( ea->eaNameAndVersion );

	ac= 0;
	XtSetArg( al[ac], XmNlabelString,	labelString ); ac++;
	XtSetArg( al[ac], XmNmarginWidth,	5 ); ac++;
	XtSetArg( al[ac], XmNmarginHeight,	0 ); ac++;
	XtSetArg( al[ac], XmNmarginTop,		4 ); ac++;
	XtSetArg( al[ac], XmNmarginBottom,	2 ); ac++;
	XtSetArg( al[ac], XmNalignment,		XmALIGNMENT_BEGINNING ); ac++;
	label= XmCreateLabel( ea->eaMainWindow, WIDGET_NAME, al, ac );

	XmStringFree( labelString );

	XtManageChild( label );
	}

    if  ( ea->eaReference )
	{
	labelString= XmStringCreateLocalized( ea->eaReference );

	ac= 0;
	XtSetArg( al[ac], XmNlabelString,	labelString ); ac++;
	XtSetArg( al[ac], XmNmarginWidth,	5 ); ac++;
	XtSetArg( al[ac], XmNmarginHeight,	0 ); ac++;
	XtSetArg( al[ac], XmNmarginTop,		2 ); ac++;
	XtSetArg( al[ac], XmNmarginBottom,	4 ); ac++;
	XtSetArg( al[ac], XmNalignment,		XmALIGNMENT_BEGINNING ); ac++;
	label= XmCreateLabel( ea->eaMainWindow, WIDGET_NAME, al, ac );

	XmStringFree( labelString );

	XtManageChild( label );
	}

    XtManageChild( ea->eaMenuBar );
    XtManageChild( ea->eaMainWindow );
    XtRealizeWidget( ea->eaTopWidget );

    if  ( pictureLabel )
	{
	Pixmap			labelPixmap;

	if  ( ! appGetImagePixmap( ea, ea->eaMainPicture, &labelPixmap ) )
	    {
	    XtVaSetValues( pictureLabel,
				XmNborderWidth,	0,
				XmNlabelPixmap,	labelPixmap,
				NULL );
	    }
	}

    if  ( ea->eaMainIcon					&&
	  appGetImagePixmap( ea, ea->eaMainIcon, &pixmap )	)
	{ SDEB(ea->eaMainIcon); return -1;	}

    if  ( pixmap )
	{
	XtVaSetValues( ea->eaTopWidget,
			    XmNiconPixmap,	pixmap,
			    NULL );
	}

    if  ( ea->eaPrintDestinationCount == 0				&&
	  utilPrinterGetPrinters( &(ea->eaPrintDestinationCount),
				    &(ea->eaDefaultPrintDestination),
				    &(ea->eaPrintDestinations) )	)
	{ LDEB(1); 	}

    adst= ea->eaDocSelectionTypes;
    for ( i= 0; i < ea->eaDocSelectionTypeCount; adst++, i++ )
	{
	int				j;
	AppDocSelectionTargetType *	adstt;

	if  ( adst->adstSelectionAtom == None )
	    {
	    adst->adstSelectionAtom= XInternAtom( ea->eaDisplay,
					    adst->adstSelectionString, 0 );
	    if  ( adst->adstSelectionAtom == None )
		{ SLDEB(adst->adstSelectionString, adst->adstSelectionAtom); }
	    }
	adstt= adst->adstTargetTypes;
	for ( j= 0; j < adst->adstTargetTypeCount; adstt++, j++ )
	    {
	    if  ( adstt->adsttTargetAtom == None )
		{
		adstt->adsttTargetAtom= XInternAtom( ea->eaDisplay,
					    adstt->adsttTargetString, 0 );
		if  ( adstt->adsttTargetAtom == None )
		    { SLDEB(adstt->adsttTargetString, adstt->adsttTargetAtom); }
		}
	    }
	}

    aast= ea->eaAppSelectionTypes;
    for ( i= 0; i < ea->eaAppSelectionTypeCount; aast++, i++ )
	{
	int				j;
	AppAppSelectionTargetType *	aastt;

	if  ( aast->aastSelectionAtom == None )
	    {
	    aast->aastSelectionAtom= XInternAtom( ea->eaDisplay,
					    aast->aastSelectionString, 0 );
	    if  ( aast->aastSelectionAtom == None )
		{ SLDEB(aast->aastSelectionString, aast->aastSelectionAtom); }
	    }
	aastt= aast->aastTargetTypes;
	for ( j= 0; j < aast->aastTargetTypeCount; aastt++, j++ )
	    {
	    if  ( aastt->aasttTargetAtom == None )
		{
		aastt->aasttTargetAtom= XInternAtom( ea->eaDisplay,
					    aastt->aasttTargetString, 0 );
		if  ( aastt->aasttTargetAtom == None )
		    { SLDEB(aastt->aasttTargetString, aastt->aasttTargetAtom); }
		}
	    }
	}

    if  ( ea->eaAppSelectionTypeCount > 0 )
	{
	XtAddEventHandler( ea->eaTopWidget,
			PropertyChangeMask, True, appAppSelectionInput, ea );
	}

    if  ( argc > 1 && ! strcmp( argv[1], "++Restore" ) )
	{
	const int	readonly= 0;
	EditDocument *	ed;

	if  ( argc != 4 && argc != 5 )
	    { SLDEB(argv[1],argc); return 1;	}

	ed= appOpenDocument( ea, ea->eaTopWidget, (Widget)0,
							readonly, argv[2] );

	if  ( ! ed )
	    { SSDEB(argv[1],argv[2]); return 1;	}

	if  ( argc == 5 )
	    {
	    appSetDocumentTitle( ed, argv[3] );
	    appSetDocumentFilename( ed, argv[4] );
	    }
	else{
	    appSetDocumentTitle( ed, argv[3] );
	    if  ( ed->edFilename )
		{ free( ed->edFilename ); ed->edFilename= (char *)0;	}
	    }

	appDocumentChanged( ea, ed, 1 );

	if  ( appRemoveFile( argv[2] ) )
	    { SDEB(argv[2]);	}
	}
    else{
	for ( arg= 1; arg < argc; arg++ )
	    {
	    const int			readonly= 0;
	    AppFileMessageResources *	afmr= &(ea->eaFileMessageResources);
	    static char			absolute[1000+1];

	    if  ( appTestFileExists( argv[arg] ) )
		{
		if  ( ea->eaCreateNewFromCommand )
		    {
		    int	res;

		    res= appQuestionRunSubjectYesNoDialog( ea, ea->eaTopWidget,
			(Widget)0, argv[arg], afmr->afmrMakeItQuestion,
			(char *)0, (char *)0 );

		    if  ( res == AQDrespYES )
			{
			if  ( appNewDocument( ea, argv[arg] ) )
			    { SDEB(argv[arg]);	}
			}
		    }
		else{
		    appQuestionRunSubjectErrorDialog( ea, ea->eaTopWidget,
			(Widget)0, argv[arg], afmr->afmrNoSuchFileMessage );
		    }
		}
	    else{
		if  ( appAbsoluteName( absolute, 1000, argv[arg] ) < 0 )
		    {
		    SDEB(argv[arg]);
		    (void)appOpenDocument( ea, ea->eaTopWidget, (Widget)0,
							readonly, argv[arg] );
		    }
		else{
		    (void)appOpenDocument( ea, ea->eaTopWidget, (Widget)0,
							readonly, absolute );
		    }
		}
	    }
	}

    if  ( ea->eaVisibleDocumentCount > 0 )
	{ XtUnmapWidget( ea->eaTopWidget ); }

    {
    double			horPixPerMM;
    double			verPixPerMM;
    double			xfac;
    double			yfac;

    appGetFactors( ea, &horPixPerMM, &verPixPerMM, &xfac, &yfac );
    }

    XtAppMainLoop( ea->eaContext );

    return 0;
    }
