; -*- coding: iso-2022-7bit  -*-
;;; ujisx0208.el --- tables between UCS and JIS X 0208-1990

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, JIS X 0208

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from JIX0208.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'japanese-jisx0208 'unicode 'jis-x-0208-1990-vs-unicode-assoc)

(defvar
  jis-x-0208-1990-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?$B!!(B . ?\x3000) ;; IDEOGRAPHIC SPACE
     (?$B!"(B . ?\x3001) ;; IDEOGRAPHIC COMMA
     (?$B!#(B . ?\x3002) ;; IDEOGRAPHIC FULL STOP
     (?$B!$(B . ?\xFF0C) ;; FULLWIDTH COMMA
     (?$B!%(B . ?\xFF0E) ;; FULLWIDTH FULL STOP
     (?$B!&(B . ?\x30FB) ;; KATAKANA MIDDLE DOT
     (?$B!'(B . ?\xFF1A) ;; FULLWIDTH COLON
     (?$B!((B . ?\xFF1B) ;; FULLWIDTH SEMICOLON
     (?$B!)(B . ?\xFF1F) ;; FULLWIDTH QUESTION MARK
     (?$B!*(B . ?\xFF01) ;; FULLWIDTH EXCLAMATION MARK
     (?$B!+(B . ?\x309B) ;; KATAKANA-HIRAGANA VOICED SOUND MARK
     (?$B!,(B . ?\x309C) ;; KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
     (?$B!-(B . ?\x00B4) ;; ACUTE ACCENT
     (?$B!.(B . ?\xFF40) ;; FULLWIDTH GRAVE ACCENT
     (?$B!/(B . ?\x00A8) ;; DIAERESIS
     (?$B!0(B . ?\xFF3E) ;; FULLWIDTH CIRCUMFLEX ACCENT
     (?$B!1(B . ?\xFFE3) ;; FULLWIDTH MACRON
     (?$B!2(B . ?\xFF3F) ;; FULLWIDTH LOW LINE
     (?$B!3(B . ?\x30FD) ;; KATAKANA ITERATION MARK
     (?$B!4(B . ?\x30FE) ;; KATAKANA VOICED ITERATION MARK
     (?$B!5(B . ?\x309D) ;; HIRAGANA ITERATION MARK
     (?$B!6(B . ?\x309E) ;; HIRAGANA VOICED ITERATION MARK
     (?$B!7(B . ?\x3003) ;; DITTO MARK
     (?$B!8(B . ?\x4EDD) ;; <CJK>
     (?$B!9(B . ?\x3005) ;; IDEOGRAPHIC ITERATION MARK
     (?$B!:(B . ?\x3006) ;; IDEOGRAPHIC CLOSING MARK
     (?$B!;(B . ?\x3007) ;; IDEOGRAPHIC NUMBER ZERO
     (?$B!<(B . ?\x30FC) ;; KATAKANA-HIRAGANA PROLONGED SOUND MARK
     (?$B!=(B . ?\x2015) ;; HORIZONTAL BAR
     (?$B!>(B . ?\x2010) ;; HYPHEN
     (?$B!?(B . ?\xFF0F) ;; FULLWIDTH SOLIDUS
     (?$B!@(B . ?\x005C) ;; REVERSE SOLIDUS
     (?$B!A(B . ?\x301C) ;; WAVE DASH
     (?$B!B(B . ?\x2016) ;; DOUBLE VERTICAL LINE
     (?$B!C(B . ?\xFF5C) ;; FULLWIDTH VERTICAL LINE
     (?$B!D(B . ?\x2026) ;; HORIZONTAL ELLIPSIS
     (?$B!E(B . ?\x2025) ;; TWO DOT LEADER
     (?$B!F(B . ?\x2018) ;; LEFT SINGLE QUOTATION MARK
     (?$B!G(B . ?\x2019) ;; RIGHT SINGLE QUOTATION MARK
     (?$B!H(B . ?\x201C) ;; LEFT DOUBLE QUOTATION MARK
     (?$B!I(B . ?\x201D) ;; RIGHT DOUBLE QUOTATION MARK
     (?$B!J(B . ?\xFF08) ;; FULLWIDTH LEFT PARENTHESIS
     (?$B!K(B . ?\xFF09) ;; FULLWIDTH RIGHT PARENTHESIS
     (?$B!L(B . ?\x3014) ;; LEFT TORTOISE SHELL BRACKET
     (?$B!M(B . ?\x3015) ;; RIGHT TORTOISE SHELL BRACKET
     (?$B!N(B . ?\xFF3B) ;; FULLWIDTH LEFT SQUARE BRACKET
     (?$B!O(B . ?\xFF3D) ;; FULLWIDTH RIGHT SQUARE BRACKET
     (?$B!P(B . ?\xFF5B) ;; FULLWIDTH LEFT CURLY BRACKET
     (?$B!Q(B . ?\xFF5D) ;; FULLWIDTH RIGHT CURLY BRACKET
     (?$B!R(B . ?\x3008) ;; LEFT ANGLE BRACKET
     (?$B!S(B . ?\x3009) ;; RIGHT ANGLE BRACKET
     (?$B!T(B . ?\x300A) ;; LEFT DOUBLE ANGLE BRACKET
     (?$B!U(B . ?\x300B) ;; RIGHT DOUBLE ANGLE BRACKET
     (?$B!V(B . ?\x300C) ;; LEFT CORNER BRACKET
     (?$B!W(B . ?\x300D) ;; RIGHT CORNER BRACKET
     (?$B!X(B . ?\x300E) ;; LEFT WHITE CORNER BRACKET
     (?$B!Y(B . ?\x300F) ;; RIGHT WHITE CORNER BRACKET
     (?$B!Z(B . ?\x3010) ;; LEFT BLACK LENTICULAR BRACKET
     (?$B![(B . ?\x3011) ;; RIGHT BLACK LENTICULAR BRACKET
     (?$B!\(B . ?\xFF0B) ;; FULLWIDTH PLUS SIGN
     (?$B!](B . ?\x2212) ;; MINUS SIGN
     (?$B!^(B . ?\x00B1) ;; PLUS-MINUS SIGN
     (?$B!_(B . ?\x00D7) ;; MULTIPLICATION SIGN
     (?$B!`(B . ?\x00F7) ;; DIVISION SIGN
     (?$B!a(B . ?\xFF1D) ;; FULLWIDTH EQUALS SIGN
     (?$B!b(B . ?\x2260) ;; NOT EQUAL TO
     (?$B!c(B . ?\xFF1C) ;; FULLWIDTH LESS-THAN SIGN
     (?$B!d(B . ?\xFF1E) ;; FULLWIDTH GREATER-THAN SIGN
     (?$B!e(B . ?\x2266) ;; LESS-THAN OVER EQUAL TO
     (?$B!f(B . ?\x2267) ;; GREATER-THAN OVER EQUAL TO
     (?$B!g(B . ?\x221E) ;; INFINITY
     (?$B!h(B . ?\x2234) ;; THEREFORE
     (?$B!i(B . ?\x2642) ;; MALE SIGN
     (?$B!j(B . ?\x2640) ;; FEMALE SIGN
     (?$B!k(B . ?\x00B0) ;; DEGREE SIGN
     (?$B!l(B . ?\x2032) ;; PRIME
     (?$B!m(B . ?\x2033) ;; DOUBLE PRIME
     (?$B!n(B . ?\x2103) ;; DEGREE CELSIUS
     (?$B!o(B . ?\xFFE5) ;; FULLWIDTH YEN SIGN
     (?$B!p(B . ?\xFF04) ;; FULLWIDTH DOLLAR SIGN
     (?$B!q(B . ?\x00A2) ;; CENT SIGN
     (?$B!r(B . ?\x00A3) ;; POUND SIGN
     (?$B!s(B . ?\xFF05) ;; FULLWIDTH PERCENT SIGN
     (?$B!t(B . ?\xFF03) ;; FULLWIDTH NUMBER SIGN
     (?$B!u(B . ?\xFF06) ;; FULLWIDTH AMPERSAND
     (?$B!v(B . ?\xFF0A) ;; FULLWIDTH ASTERISK
     (?$B!w(B . ?\xFF20) ;; FULLWIDTH COMMERCIAL AT
     (?$B!x(B . ?\x00A7) ;; SECTION SIGN
     (?$B!y(B . ?\x2606) ;; WHITE STAR
     (?$B!z(B . ?\x2605) ;; BLACK STAR
     (?$B!{(B . ?\x25CB) ;; WHITE CIRCLE
     (?$B!|(B . ?\x25CF) ;; BLACK CIRCLE
     (?$B!}(B . ?\x25CE) ;; BULLSEYE
     (?$B!~(B . ?\x25C7) ;; WHITE DIAMOND
     (?$B"!(B . ?\x25C6) ;; BLACK DIAMOND
     (?$B""(B . ?\x25A1) ;; WHITE SQUARE
     (?$B"#(B . ?\x25A0) ;; BLACK SQUARE
     (?$B"$(B . ?\x25B3) ;; WHITE UP-POINTING TRIANGLE
     (?$B"%(B . ?\x25B2) ;; BLACK UP-POINTING TRIANGLE
     (?$B"&(B . ?\x25BD) ;; WHITE DOWN-POINTING TRIANGLE
     (?$B"'(B . ?\x25BC) ;; BLACK DOWN-POINTING TRIANGLE
     (?$B"((B . ?\x203B) ;; REFERENCE MARK
     (?$B")(B . ?\x3012) ;; POSTAL MARK
     (?$B"*(B . ?\x2192) ;; RIGHTWARDS ARROW
     (?$B"+(B . ?\x2190) ;; LEFTWARDS ARROW
     (?$B",(B . ?\x2191) ;; UPWARDS ARROW
     (?$B"-(B . ?\x2193) ;; DOWNWARDS ARROW
     (?$B".(B . ?\x3013) ;; GETA MARK
     (?$B":(B . ?\x2208) ;; ELEMENT OF
     (?$B";(B . ?\x220B) ;; CONTAINS AS MEMBER
     (?$B"<(B . ?\x2286) ;; SUBSET OF OR EQUAL TO
     (?$B"=(B . ?\x2287) ;; SUPERSET OF OR EQUAL TO
     (?$B">(B . ?\x2282) ;; SUBSET OF
     (?$B"?(B . ?\x2283) ;; SUPERSET OF
     (?$B"@(B . ?\x222A) ;; UNION
     (?$B"A(B . ?\x2229) ;; INTERSECTION
     (?$B"J(B . ?\x2227) ;; LOGICAL AND
     (?$B"K(B . ?\x2228) ;; LOGICAL OR
     (?$B"L(B . ?\x00AC) ;; NOT SIGN
     (?$B"M(B . ?\x21D2) ;; RIGHTWARDS DOUBLE ARROW
     (?$B"N(B . ?\x21D4) ;; LEFT RIGHT DOUBLE ARROW
     (?$B"O(B . ?\x2200) ;; FOR ALL
     (?$B"P(B . ?\x2203) ;; THERE EXISTS
     (?$B"\(B . ?\x2220) ;; ANGLE
     (?$B"](B . ?\x22A5) ;; UP TACK
     (?$B"^(B . ?\x2312) ;; ARC
     (?$B"_(B . ?\x2202) ;; PARTIAL DIFFERENTIAL
     (?$B"`(B . ?\x2207) ;; NABLA
     (?$B"a(B . ?\x2261) ;; IDENTICAL TO
     (?$B"b(B . ?\x2252) ;; APPROXIMATELY EQUAL TO OR THE IMAGE OF
     (?$B"c(B . ?\x226A) ;; MUCH LESS-THAN
     (?$B"d(B . ?\x226B) ;; MUCH GREATER-THAN
     (?$B"e(B . ?\x221A) ;; SQUARE ROOT
     (?$B"f(B . ?\x223D) ;; REVERSED TILDE
     (?$B"g(B . ?\x221D) ;; PROPORTIONAL TO
     (?$B"h(B . ?\x2235) ;; BECAUSE
     (?$B"i(B . ?\x222B) ;; INTEGRAL
     (?$B"j(B . ?\x222C) ;; DOUBLE INTEGRAL
     (?$B"r(B . ?\x212B) ;; ANGSTROM SIGN
     (?$B"s(B . ?\x2030) ;; PER MILLE SIGN
     (?$B"t(B . ?\x266F) ;; MUSIC SHARP SIGN
     (?$B"u(B . ?\x266D) ;; MUSIC FLAT SIGN
     (?$B"v(B . ?\x266A) ;; EIGHTH NOTE
     (?$B"w(B . ?\x2020) ;; DAGGER
     (?$B"x(B . ?\x2021) ;; DOUBLE DAGGER
     (?$B"y(B . ?\x00B6) ;; PILCROW SIGN
     (?$B"~(B . ?\x25EF) ;; LARGE CIRCLE
     (?$B#0(B . ?\xFF10) ;; FULLWIDTH DIGIT ZERO
     (?$B#1(B . ?\xFF11) ;; FULLWIDTH DIGIT ONE
     (?$B#2(B . ?\xFF12) ;; FULLWIDTH DIGIT TWO
     (?$B#3(B . ?\xFF13) ;; FULLWIDTH DIGIT THREE
     (?$B#4(B . ?\xFF14) ;; FULLWIDTH DIGIT FOUR
     (?$B#5(B . ?\xFF15) ;; FULLWIDTH DIGIT FIVE
     (?$B#6(B . ?\xFF16) ;; FULLWIDTH DIGIT SIX
     (?$B#7(B . ?\xFF17) ;; FULLWIDTH DIGIT SEVEN
     (?$B#8(B . ?\xFF18) ;; FULLWIDTH DIGIT EIGHT
     (?$B#9(B . ?\xFF19) ;; FULLWIDTH DIGIT NINE
     (?$B#A(B . ?\xFF21) ;; FULLWIDTH LATIN CAPITAL LETTER A
     (?$B#B(B . ?\xFF22) ;; FULLWIDTH LATIN CAPITAL LETTER B
     (?$B#C(B . ?\xFF23) ;; FULLWIDTH LATIN CAPITAL LETTER C
     (?$B#D(B . ?\xFF24) ;; FULLWIDTH LATIN CAPITAL LETTER D
     (?$B#E(B . ?\xFF25) ;; FULLWIDTH LATIN CAPITAL LETTER E
     (?$B#F(B . ?\xFF26) ;; FULLWIDTH LATIN CAPITAL LETTER F
     (?$B#G(B . ?\xFF27) ;; FULLWIDTH LATIN CAPITAL LETTER G
     (?$B#H(B . ?\xFF28) ;; FULLWIDTH LATIN CAPITAL LETTER H
     (?$B#I(B . ?\xFF29) ;; FULLWIDTH LATIN CAPITAL LETTER I
     (?$B#J(B . ?\xFF2A) ;; FULLWIDTH LATIN CAPITAL LETTER J
     (?$B#K(B . ?\xFF2B) ;; FULLWIDTH LATIN CAPITAL LETTER K
     (?$B#L(B . ?\xFF2C) ;; FULLWIDTH LATIN CAPITAL LETTER L
     (?$B#M(B . ?\xFF2D) ;; FULLWIDTH LATIN CAPITAL LETTER M
     (?$B#N(B . ?\xFF2E) ;; FULLWIDTH LATIN CAPITAL LETTER N
     (?$B#O(B . ?\xFF2F) ;; FULLWIDTH LATIN CAPITAL LETTER O
     (?$B#P(B . ?\xFF30) ;; FULLWIDTH LATIN CAPITAL LETTER P
     (?$B#Q(B . ?\xFF31) ;; FULLWIDTH LATIN CAPITAL LETTER Q
     (?$B#R(B . ?\xFF32) ;; FULLWIDTH LATIN CAPITAL LETTER R
     (?$B#S(B . ?\xFF33) ;; FULLWIDTH LATIN CAPITAL LETTER S
     (?$B#T(B . ?\xFF34) ;; FULLWIDTH LATIN CAPITAL LETTER T
     (?$B#U(B . ?\xFF35) ;; FULLWIDTH LATIN CAPITAL LETTER U
     (?$B#V(B . ?\xFF36) ;; FULLWIDTH LATIN CAPITAL LETTER V
     (?$B#W(B . ?\xFF37) ;; FULLWIDTH LATIN CAPITAL LETTER W
     (?$B#X(B . ?\xFF38) ;; FULLWIDTH LATIN CAPITAL LETTER X
     (?$B#Y(B . ?\xFF39) ;; FULLWIDTH LATIN CAPITAL LETTER Y
     (?$B#Z(B . ?\xFF3A) ;; FULLWIDTH LATIN CAPITAL LETTER Z
     (?$B#a(B . ?\xFF41) ;; FULLWIDTH LATIN SMALL LETTER A
     (?$B#b(B . ?\xFF42) ;; FULLWIDTH LATIN SMALL LETTER B
     (?$B#c(B . ?\xFF43) ;; FULLWIDTH LATIN SMALL LETTER C
     (?$B#d(B . ?\xFF44) ;; FULLWIDTH LATIN SMALL LETTER D
     (?$B#e(B . ?\xFF45) ;; FULLWIDTH LATIN SMALL LETTER E
     (?$B#f(B . ?\xFF46) ;; FULLWIDTH LATIN SMALL LETTER F
     (?$B#g(B . ?\xFF47) ;; FULLWIDTH LATIN SMALL LETTER G
     (?$B#h(B . ?\xFF48) ;; FULLWIDTH LATIN SMALL LETTER H
     (?$B#i(B . ?\xFF49) ;; FULLWIDTH LATIN SMALL LETTER I
     (?$B#j(B . ?\xFF4A) ;; FULLWIDTH LATIN SMALL LETTER J
     (?$B#k(B . ?\xFF4B) ;; FULLWIDTH LATIN SMALL LETTER K
     (?$B#l(B . ?\xFF4C) ;; FULLWIDTH LATIN SMALL LETTER L
     (?$B#m(B . ?\xFF4D) ;; FULLWIDTH LATIN SMALL LETTER M
     (?$B#n(B . ?\xFF4E) ;; FULLWIDTH LATIN SMALL LETTER N
     (?$B#o(B . ?\xFF4F) ;; FULLWIDTH LATIN SMALL LETTER O
     (?$B#p(B . ?\xFF50) ;; FULLWIDTH LATIN SMALL LETTER P
     (?$B#q(B . ?\xFF51) ;; FULLWIDTH LATIN SMALL LETTER Q
     (?$B#r(B . ?\xFF52) ;; FULLWIDTH LATIN SMALL LETTER R
     (?$B#s(B . ?\xFF53) ;; FULLWIDTH LATIN SMALL LETTER S
     (?$B#t(B . ?\xFF54) ;; FULLWIDTH LATIN SMALL LETTER T
     (?$B#u(B . ?\xFF55) ;; FULLWIDTH LATIN SMALL LETTER U
     (?$B#v(B . ?\xFF56) ;; FULLWIDTH LATIN SMALL LETTER V
     (?$B#w(B . ?\xFF57) ;; FULLWIDTH LATIN SMALL LETTER W
     (?$B#x(B . ?\xFF58) ;; FULLWIDTH LATIN SMALL LETTER X
     (?$B#y(B . ?\xFF59) ;; FULLWIDTH LATIN SMALL LETTER Y
     (?$B#z(B . ?\xFF5A) ;; FULLWIDTH LATIN SMALL LETTER Z
     (?$B$!(B . ?\x3041) ;; HIRAGANA LETTER SMALL A
     (?$B$"(B . ?\x3042) ;; HIRAGANA LETTER A
     (?$B$#(B . ?\x3043) ;; HIRAGANA LETTER SMALL I
     (?$B$$(B . ?\x3044) ;; HIRAGANA LETTER I
     (?$B$%(B . ?\x3045) ;; HIRAGANA LETTER SMALL U
     (?$B$&(B . ?\x3046) ;; HIRAGANA LETTER U
     (?$B$'(B . ?\x3047) ;; HIRAGANA LETTER SMALL E
     (?$B$((B . ?\x3048) ;; HIRAGANA LETTER E
     (?$B$)(B . ?\x3049) ;; HIRAGANA LETTER SMALL O
     (?$B$*(B . ?\x304A) ;; HIRAGANA LETTER O
     (?$B$+(B . ?\x304B) ;; HIRAGANA LETTER KA
     (?$B$,(B . ?\x304C) ;; HIRAGANA LETTER GA
     (?$B$-(B . ?\x304D) ;; HIRAGANA LETTER KI
     (?$B$.(B . ?\x304E) ;; HIRAGANA LETTER GI
     (?$B$/(B . ?\x304F) ;; HIRAGANA LETTER KU
     (?$B$0(B . ?\x3050) ;; HIRAGANA LETTER GU
     (?$B$1(B . ?\x3051) ;; HIRAGANA LETTER KE
     (?$B$2(B . ?\x3052) ;; HIRAGANA LETTER GE
     (?$B$3(B . ?\x3053) ;; HIRAGANA LETTER KO
     (?$B$4(B . ?\x3054) ;; HIRAGANA LETTER GO
     (?$B$5(B . ?\x3055) ;; HIRAGANA LETTER SA
     (?$B$6(B . ?\x3056) ;; HIRAGANA LETTER ZA
     (?$B$7(B . ?\x3057) ;; HIRAGANA LETTER SI
     (?$B$8(B . ?\x3058) ;; HIRAGANA LETTER ZI
     (?$B$9(B . ?\x3059) ;; HIRAGANA LETTER SU
     (?$B$:(B . ?\x305A) ;; HIRAGANA LETTER ZU
     (?$B$;(B . ?\x305B) ;; HIRAGANA LETTER SE
     (?$B$<(B . ?\x305C) ;; HIRAGANA LETTER ZE
     (?$B$=(B . ?\x305D) ;; HIRAGANA LETTER SO
     (?$B$>(B . ?\x305E) ;; HIRAGANA LETTER ZO
     (?$B$?(B . ?\x305F) ;; HIRAGANA LETTER TA
     (?$B$@(B . ?\x3060) ;; HIRAGANA LETTER DA
     (?$B$A(B . ?\x3061) ;; HIRAGANA LETTER TI
     (?$B$B(B . ?\x3062) ;; HIRAGANA LETTER DI
     (?$B$C(B . ?\x3063) ;; HIRAGANA LETTER SMALL TU
     (?$B$D(B . ?\x3064) ;; HIRAGANA LETTER TU
     (?$B$E(B . ?\x3065) ;; HIRAGANA LETTER DU
     (?$B$F(B . ?\x3066) ;; HIRAGANA LETTER TE
     (?$B$G(B . ?\x3067) ;; HIRAGANA LETTER DE
     (?$B$H(B . ?\x3068) ;; HIRAGANA LETTER TO
     (?$B$I(B . ?\x3069) ;; HIRAGANA LETTER DO
     (?$B$J(B . ?\x306A) ;; HIRAGANA LETTER NA
     (?$B$K(B . ?\x306B) ;; HIRAGANA LETTER NI
     (?$B$L(B . ?\x306C) ;; HIRAGANA LETTER NU
     (?$B$M(B . ?\x306D) ;; HIRAGANA LETTER NE
     (?$B$N(B . ?\x306E) ;; HIRAGANA LETTER NO
     (?$B$O(B . ?\x306F) ;; HIRAGANA LETTER HA
     (?$B$P(B . ?\x3070) ;; HIRAGANA LETTER BA
     (?$B$Q(B . ?\x3071) ;; HIRAGANA LETTER PA
     (?$B$R(B . ?\x3072) ;; HIRAGANA LETTER HI
     (?$B$S(B . ?\x3073) ;; HIRAGANA LETTER BI
     (?$B$T(B . ?\x3074) ;; HIRAGANA LETTER PI
     (?$B$U(B . ?\x3075) ;; HIRAGANA LETTER HU
     (?$B$V(B . ?\x3076) ;; HIRAGANA LETTER BU
     (?$B$W(B . ?\x3077) ;; HIRAGANA LETTER PU
     (?$B$X(B . ?\x3078) ;; HIRAGANA LETTER HE
     (?$B$Y(B . ?\x3079) ;; HIRAGANA LETTER BE
     (?$B$Z(B . ?\x307A) ;; HIRAGANA LETTER PE
     (?$B$[(B . ?\x307B) ;; HIRAGANA LETTER HO
     (?$B$\(B . ?\x307C) ;; HIRAGANA LETTER BO
     (?$B$](B . ?\x307D) ;; HIRAGANA LETTER PO
     (?$B$^(B . ?\x307E) ;; HIRAGANA LETTER MA
     (?$B$_(B . ?\x307F) ;; HIRAGANA LETTER MI
     (?$B$`(B . ?\x3080) ;; HIRAGANA LETTER MU
     (?$B$a(B . ?\x3081) ;; HIRAGANA LETTER ME
     (?$B$b(B . ?\x3082) ;; HIRAGANA LETTER MO
     (?$B$c(B . ?\x3083) ;; HIRAGANA LETTER SMALL YA
     (?$B$d(B . ?\x3084) ;; HIRAGANA LETTER YA
     (?$B$e(B . ?\x3085) ;; HIRAGANA LETTER SMALL YU
     (?$B$f(B . ?\x3086) ;; HIRAGANA LETTER YU
     (?$B$g(B . ?\x3087) ;; HIRAGANA LETTER SMALL YO
     (?$B$h(B . ?\x3088) ;; HIRAGANA LETTER YO
     (?$B$i(B . ?\x3089) ;; HIRAGANA LETTER RA
     (?$B$j(B . ?\x308A) ;; HIRAGANA LETTER RI
     (?$B$k(B . ?\x308B) ;; HIRAGANA LETTER RU
     (?$B$l(B . ?\x308C) ;; HIRAGANA LETTER RE
     (?$B$m(B . ?\x308D) ;; HIRAGANA LETTER RO
     (?$B$n(B . ?\x308E) ;; HIRAGANA LETTER SMALL WA
     (?$B$o(B . ?\x308F) ;; HIRAGANA LETTER WA
     (?$B$p(B . ?\x3090) ;; HIRAGANA LETTER WI
     (?$B$q(B . ?\x3091) ;; HIRAGANA LETTER WE
     (?$B$r(B . ?\x3092) ;; HIRAGANA LETTER WO
     (?$B$s(B . ?\x3093) ;; HIRAGANA LETTER N
     (?$B%!(B . ?\x30A1) ;; KATAKANA LETTER SMALL A
     (?$B%"(B . ?\x30A2) ;; KATAKANA LETTER A
     (?$B%#(B . ?\x30A3) ;; KATAKANA LETTER SMALL I
     (?$B%$(B . ?\x30A4) ;; KATAKANA LETTER I
     (?$B%%(B . ?\x30A5) ;; KATAKANA LETTER SMALL U
     (?$B%&(B . ?\x30A6) ;; KATAKANA LETTER U
     (?$B%'(B . ?\x30A7) ;; KATAKANA LETTER SMALL E
     (?$B%((B . ?\x30A8) ;; KATAKANA LETTER E
     (?$B%)(B . ?\x30A9) ;; KATAKANA LETTER SMALL O
     (?$B%*(B . ?\x30AA) ;; KATAKANA LETTER O
     (?$B%+(B . ?\x30AB) ;; KATAKANA LETTER KA
     (?$B%,(B . ?\x30AC) ;; KATAKANA LETTER GA
     (?$B%-(B . ?\x30AD) ;; KATAKANA LETTER KI
     (?$B%.(B . ?\x30AE) ;; KATAKANA LETTER GI
     (?$B%/(B . ?\x30AF) ;; KATAKANA LETTER KU
     (?$B%0(B . ?\x30B0) ;; KATAKANA LETTER GU
     (?$B%1(B . ?\x30B1) ;; KATAKANA LETTER KE
     (?$B%2(B . ?\x30B2) ;; KATAKANA LETTER GE
     (?$B%3(B . ?\x30B3) ;; KATAKANA LETTER KO
     (?$B%4(B . ?\x30B4) ;; KATAKANA LETTER GO
     (?$B%5(B . ?\x30B5) ;; KATAKANA LETTER SA
     (?$B%6(B . ?\x30B6) ;; KATAKANA LETTER ZA
     (?$B%7(B . ?\x30B7) ;; KATAKANA LETTER SI
     (?$B%8(B . ?\x30B8) ;; KATAKANA LETTER ZI
     (?$B%9(B . ?\x30B9) ;; KATAKANA LETTER SU
     (?$B%:(B . ?\x30BA) ;; KATAKANA LETTER ZU
     (?$B%;(B . ?\x30BB) ;; KATAKANA LETTER SE
     (?$B%<(B . ?\x30BC) ;; KATAKANA LETTER ZE
     (?$B%=(B . ?\x30BD) ;; KATAKANA LETTER SO
     (?$B%>(B . ?\x30BE) ;; KATAKANA LETTER ZO
     (?$B%?(B . ?\x30BF) ;; KATAKANA LETTER TA
     (?$B%@(B . ?\x30C0) ;; KATAKANA LETTER DA
     (?$B%A(B . ?\x30C1) ;; KATAKANA LETTER TI
     (?$B%B(B . ?\x30C2) ;; KATAKANA LETTER DI
     (?$B%C(B . ?\x30C3) ;; KATAKANA LETTER SMALL TU
     (?$B%D(B . ?\x30C4) ;; KATAKANA LETTER TU
     (?$B%E(B . ?\x30C5) ;; KATAKANA LETTER DU
     (?$B%F(B . ?\x30C6) ;; KATAKANA LETTER TE
     (?$B%G(B . ?\x30C7) ;; KATAKANA LETTER DE
     (?$B%H(B . ?\x30C8) ;; KATAKANA LETTER TO
     (?$B%I(B . ?\x30C9) ;; KATAKANA LETTER DO
     (?$B%J(B . ?\x30CA) ;; KATAKANA LETTER NA
     (?$B%K(B . ?\x30CB) ;; KATAKANA LETTER NI
     (?$B%L(B . ?\x30CC) ;; KATAKANA LETTER NU
     (?$B%M(B . ?\x30CD) ;; KATAKANA LETTER NE
     (?$B%N(B . ?\x30CE) ;; KATAKANA LETTER NO
     (?$B%O(B . ?\x30CF) ;; KATAKANA LETTER HA
     (?$B%P(B . ?\x30D0) ;; KATAKANA LETTER BA
     (?$B%Q(B . ?\x30D1) ;; KATAKANA LETTER PA
     (?$B%R(B . ?\x30D2) ;; KATAKANA LETTER HI
     (?$B%S(B . ?\x30D3) ;; KATAKANA LETTER BI
     (?$B%T(B . ?\x30D4) ;; KATAKANA LETTER PI
     (?$B%U(B . ?\x30D5) ;; KATAKANA LETTER HU
     (?$B%V(B . ?\x30D6) ;; KATAKANA LETTER BU
     (?$B%W(B . ?\x30D7) ;; KATAKANA LETTER PU
     (?$B%X(B . ?\x30D8) ;; KATAKANA LETTER HE
     (?$B%Y(B . ?\x30D9) ;; KATAKANA LETTER BE
     (?$B%Z(B . ?\x30DA) ;; KATAKANA LETTER PE
     (?$B%[(B . ?\x30DB) ;; KATAKANA LETTER HO
     (?$B%\(B . ?\x30DC) ;; KATAKANA LETTER BO
     (?$B%](B . ?\x30DD) ;; KATAKANA LETTER PO
     (?$B%^(B . ?\x30DE) ;; KATAKANA LETTER MA
     (?$B%_(B . ?\x30DF) ;; KATAKANA LETTER MI
     (?$B%`(B . ?\x30E0) ;; KATAKANA LETTER MU
     (?$B%a(B . ?\x30E1) ;; KATAKANA LETTER ME
     (?$B%b(B . ?\x30E2) ;; KATAKANA LETTER MO
     (?$B%c(B . ?\x30E3) ;; KATAKANA LETTER SMALL YA
     (?$B%d(B . ?\x30E4) ;; KATAKANA LETTER YA
     (?$B%e(B . ?\x30E5) ;; KATAKANA LETTER SMALL YU
     (?$B%f(B . ?\x30E6) ;; KATAKANA LETTER YU
     (?$B%g(B . ?\x30E7) ;; KATAKANA LETTER SMALL YO
     (?$B%h(B . ?\x30E8) ;; KATAKANA LETTER YO
     (?$B%i(B . ?\x30E9) ;; KATAKANA LETTER RA
     (?$B%j(B . ?\x30EA) ;; KATAKANA LETTER RI
     (?$B%k(B . ?\x30EB) ;; KATAKANA LETTER RU
     (?$B%l(B . ?\x30EC) ;; KATAKANA LETTER RE
     (?$B%m(B . ?\x30ED) ;; KATAKANA LETTER RO
     (?$B%n(B . ?\x30EE) ;; KATAKANA LETTER SMALL WA
     (?$B%o(B . ?\x30EF) ;; KATAKANA LETTER WA
     (?$B%p(B . ?\x30F0) ;; KATAKANA LETTER WI
     (?$B%q(B . ?\x30F1) ;; KATAKANA LETTER WE
     (?$B%r(B . ?\x30F2) ;; KATAKANA LETTER WO
     (?$B%s(B . ?\x30F3) ;; KATAKANA LETTER N
     (?$B%t(B . ?\x30F4) ;; KATAKANA LETTER VU
     (?$B%u(B . ?\x30F5) ;; KATAKANA LETTER SMALL KA
     (?$B%v(B . ?\x30F6) ;; KATAKANA LETTER SMALL KE
     (?$B&!(B . ?\x0391) ;; GREEK CAPITAL LETTER ALPHA
     (?$B&"(B . ?\x0392) ;; GREEK CAPITAL LETTER BETA
     (?$B&#(B . ?\x0393) ;; GREEK CAPITAL LETTER GAMMA
     (?$B&$(B . ?\x0394) ;; GREEK CAPITAL LETTER DELTA
     (?$B&%(B . ?\x0395) ;; GREEK CAPITAL LETTER EPSILON
     (?$B&&(B . ?\x0396) ;; GREEK CAPITAL LETTER ZETA
     (?$B&'(B . ?\x0397) ;; GREEK CAPITAL LETTER ETA
     (?$B&((B . ?\x0398) ;; GREEK CAPITAL LETTER THETA
     (?$B&)(B . ?\x0399) ;; GREEK CAPITAL LETTER IOTA
     (?$B&*(B . ?\x039A) ;; GREEK CAPITAL LETTER KAPPA
     (?$B&+(B . ?\x039B) ;; GREEK CAPITAL LETTER LAMDA
     (?$B&,(B . ?\x039C) ;; GREEK CAPITAL LETTER MU
     (?$B&-(B . ?\x039D) ;; GREEK CAPITAL LETTER NU
     (?$B&.(B . ?\x039E) ;; GREEK CAPITAL LETTER XI
     (?$B&/(B . ?\x039F) ;; GREEK CAPITAL LETTER OMICRON
     (?$B&0(B . ?\x03A0) ;; GREEK CAPITAL LETTER PI
     (?$B&1(B . ?\x03A1) ;; GREEK CAPITAL LETTER RHO
     (?$B&2(B . ?\x03A3) ;; GREEK CAPITAL LETTER SIGMA
     (?$B&3(B . ?\x03A4) ;; GREEK CAPITAL LETTER TAU
     (?$B&4(B . ?\x03A5) ;; GREEK CAPITAL LETTER UPSILON
     (?$B&5(B . ?\x03A6) ;; GREEK CAPITAL LETTER PHI
     (?$B&6(B . ?\x03A7) ;; GREEK CAPITAL LETTER CHI
     (?$B&7(B . ?\x03A8) ;; GREEK CAPITAL LETTER PSI
     (?$B&8(B . ?\x03A9) ;; GREEK CAPITAL LETTER OMEGA
     (?$B&A(B . ?\x03B1) ;; GREEK SMALL LETTER ALPHA
     (?$B&B(B . ?\x03B2) ;; GREEK SMALL LETTER BETA
     (?$B&C(B . ?\x03B3) ;; GREEK SMALL LETTER GAMMA
     (?$B&D(B . ?\x03B4) ;; GREEK SMALL LETTER DELTA
     (?$B&E(B . ?\x03B5) ;; GREEK SMALL LETTER EPSILON
     (?$B&F(B . ?\x03B6) ;; GREEK SMALL LETTER ZETA
     (?$B&G(B . ?\x03B7) ;; GREEK SMALL LETTER ETA
     (?$B&H(B . ?\x03B8) ;; GREEK SMALL LETTER THETA
     (?$B&I(B . ?\x03B9) ;; GREEK SMALL LETTER IOTA
     (?$B&J(B . ?\x03BA) ;; GREEK SMALL LETTER KAPPA
     (?$B&K(B . ?\x03BB) ;; GREEK SMALL LETTER LAMDA
     (?$B&L(B . ?\x03BC) ;; GREEK SMALL LETTER MU
     (?$B&M(B . ?\x03BD) ;; GREEK SMALL LETTER NU
     (?$B&N(B . ?\x03BE) ;; GREEK SMALL LETTER XI
     (?$B&O(B . ?\x03BF) ;; GREEK SMALL LETTER OMICRON
     (?$B&P(B . ?\x03C0) ;; GREEK SMALL LETTER PI
     (?$B&Q(B . ?\x03C1) ;; GREEK SMALL LETTER RHO
     (?$B&R(B . ?\x03C3) ;; GREEK SMALL LETTER SIGMA
     (?$B&S(B . ?\x03C4) ;; GREEK SMALL LETTER TAU
     (?$B&T(B . ?\x03C5) ;; GREEK SMALL LETTER UPSILON
     (?$B&U(B . ?\x03C6) ;; GREEK SMALL LETTER PHI
     (?$B&V(B . ?\x03C7) ;; GREEK SMALL LETTER CHI
     (?$B&W(B . ?\x03C8) ;; GREEK SMALL LETTER PSI
     (?$B&X(B . ?\x03C9) ;; GREEK SMALL LETTER OMEGA
     (?$B'!(B . ?\x0410) ;; CYRILLIC CAPITAL LETTER A
     (?$B'"(B . ?\x0411) ;; CYRILLIC CAPITAL LETTER BE
     (?$B'#(B . ?\x0412) ;; CYRILLIC CAPITAL LETTER VE
     (?$B'$(B . ?\x0413) ;; CYRILLIC CAPITAL LETTER GHE
     (?$B'%(B . ?\x0414) ;; CYRILLIC CAPITAL LETTER DE
     (?$B'&(B . ?\x0415) ;; CYRILLIC CAPITAL LETTER IE
     (?$B''(B . ?\x0401) ;; CYRILLIC CAPITAL LETTER IO
     (?$B'((B . ?\x0416) ;; CYRILLIC CAPITAL LETTER ZHE
     (?$B')(B . ?\x0417) ;; CYRILLIC CAPITAL LETTER ZE
     (?$B'*(B . ?\x0418) ;; CYRILLIC CAPITAL LETTER I
     (?$B'+(B . ?\x0419) ;; CYRILLIC CAPITAL LETTER SHORT I
     (?$B',(B . ?\x041A) ;; CYRILLIC CAPITAL LETTER KA
     (?$B'-(B . ?\x041B) ;; CYRILLIC CAPITAL LETTER EL
     (?$B'.(B . ?\x041C) ;; CYRILLIC CAPITAL LETTER EM
     (?$B'/(B . ?\x041D) ;; CYRILLIC CAPITAL LETTER EN
     (?$B'0(B . ?\x041E) ;; CYRILLIC CAPITAL LETTER O
     (?$B'1(B . ?\x041F) ;; CYRILLIC CAPITAL LETTER PE
     (?$B'2(B . ?\x0420) ;; CYRILLIC CAPITAL LETTER ER
     (?$B'3(B . ?\x0421) ;; CYRILLIC CAPITAL LETTER ES
     (?$B'4(B . ?\x0422) ;; CYRILLIC CAPITAL LETTER TE
     (?$B'5(B . ?\x0423) ;; CYRILLIC CAPITAL LETTER U
     (?$B'6(B . ?\x0424) ;; CYRILLIC CAPITAL LETTER EF
     (?$B'7(B . ?\x0425) ;; CYRILLIC CAPITAL LETTER HA
     (?$B'8(B . ?\x0426) ;; CYRILLIC CAPITAL LETTER TSE
     (?$B'9(B . ?\x0427) ;; CYRILLIC CAPITAL LETTER CHE
     (?$B':(B . ?\x0428) ;; CYRILLIC CAPITAL LETTER SHA
     (?$B';(B . ?\x0429) ;; CYRILLIC CAPITAL LETTER SHCHA
     (?$B'<(B . ?\x042A) ;; CYRILLIC CAPITAL LETTER HARD SIGN
     (?$B'=(B . ?\x042B) ;; CYRILLIC CAPITAL LETTER YERU
     (?$B'>(B . ?\x042C) ;; CYRILLIC CAPITAL LETTER SOFT SIGN
     (?$B'?(B . ?\x042D) ;; CYRILLIC CAPITAL LETTER E
     (?$B'@(B . ?\x042E) ;; CYRILLIC CAPITAL LETTER YU
     (?$B'A(B . ?\x042F) ;; CYRILLIC CAPITAL LETTER YA
     (?$B'Q(B . ?\x0430) ;; CYRILLIC SMALL LETTER A
     (?$B'R(B . ?\x0431) ;; CYRILLIC SMALL LETTER BE
     (?$B'S(B . ?\x0432) ;; CYRILLIC SMALL LETTER VE
     (?$B'T(B . ?\x0433) ;; CYRILLIC SMALL LETTER GHE
     (?$B'U(B . ?\x0434) ;; CYRILLIC SMALL LETTER DE
     (?$B'V(B . ?\x0435) ;; CYRILLIC SMALL LETTER IE
     (?$B'W(B . ?\x0451) ;; CYRILLIC SMALL LETTER IO
     (?$B'X(B . ?\x0436) ;; CYRILLIC SMALL LETTER ZHE
     (?$B'Y(B . ?\x0437) ;; CYRILLIC SMALL LETTER ZE
     (?$B'Z(B . ?\x0438) ;; CYRILLIC SMALL LETTER I
     (?$B'[(B . ?\x0439) ;; CYRILLIC SMALL LETTER SHORT I
     (?$B'\(B . ?\x043A) ;; CYRILLIC SMALL LETTER KA
     (?$B'](B . ?\x043B) ;; CYRILLIC SMALL LETTER EL
     (?$B'^(B . ?\x043C) ;; CYRILLIC SMALL LETTER EM
     (?$B'_(B . ?\x043D) ;; CYRILLIC SMALL LETTER EN
     (?$B'`(B . ?\x043E) ;; CYRILLIC SMALL LETTER O
     (?$B'a(B . ?\x043F) ;; CYRILLIC SMALL LETTER PE
     (?$B'b(B . ?\x0440) ;; CYRILLIC SMALL LETTER ER
     (?$B'c(B . ?\x0441) ;; CYRILLIC SMALL LETTER ES
     (?$B'd(B . ?\x0442) ;; CYRILLIC SMALL LETTER TE
     (?$B'e(B . ?\x0443) ;; CYRILLIC SMALL LETTER U
     (?$B'f(B . ?\x0444) ;; CYRILLIC SMALL LETTER EF
     (?$B'g(B . ?\x0445) ;; CYRILLIC SMALL LETTER HA
     (?$B'h(B . ?\x0446) ;; CYRILLIC SMALL LETTER TSE
     (?$B'i(B . ?\x0447) ;; CYRILLIC SMALL LETTER CHE
     (?$B'j(B . ?\x0448) ;; CYRILLIC SMALL LETTER SHA
     (?$B'k(B . ?\x0449) ;; CYRILLIC SMALL LETTER SHCHA
     (?$B'l(B . ?\x044A) ;; CYRILLIC SMALL LETTER HARD SIGN
     (?$B'm(B . ?\x044B) ;; CYRILLIC SMALL LETTER YERU
     (?$B'n(B . ?\x044C) ;; CYRILLIC SMALL LETTER SOFT SIGN
     (?$B'o(B . ?\x044D) ;; CYRILLIC SMALL LETTER E
     (?$B'p(B . ?\x044E) ;; CYRILLIC SMALL LETTER YU
     (?$B'q(B . ?\x044F) ;; CYRILLIC SMALL LETTER YA
     (?$B(!(B . ?\x2500) ;; BOX DRAWINGS LIGHT HORIZONTAL
     (?$B("(B . ?\x2502) ;; BOX DRAWINGS LIGHT VERTICAL
     (?$B(#(B . ?\x250C) ;; BOX DRAWINGS LIGHT DOWN AND RIGHT
     (?$B($(B . ?\x2510) ;; BOX DRAWINGS LIGHT DOWN AND LEFT
     (?$B(%(B . ?\x2518) ;; BOX DRAWINGS LIGHT UP AND LEFT
     (?$B(&(B . ?\x2514) ;; BOX DRAWINGS LIGHT UP AND RIGHT
     (?$B('(B . ?\x251C) ;; BOX DRAWINGS LIGHT VERTICAL AND RIGHT
     (?$B(((B . ?\x252C) ;; BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
     (?$B()(B . ?\x2524) ;; BOX DRAWINGS LIGHT VERTICAL AND LEFT
     (?$B(*(B . ?\x2534) ;; BOX DRAWINGS LIGHT UP AND HORIZONTAL
     (?$B(+(B . ?\x253C) ;; BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
     (?$B(,(B . ?\x2501) ;; BOX DRAWINGS HEAVY HORIZONTAL
     (?$B(-(B . ?\x2503) ;; BOX DRAWINGS HEAVY VERTICAL
     (?$B(.(B . ?\x250F) ;; BOX DRAWINGS HEAVY DOWN AND RIGHT
     (?$B(/(B . ?\x2513) ;; BOX DRAWINGS HEAVY DOWN AND LEFT
     (?$B(0(B . ?\x251B) ;; BOX DRAWINGS HEAVY UP AND LEFT
     (?$B(1(B . ?\x2517) ;; BOX DRAWINGS HEAVY UP AND RIGHT
     (?$B(2(B . ?\x2523) ;; BOX DRAWINGS HEAVY VERTICAL AND RIGHT
     (?$B(3(B . ?\x2533) ;; BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
     (?$B(4(B . ?\x252B) ;; BOX DRAWINGS HEAVY VERTICAL AND LEFT
     (?$B(5(B . ?\x253B) ;; BOX DRAWINGS HEAVY UP AND HORIZONTAL
     (?$B(6(B . ?\x254B) ;; BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
     (?$B(7(B . ?\x2520) ;; BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
     (?$B(8(B . ?\x252F) ;; BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
     (?$B(9(B . ?\x2528) ;; BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
     (?$B(:(B . ?\x2537) ;; BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
     (?$B(;(B . ?\x253F) ;; BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
     (?$B(<(B . ?\x251D) ;; BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
     (?$B(=(B . ?\x2530) ;; BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
     (?$B(>(B . ?\x2525) ;; BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
     (?$B(?(B . ?\x2538) ;; BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
     (?$B(@(B . ?\x2542) ;; BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
     (?$B0!(B . ?\x4E9C) ;; <CJK>
     (?$B0"(B . ?\x5516) ;; <CJK>
     (?$B0#(B . ?\x5A03) ;; <CJK>
     (?$B0$(B . ?\x963F) ;; <CJK>
     (?$B0%(B . ?\x54C0) ;; <CJK>
     (?$B0&(B . ?\x611B) ;; <CJK>
     (?$B0'(B . ?\x6328) ;; <CJK>
     (?$B0((B . ?\x59F6) ;; <CJK>
     (?$B0)(B . ?\x9022) ;; <CJK>
     (?$B0*(B . ?\x8475) ;; <CJK>
     (?$B0+(B . ?\x831C) ;; <CJK>
     (?$B0,(B . ?\x7A50) ;; <CJK>
     (?$B0-(B . ?\x60AA) ;; <CJK>
     (?$B0.(B . ?\x63E1) ;; <CJK>
     (?$B0/(B . ?\x6E25) ;; <CJK>
     (?$B00(B . ?\x65ED) ;; <CJK>
     (?$B01(B . ?\x8466) ;; <CJK>
     (?$B02(B . ?\x82A6) ;; <CJK>
     (?$B03(B . ?\x9BF5) ;; <CJK>
     (?$B04(B . ?\x6893) ;; <CJK>
     (?$B05(B . ?\x5727) ;; <CJK>
     (?$B06(B . ?\x65A1) ;; <CJK>
     (?$B07(B . ?\x6271) ;; <CJK>
     (?$B08(B . ?\x5B9B) ;; <CJK>
     (?$B09(B . ?\x59D0) ;; <CJK>
     (?$B0:(B . ?\x867B) ;; <CJK>
     (?$B0;(B . ?\x98F4) ;; <CJK>
     (?$B0<(B . ?\x7D62) ;; <CJK>
     (?$B0=(B . ?\x7DBE) ;; <CJK>
     (?$B0>(B . ?\x9B8E) ;; <CJK>
     (?$B0?(B . ?\x6216) ;; <CJK>
     (?$B0@(B . ?\x7C9F) ;; <CJK>
     (?$B0A(B . ?\x88B7) ;; <CJK>
     (?$B0B(B . ?\x5B89) ;; <CJK>
     (?$B0C(B . ?\x5EB5) ;; <CJK>
     (?$B0D(B . ?\x6309) ;; <CJK>
     (?$B0E(B . ?\x6697) ;; <CJK>
     (?$B0F(B . ?\x6848) ;; <CJK>
     (?$B0G(B . ?\x95C7) ;; <CJK>
     (?$B0H(B . ?\x978D) ;; <CJK>
     (?$B0I(B . ?\x674F) ;; <CJK>
     (?$B0J(B . ?\x4EE5) ;; <CJK>
     (?$B0K(B . ?\x4F0A) ;; <CJK>
     (?$B0L(B . ?\x4F4D) ;; <CJK>
     (?$B0M(B . ?\x4F9D) ;; <CJK>
     (?$B0N(B . ?\x5049) ;; <CJK>
     (?$B0O(B . ?\x56F2) ;; <CJK>
     (?$B0P(B . ?\x5937) ;; <CJK>
     (?$B0Q(B . ?\x59D4) ;; <CJK>
     (?$B0R(B . ?\x5A01) ;; <CJK>
     (?$B0S(B . ?\x5C09) ;; <CJK>
     (?$B0T(B . ?\x60DF) ;; <CJK>
     (?$B0U(B . ?\x610F) ;; <CJK>
     (?$B0V(B . ?\x6170) ;; <CJK>
     (?$B0W(B . ?\x6613) ;; <CJK>
     (?$B0X(B . ?\x6905) ;; <CJK>
     (?$B0Y(B . ?\x70BA) ;; <CJK>
     (?$B0Z(B . ?\x754F) ;; <CJK>
     (?$B0[(B . ?\x7570) ;; <CJK>
     (?$B0\(B . ?\x79FB) ;; <CJK>
     (?$B0](B . ?\x7DAD) ;; <CJK>
     (?$B0^(B . ?\x7DEF) ;; <CJK>
     (?$B0_(B . ?\x80C3) ;; <CJK>
     (?$B0`(B . ?\x840E) ;; <CJK>
     (?$B0a(B . ?\x8863) ;; <CJK>
     (?$B0b(B . ?\x8B02) ;; <CJK>
     (?$B0c(B . ?\x9055) ;; <CJK>
     (?$B0d(B . ?\x907A) ;; <CJK>
     (?$B0e(B . ?\x533B) ;; <CJK>
     (?$B0f(B . ?\x4E95) ;; <CJK>
     (?$B0g(B . ?\x4EA5) ;; <CJK>
     (?$B0h(B . ?\x57DF) ;; <CJK>
     (?$B0i(B . ?\x80B2) ;; <CJK>
     (?$B0j(B . ?\x90C1) ;; <CJK>
     (?$B0k(B . ?\x78EF) ;; <CJK>
     (?$B0l(B . ?\x4E00) ;; <CJK>
     (?$B0m(B . ?\x58F1) ;; <CJK>
     (?$B0n(B . ?\x6EA2) ;; <CJK>
     (?$B0o(B . ?\x9038) ;; <CJK>
     (?$B0p(B . ?\x7A32) ;; <CJK>
     (?$B0q(B . ?\x8328) ;; <CJK>
     (?$B0r(B . ?\x828B) ;; <CJK>
     (?$B0s(B . ?\x9C2F) ;; <CJK>
     (?$B0t(B . ?\x5141) ;; <CJK>
     (?$B0u(B . ?\x5370) ;; <CJK>
     (?$B0v(B . ?\x54BD) ;; <CJK>
     (?$B0w(B . ?\x54E1) ;; <CJK>
     (?$B0x(B . ?\x56E0) ;; <CJK>
     (?$B0y(B . ?\x59FB) ;; <CJK>
     (?$B0z(B . ?\x5F15) ;; <CJK>
     (?$B0{(B . ?\x98F2) ;; <CJK>
     (?$B0|(B . ?\x6DEB) ;; <CJK>
     (?$B0}(B . ?\x80E4) ;; <CJK>
     (?$B0~(B . ?\x852D) ;; <CJK>
     (?$B1!(B . ?\x9662) ;; <CJK>
     (?$B1"(B . ?\x9670) ;; <CJK>
     (?$B1#(B . ?\x96A0) ;; <CJK>
     (?$B1$(B . ?\x97FB) ;; <CJK>
     (?$B1%(B . ?\x540B) ;; <CJK>
     (?$B1&(B . ?\x53F3) ;; <CJK>
     (?$B1'(B . ?\x5B87) ;; <CJK>
     (?$B1((B . ?\x70CF) ;; <CJK>
     (?$B1)(B . ?\x7FBD) ;; <CJK>
     (?$B1*(B . ?\x8FC2) ;; <CJK>
     (?$B1+(B . ?\x96E8) ;; <CJK>
     (?$B1,(B . ?\x536F) ;; <CJK>
     (?$B1-(B . ?\x9D5C) ;; <CJK>
     (?$B1.(B . ?\x7ABA) ;; <CJK>
     (?$B1/(B . ?\x4E11) ;; <CJK>
     (?$B10(B . ?\x7893) ;; <CJK>
     (?$B11(B . ?\x81FC) ;; <CJK>
     (?$B12(B . ?\x6E26) ;; <CJK>
     (?$B13(B . ?\x5618) ;; <CJK>
     (?$B14(B . ?\x5504) ;; <CJK>
     (?$B15(B . ?\x6B1D) ;; <CJK>
     (?$B16(B . ?\x851A) ;; <CJK>
     (?$B17(B . ?\x9C3B) ;; <CJK>
     (?$B18(B . ?\x59E5) ;; <CJK>
     (?$B19(B . ?\x53A9) ;; <CJK>
     (?$B1:(B . ?\x6D66) ;; <CJK>
     (?$B1;(B . ?\x74DC) ;; <CJK>
     (?$B1<(B . ?\x958F) ;; <CJK>
     (?$B1=(B . ?\x5642) ;; <CJK>
     (?$B1>(B . ?\x4E91) ;; <CJK>
     (?$B1?(B . ?\x904B) ;; <CJK>
     (?$B1@(B . ?\x96F2) ;; <CJK>
     (?$B1A(B . ?\x834F) ;; <CJK>
     (?$B1B(B . ?\x990C) ;; <CJK>
     (?$B1C(B . ?\x53E1) ;; <CJK>
     (?$B1D(B . ?\x55B6) ;; <CJK>
     (?$B1E(B . ?\x5B30) ;; <CJK>
     (?$B1F(B . ?\x5F71) ;; <CJK>
     (?$B1G(B . ?\x6620) ;; <CJK>
     (?$B1H(B . ?\x66F3) ;; <CJK>
     (?$B1I(B . ?\x6804) ;; <CJK>
     (?$B1J(B . ?\x6C38) ;; <CJK>
     (?$B1K(B . ?\x6CF3) ;; <CJK>
     (?$B1L(B . ?\x6D29) ;; <CJK>
     (?$B1M(B . ?\x745B) ;; <CJK>
     (?$B1N(B . ?\x76C8) ;; <CJK>
     (?$B1O(B . ?\x7A4E) ;; <CJK>
     (?$B1P(B . ?\x9834) ;; <CJK>
     (?$B1Q(B . ?\x82F1) ;; <CJK>
     (?$B1R(B . ?\x885B) ;; <CJK>
     (?$B1S(B . ?\x8A60) ;; <CJK>
     (?$B1T(B . ?\x92ED) ;; <CJK>
     (?$B1U(B . ?\x6DB2) ;; <CJK>
     (?$B1V(B . ?\x75AB) ;; <CJK>
     (?$B1W(B . ?\x76CA) ;; <CJK>
     (?$B1X(B . ?\x99C5) ;; <CJK>
     (?$B1Y(B . ?\x60A6) ;; <CJK>
     (?$B1Z(B . ?\x8B01) ;; <CJK>
     (?$B1[(B . ?\x8D8A) ;; <CJK>
     (?$B1\(B . ?\x95B2) ;; <CJK>
     (?$B1](B . ?\x698E) ;; <CJK>
     (?$B1^(B . ?\x53AD) ;; <CJK>
     (?$B1_(B . ?\x5186) ;; <CJK>
     (?$B1`(B . ?\x5712) ;; <CJK>
     (?$B1a(B . ?\x5830) ;; <CJK>
     (?$B1b(B . ?\x5944) ;; <CJK>
     (?$B1c(B . ?\x5BB4) ;; <CJK>
     (?$B1d(B . ?\x5EF6) ;; <CJK>
     (?$B1e(B . ?\x6028) ;; <CJK>
     (?$B1f(B . ?\x63A9) ;; <CJK>
     (?$B1g(B . ?\x63F4) ;; <CJK>
     (?$B1h(B . ?\x6CBF) ;; <CJK>
     (?$B1i(B . ?\x6F14) ;; <CJK>
     (?$B1j(B . ?\x708E) ;; <CJK>
     (?$B1k(B . ?\x7114) ;; <CJK>
     (?$B1l(B . ?\x7159) ;; <CJK>
     (?$B1m(B . ?\x71D5) ;; <CJK>
     (?$B1n(B . ?\x733F) ;; <CJK>
     (?$B1o(B . ?\x7E01) ;; <CJK>
     (?$B1p(B . ?\x8276) ;; <CJK>
     (?$B1q(B . ?\x82D1) ;; <CJK>
     (?$B1r(B . ?\x8597) ;; <CJK>
     (?$B1s(B . ?\x9060) ;; <CJK>
     (?$B1t(B . ?\x925B) ;; <CJK>
     (?$B1u(B . ?\x9D1B) ;; <CJK>
     (?$B1v(B . ?\x5869) ;; <CJK>
     (?$B1w(B . ?\x65BC) ;; <CJK>
     (?$B1x(B . ?\x6C5A) ;; <CJK>
     (?$B1y(B . ?\x7525) ;; <CJK>
     (?$B1z(B . ?\x51F9) ;; <CJK>
     (?$B1{(B . ?\x592E) ;; <CJK>
     (?$B1|(B . ?\x5965) ;; <CJK>
     (?$B1}(B . ?\x5F80) ;; <CJK>
     (?$B1~(B . ?\x5FDC) ;; <CJK>
     (?$B2!(B . ?\x62BC) ;; <CJK>
     (?$B2"(B . ?\x65FA) ;; <CJK>
     (?$B2#(B . ?\x6A2A) ;; <CJK>
     (?$B2$(B . ?\x6B27) ;; <CJK>
     (?$B2%(B . ?\x6BB4) ;; <CJK>
     (?$B2&(B . ?\x738B) ;; <CJK>
     (?$B2'(B . ?\x7FC1) ;; <CJK>
     (?$B2((B . ?\x8956) ;; <CJK>
     (?$B2)(B . ?\x9D2C) ;; <CJK>
     (?$B2*(B . ?\x9D0E) ;; <CJK>
     (?$B2+(B . ?\x9EC4) ;; <CJK>
     (?$B2,(B . ?\x5CA1) ;; <CJK>
     (?$B2-(B . ?\x6C96) ;; <CJK>
     (?$B2.(B . ?\x837B) ;; <CJK>
     (?$B2/(B . ?\x5104) ;; <CJK>
     (?$B20(B . ?\x5C4B) ;; <CJK>
     (?$B21(B . ?\x61B6) ;; <CJK>
     (?$B22(B . ?\x81C6) ;; <CJK>
     (?$B23(B . ?\x6876) ;; <CJK>
     (?$B24(B . ?\x7261) ;; <CJK>
     (?$B25(B . ?\x4E59) ;; <CJK>
     (?$B26(B . ?\x4FFA) ;; <CJK>
     (?$B27(B . ?\x5378) ;; <CJK>
     (?$B28(B . ?\x6069) ;; <CJK>
     (?$B29(B . ?\x6E29) ;; <CJK>
     (?$B2:(B . ?\x7A4F) ;; <CJK>
     (?$B2;(B . ?\x97F3) ;; <CJK>
     (?$B2<(B . ?\x4E0B) ;; <CJK>
     (?$B2=(B . ?\x5316) ;; <CJK>
     (?$B2>(B . ?\x4EEE) ;; <CJK>
     (?$B2?(B . ?\x4F55) ;; <CJK>
     (?$B2@(B . ?\x4F3D) ;; <CJK>
     (?$B2A(B . ?\x4FA1) ;; <CJK>
     (?$B2B(B . ?\x4F73) ;; <CJK>
     (?$B2C(B . ?\x52A0) ;; <CJK>
     (?$B2D(B . ?\x53EF) ;; <CJK>
     (?$B2E(B . ?\x5609) ;; <CJK>
     (?$B2F(B . ?\x590F) ;; <CJK>
     (?$B2G(B . ?\x5AC1) ;; <CJK>
     (?$B2H(B . ?\x5BB6) ;; <CJK>
     (?$B2I(B . ?\x5BE1) ;; <CJK>
     (?$B2J(B . ?\x79D1) ;; <CJK>
     (?$B2K(B . ?\x6687) ;; <CJK>
     (?$B2L(B . ?\x679C) ;; <CJK>
     (?$B2M(B . ?\x67B6) ;; <CJK>
     (?$B2N(B . ?\x6B4C) ;; <CJK>
     (?$B2O(B . ?\x6CB3) ;; <CJK>
     (?$B2P(B . ?\x706B) ;; <CJK>
     (?$B2Q(B . ?\x73C2) ;; <CJK>
     (?$B2R(B . ?\x798D) ;; <CJK>
     (?$B2S(B . ?\x79BE) ;; <CJK>
     (?$B2T(B . ?\x7A3C) ;; <CJK>
     (?$B2U(B . ?\x7B87) ;; <CJK>
     (?$B2V(B . ?\x82B1) ;; <CJK>
     (?$B2W(B . ?\x82DB) ;; <CJK>
     (?$B2X(B . ?\x8304) ;; <CJK>
     (?$B2Y(B . ?\x8377) ;; <CJK>
     (?$B2Z(B . ?\x83EF) ;; <CJK>
     (?$B2[(B . ?\x83D3) ;; <CJK>
     (?$B2\(B . ?\x8766) ;; <CJK>
     (?$B2](B . ?\x8AB2) ;; <CJK>
     (?$B2^(B . ?\x5629) ;; <CJK>
     (?$B2_(B . ?\x8CA8) ;; <CJK>
     (?$B2`(B . ?\x8FE6) ;; <CJK>
     (?$B2a(B . ?\x904E) ;; <CJK>
     (?$B2b(B . ?\x971E) ;; <CJK>
     (?$B2c(B . ?\x868A) ;; <CJK>
     (?$B2d(B . ?\x4FC4) ;; <CJK>
     (?$B2e(B . ?\x5CE8) ;; <CJK>
     (?$B2f(B . ?\x6211) ;; <CJK>
     (?$B2g(B . ?\x7259) ;; <CJK>
     (?$B2h(B . ?\x753B) ;; <CJK>
     (?$B2i(B . ?\x81E5) ;; <CJK>
     (?$B2j(B . ?\x82BD) ;; <CJK>
     (?$B2k(B . ?\x86FE) ;; <CJK>
     (?$B2l(B . ?\x8CC0) ;; <CJK>
     (?$B2m(B . ?\x96C5) ;; <CJK>
     (?$B2n(B . ?\x9913) ;; <CJK>
     (?$B2o(B . ?\x99D5) ;; <CJK>
     (?$B2p(B . ?\x4ECB) ;; <CJK>
     (?$B2q(B . ?\x4F1A) ;; <CJK>
     (?$B2r(B . ?\x89E3) ;; <CJK>
     (?$B2s(B . ?\x56DE) ;; <CJK>
     (?$B2t(B . ?\x584A) ;; <CJK>
     (?$B2u(B . ?\x58CA) ;; <CJK>
     (?$B2v(B . ?\x5EFB) ;; <CJK>
     (?$B2w(B . ?\x5FEB) ;; <CJK>
     (?$B2x(B . ?\x602A) ;; <CJK>
     (?$B2y(B . ?\x6094) ;; <CJK>
     (?$B2z(B . ?\x6062) ;; <CJK>
     (?$B2{(B . ?\x61D0) ;; <CJK>
     (?$B2|(B . ?\x6212) ;; <CJK>
     (?$B2}(B . ?\x62D0) ;; <CJK>
     (?$B2~(B . ?\x6539) ;; <CJK>
     (?$B3!(B . ?\x9B41) ;; <CJK>
     (?$B3"(B . ?\x6666) ;; <CJK>
     (?$B3#(B . ?\x68B0) ;; <CJK>
     (?$B3$(B . ?\x6D77) ;; <CJK>
     (?$B3%(B . ?\x7070) ;; <CJK>
     (?$B3&(B . ?\x754C) ;; <CJK>
     (?$B3'(B . ?\x7686) ;; <CJK>
     (?$B3((B . ?\x7D75) ;; <CJK>
     (?$B3)(B . ?\x82A5) ;; <CJK>
     (?$B3*(B . ?\x87F9) ;; <CJK>
     (?$B3+(B . ?\x958B) ;; <CJK>
     (?$B3,(B . ?\x968E) ;; <CJK>
     (?$B3-(B . ?\x8C9D) ;; <CJK>
     (?$B3.(B . ?\x51F1) ;; <CJK>
     (?$B3/(B . ?\x52BE) ;; <CJK>
     (?$B30(B . ?\x5916) ;; <CJK>
     (?$B31(B . ?\x54B3) ;; <CJK>
     (?$B32(B . ?\x5BB3) ;; <CJK>
     (?$B33(B . ?\x5D16) ;; <CJK>
     (?$B34(B . ?\x6168) ;; <CJK>
     (?$B35(B . ?\x6982) ;; <CJK>
     (?$B36(B . ?\x6DAF) ;; <CJK>
     (?$B37(B . ?\x788D) ;; <CJK>
     (?$B38(B . ?\x84CB) ;; <CJK>
     (?$B39(B . ?\x8857) ;; <CJK>
     (?$B3:(B . ?\x8A72) ;; <CJK>
     (?$B3;(B . ?\x93A7) ;; <CJK>
     (?$B3<(B . ?\x9AB8) ;; <CJK>
     (?$B3=(B . ?\x6D6C) ;; <CJK>
     (?$B3>(B . ?\x99A8) ;; <CJK>
     (?$B3?(B . ?\x86D9) ;; <CJK>
     (?$B3@(B . ?\x57A3) ;; <CJK>
     (?$B3A(B . ?\x67FF) ;; <CJK>
     (?$B3B(B . ?\x86CE) ;; <CJK>
     (?$B3C(B . ?\x920E) ;; <CJK>
     (?$B3D(B . ?\x5283) ;; <CJK>
     (?$B3E(B . ?\x5687) ;; <CJK>
     (?$B3F(B . ?\x5404) ;; <CJK>
     (?$B3G(B . ?\x5ED3) ;; <CJK>
     (?$B3H(B . ?\x62E1) ;; <CJK>
     (?$B3I(B . ?\x64B9) ;; <CJK>
     (?$B3J(B . ?\x683C) ;; <CJK>
     (?$B3K(B . ?\x6838) ;; <CJK>
     (?$B3L(B . ?\x6BBB) ;; <CJK>
     (?$B3M(B . ?\x7372) ;; <CJK>
     (?$B3N(B . ?\x78BA) ;; <CJK>
     (?$B3O(B . ?\x7A6B) ;; <CJK>
     (?$B3P(B . ?\x899A) ;; <CJK>
     (?$B3Q(B . ?\x89D2) ;; <CJK>
     (?$B3R(B . ?\x8D6B) ;; <CJK>
     (?$B3S(B . ?\x8F03) ;; <CJK>
     (?$B3T(B . ?\x90ED) ;; <CJK>
     (?$B3U(B . ?\x95A3) ;; <CJK>
     (?$B3V(B . ?\x9694) ;; <CJK>
     (?$B3W(B . ?\x9769) ;; <CJK>
     (?$B3X(B . ?\x5B66) ;; <CJK>
     (?$B3Y(B . ?\x5CB3) ;; <CJK>
     (?$B3Z(B . ?\x697D) ;; <CJK>
     (?$B3[(B . ?\x984D) ;; <CJK>
     (?$B3\(B . ?\x984E) ;; <CJK>
     (?$B3](B . ?\x639B) ;; <CJK>
     (?$B3^(B . ?\x7B20) ;; <CJK>
     (?$B3_(B . ?\x6A2B) ;; <CJK>
     (?$B3`(B . ?\x6A7F) ;; <CJK>
     (?$B3a(B . ?\x68B6) ;; <CJK>
     (?$B3b(B . ?\x9C0D) ;; <CJK>
     (?$B3c(B . ?\x6F5F) ;; <CJK>
     (?$B3d(B . ?\x5272) ;; <CJK>
     (?$B3e(B . ?\x559D) ;; <CJK>
     (?$B3f(B . ?\x6070) ;; <CJK>
     (?$B3g(B . ?\x62EC) ;; <CJK>
     (?$B3h(B . ?\x6D3B) ;; <CJK>
     (?$B3i(B . ?\x6E07) ;; <CJK>
     (?$B3j(B . ?\x6ED1) ;; <CJK>
     (?$B3k(B . ?\x845B) ;; <CJK>
     (?$B3l(B . ?\x8910) ;; <CJK>
     (?$B3m(B . ?\x8F44) ;; <CJK>
     (?$B3n(B . ?\x4E14) ;; <CJK>
     (?$B3o(B . ?\x9C39) ;; <CJK>
     (?$B3p(B . ?\x53F6) ;; <CJK>
     (?$B3q(B . ?\x691B) ;; <CJK>
     (?$B3r(B . ?\x6A3A) ;; <CJK>
     (?$B3s(B . ?\x9784) ;; <CJK>
     (?$B3t(B . ?\x682A) ;; <CJK>
     (?$B3u(B . ?\x515C) ;; <CJK>
     (?$B3v(B . ?\x7AC3) ;; <CJK>
     (?$B3w(B . ?\x84B2) ;; <CJK>
     (?$B3x(B . ?\x91DC) ;; <CJK>
     (?$B3y(B . ?\x938C) ;; <CJK>
     (?$B3z(B . ?\x565B) ;; <CJK>
     (?$B3{(B . ?\x9D28) ;; <CJK>
     (?$B3|(B . ?\x6822) ;; <CJK>
     (?$B3}(B . ?\x8305) ;; <CJK>
     (?$B3~(B . ?\x8431) ;; <CJK>
     (?$B4!(B . ?\x7CA5) ;; <CJK>
     (?$B4"(B . ?\x5208) ;; <CJK>
     (?$B4#(B . ?\x82C5) ;; <CJK>
     (?$B4$(B . ?\x74E6) ;; <CJK>
     (?$B4%(B . ?\x4E7E) ;; <CJK>
     (?$B4&(B . ?\x4F83) ;; <CJK>
     (?$B4'(B . ?\x51A0) ;; <CJK>
     (?$B4((B . ?\x5BD2) ;; <CJK>
     (?$B4)(B . ?\x520A) ;; <CJK>
     (?$B4*(B . ?\x52D8) ;; <CJK>
     (?$B4+(B . ?\x52E7) ;; <CJK>
     (?$B4,(B . ?\x5DFB) ;; <CJK>
     (?$B4-(B . ?\x559A) ;; <CJK>
     (?$B4.(B . ?\x582A) ;; <CJK>
     (?$B4/(B . ?\x59E6) ;; <CJK>
     (?$B40(B . ?\x5B8C) ;; <CJK>
     (?$B41(B . ?\x5B98) ;; <CJK>
     (?$B42(B . ?\x5BDB) ;; <CJK>
     (?$B43(B . ?\x5E72) ;; <CJK>
     (?$B44(B . ?\x5E79) ;; <CJK>
     (?$B45(B . ?\x60A3) ;; <CJK>
     (?$B46(B . ?\x611F) ;; <CJK>
     (?$B47(B . ?\x6163) ;; <CJK>
     (?$B48(B . ?\x61BE) ;; <CJK>
     (?$B49(B . ?\x63DB) ;; <CJK>
     (?$B4:(B . ?\x6562) ;; <CJK>
     (?$B4;(B . ?\x67D1) ;; <CJK>
     (?$B4<(B . ?\x6853) ;; <CJK>
     (?$B4=(B . ?\x68FA) ;; <CJK>
     (?$B4>(B . ?\x6B3E) ;; <CJK>
     (?$B4?(B . ?\x6B53) ;; <CJK>
     (?$B4@(B . ?\x6C57) ;; <CJK>
     (?$B4A(B . ?\x6F22) ;; <CJK>
     (?$B4B(B . ?\x6F97) ;; <CJK>
     (?$B4C(B . ?\x6F45) ;; <CJK>
     (?$B4D(B . ?\x74B0) ;; <CJK>
     (?$B4E(B . ?\x7518) ;; <CJK>
     (?$B4F(B . ?\x76E3) ;; <CJK>
     (?$B4G(B . ?\x770B) ;; <CJK>
     (?$B4H(B . ?\x7AFF) ;; <CJK>
     (?$B4I(B . ?\x7BA1) ;; <CJK>
     (?$B4J(B . ?\x7C21) ;; <CJK>
     (?$B4K(B . ?\x7DE9) ;; <CJK>
     (?$B4L(B . ?\x7F36) ;; <CJK>
     (?$B4M(B . ?\x7FF0) ;; <CJK>
     (?$B4N(B . ?\x809D) ;; <CJK>
     (?$B4O(B . ?\x8266) ;; <CJK>
     (?$B4P(B . ?\x839E) ;; <CJK>
     (?$B4Q(B . ?\x89B3) ;; <CJK>
     (?$B4R(B . ?\x8ACC) ;; <CJK>
     (?$B4S(B . ?\x8CAB) ;; <CJK>
     (?$B4T(B . ?\x9084) ;; <CJK>
     (?$B4U(B . ?\x9451) ;; <CJK>
     (?$B4V(B . ?\x9593) ;; <CJK>
     (?$B4W(B . ?\x9591) ;; <CJK>
     (?$B4X(B . ?\x95A2) ;; <CJK>
     (?$B4Y(B . ?\x9665) ;; <CJK>
     (?$B4Z(B . ?\x97D3) ;; <CJK>
     (?$B4[(B . ?\x9928) ;; <CJK>
     (?$B4\(B . ?\x8218) ;; <CJK>
     (?$B4](B . ?\x4E38) ;; <CJK>
     (?$B4^(B . ?\x542B) ;; <CJK>
     (?$B4_(B . ?\x5CB8) ;; <CJK>
     (?$B4`(B . ?\x5DCC) ;; <CJK>
     (?$B4a(B . ?\x73A9) ;; <CJK>
     (?$B4b(B . ?\x764C) ;; <CJK>
     (?$B4c(B . ?\x773C) ;; <CJK>
     (?$B4d(B . ?\x5CA9) ;; <CJK>
     (?$B4e(B . ?\x7FEB) ;; <CJK>
     (?$B4f(B . ?\x8D0B) ;; <CJK>
     (?$B4g(B . ?\x96C1) ;; <CJK>
     (?$B4h(B . ?\x9811) ;; <CJK>
     (?$B4i(B . ?\x9854) ;; <CJK>
     (?$B4j(B . ?\x9858) ;; <CJK>
     (?$B4k(B . ?\x4F01) ;; <CJK>
     (?$B4l(B . ?\x4F0E) ;; <CJK>
     (?$B4m(B . ?\x5371) ;; <CJK>
     (?$B4n(B . ?\x559C) ;; <CJK>
     (?$B4o(B . ?\x5668) ;; <CJK>
     (?$B4p(B . ?\x57FA) ;; <CJK>
     (?$B4q(B . ?\x5947) ;; <CJK>
     (?$B4r(B . ?\x5B09) ;; <CJK>
     (?$B4s(B . ?\x5BC4) ;; <CJK>
     (?$B4t(B . ?\x5C90) ;; <CJK>
     (?$B4u(B . ?\x5E0C) ;; <CJK>
     (?$B4v(B . ?\x5E7E) ;; <CJK>
     (?$B4w(B . ?\x5FCC) ;; <CJK>
     (?$B4x(B . ?\x63EE) ;; <CJK>
     (?$B4y(B . ?\x673A) ;; <CJK>
     (?$B4z(B . ?\x65D7) ;; <CJK>
     (?$B4{(B . ?\x65E2) ;; <CJK>
     (?$B4|(B . ?\x671F) ;; <CJK>
     (?$B4}(B . ?\x68CB) ;; <CJK>
     (?$B4~(B . ?\x68C4) ;; <CJK>
     (?$B5!(B . ?\x6A5F) ;; <CJK>
     (?$B5"(B . ?\x5E30) ;; <CJK>
     (?$B5#(B . ?\x6BC5) ;; <CJK>
     (?$B5$(B . ?\x6C17) ;; <CJK>
     (?$B5%(B . ?\x6C7D) ;; <CJK>
     (?$B5&(B . ?\x757F) ;; <CJK>
     (?$B5'(B . ?\x7948) ;; <CJK>
     (?$B5((B . ?\x5B63) ;; <CJK>
     (?$B5)(B . ?\x7A00) ;; <CJK>
     (?$B5*(B . ?\x7D00) ;; <CJK>
     (?$B5+(B . ?\x5FBD) ;; <CJK>
     (?$B5,(B . ?\x898F) ;; <CJK>
     (?$B5-(B . ?\x8A18) ;; <CJK>
     (?$B5.(B . ?\x8CB4) ;; <CJK>
     (?$B5/(B . ?\x8D77) ;; <CJK>
     (?$B50(B . ?\x8ECC) ;; <CJK>
     (?$B51(B . ?\x8F1D) ;; <CJK>
     (?$B52(B . ?\x98E2) ;; <CJK>
     (?$B53(B . ?\x9A0E) ;; <CJK>
     (?$B54(B . ?\x9B3C) ;; <CJK>
     (?$B55(B . ?\x4E80) ;; <CJK>
     (?$B56(B . ?\x507D) ;; <CJK>
     (?$B57(B . ?\x5100) ;; <CJK>
     (?$B58(B . ?\x5993) ;; <CJK>
     (?$B59(B . ?\x5B9C) ;; <CJK>
     (?$B5:(B . ?\x622F) ;; <CJK>
     (?$B5;(B . ?\x6280) ;; <CJK>
     (?$B5<(B . ?\x64EC) ;; <CJK>
     (?$B5=(B . ?\x6B3A) ;; <CJK>
     (?$B5>(B . ?\x72A0) ;; <CJK>
     (?$B5?(B . ?\x7591) ;; <CJK>
     (?$B5@(B . ?\x7947) ;; <CJK>
     (?$B5A(B . ?\x7FA9) ;; <CJK>
     (?$B5B(B . ?\x87FB) ;; <CJK>
     (?$B5C(B . ?\x8ABC) ;; <CJK>
     (?$B5D(B . ?\x8B70) ;; <CJK>
     (?$B5E(B . ?\x63AC) ;; <CJK>
     (?$B5F(B . ?\x83CA) ;; <CJK>
     (?$B5G(B . ?\x97A0) ;; <CJK>
     (?$B5H(B . ?\x5409) ;; <CJK>
     (?$B5I(B . ?\x5403) ;; <CJK>
     (?$B5J(B . ?\x55AB) ;; <CJK>
     (?$B5K(B . ?\x6854) ;; <CJK>
     (?$B5L(B . ?\x6A58) ;; <CJK>
     (?$B5M(B . ?\x8A70) ;; <CJK>
     (?$B5N(B . ?\x7827) ;; <CJK>
     (?$B5O(B . ?\x6775) ;; <CJK>
     (?$B5P(B . ?\x9ECD) ;; <CJK>
     (?$B5Q(B . ?\x5374) ;; <CJK>
     (?$B5R(B . ?\x5BA2) ;; <CJK>
     (?$B5S(B . ?\x811A) ;; <CJK>
     (?$B5T(B . ?\x8650) ;; <CJK>
     (?$B5U(B . ?\x9006) ;; <CJK>
     (?$B5V(B . ?\x4E18) ;; <CJK>
     (?$B5W(B . ?\x4E45) ;; <CJK>
     (?$B5X(B . ?\x4EC7) ;; <CJK>
     (?$B5Y(B . ?\x4F11) ;; <CJK>
     (?$B5Z(B . ?\x53CA) ;; <CJK>
     (?$B5[(B . ?\x5438) ;; <CJK>
     (?$B5\(B . ?\x5BAE) ;; <CJK>
     (?$B5](B . ?\x5F13) ;; <CJK>
     (?$B5^(B . ?\x6025) ;; <CJK>
     (?$B5_(B . ?\x6551) ;; <CJK>
     (?$B5`(B . ?\x673D) ;; <CJK>
     (?$B5a(B . ?\x6C42) ;; <CJK>
     (?$B5b(B . ?\x6C72) ;; <CJK>
     (?$B5c(B . ?\x6CE3) ;; <CJK>
     (?$B5d(B . ?\x7078) ;; <CJK>
     (?$B5e(B . ?\x7403) ;; <CJK>
     (?$B5f(B . ?\x7A76) ;; <CJK>
     (?$B5g(B . ?\x7AAE) ;; <CJK>
     (?$B5h(B . ?\x7B08) ;; <CJK>
     (?$B5i(B . ?\x7D1A) ;; <CJK>
     (?$B5j(B . ?\x7CFE) ;; <CJK>
     (?$B5k(B . ?\x7D66) ;; <CJK>
     (?$B5l(B . ?\x65E7) ;; <CJK>
     (?$B5m(B . ?\x725B) ;; <CJK>
     (?$B5n(B . ?\x53BB) ;; <CJK>
     (?$B5o(B . ?\x5C45) ;; <CJK>
     (?$B5p(B . ?\x5DE8) ;; <CJK>
     (?$B5q(B . ?\x62D2) ;; <CJK>
     (?$B5r(B . ?\x62E0) ;; <CJK>
     (?$B5s(B . ?\x6319) ;; <CJK>
     (?$B5t(B . ?\x6E20) ;; <CJK>
     (?$B5u(B . ?\x865A) ;; <CJK>
     (?$B5v(B . ?\x8A31) ;; <CJK>
     (?$B5w(B . ?\x8DDD) ;; <CJK>
     (?$B5x(B . ?\x92F8) ;; <CJK>
     (?$B5y(B . ?\x6F01) ;; <CJK>
     (?$B5z(B . ?\x79A6) ;; <CJK>
     (?$B5{(B . ?\x9B5A) ;; <CJK>
     (?$B5|(B . ?\x4EA8) ;; <CJK>
     (?$B5}(B . ?\x4EAB) ;; <CJK>
     (?$B5~(B . ?\x4EAC) ;; <CJK>
     (?$B6!(B . ?\x4F9B) ;; <CJK>
     (?$B6"(B . ?\x4FA0) ;; <CJK>
     (?$B6#(B . ?\x50D1) ;; <CJK>
     (?$B6$(B . ?\x5147) ;; <CJK>
     (?$B6%(B . ?\x7AF6) ;; <CJK>
     (?$B6&(B . ?\x5171) ;; <CJK>
     (?$B6'(B . ?\x51F6) ;; <CJK>
     (?$B6((B . ?\x5354) ;; <CJK>
     (?$B6)(B . ?\x5321) ;; <CJK>
     (?$B6*(B . ?\x537F) ;; <CJK>
     (?$B6+(B . ?\x53EB) ;; <CJK>
     (?$B6,(B . ?\x55AC) ;; <CJK>
     (?$B6-(B . ?\x5883) ;; <CJK>
     (?$B6.(B . ?\x5CE1) ;; <CJK>
     (?$B6/(B . ?\x5F37) ;; <CJK>
     (?$B60(B . ?\x5F4A) ;; <CJK>
     (?$B61(B . ?\x602F) ;; <CJK>
     (?$B62(B . ?\x6050) ;; <CJK>
     (?$B63(B . ?\x606D) ;; <CJK>
     (?$B64(B . ?\x631F) ;; <CJK>
     (?$B65(B . ?\x6559) ;; <CJK>
     (?$B66(B . ?\x6A4B) ;; <CJK>
     (?$B67(B . ?\x6CC1) ;; <CJK>
     (?$B68(B . ?\x72C2) ;; <CJK>
     (?$B69(B . ?\x72ED) ;; <CJK>
     (?$B6:(B . ?\x77EF) ;; <CJK>
     (?$B6;(B . ?\x80F8) ;; <CJK>
     (?$B6<(B . ?\x8105) ;; <CJK>
     (?$B6=(B . ?\x8208) ;; <CJK>
     (?$B6>(B . ?\x854E) ;; <CJK>
     (?$B6?(B . ?\x90F7) ;; <CJK>
     (?$B6@(B . ?\x93E1) ;; <CJK>
     (?$B6A(B . ?\x97FF) ;; <CJK>
     (?$B6B(B . ?\x9957) ;; <CJK>
     (?$B6C(B . ?\x9A5A) ;; <CJK>
     (?$B6D(B . ?\x4EF0) ;; <CJK>
     (?$B6E(B . ?\x51DD) ;; <CJK>
     (?$B6F(B . ?\x5C2D) ;; <CJK>
     (?$B6G(B . ?\x6681) ;; <CJK>
     (?$B6H(B . ?\x696D) ;; <CJK>
     (?$B6I(B . ?\x5C40) ;; <CJK>
     (?$B6J(B . ?\x66F2) ;; <CJK>
     (?$B6K(B . ?\x6975) ;; <CJK>
     (?$B6L(B . ?\x7389) ;; <CJK>
     (?$B6M(B . ?\x6850) ;; <CJK>
     (?$B6N(B . ?\x7C81) ;; <CJK>
     (?$B6O(B . ?\x50C5) ;; <CJK>
     (?$B6P(B . ?\x52E4) ;; <CJK>
     (?$B6Q(B . ?\x5747) ;; <CJK>
     (?$B6R(B . ?\x5DFE) ;; <CJK>
     (?$B6S(B . ?\x9326) ;; <CJK>
     (?$B6T(B . ?\x65A4) ;; <CJK>
     (?$B6U(B . ?\x6B23) ;; <CJK>
     (?$B6V(B . ?\x6B3D) ;; <CJK>
     (?$B6W(B . ?\x7434) ;; <CJK>
     (?$B6X(B . ?\x7981) ;; <CJK>
     (?$B6Y(B . ?\x79BD) ;; <CJK>
     (?$B6Z(B . ?\x7B4B) ;; <CJK>
     (?$B6[(B . ?\x7DCA) ;; <CJK>
     (?$B6\(B . ?\x82B9) ;; <CJK>
     (?$B6](B . ?\x83CC) ;; <CJK>
     (?$B6^(B . ?\x887F) ;; <CJK>
     (?$B6_(B . ?\x895F) ;; <CJK>
     (?$B6`(B . ?\x8B39) ;; <CJK>
     (?$B6a(B . ?\x8FD1) ;; <CJK>
     (?$B6b(B . ?\x91D1) ;; <CJK>
     (?$B6c(B . ?\x541F) ;; <CJK>
     (?$B6d(B . ?\x9280) ;; <CJK>
     (?$B6e(B . ?\x4E5D) ;; <CJK>
     (?$B6f(B . ?\x5036) ;; <CJK>
     (?$B6g(B . ?\x53E5) ;; <CJK>
     (?$B6h(B . ?\x533A) ;; <CJK>
     (?$B6i(B . ?\x72D7) ;; <CJK>
     (?$B6j(B . ?\x7396) ;; <CJK>
     (?$B6k(B . ?\x77E9) ;; <CJK>
     (?$B6l(B . ?\x82E6) ;; <CJK>
     (?$B6m(B . ?\x8EAF) ;; <CJK>
     (?$B6n(B . ?\x99C6) ;; <CJK>
     (?$B6o(B . ?\x99C8) ;; <CJK>
     (?$B6p(B . ?\x99D2) ;; <CJK>
     (?$B6q(B . ?\x5177) ;; <CJK>
     (?$B6r(B . ?\x611A) ;; <CJK>
     (?$B6s(B . ?\x865E) ;; <CJK>
     (?$B6t(B . ?\x55B0) ;; <CJK>
     (?$B6u(B . ?\x7A7A) ;; <CJK>
     (?$B6v(B . ?\x5076) ;; <CJK>
     (?$B6w(B . ?\x5BD3) ;; <CJK>
     (?$B6x(B . ?\x9047) ;; <CJK>
     (?$B6y(B . ?\x9685) ;; <CJK>
     (?$B6z(B . ?\x4E32) ;; <CJK>
     (?$B6{(B . ?\x6ADB) ;; <CJK>
     (?$B6|(B . ?\x91E7) ;; <CJK>
     (?$B6}(B . ?\x5C51) ;; <CJK>
     (?$B6~(B . ?\x5C48) ;; <CJK>
     (?$B7!(B . ?\x6398) ;; <CJK>
     (?$B7"(B . ?\x7A9F) ;; <CJK>
     (?$B7#(B . ?\x6C93) ;; <CJK>
     (?$B7$(B . ?\x9774) ;; <CJK>
     (?$B7%(B . ?\x8F61) ;; <CJK>
     (?$B7&(B . ?\x7AAA) ;; <CJK>
     (?$B7'(B . ?\x718A) ;; <CJK>
     (?$B7((B . ?\x9688) ;; <CJK>
     (?$B7)(B . ?\x7C82) ;; <CJK>
     (?$B7*(B . ?\x6817) ;; <CJK>
     (?$B7+(B . ?\x7E70) ;; <CJK>
     (?$B7,(B . ?\x6851) ;; <CJK>
     (?$B7-(B . ?\x936C) ;; <CJK>
     (?$B7.(B . ?\x52F2) ;; <CJK>
     (?$B7/(B . ?\x541B) ;; <CJK>
     (?$B70(B . ?\x85AB) ;; <CJK>
     (?$B71(B . ?\x8A13) ;; <CJK>
     (?$B72(B . ?\x7FA4) ;; <CJK>
     (?$B73(B . ?\x8ECD) ;; <CJK>
     (?$B74(B . ?\x90E1) ;; <CJK>
     (?$B75(B . ?\x5366) ;; <CJK>
     (?$B76(B . ?\x8888) ;; <CJK>
     (?$B77(B . ?\x7941) ;; <CJK>
     (?$B78(B . ?\x4FC2) ;; <CJK>
     (?$B79(B . ?\x50BE) ;; <CJK>
     (?$B7:(B . ?\x5211) ;; <CJK>
     (?$B7;(B . ?\x5144) ;; <CJK>
     (?$B7<(B . ?\x5553) ;; <CJK>
     (?$B7=(B . ?\x572D) ;; <CJK>
     (?$B7>(B . ?\x73EA) ;; <CJK>
     (?$B7?(B . ?\x578B) ;; <CJK>
     (?$B7@(B . ?\x5951) ;; <CJK>
     (?$B7A(B . ?\x5F62) ;; <CJK>
     (?$B7B(B . ?\x5F84) ;; <CJK>
     (?$B7C(B . ?\x6075) ;; <CJK>
     (?$B7D(B . ?\x6176) ;; <CJK>
     (?$B7E(B . ?\x6167) ;; <CJK>
     (?$B7F(B . ?\x61A9) ;; <CJK>
     (?$B7G(B . ?\x63B2) ;; <CJK>
     (?$B7H(B . ?\x643A) ;; <CJK>
     (?$B7I(B . ?\x656C) ;; <CJK>
     (?$B7J(B . ?\x666F) ;; <CJK>
     (?$B7K(B . ?\x6842) ;; <CJK>
     (?$B7L(B . ?\x6E13) ;; <CJK>
     (?$B7M(B . ?\x7566) ;; <CJK>
     (?$B7N(B . ?\x7A3D) ;; <CJK>
     (?$B7O(B . ?\x7CFB) ;; <CJK>
     (?$B7P(B . ?\x7D4C) ;; <CJK>
     (?$B7Q(B . ?\x7D99) ;; <CJK>
     (?$B7R(B . ?\x7E4B) ;; <CJK>
     (?$B7S(B . ?\x7F6B) ;; <CJK>
     (?$B7T(B . ?\x830E) ;; <CJK>
     (?$B7U(B . ?\x834A) ;; <CJK>
     (?$B7V(B . ?\x86CD) ;; <CJK>
     (?$B7W(B . ?\x8A08) ;; <CJK>
     (?$B7X(B . ?\x8A63) ;; <CJK>
     (?$B7Y(B . ?\x8B66) ;; <CJK>
     (?$B7Z(B . ?\x8EFD) ;; <CJK>
     (?$B7[(B . ?\x981A) ;; <CJK>
     (?$B7\(B . ?\x9D8F) ;; <CJK>
     (?$B7](B . ?\x82B8) ;; <CJK>
     (?$B7^(B . ?\x8FCE) ;; <CJK>
     (?$B7_(B . ?\x9BE8) ;; <CJK>
     (?$B7`(B . ?\x5287) ;; <CJK>
     (?$B7a(B . ?\x621F) ;; <CJK>
     (?$B7b(B . ?\x6483) ;; <CJK>
     (?$B7c(B . ?\x6FC0) ;; <CJK>
     (?$B7d(B . ?\x9699) ;; <CJK>
     (?$B7e(B . ?\x6841) ;; <CJK>
     (?$B7f(B . ?\x5091) ;; <CJK>
     (?$B7g(B . ?\x6B20) ;; <CJK>
     (?$B7h(B . ?\x6C7A) ;; <CJK>
     (?$B7i(B . ?\x6F54) ;; <CJK>
     (?$B7j(B . ?\x7A74) ;; <CJK>
     (?$B7k(B . ?\x7D50) ;; <CJK>
     (?$B7l(B . ?\x8840) ;; <CJK>
     (?$B7m(B . ?\x8A23) ;; <CJK>
     (?$B7n(B . ?\x6708) ;; <CJK>
     (?$B7o(B . ?\x4EF6) ;; <CJK>
     (?$B7p(B . ?\x5039) ;; <CJK>
     (?$B7q(B . ?\x5026) ;; <CJK>
     (?$B7r(B . ?\x5065) ;; <CJK>
     (?$B7s(B . ?\x517C) ;; <CJK>
     (?$B7t(B . ?\x5238) ;; <CJK>
     (?$B7u(B . ?\x5263) ;; <CJK>
     (?$B7v(B . ?\x55A7) ;; <CJK>
     (?$B7w(B . ?\x570F) ;; <CJK>
     (?$B7x(B . ?\x5805) ;; <CJK>
     (?$B7y(B . ?\x5ACC) ;; <CJK>
     (?$B7z(B . ?\x5EFA) ;; <CJK>
     (?$B7{(B . ?\x61B2) ;; <CJK>
     (?$B7|(B . ?\x61F8) ;; <CJK>
     (?$B7}(B . ?\x62F3) ;; <CJK>
     (?$B7~(B . ?\x6372) ;; <CJK>
     (?$B8!(B . ?\x691C) ;; <CJK>
     (?$B8"(B . ?\x6A29) ;; <CJK>
     (?$B8#(B . ?\x727D) ;; <CJK>
     (?$B8$(B . ?\x72AC) ;; <CJK>
     (?$B8%(B . ?\x732E) ;; <CJK>
     (?$B8&(B . ?\x7814) ;; <CJK>
     (?$B8'(B . ?\x786F) ;; <CJK>
     (?$B8((B . ?\x7D79) ;; <CJK>
     (?$B8)(B . ?\x770C) ;; <CJK>
     (?$B8*(B . ?\x80A9) ;; <CJK>
     (?$B8+(B . ?\x898B) ;; <CJK>
     (?$B8,(B . ?\x8B19) ;; <CJK>
     (?$B8-(B . ?\x8CE2) ;; <CJK>
     (?$B8.(B . ?\x8ED2) ;; <CJK>
     (?$B8/(B . ?\x9063) ;; <CJK>
     (?$B80(B . ?\x9375) ;; <CJK>
     (?$B81(B . ?\x967A) ;; <CJK>
     (?$B82(B . ?\x9855) ;; <CJK>
     (?$B83(B . ?\x9A13) ;; <CJK>
     (?$B84(B . ?\x9E78) ;; <CJK>
     (?$B85(B . ?\x5143) ;; <CJK>
     (?$B86(B . ?\x539F) ;; <CJK>
     (?$B87(B . ?\x53B3) ;; <CJK>
     (?$B88(B . ?\x5E7B) ;; <CJK>
     (?$B89(B . ?\x5F26) ;; <CJK>
     (?$B8:(B . ?\x6E1B) ;; <CJK>
     (?$B8;(B . ?\x6E90) ;; <CJK>
     (?$B8<(B . ?\x7384) ;; <CJK>
     (?$B8=(B . ?\x73FE) ;; <CJK>
     (?$B8>(B . ?\x7D43) ;; <CJK>
     (?$B8?(B . ?\x8237) ;; <CJK>
     (?$B8@(B . ?\x8A00) ;; <CJK>
     (?$B8A(B . ?\x8AFA) ;; <CJK>
     (?$B8B(B . ?\x9650) ;; <CJK>
     (?$B8C(B . ?\x4E4E) ;; <CJK>
     (?$B8D(B . ?\x500B) ;; <CJK>
     (?$B8E(B . ?\x53E4) ;; <CJK>
     (?$B8F(B . ?\x547C) ;; <CJK>
     (?$B8G(B . ?\x56FA) ;; <CJK>
     (?$B8H(B . ?\x59D1) ;; <CJK>
     (?$B8I(B . ?\x5B64) ;; <CJK>
     (?$B8J(B . ?\x5DF1) ;; <CJK>
     (?$B8K(B . ?\x5EAB) ;; <CJK>
     (?$B8L(B . ?\x5F27) ;; <CJK>
     (?$B8M(B . ?\x6238) ;; <CJK>
     (?$B8N(B . ?\x6545) ;; <CJK>
     (?$B8O(B . ?\x67AF) ;; <CJK>
     (?$B8P(B . ?\x6E56) ;; <CJK>
     (?$B8Q(B . ?\x72D0) ;; <CJK>
     (?$B8R(B . ?\x7CCA) ;; <CJK>
     (?$B8S(B . ?\x88B4) ;; <CJK>
     (?$B8T(B . ?\x80A1) ;; <CJK>
     (?$B8U(B . ?\x80E1) ;; <CJK>
     (?$B8V(B . ?\x83F0) ;; <CJK>
     (?$B8W(B . ?\x864E) ;; <CJK>
     (?$B8X(B . ?\x8A87) ;; <CJK>
     (?$B8Y(B . ?\x8DE8) ;; <CJK>
     (?$B8Z(B . ?\x9237) ;; <CJK>
     (?$B8[(B . ?\x96C7) ;; <CJK>
     (?$B8\(B . ?\x9867) ;; <CJK>
     (?$B8](B . ?\x9F13) ;; <CJK>
     (?$B8^(B . ?\x4E94) ;; <CJK>
     (?$B8_(B . ?\x4E92) ;; <CJK>
     (?$B8`(B . ?\x4F0D) ;; <CJK>
     (?$B8a(B . ?\x5348) ;; <CJK>
     (?$B8b(B . ?\x5449) ;; <CJK>
     (?$B8c(B . ?\x543E) ;; <CJK>
     (?$B8d(B . ?\x5A2F) ;; <CJK>
     (?$B8e(B . ?\x5F8C) ;; <CJK>
     (?$B8f(B . ?\x5FA1) ;; <CJK>
     (?$B8g(B . ?\x609F) ;; <CJK>
     (?$B8h(B . ?\x68A7) ;; <CJK>
     (?$B8i(B . ?\x6A8E) ;; <CJK>
     (?$B8j(B . ?\x745A) ;; <CJK>
     (?$B8k(B . ?\x7881) ;; <CJK>
     (?$B8l(B . ?\x8A9E) ;; <CJK>
     (?$B8m(B . ?\x8AA4) ;; <CJK>
     (?$B8n(B . ?\x8B77) ;; <CJK>
     (?$B8o(B . ?\x9190) ;; <CJK>
     (?$B8p(B . ?\x4E5E) ;; <CJK>
     (?$B8q(B . ?\x9BC9) ;; <CJK>
     (?$B8r(B . ?\x4EA4) ;; <CJK>
     (?$B8s(B . ?\x4F7C) ;; <CJK>
     (?$B8t(B . ?\x4FAF) ;; <CJK>
     (?$B8u(B . ?\x5019) ;; <CJK>
     (?$B8v(B . ?\x5016) ;; <CJK>
     (?$B8w(B . ?\x5149) ;; <CJK>
     (?$B8x(B . ?\x516C) ;; <CJK>
     (?$B8y(B . ?\x529F) ;; <CJK>
     (?$B8z(B . ?\x52B9) ;; <CJK>
     (?$B8{(B . ?\x52FE) ;; <CJK>
     (?$B8|(B . ?\x539A) ;; <CJK>
     (?$B8}(B . ?\x53E3) ;; <CJK>
     (?$B8~(B . ?\x5411) ;; <CJK>
     (?$B9!(B . ?\x540E) ;; <CJK>
     (?$B9"(B . ?\x5589) ;; <CJK>
     (?$B9#(B . ?\x5751) ;; <CJK>
     (?$B9$(B . ?\x57A2) ;; <CJK>
     (?$B9%(B . ?\x597D) ;; <CJK>
     (?$B9&(B . ?\x5B54) ;; <CJK>
     (?$B9'(B . ?\x5B5D) ;; <CJK>
     (?$B9((B . ?\x5B8F) ;; <CJK>
     (?$B9)(B . ?\x5DE5) ;; <CJK>
     (?$B9*(B . ?\x5DE7) ;; <CJK>
     (?$B9+(B . ?\x5DF7) ;; <CJK>
     (?$B9,(B . ?\x5E78) ;; <CJK>
     (?$B9-(B . ?\x5E83) ;; <CJK>
     (?$B9.(B . ?\x5E9A) ;; <CJK>
     (?$B9/(B . ?\x5EB7) ;; <CJK>
     (?$B90(B . ?\x5F18) ;; <CJK>
     (?$B91(B . ?\x6052) ;; <CJK>
     (?$B92(B . ?\x614C) ;; <CJK>
     (?$B93(B . ?\x6297) ;; <CJK>
     (?$B94(B . ?\x62D8) ;; <CJK>
     (?$B95(B . ?\x63A7) ;; <CJK>
     (?$B96(B . ?\x653B) ;; <CJK>
     (?$B97(B . ?\x6602) ;; <CJK>
     (?$B98(B . ?\x6643) ;; <CJK>
     (?$B99(B . ?\x66F4) ;; <CJK>
     (?$B9:(B . ?\x676D) ;; <CJK>
     (?$B9;(B . ?\x6821) ;; <CJK>
     (?$B9<(B . ?\x6897) ;; <CJK>
     (?$B9=(B . ?\x69CB) ;; <CJK>
     (?$B9>(B . ?\x6C5F) ;; <CJK>
     (?$B9?(B . ?\x6D2A) ;; <CJK>
     (?$B9@(B . ?\x6D69) ;; <CJK>
     (?$B9A(B . ?\x6E2F) ;; <CJK>
     (?$B9B(B . ?\x6E9D) ;; <CJK>
     (?$B9C(B . ?\x7532) ;; <CJK>
     (?$B9D(B . ?\x7687) ;; <CJK>
     (?$B9E(B . ?\x786C) ;; <CJK>
     (?$B9F(B . ?\x7A3F) ;; <CJK>
     (?$B9G(B . ?\x7CE0) ;; <CJK>
     (?$B9H(B . ?\x7D05) ;; <CJK>
     (?$B9I(B . ?\x7D18) ;; <CJK>
     (?$B9J(B . ?\x7D5E) ;; <CJK>
     (?$B9K(B . ?\x7DB1) ;; <CJK>
     (?$B9L(B . ?\x8015) ;; <CJK>
     (?$B9M(B . ?\x8003) ;; <CJK>
     (?$B9N(B . ?\x80AF) ;; <CJK>
     (?$B9O(B . ?\x80B1) ;; <CJK>
     (?$B9P(B . ?\x8154) ;; <CJK>
     (?$B9Q(B . ?\x818F) ;; <CJK>
     (?$B9R(B . ?\x822A) ;; <CJK>
     (?$B9S(B . ?\x8352) ;; <CJK>
     (?$B9T(B . ?\x884C) ;; <CJK>
     (?$B9U(B . ?\x8861) ;; <CJK>
     (?$B9V(B . ?\x8B1B) ;; <CJK>
     (?$B9W(B . ?\x8CA2) ;; <CJK>
     (?$B9X(B . ?\x8CFC) ;; <CJK>
     (?$B9Y(B . ?\x90CA) ;; <CJK>
     (?$B9Z(B . ?\x9175) ;; <CJK>
     (?$B9[(B . ?\x9271) ;; <CJK>
     (?$B9\(B . ?\x783F) ;; <CJK>
     (?$B9](B . ?\x92FC) ;; <CJK>
     (?$B9^(B . ?\x95A4) ;; <CJK>
     (?$B9_(B . ?\x964D) ;; <CJK>
     (?$B9`(B . ?\x9805) ;; <CJK>
     (?$B9a(B . ?\x9999) ;; <CJK>
     (?$B9b(B . ?\x9AD8) ;; <CJK>
     (?$B9c(B . ?\x9D3B) ;; <CJK>
     (?$B9d(B . ?\x525B) ;; <CJK>
     (?$B9e(B . ?\x52AB) ;; <CJK>
     (?$B9f(B . ?\x53F7) ;; <CJK>
     (?$B9g(B . ?\x5408) ;; <CJK>
     (?$B9h(B . ?\x58D5) ;; <CJK>
     (?$B9i(B . ?\x62F7) ;; <CJK>
     (?$B9j(B . ?\x6FE0) ;; <CJK>
     (?$B9k(B . ?\x8C6A) ;; <CJK>
     (?$B9l(B . ?\x8F5F) ;; <CJK>
     (?$B9m(B . ?\x9EB9) ;; <CJK>
     (?$B9n(B . ?\x514B) ;; <CJK>
     (?$B9o(B . ?\x523B) ;; <CJK>
     (?$B9p(B . ?\x544A) ;; <CJK>
     (?$B9q(B . ?\x56FD) ;; <CJK>
     (?$B9r(B . ?\x7A40) ;; <CJK>
     (?$B9s(B . ?\x9177) ;; <CJK>
     (?$B9t(B . ?\x9D60) ;; <CJK>
     (?$B9u(B . ?\x9ED2) ;; <CJK>
     (?$B9v(B . ?\x7344) ;; <CJK>
     (?$B9w(B . ?\x6F09) ;; <CJK>
     (?$B9x(B . ?\x8170) ;; <CJK>
     (?$B9y(B . ?\x7511) ;; <CJK>
     (?$B9z(B . ?\x5FFD) ;; <CJK>
     (?$B9{(B . ?\x60DA) ;; <CJK>
     (?$B9|(B . ?\x9AA8) ;; <CJK>
     (?$B9}(B . ?\x72DB) ;; <CJK>
     (?$B9~(B . ?\x8FBC) ;; <CJK>
     (?$B:!(B . ?\x6B64) ;; <CJK>
     (?$B:"(B . ?\x9803) ;; <CJK>
     (?$B:#(B . ?\x4ECA) ;; <CJK>
     (?$B:$(B . ?\x56F0) ;; <CJK>
     (?$B:%(B . ?\x5764) ;; <CJK>
     (?$B:&(B . ?\x58BE) ;; <CJK>
     (?$B:'(B . ?\x5A5A) ;; <CJK>
     (?$B:((B . ?\x6068) ;; <CJK>
     (?$B:)(B . ?\x61C7) ;; <CJK>
     (?$B:*(B . ?\x660F) ;; <CJK>
     (?$B:+(B . ?\x6606) ;; <CJK>
     (?$B:,(B . ?\x6839) ;; <CJK>
     (?$B:-(B . ?\x68B1) ;; <CJK>
     (?$B:.(B . ?\x6DF7) ;; <CJK>
     (?$B:/(B . ?\x75D5) ;; <CJK>
     (?$B:0(B . ?\x7D3A) ;; <CJK>
     (?$B:1(B . ?\x826E) ;; <CJK>
     (?$B:2(B . ?\x9B42) ;; <CJK>
     (?$B:3(B . ?\x4E9B) ;; <CJK>
     (?$B:4(B . ?\x4F50) ;; <CJK>
     (?$B:5(B . ?\x53C9) ;; <CJK>
     (?$B:6(B . ?\x5506) ;; <CJK>
     (?$B:7(B . ?\x5D6F) ;; <CJK>
     (?$B:8(B . ?\x5DE6) ;; <CJK>
     (?$B:9(B . ?\x5DEE) ;; <CJK>
     (?$B::(B . ?\x67FB) ;; <CJK>
     (?$B:;(B . ?\x6C99) ;; <CJK>
     (?$B:<(B . ?\x7473) ;; <CJK>
     (?$B:=(B . ?\x7802) ;; <CJK>
     (?$B:>(B . ?\x8A50) ;; <CJK>
     (?$B:?(B . ?\x9396) ;; <CJK>
     (?$B:@(B . ?\x88DF) ;; <CJK>
     (?$B:A(B . ?\x5750) ;; <CJK>
     (?$B:B(B . ?\x5EA7) ;; <CJK>
     (?$B:C(B . ?\x632B) ;; <CJK>
     (?$B:D(B . ?\x50B5) ;; <CJK>
     (?$B:E(B . ?\x50AC) ;; <CJK>
     (?$B:F(B . ?\x518D) ;; <CJK>
     (?$B:G(B . ?\x6700) ;; <CJK>
     (?$B:H(B . ?\x54C9) ;; <CJK>
     (?$B:I(B . ?\x585E) ;; <CJK>
     (?$B:J(B . ?\x59BB) ;; <CJK>
     (?$B:K(B . ?\x5BB0) ;; <CJK>
     (?$B:L(B . ?\x5F69) ;; <CJK>
     (?$B:M(B . ?\x624D) ;; <CJK>
     (?$B:N(B . ?\x63A1) ;; <CJK>
     (?$B:O(B . ?\x683D) ;; <CJK>
     (?$B:P(B . ?\x6B73) ;; <CJK>
     (?$B:Q(B . ?\x6E08) ;; <CJK>
     (?$B:R(B . ?\x707D) ;; <CJK>
     (?$B:S(B . ?\x91C7) ;; <CJK>
     (?$B:T(B . ?\x7280) ;; <CJK>
     (?$B:U(B . ?\x7815) ;; <CJK>
     (?$B:V(B . ?\x7826) ;; <CJK>
     (?$B:W(B . ?\x796D) ;; <CJK>
     (?$B:X(B . ?\x658E) ;; <CJK>
     (?$B:Y(B . ?\x7D30) ;; <CJK>
     (?$B:Z(B . ?\x83DC) ;; <CJK>
     (?$B:[(B . ?\x88C1) ;; <CJK>
     (?$B:\(B . ?\x8F09) ;; <CJK>
     (?$B:](B . ?\x969B) ;; <CJK>
     (?$B:^(B . ?\x5264) ;; <CJK>
     (?$B:_(B . ?\x5728) ;; <CJK>
     (?$B:`(B . ?\x6750) ;; <CJK>
     (?$B:a(B . ?\x7F6A) ;; <CJK>
     (?$B:b(B . ?\x8CA1) ;; <CJK>
     (?$B:c(B . ?\x51B4) ;; <CJK>
     (?$B:d(B . ?\x5742) ;; <CJK>
     (?$B:e(B . ?\x962A) ;; <CJK>
     (?$B:f(B . ?\x583A) ;; <CJK>
     (?$B:g(B . ?\x698A) ;; <CJK>
     (?$B:h(B . ?\x80B4) ;; <CJK>
     (?$B:i(B . ?\x54B2) ;; <CJK>
     (?$B:j(B . ?\x5D0E) ;; <CJK>
     (?$B:k(B . ?\x57FC) ;; <CJK>
     (?$B:l(B . ?\x7895) ;; <CJK>
     (?$B:m(B . ?\x9DFA) ;; <CJK>
     (?$B:n(B . ?\x4F5C) ;; <CJK>
     (?$B:o(B . ?\x524A) ;; <CJK>
     (?$B:p(B . ?\x548B) ;; <CJK>
     (?$B:q(B . ?\x643E) ;; <CJK>
     (?$B:r(B . ?\x6628) ;; <CJK>
     (?$B:s(B . ?\x6714) ;; <CJK>
     (?$B:t(B . ?\x67F5) ;; <CJK>
     (?$B:u(B . ?\x7A84) ;; <CJK>
     (?$B:v(B . ?\x7B56) ;; <CJK>
     (?$B:w(B . ?\x7D22) ;; <CJK>
     (?$B:x(B . ?\x932F) ;; <CJK>
     (?$B:y(B . ?\x685C) ;; <CJK>
     (?$B:z(B . ?\x9BAD) ;; <CJK>
     (?$B:{(B . ?\x7B39) ;; <CJK>
     (?$B:|(B . ?\x5319) ;; <CJK>
     (?$B:}(B . ?\x518A) ;; <CJK>
     (?$B:~(B . ?\x5237) ;; <CJK>
     (?$B;!(B . ?\x5BDF) ;; <CJK>
     (?$B;"(B . ?\x62F6) ;; <CJK>
     (?$B;#(B . ?\x64AE) ;; <CJK>
     (?$B;$(B . ?\x64E6) ;; <CJK>
     (?$B;%(B . ?\x672D) ;; <CJK>
     (?$B;&(B . ?\x6BBA) ;; <CJK>
     (?$B;'(B . ?\x85A9) ;; <CJK>
     (?$B;((B . ?\x96D1) ;; <CJK>
     (?$B;)(B . ?\x7690) ;; <CJK>
     (?$B;*(B . ?\x9BD6) ;; <CJK>
     (?$B;+(B . ?\x634C) ;; <CJK>
     (?$B;,(B . ?\x9306) ;; <CJK>
     (?$B;-(B . ?\x9BAB) ;; <CJK>
     (?$B;.(B . ?\x76BF) ;; <CJK>
     (?$B;/(B . ?\x6652) ;; <CJK>
     (?$B;0(B . ?\x4E09) ;; <CJK>
     (?$B;1(B . ?\x5098) ;; <CJK>
     (?$B;2(B . ?\x53C2) ;; <CJK>
     (?$B;3(B . ?\x5C71) ;; <CJK>
     (?$B;4(B . ?\x60E8) ;; <CJK>
     (?$B;5(B . ?\x6492) ;; <CJK>
     (?$B;6(B . ?\x6563) ;; <CJK>
     (?$B;7(B . ?\x685F) ;; <CJK>
     (?$B;8(B . ?\x71E6) ;; <CJK>
     (?$B;9(B . ?\x73CA) ;; <CJK>
     (?$B;:(B . ?\x7523) ;; <CJK>
     (?$B;;(B . ?\x7B97) ;; <CJK>
     (?$B;<(B . ?\x7E82) ;; <CJK>
     (?$B;=(B . ?\x8695) ;; <CJK>
     (?$B;>(B . ?\x8B83) ;; <CJK>
     (?$B;?(B . ?\x8CDB) ;; <CJK>
     (?$B;@(B . ?\x9178) ;; <CJK>
     (?$B;A(B . ?\x9910) ;; <CJK>
     (?$B;B(B . ?\x65AC) ;; <CJK>
     (?$B;C(B . ?\x66AB) ;; <CJK>
     (?$B;D(B . ?\x6B8B) ;; <CJK>
     (?$B;E(B . ?\x4ED5) ;; <CJK>
     (?$B;F(B . ?\x4ED4) ;; <CJK>
     (?$B;G(B . ?\x4F3A) ;; <CJK>
     (?$B;H(B . ?\x4F7F) ;; <CJK>
     (?$B;I(B . ?\x523A) ;; <CJK>
     (?$B;J(B . ?\x53F8) ;; <CJK>
     (?$B;K(B . ?\x53F2) ;; <CJK>
     (?$B;L(B . ?\x55E3) ;; <CJK>
     (?$B;M(B . ?\x56DB) ;; <CJK>
     (?$B;N(B . ?\x58EB) ;; <CJK>
     (?$B;O(B . ?\x59CB) ;; <CJK>
     (?$B;P(B . ?\x59C9) ;; <CJK>
     (?$B;Q(B . ?\x59FF) ;; <CJK>
     (?$B;R(B . ?\x5B50) ;; <CJK>
     (?$B;S(B . ?\x5C4D) ;; <CJK>
     (?$B;T(B . ?\x5E02) ;; <CJK>
     (?$B;U(B . ?\x5E2B) ;; <CJK>
     (?$B;V(B . ?\x5FD7) ;; <CJK>
     (?$B;W(B . ?\x601D) ;; <CJK>
     (?$B;X(B . ?\x6307) ;; <CJK>
     (?$B;Y(B . ?\x652F) ;; <CJK>
     (?$B;Z(B . ?\x5B5C) ;; <CJK>
     (?$B;[(B . ?\x65AF) ;; <CJK>
     (?$B;\(B . ?\x65BD) ;; <CJK>
     (?$B;](B . ?\x65E8) ;; <CJK>
     (?$B;^(B . ?\x679D) ;; <CJK>
     (?$B;_(B . ?\x6B62) ;; <CJK>
     (?$B;`(B . ?\x6B7B) ;; <CJK>
     (?$B;a(B . ?\x6C0F) ;; <CJK>
     (?$B;b(B . ?\x7345) ;; <CJK>
     (?$B;c(B . ?\x7949) ;; <CJK>
     (?$B;d(B . ?\x79C1) ;; <CJK>
     (?$B;e(B . ?\x7CF8) ;; <CJK>
     (?$B;f(B . ?\x7D19) ;; <CJK>
     (?$B;g(B . ?\x7D2B) ;; <CJK>
     (?$B;h(B . ?\x80A2) ;; <CJK>
     (?$B;i(B . ?\x8102) ;; <CJK>
     (?$B;j(B . ?\x81F3) ;; <CJK>
     (?$B;k(B . ?\x8996) ;; <CJK>
     (?$B;l(B . ?\x8A5E) ;; <CJK>
     (?$B;m(B . ?\x8A69) ;; <CJK>
     (?$B;n(B . ?\x8A66) ;; <CJK>
     (?$B;o(B . ?\x8A8C) ;; <CJK>
     (?$B;p(B . ?\x8AEE) ;; <CJK>
     (?$B;q(B . ?\x8CC7) ;; <CJK>
     (?$B;r(B . ?\x8CDC) ;; <CJK>
     (?$B;s(B . ?\x96CC) ;; <CJK>
     (?$B;t(B . ?\x98FC) ;; <CJK>
     (?$B;u(B . ?\x6B6F) ;; <CJK>
     (?$B;v(B . ?\x4E8B) ;; <CJK>
     (?$B;w(B . ?\x4F3C) ;; <CJK>
     (?$B;x(B . ?\x4F8D) ;; <CJK>
     (?$B;y(B . ?\x5150) ;; <CJK>
     (?$B;z(B . ?\x5B57) ;; <CJK>
     (?$B;{(B . ?\x5BFA) ;; <CJK>
     (?$B;|(B . ?\x6148) ;; <CJK>
     (?$B;}(B . ?\x6301) ;; <CJK>
     (?$B;~(B . ?\x6642) ;; <CJK>
     (?$B<!(B . ?\x6B21) ;; <CJK>
     (?$B<"(B . ?\x6ECB) ;; <CJK>
     (?$B<#(B . ?\x6CBB) ;; <CJK>
     (?$B<$(B . ?\x723E) ;; <CJK>
     (?$B<%(B . ?\x74BD) ;; <CJK>
     (?$B<&(B . ?\x75D4) ;; <CJK>
     (?$B<'(B . ?\x78C1) ;; <CJK>
     (?$B<((B . ?\x793A) ;; <CJK>
     (?$B<)(B . ?\x800C) ;; <CJK>
     (?$B<*(B . ?\x8033) ;; <CJK>
     (?$B<+(B . ?\x81EA) ;; <CJK>
     (?$B<,(B . ?\x8494) ;; <CJK>
     (?$B<-(B . ?\x8F9E) ;; <CJK>
     (?$B<.(B . ?\x6C50) ;; <CJK>
     (?$B</(B . ?\x9E7F) ;; <CJK>
     (?$B<0(B . ?\x5F0F) ;; <CJK>
     (?$B<1(B . ?\x8B58) ;; <CJK>
     (?$B<2(B . ?\x9D2B) ;; <CJK>
     (?$B<3(B . ?\x7AFA) ;; <CJK>
     (?$B<4(B . ?\x8EF8) ;; <CJK>
     (?$B<5(B . ?\x5B8D) ;; <CJK>
     (?$B<6(B . ?\x96EB) ;; <CJK>
     (?$B<7(B . ?\x4E03) ;; <CJK>
     (?$B<8(B . ?\x53F1) ;; <CJK>
     (?$B<9(B . ?\x57F7) ;; <CJK>
     (?$B<:(B . ?\x5931) ;; <CJK>
     (?$B<;(B . ?\x5AC9) ;; <CJK>
     (?$B<<(B . ?\x5BA4) ;; <CJK>
     (?$B<=(B . ?\x6089) ;; <CJK>
     (?$B<>(B . ?\x6E7F) ;; <CJK>
     (?$B<?(B . ?\x6F06) ;; <CJK>
     (?$B<@(B . ?\x75BE) ;; <CJK>
     (?$B<A(B . ?\x8CEA) ;; <CJK>
     (?$B<B(B . ?\x5B9F) ;; <CJK>
     (?$B<C(B . ?\x8500) ;; <CJK>
     (?$B<D(B . ?\x7BE0) ;; <CJK>
     (?$B<E(B . ?\x5072) ;; <CJK>
     (?$B<F(B . ?\x67F4) ;; <CJK>
     (?$B<G(B . ?\x829D) ;; <CJK>
     (?$B<H(B . ?\x5C61) ;; <CJK>
     (?$B<I(B . ?\x854A) ;; <CJK>
     (?$B<J(B . ?\x7E1E) ;; <CJK>
     (?$B<K(B . ?\x820E) ;; <CJK>
     (?$B<L(B . ?\x5199) ;; <CJK>
     (?$B<M(B . ?\x5C04) ;; <CJK>
     (?$B<N(B . ?\x6368) ;; <CJK>
     (?$B<O(B . ?\x8D66) ;; <CJK>
     (?$B<P(B . ?\x659C) ;; <CJK>
     (?$B<Q(B . ?\x716E) ;; <CJK>
     (?$B<R(B . ?\x793E) ;; <CJK>
     (?$B<S(B . ?\x7D17) ;; <CJK>
     (?$B<T(B . ?\x8005) ;; <CJK>
     (?$B<U(B . ?\x8B1D) ;; <CJK>
     (?$B<V(B . ?\x8ECA) ;; <CJK>
     (?$B<W(B . ?\x906E) ;; <CJK>
     (?$B<X(B . ?\x86C7) ;; <CJK>
     (?$B<Y(B . ?\x90AA) ;; <CJK>
     (?$B<Z(B . ?\x501F) ;; <CJK>
     (?$B<[(B . ?\x52FA) ;; <CJK>
     (?$B<\(B . ?\x5C3A) ;; <CJK>
     (?$B<](B . ?\x6753) ;; <CJK>
     (?$B<^(B . ?\x707C) ;; <CJK>
     (?$B<_(B . ?\x7235) ;; <CJK>
     (?$B<`(B . ?\x914C) ;; <CJK>
     (?$B<a(B . ?\x91C8) ;; <CJK>
     (?$B<b(B . ?\x932B) ;; <CJK>
     (?$B<c(B . ?\x82E5) ;; <CJK>
     (?$B<d(B . ?\x5BC2) ;; <CJK>
     (?$B<e(B . ?\x5F31) ;; <CJK>
     (?$B<f(B . ?\x60F9) ;; <CJK>
     (?$B<g(B . ?\x4E3B) ;; <CJK>
     (?$B<h(B . ?\x53D6) ;; <CJK>
     (?$B<i(B . ?\x5B88) ;; <CJK>
     (?$B<j(B . ?\x624B) ;; <CJK>
     (?$B<k(B . ?\x6731) ;; <CJK>
     (?$B<l(B . ?\x6B8A) ;; <CJK>
     (?$B<m(B . ?\x72E9) ;; <CJK>
     (?$B<n(B . ?\x73E0) ;; <CJK>
     (?$B<o(B . ?\x7A2E) ;; <CJK>
     (?$B<p(B . ?\x816B) ;; <CJK>
     (?$B<q(B . ?\x8DA3) ;; <CJK>
     (?$B<r(B . ?\x9152) ;; <CJK>
     (?$B<s(B . ?\x9996) ;; <CJK>
     (?$B<t(B . ?\x5112) ;; <CJK>
     (?$B<u(B . ?\x53D7) ;; <CJK>
     (?$B<v(B . ?\x546A) ;; <CJK>
     (?$B<w(B . ?\x5BFF) ;; <CJK>
     (?$B<x(B . ?\x6388) ;; <CJK>
     (?$B<y(B . ?\x6A39) ;; <CJK>
     (?$B<z(B . ?\x7DAC) ;; <CJK>
     (?$B<{(B . ?\x9700) ;; <CJK>
     (?$B<|(B . ?\x56DA) ;; <CJK>
     (?$B<}(B . ?\x53CE) ;; <CJK>
     (?$B<~(B . ?\x5468) ;; <CJK>
     (?$B=!(B . ?\x5B97) ;; <CJK>
     (?$B="(B . ?\x5C31) ;; <CJK>
     (?$B=#(B . ?\x5DDE) ;; <CJK>
     (?$B=$(B . ?\x4FEE) ;; <CJK>
     (?$B=%(B . ?\x6101) ;; <CJK>
     (?$B=&(B . ?\x62FE) ;; <CJK>
     (?$B='(B . ?\x6D32) ;; <CJK>
     (?$B=((B . ?\x79C0) ;; <CJK>
     (?$B=)(B . ?\x79CB) ;; <CJK>
     (?$B=*(B . ?\x7D42) ;; <CJK>
     (?$B=+(B . ?\x7E4D) ;; <CJK>
     (?$B=,(B . ?\x7FD2) ;; <CJK>
     (?$B=-(B . ?\x81ED) ;; <CJK>
     (?$B=.(B . ?\x821F) ;; <CJK>
     (?$B=/(B . ?\x8490) ;; <CJK>
     (?$B=0(B . ?\x8846) ;; <CJK>
     (?$B=1(B . ?\x8972) ;; <CJK>
     (?$B=2(B . ?\x8B90) ;; <CJK>
     (?$B=3(B . ?\x8E74) ;; <CJK>
     (?$B=4(B . ?\x8F2F) ;; <CJK>
     (?$B=5(B . ?\x9031) ;; <CJK>
     (?$B=6(B . ?\x914B) ;; <CJK>
     (?$B=7(B . ?\x916C) ;; <CJK>
     (?$B=8(B . ?\x96C6) ;; <CJK>
     (?$B=9(B . ?\x919C) ;; <CJK>
     (?$B=:(B . ?\x4EC0) ;; <CJK>
     (?$B=;(B . ?\x4F4F) ;; <CJK>
     (?$B=<(B . ?\x5145) ;; <CJK>
     (?$B==(B . ?\x5341) ;; <CJK>
     (?$B=>(B . ?\x5F93) ;; <CJK>
     (?$B=?(B . ?\x620E) ;; <CJK>
     (?$B=@(B . ?\x67D4) ;; <CJK>
     (?$B=A(B . ?\x6C41) ;; <CJK>
     (?$B=B(B . ?\x6E0B) ;; <CJK>
     (?$B=C(B . ?\x7363) ;; <CJK>
     (?$B=D(B . ?\x7E26) ;; <CJK>
     (?$B=E(B . ?\x91CD) ;; <CJK>
     (?$B=F(B . ?\x9283) ;; <CJK>
     (?$B=G(B . ?\x53D4) ;; <CJK>
     (?$B=H(B . ?\x5919) ;; <CJK>
     (?$B=I(B . ?\x5BBF) ;; <CJK>
     (?$B=J(B . ?\x6DD1) ;; <CJK>
     (?$B=K(B . ?\x795D) ;; <CJK>
     (?$B=L(B . ?\x7E2E) ;; <CJK>
     (?$B=M(B . ?\x7C9B) ;; <CJK>
     (?$B=N(B . ?\x587E) ;; <CJK>
     (?$B=O(B . ?\x719F) ;; <CJK>
     (?$B=P(B . ?\x51FA) ;; <CJK>
     (?$B=Q(B . ?\x8853) ;; <CJK>
     (?$B=R(B . ?\x8FF0) ;; <CJK>
     (?$B=S(B . ?\x4FCA) ;; <CJK>
     (?$B=T(B . ?\x5CFB) ;; <CJK>
     (?$B=U(B . ?\x6625) ;; <CJK>
     (?$B=V(B . ?\x77AC) ;; <CJK>
     (?$B=W(B . ?\x7AE3) ;; <CJK>
     (?$B=X(B . ?\x821C) ;; <CJK>
     (?$B=Y(B . ?\x99FF) ;; <CJK>
     (?$B=Z(B . ?\x51C6) ;; <CJK>
     (?$B=[(B . ?\x5FAA) ;; <CJK>
     (?$B=\(B . ?\x65EC) ;; <CJK>
     (?$B=](B . ?\x696F) ;; <CJK>
     (?$B=^(B . ?\x6B89) ;; <CJK>
     (?$B=_(B . ?\x6DF3) ;; <CJK>
     (?$B=`(B . ?\x6E96) ;; <CJK>
     (?$B=a(B . ?\x6F64) ;; <CJK>
     (?$B=b(B . ?\x76FE) ;; <CJK>
     (?$B=c(B . ?\x7D14) ;; <CJK>
     (?$B=d(B . ?\x5DE1) ;; <CJK>
     (?$B=e(B . ?\x9075) ;; <CJK>
     (?$B=f(B . ?\x9187) ;; <CJK>
     (?$B=g(B . ?\x9806) ;; <CJK>
     (?$B=h(B . ?\x51E6) ;; <CJK>
     (?$B=i(B . ?\x521D) ;; <CJK>
     (?$B=j(B . ?\x6240) ;; <CJK>
     (?$B=k(B . ?\x6691) ;; <CJK>
     (?$B=l(B . ?\x66D9) ;; <CJK>
     (?$B=m(B . ?\x6E1A) ;; <CJK>
     (?$B=n(B . ?\x5EB6) ;; <CJK>
     (?$B=o(B . ?\x7DD2) ;; <CJK>
     (?$B=p(B . ?\x7F72) ;; <CJK>
     (?$B=q(B . ?\x66F8) ;; <CJK>
     (?$B=r(B . ?\x85AF) ;; <CJK>
     (?$B=s(B . ?\x85F7) ;; <CJK>
     (?$B=t(B . ?\x8AF8) ;; <CJK>
     (?$B=u(B . ?\x52A9) ;; <CJK>
     (?$B=v(B . ?\x53D9) ;; <CJK>
     (?$B=w(B . ?\x5973) ;; <CJK>
     (?$B=x(B . ?\x5E8F) ;; <CJK>
     (?$B=y(B . ?\x5F90) ;; <CJK>
     (?$B=z(B . ?\x6055) ;; <CJK>
     (?$B={(B . ?\x92E4) ;; <CJK>
     (?$B=|(B . ?\x9664) ;; <CJK>
     (?$B=}(B . ?\x50B7) ;; <CJK>
     (?$B=~(B . ?\x511F) ;; <CJK>
     (?$B>!(B . ?\x52DD) ;; <CJK>
     (?$B>"(B . ?\x5320) ;; <CJK>
     (?$B>#(B . ?\x5347) ;; <CJK>
     (?$B>$(B . ?\x53EC) ;; <CJK>
     (?$B>%(B . ?\x54E8) ;; <CJK>
     (?$B>&(B . ?\x5546) ;; <CJK>
     (?$B>'(B . ?\x5531) ;; <CJK>
     (?$B>((B . ?\x5617) ;; <CJK>
     (?$B>)(B . ?\x5968) ;; <CJK>
     (?$B>*(B . ?\x59BE) ;; <CJK>
     (?$B>+(B . ?\x5A3C) ;; <CJK>
     (?$B>,(B . ?\x5BB5) ;; <CJK>
     (?$B>-(B . ?\x5C06) ;; <CJK>
     (?$B>.(B . ?\x5C0F) ;; <CJK>
     (?$B>/(B . ?\x5C11) ;; <CJK>
     (?$B>0(B . ?\x5C1A) ;; <CJK>
     (?$B>1(B . ?\x5E84) ;; <CJK>
     (?$B>2(B . ?\x5E8A) ;; <CJK>
     (?$B>3(B . ?\x5EE0) ;; <CJK>
     (?$B>4(B . ?\x5F70) ;; <CJK>
     (?$B>5(B . ?\x627F) ;; <CJK>
     (?$B>6(B . ?\x6284) ;; <CJK>
     (?$B>7(B . ?\x62DB) ;; <CJK>
     (?$B>8(B . ?\x638C) ;; <CJK>
     (?$B>9(B . ?\x6377) ;; <CJK>
     (?$B>:(B . ?\x6607) ;; <CJK>
     (?$B>;(B . ?\x660C) ;; <CJK>
     (?$B><(B . ?\x662D) ;; <CJK>
     (?$B>=(B . ?\x6676) ;; <CJK>
     (?$B>>(B . ?\x677E) ;; <CJK>
     (?$B>?(B . ?\x68A2) ;; <CJK>
     (?$B>@(B . ?\x6A1F) ;; <CJK>
     (?$B>A(B . ?\x6A35) ;; <CJK>
     (?$B>B(B . ?\x6CBC) ;; <CJK>
     (?$B>C(B . ?\x6D88) ;; <CJK>
     (?$B>D(B . ?\x6E09) ;; <CJK>
     (?$B>E(B . ?\x6E58) ;; <CJK>
     (?$B>F(B . ?\x713C) ;; <CJK>
     (?$B>G(B . ?\x7126) ;; <CJK>
     (?$B>H(B . ?\x7167) ;; <CJK>
     (?$B>I(B . ?\x75C7) ;; <CJK>
     (?$B>J(B . ?\x7701) ;; <CJK>
     (?$B>K(B . ?\x785D) ;; <CJK>
     (?$B>L(B . ?\x7901) ;; <CJK>
     (?$B>M(B . ?\x7965) ;; <CJK>
     (?$B>N(B . ?\x79F0) ;; <CJK>
     (?$B>O(B . ?\x7AE0) ;; <CJK>
     (?$B>P(B . ?\x7B11) ;; <CJK>
     (?$B>Q(B . ?\x7CA7) ;; <CJK>
     (?$B>R(B . ?\x7D39) ;; <CJK>
     (?$B>S(B . ?\x8096) ;; <CJK>
     (?$B>T(B . ?\x83D6) ;; <CJK>
     (?$B>U(B . ?\x848B) ;; <CJK>
     (?$B>V(B . ?\x8549) ;; <CJK>
     (?$B>W(B . ?\x885D) ;; <CJK>
     (?$B>X(B . ?\x88F3) ;; <CJK>
     (?$B>Y(B . ?\x8A1F) ;; <CJK>
     (?$B>Z(B . ?\x8A3C) ;; <CJK>
     (?$B>[(B . ?\x8A54) ;; <CJK>
     (?$B>\(B . ?\x8A73) ;; <CJK>
     (?$B>](B . ?\x8C61) ;; <CJK>
     (?$B>^(B . ?\x8CDE) ;; <CJK>
     (?$B>_(B . ?\x91A4) ;; <CJK>
     (?$B>`(B . ?\x9266) ;; <CJK>
     (?$B>a(B . ?\x937E) ;; <CJK>
     (?$B>b(B . ?\x9418) ;; <CJK>
     (?$B>c(B . ?\x969C) ;; <CJK>
     (?$B>d(B . ?\x9798) ;; <CJK>
     (?$B>e(B . ?\x4E0A) ;; <CJK>
     (?$B>f(B . ?\x4E08) ;; <CJK>
     (?$B>g(B . ?\x4E1E) ;; <CJK>
     (?$B>h(B . ?\x4E57) ;; <CJK>
     (?$B>i(B . ?\x5197) ;; <CJK>
     (?$B>j(B . ?\x5270) ;; <CJK>
     (?$B>k(B . ?\x57CE) ;; <CJK>
     (?$B>l(B . ?\x5834) ;; <CJK>
     (?$B>m(B . ?\x58CC) ;; <CJK>
     (?$B>n(B . ?\x5B22) ;; <CJK>
     (?$B>o(B . ?\x5E38) ;; <CJK>
     (?$B>p(B . ?\x60C5) ;; <CJK>
     (?$B>q(B . ?\x64FE) ;; <CJK>
     (?$B>r(B . ?\x6761) ;; <CJK>
     (?$B>s(B . ?\x6756) ;; <CJK>
     (?$B>t(B . ?\x6D44) ;; <CJK>
     (?$B>u(B . ?\x72B6) ;; <CJK>
     (?$B>v(B . ?\x7573) ;; <CJK>
     (?$B>w(B . ?\x7A63) ;; <CJK>
     (?$B>x(B . ?\x84B8) ;; <CJK>
     (?$B>y(B . ?\x8B72) ;; <CJK>
     (?$B>z(B . ?\x91B8) ;; <CJK>
     (?$B>{(B . ?\x9320) ;; <CJK>
     (?$B>|(B . ?\x5631) ;; <CJK>
     (?$B>}(B . ?\x57F4) ;; <CJK>
     (?$B>~(B . ?\x98FE) ;; <CJK>
     (?$B?!(B . ?\x62ED) ;; <CJK>
     (?$B?"(B . ?\x690D) ;; <CJK>
     (?$B?#(B . ?\x6B96) ;; <CJK>
     (?$B?$(B . ?\x71ED) ;; <CJK>
     (?$B?%(B . ?\x7E54) ;; <CJK>
     (?$B?&(B . ?\x8077) ;; <CJK>
     (?$B?'(B . ?\x8272) ;; <CJK>
     (?$B?((B . ?\x89E6) ;; <CJK>
     (?$B?)(B . ?\x98DF) ;; <CJK>
     (?$B?*(B . ?\x8755) ;; <CJK>
     (?$B?+(B . ?\x8FB1) ;; <CJK>
     (?$B?,(B . ?\x5C3B) ;; <CJK>
     (?$B?-(B . ?\x4F38) ;; <CJK>
     (?$B?.(B . ?\x4FE1) ;; <CJK>
     (?$B?/(B . ?\x4FB5) ;; <CJK>
     (?$B?0(B . ?\x5507) ;; <CJK>
     (?$B?1(B . ?\x5A20) ;; <CJK>
     (?$B?2(B . ?\x5BDD) ;; <CJK>
     (?$B?3(B . ?\x5BE9) ;; <CJK>
     (?$B?4(B . ?\x5FC3) ;; <CJK>
     (?$B?5(B . ?\x614E) ;; <CJK>
     (?$B?6(B . ?\x632F) ;; <CJK>
     (?$B?7(B . ?\x65B0) ;; <CJK>
     (?$B?8(B . ?\x664B) ;; <CJK>
     (?$B?9(B . ?\x68EE) ;; <CJK>
     (?$B?:(B . ?\x699B) ;; <CJK>
     (?$B?;(B . ?\x6D78) ;; <CJK>
     (?$B?<(B . ?\x6DF1) ;; <CJK>
     (?$B?=(B . ?\x7533) ;; <CJK>
     (?$B?>(B . ?\x75B9) ;; <CJK>
     (?$B??(B . ?\x771F) ;; <CJK>
     (?$B?@(B . ?\x795E) ;; <CJK>
     (?$B?A(B . ?\x79E6) ;; <CJK>
     (?$B?B(B . ?\x7D33) ;; <CJK>
     (?$B?C(B . ?\x81E3) ;; <CJK>
     (?$B?D(B . ?\x82AF) ;; <CJK>
     (?$B?E(B . ?\x85AA) ;; <CJK>
     (?$B?F(B . ?\x89AA) ;; <CJK>
     (?$B?G(B . ?\x8A3A) ;; <CJK>
     (?$B?H(B . ?\x8EAB)  ;; <CJK>
     (?$B?I(B . ?\x8F9B)  ;; <CJK>
     (?$B?J(B . ?\x9032)  ;; <CJK>
     (?$B?K(B . ?\x91DD)  ;; <CJK>
     (?$B?L(B . ?\x9707)  ;; <CJK>
     (?$B?M(B . ?\x4EBA)  ;; <CJK>
     (?$B?N(B . ?\x4EC1)  ;; <CJK>
     (?$B?O(B . ?\x5203)  ;; <CJK>
     (?$B?P(B . ?\x5875)  ;; <CJK>
     (?$B?Q(B . ?\x58EC)  ;; <CJK>
     (?$B?R(B . ?\x5C0B)  ;; <CJK>
     (?$B?S(B . ?\x751A)  ;; <CJK>
     (?$B?T(B . ?\x5C3D)  ;; <CJK>
     (?$B?U(B . ?\x814E)  ;; <CJK>
     (?$B?V(B . ?\x8A0A)  ;; <CJK>
     (?$B?W(B . ?\x8FC5)  ;; <CJK>
     (?$B?X(B . ?\x9663)  ;; <CJK>
     (?$B?Y(B . ?\x976D)  ;; <CJK>
     (?$B?Z(B . ?\x7B25)  ;; <CJK>
     (?$B?[(B . ?\x8ACF)  ;; <CJK>
     (?$B?\(B . ?\x9808)  ;; <CJK>
     (?$B?](B . ?\x9162)  ;; <CJK>
     (?$B?^(B . ?\x56F3)  ;; <CJK>
     (?$B?_(B . ?\x53A8)  ;; <CJK>
     (?$B?`(B . ?\x9017)  ;; <CJK>
     (?$B?a(B . ?\x5439)  ;; <CJK>
     (?$B?b(B . ?\x5782)  ;; <CJK>
     (?$B?c(B . ?\x5E25)  ;; <CJK>
     (?$B?d(B . ?\x63A8)  ;; <CJK>
     (?$B?e(B . ?\x6C34)  ;; <CJK>
     (?$B?f(B . ?\x708A)  ;; <CJK>
     (?$B?g(B . ?\x7761)  ;; <CJK>
     (?$B?h(B . ?\x7C8B)  ;; <CJK>
     (?$B?i(B . ?\x7FE0)  ;; <CJK>
     (?$B?j(B . ?\x8870)  ;; <CJK>
     (?$B?k(B . ?\x9042)  ;; <CJK>
     (?$B?l(B . ?\x9154)  ;; <CJK>
     (?$B?m(B . ?\x9310)  ;; <CJK>
     (?$B?n(B . ?\x9318)  ;; <CJK>
     (?$B?o(B . ?\x968F)  ;; <CJK>
     (?$B?p(B . ?\x745E)  ;; <CJK>
     (?$B?q(B . ?\x9AC4)  ;; <CJK>
     (?$B?r(B . ?\x5D07)  ;; <CJK>
     (?$B?s(B . ?\x5D69)  ;; <CJK>
     (?$B?t(B . ?\x6570)  ;; <CJK>
     (?$B?u(B . ?\x67A2)  ;; <CJK>
     (?$B?v(B . ?\x8DA8)  ;; <CJK>
     (?$B?w(B . ?\x96DB)  ;; <CJK>
     (?$B?x(B . ?\x636E)  ;; <CJK>
     (?$B?y(B . ?\x6749)  ;; <CJK>
     (?$B?z(B . ?\x6919)  ;; <CJK>
     (?$B?{(B . ?\x83C5)  ;; <CJK>
     (?$B?|(B . ?\x9817)  ;; <CJK>
     (?$B?}(B . ?\x96C0)  ;; <CJK>
     (?$B?~(B . ?\x88FE)  ;; <CJK>
     (?$B@!(B . ?\x6F84)  ;; <CJK>
     (?$B@"(B . ?\x647A)  ;; <CJK>
     (?$B@#(B . ?\x5BF8)  ;; <CJK>
     (?$B@$(B . ?\x4E16)  ;; <CJK>
     (?$B@%(B . ?\x702C)  ;; <CJK>
     (?$B@&(B . ?\x755D)  ;; <CJK>
     (?$B@'(B . ?\x662F)  ;; <CJK>
     (?$B@((B . ?\x51C4)  ;; <CJK>
     (?$B@)(B . ?\x5236)  ;; <CJK>
     (?$B@*(B . ?\x52E2)  ;; <CJK>
     (?$B@+(B . ?\x59D3)  ;; <CJK>
     (?$B@,(B . ?\x5F81)  ;; <CJK>
     (?$B@-(B . ?\x6027)  ;; <CJK>
     (?$B@.(B . ?\x6210)  ;; <CJK>
     (?$B@/(B . ?\x653F)  ;; <CJK>
     (?$B@0(B . ?\x6574)  ;; <CJK>
     (?$B@1(B . ?\x661F)  ;; <CJK>
     (?$B@2(B . ?\x6674)  ;; <CJK>
     (?$B@3(B . ?\x68F2)  ;; <CJK>
     (?$B@4(B . ?\x6816)  ;; <CJK>
     (?$B@5(B . ?\x6B63)  ;; <CJK>
     (?$B@6(B . ?\x6E05)  ;; <CJK>
     (?$B@7(B . ?\x7272)  ;; <CJK>
     (?$B@8(B . ?\x751F)  ;; <CJK>
     (?$B@9(B . ?\x76DB)  ;; <CJK>
     (?$B@:(B . ?\x7CBE)  ;; <CJK>
     (?$B@;(B . ?\x8056)  ;; <CJK>
     (?$B@<(B . ?\x58F0)  ;; <CJK>
     (?$B@=(B . ?\x88FD)  ;; <CJK>
     (?$B@>(B . ?\x897F)  ;; <CJK>
     (?$B@?(B . ?\x8AA0)  ;; <CJK>
     (?$B@@(B . ?\x8A93)  ;; <CJK>
     (?$B@A(B . ?\x8ACB)  ;; <CJK>
     (?$B@B(B . ?\x901D)  ;; <CJK>
     (?$B@C(B . ?\x9192)  ;; <CJK>
     (?$B@D(B . ?\x9752)  ;; <CJK>
     (?$B@E(B . ?\x9759)  ;; <CJK>
     (?$B@F(B . ?\x6589)  ;; <CJK>
     (?$B@G(B . ?\x7A0E)  ;; <CJK>
     (?$B@H(B . ?\x8106)  ;; <CJK>
     (?$B@I(B . ?\x96BB)  ;; <CJK>
     (?$B@J(B . ?\x5E2D)  ;; <CJK>
     (?$B@K(B . ?\x60DC)  ;; <CJK>
     (?$B@L(B . ?\x621A)  ;; <CJK>
     (?$B@M(B . ?\x65A5)  ;; <CJK>
     (?$B@N(B . ?\x6614)  ;; <CJK>
     (?$B@O(B . ?\x6790)  ;; <CJK>
     (?$B@P(B . ?\x77F3)  ;; <CJK>
     (?$B@Q(B . ?\x7A4D)  ;; <CJK>
     (?$B@R(B . ?\x7C4D)  ;; <CJK>
     (?$B@S(B . ?\x7E3E)  ;; <CJK>
     (?$B@T(B . ?\x810A)  ;; <CJK>
     (?$B@U(B . ?\x8CAC)  ;; <CJK>
     (?$B@V(B . ?\x8D64)  ;; <CJK>
     (?$B@W(B . ?\x8DE1)  ;; <CJK>
     (?$B@X(B . ?\x8E5F)  ;; <CJK>
     (?$B@Y(B . ?\x78A9)  ;; <CJK>
     (?$B@Z(B . ?\x5207)  ;; <CJK>
     (?$B@[(B . ?\x62D9)  ;; <CJK>
     (?$B@\(B . ?\x63A5)  ;; <CJK>
     (?$B@](B . ?\x6442)  ;; <CJK>
     (?$B@^(B . ?\x6298)  ;; <CJK>
     (?$B@_(B . ?\x8A2D)  ;; <CJK>
     (?$B@`(B . ?\x7A83)  ;; <CJK>
     (?$B@a(B . ?\x7BC0)  ;; <CJK>
     (?$B@b(B . ?\x8AAC)  ;; <CJK>
     (?$B@c(B . ?\x96EA)  ;; <CJK>
     (?$B@d(B . ?\x7D76)  ;; <CJK>
     (?$B@e(B . ?\x820C)  ;; <CJK>
     (?$B@f(B . ?\x8749)  ;; <CJK>
     (?$B@g(B . ?\x4ED9)  ;; <CJK>
     (?$B@h(B . ?\x5148)  ;; <CJK>
     (?$B@i(B . ?\x5343)  ;; <CJK>
     (?$B@j(B . ?\x5360)  ;; <CJK>
     (?$B@k(B . ?\x5BA3)  ;; <CJK>
     (?$B@l(B . ?\x5C02)  ;; <CJK>
     (?$B@m(B . ?\x5C16)  ;; <CJK>
     (?$B@n(B . ?\x5DDD)  ;; <CJK>
     (?$B@o(B . ?\x6226)  ;; <CJK>
     (?$B@p(B . ?\x6247)  ;; <CJK>
     (?$B@q(B . ?\x64B0)  ;; <CJK>
     (?$B@r(B . ?\x6813)  ;; <CJK>
     (?$B@s(B . ?\x6834)  ;; <CJK>
     (?$B@t(B . ?\x6CC9)  ;; <CJK>
     (?$B@u(B . ?\x6D45)  ;; <CJK>
     (?$B@v(B . ?\x6D17)  ;; <CJK>
     (?$B@w(B . ?\x67D3)  ;; <CJK>
     (?$B@x(B . ?\x6F5C)  ;; <CJK>
     (?$B@y(B . ?\x714E)  ;; <CJK>
     (?$B@z(B . ?\x717D)  ;; <CJK>
     (?$B@{(B . ?\x65CB)  ;; <CJK>
     (?$B@|(B . ?\x7A7F)  ;; <CJK>
     (?$B@}(B . ?\x7BAD)  ;; <CJK>
     (?$B@~(B . ?\x7DDA)  ;; <CJK>
     (?$BA!(B . ?\x7E4A)  ;; <CJK>
     (?$BA"(B . ?\x7FA8)  ;; <CJK>
     (?$BA#(B . ?\x817A)  ;; <CJK>
     (?$BA$(B . ?\x821B)  ;; <CJK>
     (?$BA%(B . ?\x8239)  ;; <CJK>
     (?$BA&(B . ?\x85A6)  ;; <CJK>
     (?$BA'(B . ?\x8A6E)  ;; <CJK>
     (?$BA((B . ?\x8CCE)  ;; <CJK>
     (?$BA)(B . ?\x8DF5)  ;; <CJK>
     (?$BA*(B . ?\x9078)  ;; <CJK>
     (?$BA+(B . ?\x9077)  ;; <CJK>
     (?$BA,(B . ?\x92AD)  ;; <CJK>
     (?$BA-(B . ?\x9291)  ;; <CJK>
     (?$BA.(B . ?\x9583)  ;; <CJK>
     (?$BA/(B . ?\x9BAE)  ;; <CJK>
     (?$BA0(B . ?\x524D)  ;; <CJK>
     (?$BA1(B . ?\x5584)  ;; <CJK>
     (?$BA2(B . ?\x6F38)  ;; <CJK>
     (?$BA3(B . ?\x7136)  ;; <CJK>
     (?$BA4(B . ?\x5168)  ;; <CJK>
     (?$BA5(B . ?\x7985)  ;; <CJK>
     (?$BA6(B . ?\x7E55)  ;; <CJK>
     (?$BA7(B . ?\x81B3)  ;; <CJK>
     (?$BA8(B . ?\x7CCE)  ;; <CJK>
     (?$BA9(B . ?\x564C)  ;; <CJK>
     (?$BA:(B . ?\x5851)  ;; <CJK>
     (?$BA;(B . ?\x5CA8)  ;; <CJK>
     (?$BA<(B . ?\x63AA)  ;; <CJK>
     (?$BA=(B . ?\x66FE)  ;; <CJK>
     (?$BA>(B . ?\x66FD)  ;; <CJK>
     (?$BA?(B . ?\x695A)  ;; <CJK>
     (?$BA@(B . ?\x72D9)  ;; <CJK>
     (?$BAA(B . ?\x758F)  ;; <CJK>
     (?$BAB(B . ?\x758E)  ;; <CJK>
     (?$BAC(B . ?\x790E)  ;; <CJK>
     (?$BAD(B . ?\x7956)  ;; <CJK>
     (?$BAE(B . ?\x79DF)  ;; <CJK>
     (?$BAF(B . ?\x7C97)  ;; <CJK>
     (?$BAG(B . ?\x7D20)  ;; <CJK>
     (?$BAH(B . ?\x7D44)  ;; <CJK>
     (?$BAI(B . ?\x8607)  ;; <CJK>
     (?$BAJ(B . ?\x8A34)  ;; <CJK>
     (?$BAK(B . ?\x963B)  ;; <CJK>
     (?$BAL(B . ?\x9061)  ;; <CJK>
     (?$BAM(B . ?\x9F20)  ;; <CJK>
     (?$BAN(B . ?\x50E7)  ;; <CJK>
     (?$BAO(B . ?\x5275)  ;; <CJK>
     (?$BAP(B . ?\x53CC)  ;; <CJK>
     (?$BAQ(B . ?\x53E2)  ;; <CJK>
     (?$BAR(B . ?\x5009)  ;; <CJK>
     (?$BAS(B . ?\x55AA)  ;; <CJK>
     (?$BAT(B . ?\x58EE)  ;; <CJK>
     (?$BAU(B . ?\x594F)  ;; <CJK>
     (?$BAV(B . ?\x723D)  ;; <CJK>
     (?$BAW(B . ?\x5B8B)  ;; <CJK>
     (?$BAX(B . ?\x5C64)  ;; <CJK>
     (?$BAY(B . ?\x531D)  ;; <CJK>
     (?$BAZ(B . ?\x60E3)  ;; <CJK>
     (?$BA[(B . ?\x60F3)  ;; <CJK>
     (?$BA\(B . ?\x635C)  ;; <CJK>
     (?$BA](B . ?\x6383)  ;; <CJK>
     (?$BA^(B . ?\x633F)  ;; <CJK>
     (?$BA_(B . ?\x63BB)  ;; <CJK>
     (?$BA`(B . ?\x64CD)  ;; <CJK>
     (?$BAa(B . ?\x65E9)  ;; <CJK>
     (?$BAb(B . ?\x66F9)  ;; <CJK>
     (?$BAc(B . ?\x5DE3)  ;; <CJK>
     (?$BAd(B . ?\x69CD)  ;; <CJK>
     (?$BAe(B . ?\x69FD)  ;; <CJK>
     (?$BAf(B . ?\x6F15)  ;; <CJK>
     (?$BAg(B . ?\x71E5)  ;; <CJK>
     (?$BAh(B . ?\x4E89)  ;; <CJK>
     (?$BAi(B . ?\x75E9)  ;; <CJK>
     (?$BAj(B . ?\x76F8)  ;; <CJK>
     (?$BAk(B . ?\x7A93)  ;; <CJK>
     (?$BAl(B . ?\x7CDF)  ;; <CJK>
     (?$BAm(B . ?\x7DCF)  ;; <CJK>
     (?$BAn(B . ?\x7D9C)  ;; <CJK>
     (?$BAo(B . ?\x8061)  ;; <CJK>
     (?$BAp(B . ?\x8349)  ;; <CJK>
     (?$BAq(B . ?\x8358)  ;; <CJK>
     (?$BAr(B . ?\x846C)  ;; <CJK>
     (?$BAs(B . ?\x84BC)  ;; <CJK>
     (?$BAt(B . ?\x85FB)  ;; <CJK>
     (?$BAu(B . ?\x88C5)  ;; <CJK>
     (?$BAv(B . ?\x8D70)  ;; <CJK>
     (?$BAw(B . ?\x9001)  ;; <CJK>
     (?$BAx(B . ?\x906D)  ;; <CJK>
     (?$BAy(B . ?\x9397)  ;; <CJK>
     (?$BAz(B . ?\x971C)  ;; <CJK>
     (?$BA{(B . ?\x9A12)  ;; <CJK>
     (?$BA|(B . ?\x50CF)  ;; <CJK>
     (?$BA}(B . ?\x5897)  ;; <CJK>
     (?$BA~(B . ?\x618E)  ;; <CJK>
     (?$BB!(B . ?\x81D3)  ;; <CJK>
     (?$BB"(B . ?\x8535)  ;; <CJK>
     (?$BB#(B . ?\x8D08)  ;; <CJK>
     (?$BB$(B . ?\x9020)  ;; <CJK>
     (?$BB%(B . ?\x4FC3)  ;; <CJK>
     (?$BB&(B . ?\x5074)  ;; <CJK>
     (?$BB'(B . ?\x5247)  ;; <CJK>
     (?$BB((B . ?\x5373)  ;; <CJK>
     (?$BB)(B . ?\x606F)  ;; <CJK>
     (?$BB*(B . ?\x6349)  ;; <CJK>
     (?$BB+(B . ?\x675F)  ;; <CJK>
     (?$BB,(B . ?\x6E2C)  ;; <CJK>
     (?$BB-(B . ?\x8DB3)  ;; <CJK>
     (?$BB.(B . ?\x901F)  ;; <CJK>
     (?$BB/(B . ?\x4FD7)  ;; <CJK>
     (?$BB0(B . ?\x5C5E)  ;; <CJK>
     (?$BB1(B . ?\x8CCA)  ;; <CJK>
     (?$BB2(B . ?\x65CF)  ;; <CJK>
     (?$BB3(B . ?\x7D9A)  ;; <CJK>
     (?$BB4(B . ?\x5352)  ;; <CJK>
     (?$BB5(B . ?\x8896)  ;; <CJK>
     (?$BB6(B . ?\x5176)  ;; <CJK>
     (?$BB7(B . ?\x63C3)  ;; <CJK>
     (?$BB8(B . ?\x5B58)  ;; <CJK>
     (?$BB9(B . ?\x5B6B)  ;; <CJK>
     (?$BB:(B . ?\x5C0A)  ;; <CJK>
     (?$BB;(B . ?\x640D)  ;; <CJK>
     (?$BB<(B . ?\x6751)  ;; <CJK>
     (?$BB=(B . ?\x905C)  ;; <CJK>
     (?$BB>(B . ?\x4ED6)  ;; <CJK>
     (?$BB?(B . ?\x591A)  ;; <CJK>
     (?$BB@(B . ?\x592A)  ;; <CJK>
     (?$BBA(B . ?\x6C70)  ;; <CJK>
     (?$BBB(B . ?\x8A51)  ;; <CJK>
     (?$BBC(B . ?\x553E)  ;; <CJK>
     (?$BBD(B . ?\x5815)  ;; <CJK>
     (?$BBE(B . ?\x59A5)  ;; <CJK>
     (?$BBF(B . ?\x60F0)  ;; <CJK>
     (?$BBG(B . ?\x6253)  ;; <CJK>
     (?$BBH(B . ?\x67C1)  ;; <CJK>
     (?$BBI(B . ?\x8235)  ;; <CJK>
     (?$BBJ(B . ?\x6955)  ;; <CJK>
     (?$BBK(B . ?\x9640)  ;; <CJK>
     (?$BBL(B . ?\x99C4)  ;; <CJK>
     (?$BBM(B . ?\x9A28)  ;; <CJK>
     (?$BBN(B . ?\x4F53)  ;; <CJK>
     (?$BBO(B . ?\x5806)  ;; <CJK>
     (?$BBP(B . ?\x5BFE)  ;; <CJK>
     (?$BBQ(B . ?\x8010)  ;; <CJK>
     (?$BBR(B . ?\x5CB1)  ;; <CJK>
     (?$BBS(B . ?\x5E2F)  ;; <CJK>
     (?$BBT(B . ?\x5F85)  ;; <CJK>
     (?$BBU(B . ?\x6020)  ;; <CJK>
     (?$BBV(B . ?\x614B)  ;; <CJK>
     (?$BBW(B . ?\x6234)  ;; <CJK>
     (?$BBX(B . ?\x66FF)  ;; <CJK>
     (?$BBY(B . ?\x6CF0)  ;; <CJK>
     (?$BBZ(B . ?\x6EDE)  ;; <CJK>
     (?$BB[(B . ?\x80CE)  ;; <CJK>
     (?$BB\(B . ?\x817F)  ;; <CJK>
     (?$BB](B . ?\x82D4)  ;; <CJK>
     (?$BB^(B . ?\x888B)  ;; <CJK>
     (?$BB_(B . ?\x8CB8)  ;; <CJK>
     (?$BB`(B . ?\x9000)  ;; <CJK>
     (?$BBa(B . ?\x902E)  ;; <CJK>
     (?$BBb(B . ?\x968A)  ;; <CJK>
     (?$BBc(B . ?\x9EDB)  ;; <CJK>
     (?$BBd(B . ?\x9BDB)  ;; <CJK>
     (?$BBe(B . ?\x4EE3)  ;; <CJK>
     (?$BBf(B . ?\x53F0)  ;; <CJK>
     (?$BBg(B . ?\x5927)  ;; <CJK>
     (?$BBh(B . ?\x7B2C)  ;; <CJK>
     (?$BBi(B . ?\x918D)  ;; <CJK>
     (?$BBj(B . ?\x984C)  ;; <CJK>
     (?$BBk(B . ?\x9DF9)  ;; <CJK>
     (?$BBl(B . ?\x6EDD)  ;; <CJK>
     (?$BBm(B . ?\x7027)  ;; <CJK>
     (?$BBn(B . ?\x5353)  ;; <CJK>
     (?$BBo(B . ?\x5544)  ;; <CJK>
     (?$BBp(B . ?\x5B85)  ;; <CJK>
     (?$BBq(B . ?\x6258)  ;; <CJK>
     (?$BBr(B . ?\x629E)  ;; <CJK>
     (?$BBs(B . ?\x62D3)  ;; <CJK>
     (?$BBt(B . ?\x6CA2)  ;; <CJK>
     (?$BBu(B . ?\x6FEF)  ;; <CJK>
     (?$BBv(B . ?\x7422)  ;; <CJK>
     (?$BBw(B . ?\x8A17)  ;; <CJK>
     (?$BBx(B . ?\x9438)  ;; <CJK>
     (?$BBy(B . ?\x6FC1)  ;; <CJK>
     (?$BBz(B . ?\x8AFE)  ;; <CJK>
     (?$BB{(B . ?\x8338)  ;; <CJK>
     (?$BB|(B . ?\x51E7)  ;; <CJK>
     (?$BB}(B . ?\x86F8)  ;; <CJK>
     (?$BB~(B . ?\x53EA)  ;; <CJK>
     (?$BC!(B . ?\x53E9)  ;; <CJK>
     (?$BC"(B . ?\x4F46)  ;; <CJK>
     (?$BC#(B . ?\x9054)  ;; <CJK>
     (?$BC$(B . ?\x8FB0)  ;; <CJK>
     (?$BC%(B . ?\x596A)  ;; <CJK>
     (?$BC&(B . ?\x8131)  ;; <CJK>
     (?$BC'(B . ?\x5DFD)  ;; <CJK>
     (?$BC((B . ?\x7AEA)  ;; <CJK>
     (?$BC)(B . ?\x8FBF)  ;; <CJK>
     (?$BC*(B . ?\x68DA)  ;; <CJK>
     (?$BC+(B . ?\x8C37)  ;; <CJK>
     (?$BC,(B . ?\x72F8)  ;; <CJK>
     (?$BC-(B . ?\x9C48)  ;; <CJK>
     (?$BC.(B . ?\x6A3D)  ;; <CJK>
     (?$BC/(B . ?\x8AB0)  ;; <CJK>
     (?$BC0(B . ?\x4E39)  ;; <CJK>
     (?$BC1(B . ?\x5358)  ;; <CJK>
     (?$BC2(B . ?\x5606)  ;; <CJK>
     (?$BC3(B . ?\x5766)  ;; <CJK>
     (?$BC4(B . ?\x62C5)  ;; <CJK>
     (?$BC5(B . ?\x63A2)  ;; <CJK>
     (?$BC6(B . ?\x65E6)  ;; <CJK>
     (?$BC7(B . ?\x6B4E)  ;; <CJK>
     (?$BC8(B . ?\x6DE1)  ;; <CJK>
     (?$BC9(B . ?\x6E5B)  ;; <CJK>
     (?$BC:(B . ?\x70AD)  ;; <CJK>
     (?$BC;(B . ?\x77ED)  ;; <CJK>
     (?$BC<(B . ?\x7AEF)  ;; <CJK>
     (?$BC=(B . ?\x7BAA)  ;; <CJK>
     (?$BC>(B . ?\x7DBB)  ;; <CJK>
     (?$BC?(B . ?\x803D)  ;; <CJK>
     (?$BC@(B . ?\x80C6)  ;; <CJK>
     (?$BCA(B . ?\x86CB)  ;; <CJK>
     (?$BCB(B . ?\x8A95)  ;; <CJK>
     (?$BCC(B . ?\x935B)  ;; <CJK>
     (?$BCD(B . ?\x56E3)  ;; <CJK>
     (?$BCE(B . ?\x58C7)  ;; <CJK>
     (?$BCF(B . ?\x5F3E)  ;; <CJK>
     (?$BCG(B . ?\x65AD)  ;; <CJK>
     (?$BCH(B . ?\x6696)  ;; <CJK>
     (?$BCI(B . ?\x6A80)  ;; <CJK>
     (?$BCJ(B . ?\x6BB5)  ;; <CJK>
     (?$BCK(B . ?\x7537)  ;; <CJK>
     (?$BCL(B . ?\x8AC7)  ;; <CJK>
     (?$BCM(B . ?\x5024)  ;; <CJK>
     (?$BCN(B . ?\x77E5)  ;; <CJK>
     (?$BCO(B . ?\x5730)  ;; <CJK>
     (?$BCP(B . ?\x5F1B)  ;; <CJK>
     (?$BCQ(B . ?\x6065)  ;; <CJK>
     (?$BCR(B . ?\x667A)  ;; <CJK>
     (?$BCS(B . ?\x6C60)  ;; <CJK>
     (?$BCT(B . ?\x75F4)  ;; <CJK>
     (?$BCU(B . ?\x7A1A)  ;; <CJK>
     (?$BCV(B . ?\x7F6E)  ;; <CJK>
     (?$BCW(B . ?\x81F4)  ;; <CJK>
     (?$BCX(B . ?\x8718)  ;; <CJK>
     (?$BCY(B . ?\x9045)  ;; <CJK>
     (?$BCZ(B . ?\x99B3)  ;; <CJK>
     (?$BC[(B . ?\x7BC9)  ;; <CJK>
     (?$BC\(B . ?\x755C)  ;; <CJK>
     (?$BC](B . ?\x7AF9)  ;; <CJK>
     (?$BC^(B . ?\x7B51)  ;; <CJK>
     (?$BC_(B . ?\x84C4)  ;; <CJK>
     (?$BC`(B . ?\x9010)  ;; <CJK>
     (?$BCa(B . ?\x79E9)  ;; <CJK>
     (?$BCb(B . ?\x7A92)  ;; <CJK>
     (?$BCc(B . ?\x8336)  ;; <CJK>
     (?$BCd(B . ?\x5AE1)  ;; <CJK>
     (?$BCe(B . ?\x7740)  ;; <CJK>
     (?$BCf(B . ?\x4E2D)  ;; <CJK>
     (?$BCg(B . ?\x4EF2)  ;; <CJK>
     (?$BCh(B . ?\x5B99)  ;; <CJK>
     (?$BCi(B . ?\x5FE0)  ;; <CJK>
     (?$BCj(B . ?\x62BD)  ;; <CJK>
     (?$BCk(B . ?\x663C)  ;; <CJK>
     (?$BCl(B . ?\x67F1)  ;; <CJK>
     (?$BCm(B . ?\x6CE8)  ;; <CJK>
     (?$BCn(B . ?\x866B)  ;; <CJK>
     (?$BCo(B . ?\x8877)  ;; <CJK>
     (?$BCp(B . ?\x8A3B)  ;; <CJK>
     (?$BCq(B . ?\x914E)  ;; <CJK>
     (?$BCr(B . ?\x92F3)  ;; <CJK>
     (?$BCs(B . ?\x99D0)  ;; <CJK>
     (?$BCt(B . ?\x6A17)  ;; <CJK>
     (?$BCu(B . ?\x7026)  ;; <CJK>
     (?$BCv(B . ?\x732A)  ;; <CJK>
     (?$BCw(B . ?\x82E7)  ;; <CJK>
     (?$BCx(B . ?\x8457)  ;; <CJK>
     (?$BCy(B . ?\x8CAF)  ;; <CJK>
     (?$BCz(B . ?\x4E01)  ;; <CJK>
     (?$BC{(B . ?\x5146)  ;; <CJK>
     (?$BC|(B . ?\x51CB)  ;; <CJK>
     (?$BC}(B . ?\x558B)  ;; <CJK>
     (?$BC~(B . ?\x5BF5)  ;; <CJK>
     (?$BD!(B . ?\x5E16)  ;; <CJK>
     (?$BD"(B . ?\x5E33)  ;; <CJK>
     (?$BD#(B . ?\x5E81)  ;; <CJK>
     (?$BD$(B . ?\x5F14)  ;; <CJK>
     (?$BD%(B . ?\x5F35)  ;; <CJK>
     (?$BD&(B . ?\x5F6B)  ;; <CJK>
     (?$BD'(B . ?\x5FB4)  ;; <CJK>
     (?$BD((B . ?\x61F2)  ;; <CJK>
     (?$BD)(B . ?\x6311)  ;; <CJK>
     (?$BD*(B . ?\x66A2)  ;; <CJK>
     (?$BD+(B . ?\x671D)  ;; <CJK>
     (?$BD,(B . ?\x6F6E)  ;; <CJK>
     (?$BD-(B . ?\x7252)  ;; <CJK>
     (?$BD.(B . ?\x753A)  ;; <CJK>
     (?$BD/(B . ?\x773A)  ;; <CJK>
     (?$BD0(B . ?\x8074)  ;; <CJK>
     (?$BD1(B . ?\x8139)  ;; <CJK>
     (?$BD2(B . ?\x8178)  ;; <CJK>
     (?$BD3(B . ?\x8776)  ;; <CJK>
     (?$BD4(B . ?\x8ABF)  ;; <CJK>
     (?$BD5(B . ?\x8ADC)  ;; <CJK>
     (?$BD6(B . ?\x8D85)  ;; <CJK>
     (?$BD7(B . ?\x8DF3)  ;; <CJK>
     (?$BD8(B . ?\x929A)  ;; <CJK>
     (?$BD9(B . ?\x9577)  ;; <CJK>
     (?$BD:(B . ?\x9802)  ;; <CJK>
     (?$BD;(B . ?\x9CE5)  ;; <CJK>
     (?$BD<(B . ?\x52C5)  ;; <CJK>
     (?$BD=(B . ?\x6357)  ;; <CJK>
     (?$BD>(B . ?\x76F4)  ;; <CJK>
     (?$BD?(B . ?\x6715)  ;; <CJK>
     (?$BD@(B . ?\x6C88)  ;; <CJK>
     (?$BDA(B . ?\x73CD)  ;; <CJK>
     (?$BDB(B . ?\x8CC3)  ;; <CJK>
     (?$BDC(B . ?\x93AE)  ;; <CJK>
     (?$BDD(B . ?\x9673)  ;; <CJK>
     (?$BDE(B . ?\x6D25)  ;; <CJK>
     (?$BDF(B . ?\x589C)  ;; <CJK>
     (?$BDG(B . ?\x690E)  ;; <CJK>
     (?$BDH(B . ?\x69CC)  ;; <CJK>
     (?$BDI(B . ?\x8FFD)  ;; <CJK>
     (?$BDJ(B . ?\x939A)  ;; <CJK>
     (?$BDK(B . ?\x75DB)  ;; <CJK>
     (?$BDL(B . ?\x901A)  ;; <CJK>
     (?$BDM(B . ?\x585A)  ;; <CJK>
     (?$BDN(B . ?\x6802)  ;; <CJK>
     (?$BDO(B . ?\x63B4)  ;; <CJK>
     (?$BDP(B . ?\x69FB)  ;; <CJK>
     (?$BDQ(B . ?\x4F43)  ;; <CJK>
     (?$BDR(B . ?\x6F2C)  ;; <CJK>
     (?$BDS(B . ?\x67D8)  ;; <CJK>
     (?$BDT(B . ?\x8FBB)  ;; <CJK>
     (?$BDU(B . ?\x8526)  ;; <CJK>
     (?$BDV(B . ?\x7DB4)  ;; <CJK>
     (?$BDW(B . ?\x9354)  ;; <CJK>
     (?$BDX(B . ?\x693F)  ;; <CJK>
     (?$BDY(B . ?\x6F70)  ;; <CJK>
     (?$BDZ(B . ?\x576A)  ;; <CJK>
     (?$BD[(B . ?\x58F7)  ;; <CJK>
     (?$BD\(B . ?\x5B2C)  ;; <CJK>
     (?$BD](B . ?\x7D2C)  ;; <CJK>
     (?$BD^(B . ?\x722A)  ;; <CJK>
     (?$BD_(B . ?\x540A)  ;; <CJK>
     (?$BD`(B . ?\x91E3)  ;; <CJK>
     (?$BDa(B . ?\x9DB4)  ;; <CJK>
     (?$BDb(B . ?\x4EAD)  ;; <CJK>
     (?$BDc(B . ?\x4F4E)  ;; <CJK>
     (?$BDd(B . ?\x505C)  ;; <CJK>
     (?$BDe(B . ?\x5075)  ;; <CJK>
     (?$BDf(B . ?\x5243)  ;; <CJK>
     (?$BDg(B . ?\x8C9E)  ;; <CJK>
     (?$BDh(B . ?\x5448)  ;; <CJK>
     (?$BDi(B . ?\x5824)  ;; <CJK>
     (?$BDj(B . ?\x5B9A)  ;; <CJK>
     (?$BDk(B . ?\x5E1D)  ;; <CJK>
     (?$BDl(B . ?\x5E95)  ;; <CJK>
     (?$BDm(B . ?\x5EAD)  ;; <CJK>
     (?$BDn(B . ?\x5EF7)  ;; <CJK>
     (?$BDo(B . ?\x5F1F)  ;; <CJK>
     (?$BDp(B . ?\x608C)  ;; <CJK>
     (?$BDq(B . ?\x62B5)  ;; <CJK>
     (?$BDr(B . ?\x633A)  ;; <CJK>
     (?$BDs(B . ?\x63D0)  ;; <CJK>
     (?$BDt(B . ?\x68AF)  ;; <CJK>
     (?$BDu(B . ?\x6C40)  ;; <CJK>
     (?$BDv(B . ?\x7887)  ;; <CJK>
     (?$BDw(B . ?\x798E)  ;; <CJK>
     (?$BDx(B . ?\x7A0B)  ;; <CJK>
     (?$BDy(B . ?\x7DE0)  ;; <CJK>
     (?$BDz(B . ?\x8247)  ;; <CJK>
     (?$BD{(B . ?\x8A02)  ;; <CJK>
     (?$BD|(B . ?\x8AE6)  ;; <CJK>
     (?$BD}(B . ?\x8E44)  ;; <CJK>
     (?$BD~(B . ?\x9013)  ;; <CJK>
     (?$BE!(B . ?\x90B8)  ;; <CJK>
     (?$BE"(B . ?\x912D)  ;; <CJK>
     (?$BE#(B . ?\x91D8)  ;; <CJK>
     (?$BE$(B . ?\x9F0E)  ;; <CJK>
     (?$BE%(B . ?\x6CE5)  ;; <CJK>
     (?$BE&(B . ?\x6458)  ;; <CJK>
     (?$BE'(B . ?\x64E2)  ;; <CJK>
     (?$BE((B . ?\x6575)  ;; <CJK>
     (?$BE)(B . ?\x6EF4)  ;; <CJK>
     (?$BE*(B . ?\x7684)  ;; <CJK>
     (?$BE+(B . ?\x7B1B)  ;; <CJK>
     (?$BE,(B . ?\x9069)  ;; <CJK>
     (?$BE-(B . ?\x93D1)  ;; <CJK>
     (?$BE.(B . ?\x6EBA)  ;; <CJK>
     (?$BE/(B . ?\x54F2)  ;; <CJK>
     (?$BE0(B . ?\x5FB9)  ;; <CJK>
     (?$BE1(B . ?\x64A4)  ;; <CJK>
     (?$BE2(B . ?\x8F4D)  ;; <CJK>
     (?$BE3(B . ?\x8FED)  ;; <CJK>
     (?$BE4(B . ?\x9244)  ;; <CJK>
     (?$BE5(B . ?\x5178)  ;; <CJK>
     (?$BE6(B . ?\x586B)  ;; <CJK>
     (?$BE7(B . ?\x5929)  ;; <CJK>
     (?$BE8(B . ?\x5C55)  ;; <CJK>
     (?$BE9(B . ?\x5E97)  ;; <CJK>
     (?$BE:(B . ?\x6DFB)  ;; <CJK>
     (?$BE;(B . ?\x7E8F)  ;; <CJK>
     (?$BE<(B . ?\x751C)  ;; <CJK>
     (?$BE=(B . ?\x8CBC)  ;; <CJK>
     (?$BE>(B . ?\x8EE2)  ;; <CJK>
     (?$BE?(B . ?\x985B)  ;; <CJK>
     (?$BE@(B . ?\x70B9)  ;; <CJK>
     (?$BEA(B . ?\x4F1D)  ;; <CJK>
     (?$BEB(B . ?\x6BBF)  ;; <CJK>
     (?$BEC(B . ?\x6FB1)  ;; <CJK>
     (?$BED(B . ?\x7530)  ;; <CJK>
     (?$BEE(B . ?\x96FB)  ;; <CJK>
     (?$BEF(B . ?\x514E)  ;; <CJK>
     (?$BEG(B . ?\x5410)  ;; <CJK>
     (?$BEH(B . ?\x5835)  ;; <CJK>
     (?$BEI(B . ?\x5857)  ;; <CJK>
     (?$BEJ(B . ?\x59AC)  ;; <CJK>
     (?$BEK(B . ?\x5C60)  ;; <CJK>
     (?$BEL(B . ?\x5F92)  ;; <CJK>
     (?$BEM(B . ?\x6597)  ;; <CJK>
     (?$BEN(B . ?\x675C)  ;; <CJK>
     (?$BEO(B . ?\x6E21)  ;; <CJK>
     (?$BEP(B . ?\x767B)  ;; <CJK>
     (?$BEQ(B . ?\x83DF)  ;; <CJK>
     (?$BER(B . ?\x8CED)  ;; <CJK>
     (?$BES(B . ?\x9014)  ;; <CJK>
     (?$BET(B . ?\x90FD)  ;; <CJK>
     (?$BEU(B . ?\x934D)  ;; <CJK>
     (?$BEV(B . ?\x7825)  ;; <CJK>
     (?$BEW(B . ?\x783A)  ;; <CJK>
     (?$BEX(B . ?\x52AA)  ;; <CJK>
     (?$BEY(B . ?\x5EA6)  ;; <CJK>
     (?$BEZ(B . ?\x571F)  ;; <CJK>
     (?$BE[(B . ?\x5974)  ;; <CJK>
     (?$BE\(B . ?\x6012)  ;; <CJK>
     (?$BE](B . ?\x5012)  ;; <CJK>
     (?$BE^(B . ?\x515A)  ;; <CJK>
     (?$BE_(B . ?\x51AC)  ;; <CJK>
     (?$BE`(B . ?\x51CD)  ;; <CJK>
     (?$BEa(B . ?\x5200)  ;; <CJK>
     (?$BEb(B . ?\x5510)  ;; <CJK>
     (?$BEc(B . ?\x5854)  ;; <CJK>
     (?$BEd(B . ?\x5858)  ;; <CJK>
     (?$BEe(B . ?\x5957)  ;; <CJK>
     (?$BEf(B . ?\x5B95)  ;; <CJK>
     (?$BEg(B . ?\x5CF6)  ;; <CJK>
     (?$BEh(B . ?\x5D8B)  ;; <CJK>
     (?$BEi(B . ?\x60BC)  ;; <CJK>
     (?$BEj(B . ?\x6295)  ;; <CJK>
     (?$BEk(B . ?\x642D)  ;; <CJK>
     (?$BEl(B . ?\x6771)  ;; <CJK>
     (?$BEm(B . ?\x6843)  ;; <CJK>
     (?$BEn(B . ?\x68BC)  ;; <CJK>
     (?$BEo(B . ?\x68DF)  ;; <CJK>
     (?$BEp(B . ?\x76D7)  ;; <CJK>
     (?$BEq(B . ?\x6DD8)  ;; <CJK>
     (?$BEr(B . ?\x6E6F)  ;; <CJK>
     (?$BEs(B . ?\x6D9B)  ;; <CJK>
     (?$BEt(B . ?\x706F)  ;; <CJK>
     (?$BEu(B . ?\x71C8)  ;; <CJK>
     (?$BEv(B . ?\x5F53)  ;; <CJK>
     (?$BEw(B . ?\x75D8)  ;; <CJK>
     (?$BEx(B . ?\x7977)  ;; <CJK>
     (?$BEy(B . ?\x7B49)  ;; <CJK>
     (?$BEz(B . ?\x7B54)  ;; <CJK>
     (?$BE{(B . ?\x7B52)  ;; <CJK>
     (?$BE|(B . ?\x7CD6)  ;; <CJK>
     (?$BE}(B . ?\x7D71)  ;; <CJK>
     (?$BE~(B . ?\x5230)  ;; <CJK>
     (?$BF!(B . ?\x8463)  ;; <CJK>
     (?$BF"(B . ?\x8569)  ;; <CJK>
     (?$BF#(B . ?\x85E4)  ;; <CJK>
     (?$BF$(B . ?\x8A0E)  ;; <CJK>
     (?$BF%(B . ?\x8B04)  ;; <CJK>
     (?$BF&(B . ?\x8C46)  ;; <CJK>
     (?$BF'(B . ?\x8E0F)  ;; <CJK>
     (?$BF((B . ?\x9003)  ;; <CJK>
     (?$BF)(B . ?\x900F)  ;; <CJK>
     (?$BF*(B . ?\x9419)  ;; <CJK>
     (?$BF+(B . ?\x9676)  ;; <CJK>
     (?$BF,(B . ?\x982D)  ;; <CJK>
     (?$BF-(B . ?\x9A30)  ;; <CJK>
     (?$BF.(B . ?\x95D8)  ;; <CJK>
     (?$BF/(B . ?\x50CD)  ;; <CJK>
     (?$BF0(B . ?\x52D5)  ;; <CJK>
     (?$BF1(B . ?\x540C)  ;; <CJK>
     (?$BF2(B . ?\x5802)  ;; <CJK>
     (?$BF3(B . ?\x5C0E)  ;; <CJK>
     (?$BF4(B . ?\x61A7)  ;; <CJK>
     (?$BF5(B . ?\x649E)  ;; <CJK>
     (?$BF6(B . ?\x6D1E)  ;; <CJK>
     (?$BF7(B . ?\x77B3)  ;; <CJK>
     (?$BF8(B . ?\x7AE5)  ;; <CJK>
     (?$BF9(B . ?\x80F4)  ;; <CJK>
     (?$BF:(B . ?\x8404)  ;; <CJK>
     (?$BF;(B . ?\x9053)  ;; <CJK>
     (?$BF<(B . ?\x9285)  ;; <CJK>
     (?$BF=(B . ?\x5CE0)  ;; <CJK>
     (?$BF>(B . ?\x9D07)  ;; <CJK>
     (?$BF?(B . ?\x533F)  ;; <CJK>
     (?$BF@(B . ?\x5F97)  ;; <CJK>
     (?$BFA(B . ?\x5FB3)  ;; <CJK>
     (?$BFB(B . ?\x6D9C)  ;; <CJK>
     (?$BFC(B . ?\x7279)  ;; <CJK>
     (?$BFD(B . ?\x7763)  ;; <CJK>
     (?$BFE(B . ?\x79BF)  ;; <CJK>
     (?$BFF(B . ?\x7BE4)  ;; <CJK>
     (?$BFG(B . ?\x6BD2)  ;; <CJK>
     (?$BFH(B . ?\x72EC)  ;; <CJK>
     (?$BFI(B . ?\x8AAD)  ;; <CJK>
     (?$BFJ(B . ?\x6803)  ;; <CJK>
     (?$BFK(B . ?\x6A61)  ;; <CJK>
     (?$BFL(B . ?\x51F8)  ;; <CJK>
     (?$BFM(B . ?\x7A81)  ;; <CJK>
     (?$BFN(B . ?\x6934)  ;; <CJK>
     (?$BFO(B . ?\x5C4A)  ;; <CJK>
     (?$BFP(B . ?\x9CF6)  ;; <CJK>
     (?$BFQ(B . ?\x82EB)  ;; <CJK>
     (?$BFR(B . ?\x5BC5)  ;; <CJK>
     (?$BFS(B . ?\x9149)  ;; <CJK>
     (?$BFT(B . ?\x701E)  ;; <CJK>
     (?$BFU(B . ?\x5678)  ;; <CJK>
     (?$BFV(B . ?\x5C6F)  ;; <CJK>
     (?$BFW(B . ?\x60C7)  ;; <CJK>
     (?$BFX(B . ?\x6566)  ;; <CJK>
     (?$BFY(B . ?\x6C8C)  ;; <CJK>
     (?$BFZ(B . ?\x8C5A)  ;; <CJK>
     (?$BF[(B . ?\x9041)  ;; <CJK>
     (?$BF\(B . ?\x9813)  ;; <CJK>
     (?$BF](B . ?\x5451)  ;; <CJK>
     (?$BF^(B . ?\x66C7)  ;; <CJK>
     (?$BF_(B . ?\x920D)  ;; <CJK>
     (?$BF`(B . ?\x5948)  ;; <CJK>
     (?$BFa(B . ?\x90A3)  ;; <CJK>
     (?$BFb(B . ?\x5185)  ;; <CJK>
     (?$BFc(B . ?\x4E4D)  ;; <CJK>
     (?$BFd(B . ?\x51EA)  ;; <CJK>
     (?$BFe(B . ?\x8599)  ;; <CJK>
     (?$BFf(B . ?\x8B0E)  ;; <CJK>
     (?$BFg(B . ?\x7058)  ;; <CJK>
     (?$BFh(B . ?\x637A)  ;; <CJK>
     (?$BFi(B . ?\x934B)  ;; <CJK>
     (?$BFj(B . ?\x6962)  ;; <CJK>
     (?$BFk(B . ?\x99B4)  ;; <CJK>
     (?$BFl(B . ?\x7E04)  ;; <CJK>
     (?$BFm(B . ?\x7577)  ;; <CJK>
     (?$BFn(B . ?\x5357)  ;; <CJK>
     (?$BFo(B . ?\x6960)  ;; <CJK>
     (?$BFp(B . ?\x8EDF)  ;; <CJK>
     (?$BFq(B . ?\x96E3)  ;; <CJK>
     (?$BFr(B . ?\x6C5D)  ;; <CJK>
     (?$BFs(B . ?\x4E8C)  ;; <CJK>
     (?$BFt(B . ?\x5C3C)  ;; <CJK>
     (?$BFu(B . ?\x5F10)  ;; <CJK>
     (?$BFv(B . ?\x8FE9)  ;; <CJK>
     (?$BFw(B . ?\x5302)  ;; <CJK>
     (?$BFx(B . ?\x8CD1)  ;; <CJK>
     (?$BFy(B . ?\x8089)  ;; <CJK>
     (?$BFz(B . ?\x8679)  ;; <CJK>
     (?$BF{(B . ?\x5EFF)  ;; <CJK>
     (?$BF|(B . ?\x65E5)  ;; <CJK>
     (?$BF}(B . ?\x4E73)  ;; <CJK>
     (?$BF~(B . ?\x5165)  ;; <CJK>
     (?$BG!(B . ?\x5982)  ;; <CJK>
     (?$BG"(B . ?\x5C3F)  ;; <CJK>
     (?$BG#(B . ?\x97EE)  ;; <CJK>
     (?$BG$(B . ?\x4EFB)  ;; <CJK>
     (?$BG%(B . ?\x598A)  ;; <CJK>
     (?$BG&(B . ?\x5FCD)  ;; <CJK>
     (?$BG'(B . ?\x8A8D)  ;; <CJK>
     (?$BG((B . ?\x6FE1)  ;; <CJK>
     (?$BG)(B . ?\x79B0)  ;; <CJK>
     (?$BG*(B . ?\x7962)  ;; <CJK>
     (?$BG+(B . ?\x5BE7)  ;; <CJK>
     (?$BG,(B . ?\x8471)  ;; <CJK>
     (?$BG-(B . ?\x732B)  ;; <CJK>
     (?$BG.(B . ?\x71B1)  ;; <CJK>
     (?$BG/(B . ?\x5E74)  ;; <CJK>
     (?$BG0(B . ?\x5FF5)  ;; <CJK>
     (?$BG1(B . ?\x637B)  ;; <CJK>
     (?$BG2(B . ?\x649A)  ;; <CJK>
     (?$BG3(B . ?\x71C3)  ;; <CJK>
     (?$BG4(B . ?\x7C98)  ;; <CJK>
     (?$BG5(B . ?\x4E43)  ;; <CJK>
     (?$BG6(B . ?\x5EFC)  ;; <CJK>
     (?$BG7(B . ?\x4E4B)  ;; <CJK>
     (?$BG8(B . ?\x57DC)  ;; <CJK>
     (?$BG9(B . ?\x56A2)  ;; <CJK>
     (?$BG:(B . ?\x60A9)  ;; <CJK>
     (?$BG;(B . ?\x6FC3)  ;; <CJK>
     (?$BG<(B . ?\x7D0D)  ;; <CJK>
     (?$BG=(B . ?\x80FD)  ;; <CJK>
     (?$BG>(B . ?\x8133)  ;; <CJK>
     (?$BG?(B . ?\x81BF)  ;; <CJK>
     (?$BG@(B . ?\x8FB2)  ;; <CJK>
     (?$BGA(B . ?\x8997)  ;; <CJK>
     (?$BGB(B . ?\x86A4)  ;; <CJK>
     (?$BGC(B . ?\x5DF4)  ;; <CJK>
     (?$BGD(B . ?\x628A)  ;; <CJK>
     (?$BGE(B . ?\x64AD)  ;; <CJK>
     (?$BGF(B . ?\x8987)  ;; <CJK>
     (?$BGG(B . ?\x6777)  ;; <CJK>
     (?$BGH(B . ?\x6CE2)  ;; <CJK>
     (?$BGI(B . ?\x6D3E)  ;; <CJK>
     (?$BGJ(B . ?\x7436)  ;; <CJK>
     (?$BGK(B . ?\x7834)  ;; <CJK>
     (?$BGL(B . ?\x5A46)  ;; <CJK>
     (?$BGM(B . ?\x7F75)  ;; <CJK>
     (?$BGN(B . ?\x82AD)  ;; <CJK>
     (?$BGO(B . ?\x99AC)  ;; <CJK>
     (?$BGP(B . ?\x4FF3)  ;; <CJK>
     (?$BGQ(B . ?\x5EC3)  ;; <CJK>
     (?$BGR(B . ?\x62DD)  ;; <CJK>
     (?$BGS(B . ?\x6392)  ;; <CJK>
     (?$BGT(B . ?\x6557)  ;; <CJK>
     (?$BGU(B . ?\x676F)  ;; <CJK>
     (?$BGV(B . ?\x76C3)  ;; <CJK>
     (?$BGW(B . ?\x724C)  ;; <CJK>
     (?$BGX(B . ?\x80CC)  ;; <CJK>
     (?$BGY(B . ?\x80BA)  ;; <CJK>
     (?$BGZ(B . ?\x8F29)  ;; <CJK>
     (?$BG[(B . ?\x914D)  ;; <CJK>
     (?$BG\(B . ?\x500D)  ;; <CJK>
     (?$BG](B . ?\x57F9)  ;; <CJK>
     (?$BG^(B . ?\x5A92)  ;; <CJK>
     (?$BG_(B . ?\x6885)  ;; <CJK>
     (?$BG`(B . ?\x6973)  ;; <CJK>
     (?$BGa(B . ?\x7164)  ;; <CJK>
     (?$BGb(B . ?\x72FD)  ;; <CJK>
     (?$BGc(B . ?\x8CB7)  ;; <CJK>
     (?$BGd(B . ?\x58F2)  ;; <CJK>
     (?$BGe(B . ?\x8CE0)  ;; <CJK>
     (?$BGf(B . ?\x966A)  ;; <CJK>
     (?$BGg(B . ?\x9019)  ;; <CJK>
     (?$BGh(B . ?\x877F)  ;; <CJK>
     (?$BGi(B . ?\x79E4)  ;; <CJK>
     (?$BGj(B . ?\x77E7)  ;; <CJK>
     (?$BGk(B . ?\x8429)  ;; <CJK>
     (?$BGl(B . ?\x4F2F)  ;; <CJK>
     (?$BGm(B . ?\x5265)  ;; <CJK>
     (?$BGn(B . ?\x535A)  ;; <CJK>
     (?$BGo(B . ?\x62CD)  ;; <CJK>
     (?$BGp(B . ?\x67CF)  ;; <CJK>
     (?$BGq(B . ?\x6CCA)  ;; <CJK>
     (?$BGr(B . ?\x767D)  ;; <CJK>
     (?$BGs(B . ?\x7B94)  ;; <CJK>
     (?$BGt(B . ?\x7C95)  ;; <CJK>
     (?$BGu(B . ?\x8236)  ;; <CJK>
     (?$BGv(B . ?\x8584)  ;; <CJK>
     (?$BGw(B . ?\x8FEB)  ;; <CJK>
     (?$BGx(B . ?\x66DD)  ;; <CJK>
     (?$BGy(B . ?\x6F20)  ;; <CJK>
     (?$BGz(B . ?\x7206)  ;; <CJK>
     (?$BG{(B . ?\x7E1B)  ;; <CJK>
     (?$BG|(B . ?\x83AB)  ;; <CJK>
     (?$BG}(B . ?\x99C1)  ;; <CJK>
     (?$BG~(B . ?\x9EA6)  ;; <CJK>
     (?$BH!(B . ?\x51FD)  ;; <CJK>
     (?$BH"(B . ?\x7BB1)  ;; <CJK>
     (?$BH#(B . ?\x7872)  ;; <CJK>
     (?$BH$(B . ?\x7BB8)  ;; <CJK>
     (?$BH%(B . ?\x8087)  ;; <CJK>
     (?$BH&(B . ?\x7B48)  ;; <CJK>
     (?$BH'(B . ?\x6AE8)  ;; <CJK>
     (?$BH((B . ?\x5E61)  ;; <CJK>
     (?$BH)(B . ?\x808C)  ;; <CJK>
     (?$BH*(B . ?\x7551)  ;; <CJK>
     (?$BH+(B . ?\x7560)  ;; <CJK>
     (?$BH,(B . ?\x516B)  ;; <CJK>
     (?$BH-(B . ?\x9262)  ;; <CJK>
     (?$BH.(B . ?\x6E8C)  ;; <CJK>
     (?$BH/(B . ?\x767A)  ;; <CJK>
     (?$BH0(B . ?\x9197)  ;; <CJK>
     (?$BH1(B . ?\x9AEA)  ;; <CJK>
     (?$BH2(B . ?\x4F10)  ;; <CJK>
     (?$BH3(B . ?\x7F70)  ;; <CJK>
     (?$BH4(B . ?\x629C)  ;; <CJK>
     (?$BH5(B . ?\x7B4F)  ;; <CJK>
     (?$BH6(B . ?\x95A5)  ;; <CJK>
     (?$BH7(B . ?\x9CE9)  ;; <CJK>
     (?$BH8(B . ?\x567A)  ;; <CJK>
     (?$BH9(B . ?\x5859)  ;; <CJK>
     (?$BH:(B . ?\x86E4)  ;; <CJK>
     (?$BH;(B . ?\x96BC)  ;; <CJK>
     (?$BH<(B . ?\x4F34)  ;; <CJK>
     (?$BH=(B . ?\x5224)  ;; <CJK>
     (?$BH>(B . ?\x534A)  ;; <CJK>
     (?$BH?(B . ?\x53CD)  ;; <CJK>
     (?$BH@(B . ?\x53DB)  ;; <CJK>
     (?$BHA(B . ?\x5E06)  ;; <CJK>
     (?$BHB(B . ?\x642C)  ;; <CJK>
     (?$BHC(B . ?\x6591)  ;; <CJK>
     (?$BHD(B . ?\x677F)  ;; <CJK>
     (?$BHE(B . ?\x6C3E)  ;; <CJK>
     (?$BHF(B . ?\x6C4E)  ;; <CJK>
     (?$BHG(B . ?\x7248)  ;; <CJK>
     (?$BHH(B . ?\x72AF)  ;; <CJK>
     (?$BHI(B . ?\x73ED)  ;; <CJK>
     (?$BHJ(B . ?\x7554)  ;; <CJK>
     (?$BHK(B . ?\x7E41)  ;; <CJK>
     (?$BHL(B . ?\x822C)  ;; <CJK>
     (?$BHM(B . ?\x85E9)  ;; <CJK>
     (?$BHN(B . ?\x8CA9)  ;; <CJK>
     (?$BHO(B . ?\x7BC4)  ;; <CJK>
     (?$BHP(B . ?\x91C6)  ;; <CJK>
     (?$BHQ(B . ?\x7169)  ;; <CJK>
     (?$BHR(B . ?\x9812)  ;; <CJK>
     (?$BHS(B . ?\x98EF)  ;; <CJK>
     (?$BHT(B . ?\x633D)  ;; <CJK>
     (?$BHU(B . ?\x6669)  ;; <CJK>
     (?$BHV(B . ?\x756A)  ;; <CJK>
     (?$BHW(B . ?\x76E4)  ;; <CJK>
     (?$BHX(B . ?\x78D0)  ;; <CJK>
     (?$BHY(B . ?\x8543)  ;; <CJK>
     (?$BHZ(B . ?\x86EE)  ;; <CJK>
     (?$BH[(B . ?\x532A)  ;; <CJK>
     (?$BH\(B . ?\x5351)  ;; <CJK>
     (?$BH](B . ?\x5426)  ;; <CJK>
     (?$BH^(B . ?\x5983)  ;; <CJK>
     (?$BH_(B . ?\x5E87)  ;; <CJK>
     (?$BH`(B . ?\x5F7C)  ;; <CJK>
     (?$BHa(B . ?\x60B2)  ;; <CJK>
     (?$BHb(B . ?\x6249)  ;; <CJK>
     (?$BHc(B . ?\x6279)  ;; <CJK>
     (?$BHd(B . ?\x62AB)  ;; <CJK>
     (?$BHe(B . ?\x6590)  ;; <CJK>
     (?$BHf(B . ?\x6BD4)  ;; <CJK>
     (?$BHg(B . ?\x6CCC)  ;; <CJK>
     (?$BHh(B . ?\x75B2)  ;; <CJK>
     (?$BHi(B . ?\x76AE)  ;; <CJK>
     (?$BHj(B . ?\x7891)  ;; <CJK>
     (?$BHk(B . ?\x79D8)  ;; <CJK>
     (?$BHl(B . ?\x7DCB)  ;; <CJK>
     (?$BHm(B . ?\x7F77)  ;; <CJK>
     (?$BHn(B . ?\x80A5)  ;; <CJK>
     (?$BHo(B . ?\x88AB)  ;; <CJK>
     (?$BHp(B . ?\x8AB9)  ;; <CJK>
     (?$BHq(B . ?\x8CBB)  ;; <CJK>
     (?$BHr(B . ?\x907F)  ;; <CJK>
     (?$BHs(B . ?\x975E)  ;; <CJK>
     (?$BHt(B . ?\x98DB)  ;; <CJK>
     (?$BHu(B . ?\x6A0B)  ;; <CJK>
     (?$BHv(B . ?\x7C38)  ;; <CJK>
     (?$BHw(B . ?\x5099)  ;; <CJK>
     (?$BHx(B . ?\x5C3E)  ;; <CJK>
     (?$BHy(B . ?\x5FAE)  ;; <CJK>
     (?$BHz(B . ?\x6787)  ;; <CJK>
     (?$BH{(B . ?\x6BD8)  ;; <CJK>
     (?$BH|(B . ?\x7435)  ;; <CJK>
     (?$BH}(B . ?\x7709)  ;; <CJK>
     (?$BH~(B . ?\x7F8E)  ;; <CJK>
     (?$BI!(B . ?\x9F3B)  ;; <CJK>
     (?$BI"(B . ?\x67CA)  ;; <CJK>
     (?$BI#(B . ?\x7A17)  ;; <CJK>
     (?$BI$(B . ?\x5339)  ;; <CJK>
     (?$BI%(B . ?\x758B)  ;; <CJK>
     (?$BI&(B . ?\x9AED)  ;; <CJK>
     (?$BI'(B . ?\x5F66)  ;; <CJK>
     (?$BI((B . ?\x819D)  ;; <CJK>
     (?$BI)(B . ?\x83F1)  ;; <CJK>
     (?$BI*(B . ?\x8098)  ;; <CJK>
     (?$BI+(B . ?\x5F3C)  ;; <CJK>
     (?$BI,(B . ?\x5FC5)  ;; <CJK>
     (?$BI-(B . ?\x7562)  ;; <CJK>
     (?$BI.(B . ?\x7B46)  ;; <CJK>
     (?$BI/(B . ?\x903C)  ;; <CJK>
     (?$BI0(B . ?\x6867)  ;; <CJK>
     (?$BI1(B . ?\x59EB)  ;; <CJK>
     (?$BI2(B . ?\x5A9B)  ;; <CJK>
     (?$BI3(B . ?\x7D10)  ;; <CJK>
     (?$BI4(B . ?\x767E)  ;; <CJK>
     (?$BI5(B . ?\x8B2C)  ;; <CJK>
     (?$BI6(B . ?\x4FF5)  ;; <CJK>
     (?$BI7(B . ?\x5F6A)  ;; <CJK>
     (?$BI8(B . ?\x6A19)  ;; <CJK>
     (?$BI9(B . ?\x6C37)  ;; <CJK>
     (?$BI:(B . ?\x6F02)  ;; <CJK>
     (?$BI;(B . ?\x74E2)  ;; <CJK>
     (?$BI<(B . ?\x7968)  ;; <CJK>
     (?$BI=(B . ?\x8868)  ;; <CJK>
     (?$BI>(B . ?\x8A55)  ;; <CJK>
     (?$BI?(B . ?\x8C79)  ;; <CJK>
     (?$BI@(B . ?\x5EDF)  ;; <CJK>
     (?$BIA(B . ?\x63CF)  ;; <CJK>
     (?$BIB(B . ?\x75C5)  ;; <CJK>
     (?$BIC(B . ?\x79D2)  ;; <CJK>
     (?$BID(B . ?\x82D7)  ;; <CJK>
     (?$BIE(B . ?\x9328)  ;; <CJK>
     (?$BIF(B . ?\x92F2)  ;; <CJK>
     (?$BIG(B . ?\x849C)  ;; <CJK>
     (?$BIH(B . ?\x86ED)  ;; <CJK>
     (?$BII(B . ?\x9C2D)  ;; <CJK>
     (?$BIJ(B . ?\x54C1)  ;; <CJK>
     (?$BIK(B . ?\x5F6C)  ;; <CJK>
     (?$BIL(B . ?\x658C)  ;; <CJK>
     (?$BIM(B . ?\x6D5C)  ;; <CJK>
     (?$BIN(B . ?\x7015)  ;; <CJK>
     (?$BIO(B . ?\x8CA7)  ;; <CJK>
     (?$BIP(B . ?\x8CD3)  ;; <CJK>
     (?$BIQ(B . ?\x983B)  ;; <CJK>
     (?$BIR(B . ?\x654F)  ;; <CJK>
     (?$BIS(B . ?\x74F6)  ;; <CJK>
     (?$BIT(B . ?\x4E0D)  ;; <CJK>
     (?$BIU(B . ?\x4ED8)  ;; <CJK>
     (?$BIV(B . ?\x57E0)  ;; <CJK>
     (?$BIW(B . ?\x592B)  ;; <CJK>
     (?$BIX(B . ?\x5A66)  ;; <CJK>
     (?$BIY(B . ?\x5BCC)  ;; <CJK>
     (?$BIZ(B . ?\x51A8)  ;; <CJK>
     (?$BI[(B . ?\x5E03)  ;; <CJK>
     (?$BI\(B . ?\x5E9C)  ;; <CJK>
     (?$BI](B . ?\x6016)  ;; <CJK>
     (?$BI^(B . ?\x6276)  ;; <CJK>
     (?$BI_(B . ?\x6577)  ;; <CJK>
     (?$BI`(B . ?\x65A7)  ;; <CJK>
     (?$BIa(B . ?\x666E)  ;; <CJK>
     (?$BIb(B . ?\x6D6E)  ;; <CJK>
     (?$BIc(B . ?\x7236)  ;; <CJK>
     (?$BId(B . ?\x7B26)  ;; <CJK>
     (?$BIe(B . ?\x8150)  ;; <CJK>
     (?$BIf(B . ?\x819A)  ;; <CJK>
     (?$BIg(B . ?\x8299)  ;; <CJK>
     (?$BIh(B . ?\x8B5C)  ;; <CJK>
     (?$BIi(B . ?\x8CA0)  ;; <CJK>
     (?$BIj(B . ?\x8CE6)  ;; <CJK>
     (?$BIk(B . ?\x8D74)  ;; <CJK>
     (?$BIl(B . ?\x961C)  ;; <CJK>
     (?$BIm(B . ?\x9644)  ;; <CJK>
     (?$BIn(B . ?\x4FAE)  ;; <CJK>
     (?$BIo(B . ?\x64AB)  ;; <CJK>
     (?$BIp(B . ?\x6B66)  ;; <CJK>
     (?$BIq(B . ?\x821E)  ;; <CJK>
     (?$BIr(B . ?\x8461)  ;; <CJK>
     (?$BIs(B . ?\x856A)  ;; <CJK>
     (?$BIt(B . ?\x90E8)  ;; <CJK>
     (?$BIu(B . ?\x5C01)  ;; <CJK>
     (?$BIv(B . ?\x6953)  ;; <CJK>
     (?$BIw(B . ?\x98A8)  ;; <CJK>
     (?$BIx(B . ?\x847A)  ;; <CJK>
     (?$BIy(B . ?\x8557)  ;; <CJK>
     (?$BIz(B . ?\x4F0F)  ;; <CJK>
     (?$BI{(B . ?\x526F)  ;; <CJK>
     (?$BI|(B . ?\x5FA9)  ;; <CJK>
     (?$BI}(B . ?\x5E45)  ;; <CJK>
     (?$BI~(B . ?\x670D)  ;; <CJK>
     (?$BJ!(B . ?\x798F)  ;; <CJK>
     (?$BJ"(B . ?\x8179)  ;; <CJK>
     (?$BJ#(B . ?\x8907)  ;; <CJK>
     (?$BJ$(B . ?\x8986)  ;; <CJK>
     (?$BJ%(B . ?\x6DF5)  ;; <CJK>
     (?$BJ&(B . ?\x5F17)  ;; <CJK>
     (?$BJ'(B . ?\x6255)  ;; <CJK>
     (?$BJ((B . ?\x6CB8)  ;; <CJK>
     (?$BJ)(B . ?\x4ECF)  ;; <CJK>
     (?$BJ*(B . ?\x7269)  ;; <CJK>
     (?$BJ+(B . ?\x9B92)  ;; <CJK>
     (?$BJ,(B . ?\x5206)  ;; <CJK>
     (?$BJ-(B . ?\x543B)  ;; <CJK>
     (?$BJ.(B . ?\x5674)  ;; <CJK>
     (?$BJ/(B . ?\x58B3)  ;; <CJK>
     (?$BJ0(B . ?\x61A4)  ;; <CJK>
     (?$BJ1(B . ?\x626E)  ;; <CJK>
     (?$BJ2(B . ?\x711A)  ;; <CJK>
     (?$BJ3(B . ?\x596E)  ;; <CJK>
     (?$BJ4(B . ?\x7C89)  ;; <CJK>
     (?$BJ5(B . ?\x7CDE)  ;; <CJK>
     (?$BJ6(B . ?\x7D1B)  ;; <CJK>
     (?$BJ7(B . ?\x96F0)  ;; <CJK>
     (?$BJ8(B . ?\x6587)  ;; <CJK>
     (?$BJ9(B . ?\x805E)  ;; <CJK>
     (?$BJ:(B . ?\x4E19)  ;; <CJK>
     (?$BJ;(B . ?\x4F75)  ;; <CJK>
     (?$BJ<(B . ?\x5175)  ;; <CJK>
     (?$BJ=(B . ?\x5840)  ;; <CJK>
     (?$BJ>(B . ?\x5E63)  ;; <CJK>
     (?$BJ?(B . ?\x5E73)  ;; <CJK>
     (?$BJ@(B . ?\x5F0A)  ;; <CJK>
     (?$BJA(B . ?\x67C4)  ;; <CJK>
     (?$BJB(B . ?\x4E26)  ;; <CJK>
     (?$BJC(B . ?\x853D)  ;; <CJK>
     (?$BJD(B . ?\x9589)  ;; <CJK>
     (?$BJE(B . ?\x965B)  ;; <CJK>
     (?$BJF(B . ?\x7C73)  ;; <CJK>
     (?$BJG(B . ?\x9801)  ;; <CJK>
     (?$BJH(B . ?\x50FB)  ;; <CJK>
     (?$BJI(B . ?\x58C1)  ;; <CJK>
     (?$BJJ(B . ?\x7656)  ;; <CJK>
     (?$BJK(B . ?\x78A7)  ;; <CJK>
     (?$BJL(B . ?\x5225)  ;; <CJK>
     (?$BJM(B . ?\x77A5)  ;; <CJK>
     (?$BJN(B . ?\x8511)  ;; <CJK>
     (?$BJO(B . ?\x7B86)  ;; <CJK>
     (?$BJP(B . ?\x504F)  ;; <CJK>
     (?$BJQ(B . ?\x5909)  ;; <CJK>
     (?$BJR(B . ?\x7247)  ;; <CJK>
     (?$BJS(B . ?\x7BC7)  ;; <CJK>
     (?$BJT(B . ?\x7DE8)  ;; <CJK>
     (?$BJU(B . ?\x8FBA)  ;; <CJK>
     (?$BJV(B . ?\x8FD4)  ;; <CJK>
     (?$BJW(B . ?\x904D)  ;; <CJK>
     (?$BJX(B . ?\x4FBF)  ;; <CJK>
     (?$BJY(B . ?\x52C9)  ;; <CJK>
     (?$BJZ(B . ?\x5A29)  ;; <CJK>
     (?$BJ[(B . ?\x5F01)  ;; <CJK>
     (?$BJ\(B . ?\x97AD)  ;; <CJK>
     (?$BJ](B . ?\x4FDD)  ;; <CJK>
     (?$BJ^(B . ?\x8217)  ;; <CJK>
     (?$BJ_(B . ?\x92EA)  ;; <CJK>
     (?$BJ`(B . ?\x5703)  ;; <CJK>
     (?$BJa(B . ?\x6355)  ;; <CJK>
     (?$BJb(B . ?\x6B69)  ;; <CJK>
     (?$BJc(B . ?\x752B)  ;; <CJK>
     (?$BJd(B . ?\x88DC)  ;; <CJK>
     (?$BJe(B . ?\x8F14)  ;; <CJK>
     (?$BJf(B . ?\x7A42)  ;; <CJK>
     (?$BJg(B . ?\x52DF)  ;; <CJK>
     (?$BJh(B . ?\x5893)  ;; <CJK>
     (?$BJi(B . ?\x6155)  ;; <CJK>
     (?$BJj(B . ?\x620A)  ;; <CJK>
     (?$BJk(B . ?\x66AE)  ;; <CJK>
     (?$BJl(B . ?\x6BCD)  ;; <CJK>
     (?$BJm(B . ?\x7C3F)  ;; <CJK>
     (?$BJn(B . ?\x83E9)  ;; <CJK>
     (?$BJo(B . ?\x5023)  ;; <CJK>
     (?$BJp(B . ?\x4FF8)  ;; <CJK>
     (?$BJq(B . ?\x5305)  ;; <CJK>
     (?$BJr(B . ?\x5446)  ;; <CJK>
     (?$BJs(B . ?\x5831)  ;; <CJK>
     (?$BJt(B . ?\x5949)  ;; <CJK>
     (?$BJu(B . ?\x5B9D)  ;; <CJK>
     (?$BJv(B . ?\x5CF0)  ;; <CJK>
     (?$BJw(B . ?\x5CEF)  ;; <CJK>
     (?$BJx(B . ?\x5D29)  ;; <CJK>
     (?$BJy(B . ?\x5E96)  ;; <CJK>
     (?$BJz(B . ?\x62B1)  ;; <CJK>
     (?$BJ{(B . ?\x6367)  ;; <CJK>
     (?$BJ|(B . ?\x653E)  ;; <CJK>
     (?$BJ}(B . ?\x65B9)  ;; <CJK>
     (?$BJ~(B . ?\x670B)  ;; <CJK>
     (?$BK!(B . ?\x6CD5)  ;; <CJK>
     (?$BK"(B . ?\x6CE1)  ;; <CJK>
     (?$BK#(B . ?\x70F9)  ;; <CJK>
     (?$BK$(B . ?\x7832)  ;; <CJK>
     (?$BK%(B . ?\x7E2B)  ;; <CJK>
     (?$BK&(B . ?\x80DE)  ;; <CJK>
     (?$BK'(B . ?\x82B3)  ;; <CJK>
     (?$BK((B . ?\x840C)  ;; <CJK>
     (?$BK)(B . ?\x84EC)  ;; <CJK>
     (?$BK*(B . ?\x8702)  ;; <CJK>
     (?$BK+(B . ?\x8912)  ;; <CJK>
     (?$BK,(B . ?\x8A2A)  ;; <CJK>
     (?$BK-(B . ?\x8C4A)  ;; <CJK>
     (?$BK.(B . ?\x90A6)  ;; <CJK>
     (?$BK/(B . ?\x92D2)  ;; <CJK>
     (?$BK0(B . ?\x98FD)  ;; <CJK>
     (?$BK1(B . ?\x9CF3)  ;; <CJK>
     (?$BK2(B . ?\x9D6C)  ;; <CJK>
     (?$BK3(B . ?\x4E4F)  ;; <CJK>
     (?$BK4(B . ?\x4EA1)  ;; <CJK>
     (?$BK5(B . ?\x508D)  ;; <CJK>
     (?$BK6(B . ?\x5256)  ;; <CJK>
     (?$BK7(B . ?\x574A)  ;; <CJK>
     (?$BK8(B . ?\x59A8)  ;; <CJK>
     (?$BK9(B . ?\x5E3D)  ;; <CJK>
     (?$BK:(B . ?\x5FD8)  ;; <CJK>
     (?$BK;(B . ?\x5FD9)  ;; <CJK>
     (?$BK<(B . ?\x623F)  ;; <CJK>
     (?$BK=(B . ?\x66B4)  ;; <CJK>
     (?$BK>(B . ?\x671B)  ;; <CJK>
     (?$BK?(B . ?\x67D0)  ;; <CJK>
     (?$BK@(B . ?\x68D2)  ;; <CJK>
     (?$BKA(B . ?\x5192)  ;; <CJK>
     (?$BKB(B . ?\x7D21)  ;; <CJK>
     (?$BKC(B . ?\x80AA)  ;; <CJK>
     (?$BKD(B . ?\x81A8)  ;; <CJK>
     (?$BKE(B . ?\x8B00)  ;; <CJK>
     (?$BKF(B . ?\x8C8C)  ;; <CJK>
     (?$BKG(B . ?\x8CBF)  ;; <CJK>
     (?$BKH(B . ?\x927E)  ;; <CJK>
     (?$BKI(B . ?\x9632)  ;; <CJK>
     (?$BKJ(B . ?\x5420)  ;; <CJK>
     (?$BKK(B . ?\x982C)  ;; <CJK>
     (?$BKL(B . ?\x5317)  ;; <CJK>
     (?$BKM(B . ?\x50D5)  ;; <CJK>
     (?$BKN(B . ?\x535C)  ;; <CJK>
     (?$BKO(B . ?\x58A8)  ;; <CJK>
     (?$BKP(B . ?\x64B2)  ;; <CJK>
     (?$BKQ(B . ?\x6734)  ;; <CJK>
     (?$BKR(B . ?\x7267)  ;; <CJK>
     (?$BKS(B . ?\x7766)  ;; <CJK>
     (?$BKT(B . ?\x7A46)  ;; <CJK>
     (?$BKU(B . ?\x91E6)  ;; <CJK>
     (?$BKV(B . ?\x52C3)  ;; <CJK>
     (?$BKW(B . ?\x6CA1)  ;; <CJK>
     (?$BKX(B . ?\x6B86)  ;; <CJK>
     (?$BKY(B . ?\x5800)  ;; <CJK>
     (?$BKZ(B . ?\x5E4C)  ;; <CJK>
     (?$BK[(B . ?\x5954)  ;; <CJK>
     (?$BK\(B . ?\x672C)  ;; <CJK>
     (?$BK](B . ?\x7FFB)  ;; <CJK>
     (?$BK^(B . ?\x51E1)  ;; <CJK>
     (?$BK_(B . ?\x76C6)  ;; <CJK>
     (?$BK`(B . ?\x6469)  ;; <CJK>
     (?$BKa(B . ?\x78E8)  ;; <CJK>
     (?$BKb(B . ?\x9B54)  ;; <CJK>
     (?$BKc(B . ?\x9EBB)  ;; <CJK>
     (?$BKd(B . ?\x57CB)  ;; <CJK>
     (?$BKe(B . ?\x59B9)  ;; <CJK>
     (?$BKf(B . ?\x6627)  ;; <CJK>
     (?$BKg(B . ?\x679A)  ;; <CJK>
     (?$BKh(B . ?\x6BCE)  ;; <CJK>
     (?$BKi(B . ?\x54E9)  ;; <CJK>
     (?$BKj(B . ?\x69D9)  ;; <CJK>
     (?$BKk(B . ?\x5E55)  ;; <CJK>
     (?$BKl(B . ?\x819C)  ;; <CJK>
     (?$BKm(B . ?\x6795)  ;; <CJK>
     (?$BKn(B . ?\x9BAA)  ;; <CJK>
     (?$BKo(B . ?\x67FE)  ;; <CJK>
     (?$BKp(B . ?\x9C52)  ;; <CJK>
     (?$BKq(B . ?\x685D)  ;; <CJK>
     (?$BKr(B . ?\x4EA6)  ;; <CJK>
     (?$BKs(B . ?\x4FE3)  ;; <CJK>
     (?$BKt(B . ?\x53C8)  ;; <CJK>
     (?$BKu(B . ?\x62B9)  ;; <CJK>
     (?$BKv(B . ?\x672B)  ;; <CJK>
     (?$BKw(B . ?\x6CAB)  ;; <CJK>
     (?$BKx(B . ?\x8FC4)  ;; <CJK>
     (?$BKy(B . ?\x4FAD)  ;; <CJK>
     (?$BKz(B . ?\x7E6D)  ;; <CJK>
     (?$BK{(B . ?\x9EBF)  ;; <CJK>
     (?$BK|(B . ?\x4E07)  ;; <CJK>
     (?$BK}(B . ?\x6162)  ;; <CJK>
     (?$BK~(B . ?\x6E80)  ;; <CJK>
     (?$BL!(B . ?\x6F2B)  ;; <CJK>
     (?$BL"(B . ?\x8513)  ;; <CJK>
     (?$BL#(B . ?\x5473)  ;; <CJK>
     (?$BL$(B . ?\x672A)  ;; <CJK>
     (?$BL%(B . ?\x9B45)  ;; <CJK>
     (?$BL&(B . ?\x5DF3)  ;; <CJK>
     (?$BL'(B . ?\x7B95)  ;; <CJK>
     (?$BL((B . ?\x5CAC)  ;; <CJK>
     (?$BL)(B . ?\x5BC6)  ;; <CJK>
     (?$BL*(B . ?\x871C)  ;; <CJK>
     (?$BL+(B . ?\x6E4A)  ;; <CJK>
     (?$BL,(B . ?\x84D1)  ;; <CJK>
     (?$BL-(B . ?\x7A14)  ;; <CJK>
     (?$BL.(B . ?\x8108)  ;; <CJK>
     (?$BL/(B . ?\x5999)  ;; <CJK>
     (?$BL0(B . ?\x7C8D)  ;; <CJK>
     (?$BL1(B . ?\x6C11)  ;; <CJK>
     (?$BL2(B . ?\x7720)  ;; <CJK>
     (?$BL3(B . ?\x52D9)  ;; <CJK>
     (?$BL4(B . ?\x5922)  ;; <CJK>
     (?$BL5(B . ?\x7121)  ;; <CJK>
     (?$BL6(B . ?\x725F)  ;; <CJK>
     (?$BL7(B . ?\x77DB)  ;; <CJK>
     (?$BL8(B . ?\x9727)  ;; <CJK>
     (?$BL9(B . ?\x9D61)  ;; <CJK>
     (?$BL:(B . ?\x690B)  ;; <CJK>
     (?$BL;(B . ?\x5A7F)  ;; <CJK>
     (?$BL<(B . ?\x5A18)  ;; <CJK>
     (?$BL=(B . ?\x51A5)  ;; <CJK>
     (?$BL>(B . ?\x540D)  ;; <CJK>
     (?$BL?(B . ?\x547D)  ;; <CJK>
     (?$BL@(B . ?\x660E)  ;; <CJK>
     (?$BLA(B . ?\x76DF)  ;; <CJK>
     (?$BLB(B . ?\x8FF7)  ;; <CJK>
     (?$BLC(B . ?\x9298)  ;; <CJK>
     (?$BLD(B . ?\x9CF4)  ;; <CJK>
     (?$BLE(B . ?\x59EA)  ;; <CJK>
     (?$BLF(B . ?\x725D)  ;; <CJK>
     (?$BLG(B . ?\x6EC5)  ;; <CJK>
     (?$BLH(B . ?\x514D)  ;; <CJK>
     (?$BLI(B . ?\x68C9)  ;; <CJK>
     (?$BLJ(B . ?\x7DBF)  ;; <CJK>
     (?$BLK(B . ?\x7DEC)  ;; <CJK>
     (?$BLL(B . ?\x9762)  ;; <CJK>
     (?$BLM(B . ?\x9EBA)  ;; <CJK>
     (?$BLN(B . ?\x6478)  ;; <CJK>
     (?$BLO(B . ?\x6A21)  ;; <CJK>
     (?$BLP(B . ?\x8302)  ;; <CJK>
     (?$BLQ(B . ?\x5984)  ;; <CJK>
     (?$BLR(B . ?\x5B5F)  ;; <CJK>
     (?$BLS(B . ?\x6BDB)  ;; <CJK>
     (?$BLT(B . ?\x731B)  ;; <CJK>
     (?$BLU(B . ?\x76F2)  ;; <CJK>
     (?$BLV(B . ?\x7DB2)  ;; <CJK>
     (?$BLW(B . ?\x8017)  ;; <CJK>
     (?$BLX(B . ?\x8499)  ;; <CJK>
     (?$BLY(B . ?\x5132)  ;; <CJK>
     (?$BLZ(B . ?\x6728)  ;; <CJK>
     (?$BL[(B . ?\x9ED9)  ;; <CJK>
     (?$BL\(B . ?\x76EE)  ;; <CJK>
     (?$BL](B . ?\x6762)  ;; <CJK>
     (?$BL^(B . ?\x52FF)  ;; <CJK>
     (?$BL_(B . ?\x9905)  ;; <CJK>
     (?$BL`(B . ?\x5C24)  ;; <CJK>
     (?$BLa(B . ?\x623B)  ;; <CJK>
     (?$BLb(B . ?\x7C7E)  ;; <CJK>
     (?$BLc(B . ?\x8CB0)  ;; <CJK>
     (?$BLd(B . ?\x554F)  ;; <CJK>
     (?$BLe(B . ?\x60B6)  ;; <CJK>
     (?$BLf(B . ?\x7D0B)  ;; <CJK>
     (?$BLg(B . ?\x9580)  ;; <CJK>
     (?$BLh(B . ?\x5301)  ;; <CJK>
     (?$BLi(B . ?\x4E5F)  ;; <CJK>
     (?$BLj(B . ?\x51B6)  ;; <CJK>
     (?$BLk(B . ?\x591C)  ;; <CJK>
     (?$BLl(B . ?\x723A)  ;; <CJK>
     (?$BLm(B . ?\x8036)  ;; <CJK>
     (?$BLn(B . ?\x91CE)  ;; <CJK>
     (?$BLo(B . ?\x5F25)  ;; <CJK>
     (?$BLp(B . ?\x77E2)  ;; <CJK>
     (?$BLq(B . ?\x5384)  ;; <CJK>
     (?$BLr(B . ?\x5F79)  ;; <CJK>
     (?$BLs(B . ?\x7D04)  ;; <CJK>
     (?$BLt(B . ?\x85AC)  ;; <CJK>
     (?$BLu(B . ?\x8A33)  ;; <CJK>
     (?$BLv(B . ?\x8E8D)  ;; <CJK>
     (?$BLw(B . ?\x9756)  ;; <CJK>
     (?$BLx(B . ?\x67F3)  ;; <CJK>
     (?$BLy(B . ?\x85AE)  ;; <CJK>
     (?$BLz(B . ?\x9453)  ;; <CJK>
     (?$BL{(B . ?\x6109)  ;; <CJK>
     (?$BL|(B . ?\x6108)  ;; <CJK>
     (?$BL}(B . ?\x6CB9)  ;; <CJK>
     (?$BL~(B . ?\x7652)  ;; <CJK>
     (?$BM!(B . ?\x8AED)  ;; <CJK>
     (?$BM"(B . ?\x8F38)  ;; <CJK>
     (?$BM#(B . ?\x552F)  ;; <CJK>
     (?$BM$(B . ?\x4F51)  ;; <CJK>
     (?$BM%(B . ?\x512A)  ;; <CJK>
     (?$BM&(B . ?\x52C7)  ;; <CJK>
     (?$BM'(B . ?\x53CB)  ;; <CJK>
     (?$BM((B . ?\x5BA5)  ;; <CJK>
     (?$BM)(B . ?\x5E7D)  ;; <CJK>
     (?$BM*(B . ?\x60A0)  ;; <CJK>
     (?$BM+(B . ?\x6182)  ;; <CJK>
     (?$BM,(B . ?\x63D6)  ;; <CJK>
     (?$BM-(B . ?\x6709)  ;; <CJK>
     (?$BM.(B . ?\x67DA)  ;; <CJK>
     (?$BM/(B . ?\x6E67)  ;; <CJK>
     (?$BM0(B . ?\x6D8C)  ;; <CJK>
     (?$BM1(B . ?\x7336)  ;; <CJK>
     (?$BM2(B . ?\x7337)  ;; <CJK>
     (?$BM3(B . ?\x7531)  ;; <CJK>
     (?$BM4(B . ?\x7950)  ;; <CJK>
     (?$BM5(B . ?\x88D5)  ;; <CJK>
     (?$BM6(B . ?\x8A98)  ;; <CJK>
     (?$BM7(B . ?\x904A)  ;; <CJK>
     (?$BM8(B . ?\x9091)  ;; <CJK>
     (?$BM9(B . ?\x90F5)  ;; <CJK>
     (?$BM:(B . ?\x96C4)  ;; <CJK>
     (?$BM;(B . ?\x878D)  ;; <CJK>
     (?$BM<(B . ?\x5915)  ;; <CJK>
     (?$BM=(B . ?\x4E88)  ;; <CJK>
     (?$BM>(B . ?\x4F59)  ;; <CJK>
     (?$BM?(B . ?\x4E0E)  ;; <CJK>
     (?$BM@(B . ?\x8A89)  ;; <CJK>
     (?$BMA(B . ?\x8F3F)  ;; <CJK>
     (?$BMB(B . ?\x9810)  ;; <CJK>
     (?$BMC(B . ?\x50AD)  ;; <CJK>
     (?$BMD(B . ?\x5E7C)  ;; <CJK>
     (?$BME(B . ?\x5996)  ;; <CJK>
     (?$BMF(B . ?\x5BB9)  ;; <CJK>
     (?$BMG(B . ?\x5EB8)  ;; <CJK>
     (?$BMH(B . ?\x63DA)  ;; <CJK>
     (?$BMI(B . ?\x63FA)  ;; <CJK>
     (?$BMJ(B . ?\x64C1)  ;; <CJK>
     (?$BMK(B . ?\x66DC)  ;; <CJK>
     (?$BML(B . ?\x694A)  ;; <CJK>
     (?$BMM(B . ?\x69D8)  ;; <CJK>
     (?$BMN(B . ?\x6D0B)  ;; <CJK>
     (?$BMO(B . ?\x6EB6)  ;; <CJK>
     (?$BMP(B . ?\x7194)  ;; <CJK>
     (?$BMQ(B . ?\x7528)  ;; <CJK>
     (?$BMR(B . ?\x7AAF)  ;; <CJK>
     (?$BMS(B . ?\x7F8A)  ;; <CJK>
     (?$BMT(B . ?\x8000)  ;; <CJK>
     (?$BMU(B . ?\x8449)  ;; <CJK>
     (?$BMV(B . ?\x84C9)  ;; <CJK>
     (?$BMW(B . ?\x8981)  ;; <CJK>
     (?$BMX(B . ?\x8B21)  ;; <CJK>
     (?$BMY(B . ?\x8E0A)  ;; <CJK>
     (?$BMZ(B . ?\x9065)  ;; <CJK>
     (?$BM[(B . ?\x967D)  ;; <CJK>
     (?$BM\(B . ?\x990A)  ;; <CJK>
     (?$BM](B . ?\x617E)  ;; <CJK>
     (?$BM^(B . ?\x6291)  ;; <CJK>
     (?$BM_(B . ?\x6B32)  ;; <CJK>
     (?$BM`(B . ?\x6C83)  ;; <CJK>
     (?$BMa(B . ?\x6D74)  ;; <CJK>
     (?$BMb(B . ?\x7FCC)  ;; <CJK>
     (?$BMc(B . ?\x7FFC)  ;; <CJK>
     (?$BMd(B . ?\x6DC0)  ;; <CJK>
     (?$BMe(B . ?\x7F85)  ;; <CJK>
     (?$BMf(B . ?\x87BA)  ;; <CJK>
     (?$BMg(B . ?\x88F8)  ;; <CJK>
     (?$BMh(B . ?\x6765)  ;; <CJK>
     (?$BMi(B . ?\x83B1)  ;; <CJK>
     (?$BMj(B . ?\x983C)  ;; <CJK>
     (?$BMk(B . ?\x96F7)  ;; <CJK>
     (?$BMl(B . ?\x6D1B)  ;; <CJK>
     (?$BMm(B . ?\x7D61)  ;; <CJK>
     (?$BMn(B . ?\x843D)  ;; <CJK>
     (?$BMo(B . ?\x916A)  ;; <CJK>
     (?$BMp(B . ?\x4E71)  ;; <CJK>
     (?$BMq(B . ?\x5375)  ;; <CJK>
     (?$BMr(B . ?\x5D50)  ;; <CJK>
     (?$BMs(B . ?\x6B04)  ;; <CJK>
     (?$BMt(B . ?\x6FEB)  ;; <CJK>
     (?$BMu(B . ?\x85CD)  ;; <CJK>
     (?$BMv(B . ?\x862D)  ;; <CJK>
     (?$BMw(B . ?\x89A7)  ;; <CJK>
     (?$BMx(B . ?\x5229)  ;; <CJK>
     (?$BMy(B . ?\x540F)  ;; <CJK>
     (?$BMz(B . ?\x5C65)  ;; <CJK>
     (?$BM{(B . ?\x674E)  ;; <CJK>
     (?$BM|(B . ?\x68A8)  ;; <CJK>
     (?$BM}(B . ?\x7406)  ;; <CJK>
     (?$BM~(B . ?\x7483)  ;; <CJK>
     (?$BN!(B . ?\x75E2)  ;; <CJK>
     (?$BN"(B . ?\x88CF)  ;; <CJK>
     (?$BN#(B . ?\x88E1)  ;; <CJK>
     (?$BN$(B . ?\x91CC)  ;; <CJK>
     (?$BN%(B . ?\x96E2)  ;; <CJK>
     (?$BN&(B . ?\x9678)  ;; <CJK>
     (?$BN'(B . ?\x5F8B)  ;; <CJK>
     (?$BN((B . ?\x7387)  ;; <CJK>
     (?$BN)(B . ?\x7ACB)  ;; <CJK>
     (?$BN*(B . ?\x844E)  ;; <CJK>
     (?$BN+(B . ?\x63A0)  ;; <CJK>
     (?$BN,(B . ?\x7565)  ;; <CJK>
     (?$BN-(B . ?\x5289)  ;; <CJK>
     (?$BN.(B . ?\x6D41)  ;; <CJK>
     (?$BN/(B . ?\x6E9C)  ;; <CJK>
     (?$BN0(B . ?\x7409)  ;; <CJK>
     (?$BN1(B . ?\x7559)  ;; <CJK>
     (?$BN2(B . ?\x786B)  ;; <CJK>
     (?$BN3(B . ?\x7C92)  ;; <CJK>
     (?$BN4(B . ?\x9686)  ;; <CJK>
     (?$BN5(B . ?\x7ADC)  ;; <CJK>
     (?$BN6(B . ?\x9F8D)  ;; <CJK>
     (?$BN7(B . ?\x4FB6)  ;; <CJK>
     (?$BN8(B . ?\x616E)  ;; <CJK>
     (?$BN9(B . ?\x65C5)  ;; <CJK>
     (?$BN:(B . ?\x865C)  ;; <CJK>
     (?$BN;(B . ?\x4E86)  ;; <CJK>
     (?$BN<(B . ?\x4EAE)  ;; <CJK>
     (?$BN=(B . ?\x50DA)  ;; <CJK>
     (?$BN>(B . ?\x4E21)  ;; <CJK>
     (?$BN?(B . ?\x51CC)  ;; <CJK>
     (?$BN@(B . ?\x5BEE)  ;; <CJK>
     (?$BNA(B . ?\x6599)  ;; <CJK>
     (?$BNB(B . ?\x6881)  ;; <CJK>
     (?$BNC(B . ?\x6DBC)  ;; <CJK>
     (?$BND(B . ?\x731F)  ;; <CJK>
     (?$BNE(B . ?\x7642)  ;; <CJK>
     (?$BNF(B . ?\x77AD)  ;; <CJK>
     (?$BNG(B . ?\x7A1C)  ;; <CJK>
     (?$BNH(B . ?\x7CE7)  ;; <CJK>
     (?$BNI(B . ?\x826F)  ;; <CJK>
     (?$BNJ(B . ?\x8AD2)  ;; <CJK>
     (?$BNK(B . ?\x907C)  ;; <CJK>
     (?$BNL(B . ?\x91CF)  ;; <CJK>
     (?$BNM(B . ?\x9675)  ;; <CJK>
     (?$BNN(B . ?\x9818)  ;; <CJK>
     (?$BNO(B . ?\x529B)  ;; <CJK>
     (?$BNP(B . ?\x7DD1)  ;; <CJK>
     (?$BNQ(B . ?\x502B)  ;; <CJK>
     (?$BNR(B . ?\x5398)  ;; <CJK>
     (?$BNS(B . ?\x6797)  ;; <CJK>
     (?$BNT(B . ?\x6DCB)  ;; <CJK>
     (?$BNU(B . ?\x71D0)  ;; <CJK>
     (?$BNV(B . ?\x7433)  ;; <CJK>
     (?$BNW(B . ?\x81E8)  ;; <CJK>
     (?$BNX(B . ?\x8F2A)  ;; <CJK>
     (?$BNY(B . ?\x96A3)  ;; <CJK>
     (?$BNZ(B . ?\x9C57)  ;; <CJK>
     (?$BN[(B . ?\x9E9F)  ;; <CJK>
     (?$BN\(B . ?\x7460)  ;; <CJK>
     (?$BN](B . ?\x5841)  ;; <CJK>
     (?$BN^(B . ?\x6D99)  ;; <CJK>
     (?$BN_(B . ?\x7D2F)  ;; <CJK>
     (?$BN`(B . ?\x985E)  ;; <CJK>
     (?$BNa(B . ?\x4EE4)  ;; <CJK>
     (?$BNb(B . ?\x4F36)  ;; <CJK>
     (?$BNc(B . ?\x4F8B)  ;; <CJK>
     (?$BNd(B . ?\x51B7)  ;; <CJK>
     (?$BNe(B . ?\x52B1)  ;; <CJK>
     (?$BNf(B . ?\x5DBA)  ;; <CJK>
     (?$BNg(B . ?\x601C)  ;; <CJK>
     (?$BNh(B . ?\x73B2)  ;; <CJK>
     (?$BNi(B . ?\x793C)  ;; <CJK>
     (?$BNj(B . ?\x82D3)  ;; <CJK>
     (?$BNk(B . ?\x9234)  ;; <CJK>
     (?$BNl(B . ?\x96B7)  ;; <CJK>
     (?$BNm(B . ?\x96F6)  ;; <CJK>
     (?$BNn(B . ?\x970A)  ;; <CJK>
     (?$BNo(B . ?\x9E97)  ;; <CJK>
     (?$BNp(B . ?\x9F62)  ;; <CJK>
     (?$BNq(B . ?\x66A6)  ;; <CJK>
     (?$BNr(B . ?\x6B74)  ;; <CJK>
     (?$BNs(B . ?\x5217)  ;; <CJK>
     (?$BNt(B . ?\x52A3)  ;; <CJK>
     (?$BNu(B . ?\x70C8)  ;; <CJK>
     (?$BNv(B . ?\x88C2)  ;; <CJK>
     (?$BNw(B . ?\x5EC9)  ;; <CJK>
     (?$BNx(B . ?\x604B)  ;; <CJK>
     (?$BNy(B . ?\x6190)  ;; <CJK>
     (?$BNz(B . ?\x6F23)  ;; <CJK>
     (?$BN{(B . ?\x7149)  ;; <CJK>
     (?$BN|(B . ?\x7C3E)  ;; <CJK>
     (?$BN}(B . ?\x7DF4)  ;; <CJK>
     (?$BN~(B . ?\x806F)  ;; <CJK>
     (?$BO!(B . ?\x84EE)  ;; <CJK>
     (?$BO"(B . ?\x9023)  ;; <CJK>
     (?$BO#(B . ?\x932C)  ;; <CJK>
     (?$BO$(B . ?\x5442)  ;; <CJK>
     (?$BO%(B . ?\x9B6F)  ;; <CJK>
     (?$BO&(B . ?\x6AD3)  ;; <CJK>
     (?$BO'(B . ?\x7089)  ;; <CJK>
     (?$BO((B . ?\x8CC2)  ;; <CJK>
     (?$BO)(B . ?\x8DEF)  ;; <CJK>
     (?$BO*(B . ?\x9732)  ;; <CJK>
     (?$BO+(B . ?\x52B4)  ;; <CJK>
     (?$BO,(B . ?\x5A41)  ;; <CJK>
     (?$BO-(B . ?\x5ECA)  ;; <CJK>
     (?$BO.(B . ?\x5F04)  ;; <CJK>
     (?$BO/(B . ?\x6717)  ;; <CJK>
     (?$BO0(B . ?\x697C)  ;; <CJK>
     (?$BO1(B . ?\x6994)  ;; <CJK>
     (?$BO2(B . ?\x6D6A)  ;; <CJK>
     (?$BO3(B . ?\x6F0F)  ;; <CJK>
     (?$BO4(B . ?\x7262)  ;; <CJK>
     (?$BO5(B . ?\x72FC)  ;; <CJK>
     (?$BO6(B . ?\x7BED)  ;; <CJK>
     (?$BO7(B . ?\x8001)  ;; <CJK>
     (?$BO8(B . ?\x807E)  ;; <CJK>
     (?$BO9(B . ?\x874B)  ;; <CJK>
     (?$BO:(B . ?\x90CE)  ;; <CJK>
     (?$BO;(B . ?\x516D)  ;; <CJK>
     (?$BO<(B . ?\x9E93)  ;; <CJK>
     (?$BO=(B . ?\x7984)  ;; <CJK>
     (?$BO>(B . ?\x808B)  ;; <CJK>
     (?$BO?(B . ?\x9332)  ;; <CJK>
     (?$BO@(B . ?\x8AD6)  ;; <CJK>
     (?$BOA(B . ?\x502D)  ;; <CJK>
     (?$BOB(B . ?\x548C)  ;; <CJK>
     (?$BOC(B . ?\x8A71)  ;; <CJK>
     (?$BOD(B . ?\x6B6A)  ;; <CJK>
     (?$BOE(B . ?\x8CC4)  ;; <CJK>
     (?$BOF(B . ?\x8107)  ;; <CJK>
     (?$BOG(B . ?\x60D1)  ;; <CJK>
     (?$BOH(B . ?\x67A0)  ;; <CJK>
     (?$BOI(B . ?\x9DF2)  ;; <CJK>
     (?$BOJ(B . ?\x4E99)  ;; <CJK>
     (?$BOK(B . ?\x4E98)  ;; <CJK>
     (?$BOL(B . ?\x9C10)  ;; <CJK>
     (?$BOM(B . ?\x8A6B)  ;; <CJK>
     (?$BON(B . ?\x85C1)  ;; <CJK>
     (?$BOO(B . ?\x8568)  ;; <CJK>
     (?$BOP(B . ?\x6900)  ;; <CJK>
     (?$BOQ(B . ?\x6E7E)  ;; <CJK>
     (?$BOR(B . ?\x7897)  ;; <CJK>
     (?$BOS(B . ?\x8155)  ;; <CJK>
     (?$BP!(B . ?\x5F0C)  ;; <CJK>
     (?$BP"(B . ?\x4E10)  ;; <CJK>
     (?$BP#(B . ?\x4E15)  ;; <CJK>
     (?$BP$(B . ?\x4E2A)  ;; <CJK>
     (?$BP%(B . ?\x4E31)  ;; <CJK>
     (?$BP&(B . ?\x4E36)  ;; <CJK>
     (?$BP'(B . ?\x4E3C)  ;; <CJK>
     (?$BP((B . ?\x4E3F)  ;; <CJK>
     (?$BP)(B . ?\x4E42)  ;; <CJK>
     (?$BP*(B . ?\x4E56)  ;; <CJK>
     (?$BP+(B . ?\x4E58)  ;; <CJK>
     (?$BP,(B . ?\x4E82)  ;; <CJK>
     (?$BP-(B . ?\x4E85)  ;; <CJK>
     (?$BP.(B . ?\x8C6B)  ;; <CJK>
     (?$BP/(B . ?\x4E8A)  ;; <CJK>
     (?$BP0(B . ?\x8212)  ;; <CJK>
     (?$BP1(B . ?\x5F0D)  ;; <CJK>
     (?$BP2(B . ?\x4E8E)  ;; <CJK>
     (?$BP3(B . ?\x4E9E)  ;; <CJK>
     (?$BP4(B . ?\x4E9F)  ;; <CJK>
     (?$BP5(B . ?\x4EA0)  ;; <CJK>
     (?$BP6(B . ?\x4EA2)  ;; <CJK>
     (?$BP7(B . ?\x4EB0)  ;; <CJK>
     (?$BP8(B . ?\x4EB3)  ;; <CJK>
     (?$BP9(B . ?\x4EB6)  ;; <CJK>
     (?$BP:(B . ?\x4ECE)  ;; <CJK>
     (?$BP;(B . ?\x4ECD)  ;; <CJK>
     (?$BP<(B . ?\x4EC4)  ;; <CJK>
     (?$BP=(B . ?\x4EC6)  ;; <CJK>
     (?$BP>(B . ?\x4EC2)  ;; <CJK>
     (?$BP?(B . ?\x4ED7)  ;; <CJK>
     (?$BP@(B . ?\x4EDE)  ;; <CJK>
     (?$BPA(B . ?\x4EED)  ;; <CJK>
     (?$BPB(B . ?\x4EDF)  ;; <CJK>
     (?$BPC(B . ?\x4EF7)  ;; <CJK>
     (?$BPD(B . ?\x4F09)  ;; <CJK>
     (?$BPE(B . ?\x4F5A)  ;; <CJK>
     (?$BPF(B . ?\x4F30)  ;; <CJK>
     (?$BPG(B . ?\x4F5B)  ;; <CJK>
     (?$BPH(B . ?\x4F5D)  ;; <CJK>
     (?$BPI(B . ?\x4F57)  ;; <CJK>
     (?$BPJ(B . ?\x4F47)  ;; <CJK>
     (?$BPK(B . ?\x4F76)  ;; <CJK>
     (?$BPL(B . ?\x4F88)  ;; <CJK>
     (?$BPM(B . ?\x4F8F)  ;; <CJK>
     (?$BPN(B . ?\x4F98)  ;; <CJK>
     (?$BPO(B . ?\x4F7B)  ;; <CJK>
     (?$BPP(B . ?\x4F69)  ;; <CJK>
     (?$BPQ(B . ?\x4F70)  ;; <CJK>
     (?$BPR(B . ?\x4F91)  ;; <CJK>
     (?$BPS(B . ?\x4F6F)  ;; <CJK>
     (?$BPT(B . ?\x4F86)  ;; <CJK>
     (?$BPU(B . ?\x4F96)  ;; <CJK>
     (?$BPV(B . ?\x5118)  ;; <CJK>
     (?$BPW(B . ?\x4FD4)  ;; <CJK>
     (?$BPX(B . ?\x4FDF)  ;; <CJK>
     (?$BPY(B . ?\x4FCE)  ;; <CJK>
     (?$BPZ(B . ?\x4FD8)  ;; <CJK>
     (?$BP[(B . ?\x4FDB)  ;; <CJK>
     (?$BP\(B . ?\x4FD1)  ;; <CJK>
     (?$BP](B . ?\x4FDA)  ;; <CJK>
     (?$BP^(B . ?\x4FD0)  ;; <CJK>
     (?$BP_(B . ?\x4FE4)  ;; <CJK>
     (?$BP`(B . ?\x4FE5)  ;; <CJK>
     (?$BPa(B . ?\x501A)  ;; <CJK>
     (?$BPb(B . ?\x5028)  ;; <CJK>
     (?$BPc(B . ?\x5014)  ;; <CJK>
     (?$BPd(B . ?\x502A)  ;; <CJK>
     (?$BPe(B . ?\x5025)  ;; <CJK>
     (?$BPf(B . ?\x5005)  ;; <CJK>
     (?$BPg(B . ?\x4F1C)  ;; <CJK>
     (?$BPh(B . ?\x4FF6)  ;; <CJK>
     (?$BPi(B . ?\x5021)  ;; <CJK>
     (?$BPj(B . ?\x5029)  ;; <CJK>
     (?$BPk(B . ?\x502C)  ;; <CJK>
     (?$BPl(B . ?\x4FFE)  ;; <CJK>
     (?$BPm(B . ?\x4FEF)  ;; <CJK>
     (?$BPn(B . ?\x5011)  ;; <CJK>
     (?$BPo(B . ?\x5006)  ;; <CJK>
     (?$BPp(B . ?\x5043)  ;; <CJK>
     (?$BPq(B . ?\x5047)  ;; <CJK>
     (?$BPr(B . ?\x6703)  ;; <CJK>
     (?$BPs(B . ?\x5055)  ;; <CJK>
     (?$BPt(B . ?\x5050)  ;; <CJK>
     (?$BPu(B . ?\x5048)  ;; <CJK>
     (?$BPv(B . ?\x505A)  ;; <CJK>
     (?$BPw(B . ?\x5056)  ;; <CJK>
     (?$BPx(B . ?\x506C)  ;; <CJK>
     (?$BPy(B . ?\x5078)  ;; <CJK>
     (?$BPz(B . ?\x5080)  ;; <CJK>
     (?$BP{(B . ?\x509A)  ;; <CJK>
     (?$BP|(B . ?\x5085)  ;; <CJK>
     (?$BP}(B . ?\x50B4)  ;; <CJK>
     (?$BP~(B . ?\x50B2)  ;; <CJK>
     (?$BQ!(B . ?\x50C9)  ;; <CJK>
     (?$BQ"(B . ?\x50CA)  ;; <CJK>
     (?$BQ#(B . ?\x50B3)  ;; <CJK>
     (?$BQ$(B . ?\x50C2)  ;; <CJK>
     (?$BQ%(B . ?\x50D6)  ;; <CJK>
     (?$BQ&(B . ?\x50DE)  ;; <CJK>
     (?$BQ'(B . ?\x50E5)  ;; <CJK>
     (?$BQ((B . ?\x50ED)  ;; <CJK>
     (?$BQ)(B . ?\x50E3)  ;; <CJK>
     (?$BQ*(B . ?\x50EE)  ;; <CJK>
     (?$BQ+(B . ?\x50F9)  ;; <CJK>
     (?$BQ,(B . ?\x50F5)  ;; <CJK>
     (?$BQ-(B . ?\x5109)  ;; <CJK>
     (?$BQ.(B . ?\x5101)  ;; <CJK>
     (?$BQ/(B . ?\x5102)  ;; <CJK>
     (?$BQ0(B . ?\x5116)  ;; <CJK>
     (?$BQ1(B . ?\x5115)  ;; <CJK>
     (?$BQ2(B . ?\x5114)  ;; <CJK>
     (?$BQ3(B . ?\x511A)  ;; <CJK>
     (?$BQ4(B . ?\x5121)  ;; <CJK>
     (?$BQ5(B . ?\x513A)  ;; <CJK>
     (?$BQ6(B . ?\x5137)  ;; <CJK>
     (?$BQ7(B . ?\x513C)  ;; <CJK>
     (?$BQ8(B . ?\x513B)  ;; <CJK>
     (?$BQ9(B . ?\x513F)  ;; <CJK>
     (?$BQ:(B . ?\x5140)  ;; <CJK>
     (?$BQ;(B . ?\x5152)  ;; <CJK>
     (?$BQ<(B . ?\x514C)  ;; <CJK>
     (?$BQ=(B . ?\x5154)  ;; <CJK>
     (?$BQ>(B . ?\x5162)  ;; <CJK>
     (?$BQ?(B . ?\x7AF8)  ;; <CJK>
     (?$BQ@(B . ?\x5169)  ;; <CJK>
     (?$BQA(B . ?\x516A)  ;; <CJK>
     (?$BQB(B . ?\x516E)  ;; <CJK>
     (?$BQC(B . ?\x5180)  ;; <CJK>
     (?$BQD(B . ?\x5182)  ;; <CJK>
     (?$BQE(B . ?\x56D8)  ;; <CJK>
     (?$BQF(B . ?\x518C)  ;; <CJK>
     (?$BQG(B . ?\x5189)  ;; <CJK>
     (?$BQH(B . ?\x518F)  ;; <CJK>
     (?$BQI(B . ?\x5191)  ;; <CJK>
     (?$BQJ(B . ?\x5193)  ;; <CJK>
     (?$BQK(B . ?\x5195)  ;; <CJK>
     (?$BQL(B . ?\x5196)  ;; <CJK>
     (?$BQM(B . ?\x51A4)  ;; <CJK>
     (?$BQN(B . ?\x51A6)  ;; <CJK>
     (?$BQO(B . ?\x51A2)  ;; <CJK>
     (?$BQP(B . ?\x51A9)  ;; <CJK>
     (?$BQQ(B . ?\x51AA)  ;; <CJK>
     (?$BQR(B . ?\x51AB)  ;; <CJK>
     (?$BQS(B . ?\x51B3)  ;; <CJK>
     (?$BQT(B . ?\x51B1)  ;; <CJK>
     (?$BQU(B . ?\x51B2)  ;; <CJK>
     (?$BQV(B . ?\x51B0)  ;; <CJK>
     (?$BQW(B . ?\x51B5)  ;; <CJK>
     (?$BQX(B . ?\x51BD)  ;; <CJK>
     (?$BQY(B . ?\x51C5)  ;; <CJK>
     (?$BQZ(B . ?\x51C9)  ;; <CJK>
     (?$BQ[(B . ?\x51DB)  ;; <CJK>
     (?$BQ\(B . ?\x51E0)  ;; <CJK>
     (?$BQ](B . ?\x8655)  ;; <CJK>
     (?$BQ^(B . ?\x51E9)  ;; <CJK>
     (?$BQ_(B . ?\x51ED)  ;; <CJK>
     (?$BQ`(B . ?\x51F0)  ;; <CJK>
     (?$BQa(B . ?\x51F5)  ;; <CJK>
     (?$BQb(B . ?\x51FE)  ;; <CJK>
     (?$BQc(B . ?\x5204)  ;; <CJK>
     (?$BQd(B . ?\x520B)  ;; <CJK>
     (?$BQe(B . ?\x5214)  ;; <CJK>
     (?$BQf(B . ?\x520E)  ;; <CJK>
     (?$BQg(B . ?\x5227)  ;; <CJK>
     (?$BQh(B . ?\x522A)  ;; <CJK>
     (?$BQi(B . ?\x522E)  ;; <CJK>
     (?$BQj(B . ?\x5233)  ;; <CJK>
     (?$BQk(B . ?\x5239)  ;; <CJK>
     (?$BQl(B . ?\x524F)  ;; <CJK>
     (?$BQm(B . ?\x5244)  ;; <CJK>
     (?$BQn(B . ?\x524B)  ;; <CJK>
     (?$BQo(B . ?\x524C)  ;; <CJK>
     (?$BQp(B . ?\x525E)  ;; <CJK>
     (?$BQq(B . ?\x5254)  ;; <CJK>
     (?$BQr(B . ?\x526A)  ;; <CJK>
     (?$BQs(B . ?\x5274)  ;; <CJK>
     (?$BQt(B . ?\x5269)  ;; <CJK>
     (?$BQu(B . ?\x5273)  ;; <CJK>
     (?$BQv(B . ?\x527F)  ;; <CJK>
     (?$BQw(B . ?\x527D)  ;; <CJK>
     (?$BQx(B . ?\x528D)  ;; <CJK>
     (?$BQy(B . ?\x5294)  ;; <CJK>
     (?$BQz(B . ?\x5292)  ;; <CJK>
     (?$BQ{(B . ?\x5271)  ;; <CJK>
     (?$BQ|(B . ?\x5288)  ;; <CJK>
     (?$BQ}(B . ?\x5291)  ;; <CJK>
     (?$BQ~(B . ?\x8FA8)  ;; <CJK>
     (?$BR!(B . ?\x8FA7)  ;; <CJK>
     (?$BR"(B . ?\x52AC)  ;; <CJK>
     (?$BR#(B . ?\x52AD)  ;; <CJK>
     (?$BR$(B . ?\x52BC)  ;; <CJK>
     (?$BR%(B . ?\x52B5)  ;; <CJK>
     (?$BR&(B . ?\x52C1)  ;; <CJK>
     (?$BR'(B . ?\x52CD)  ;; <CJK>
     (?$BR((B . ?\x52D7)  ;; <CJK>
     (?$BR)(B . ?\x52DE)  ;; <CJK>
     (?$BR*(B . ?\x52E3)  ;; <CJK>
     (?$BR+(B . ?\x52E6)  ;; <CJK>
     (?$BR,(B . ?\x98ED)  ;; <CJK>
     (?$BR-(B . ?\x52E0)  ;; <CJK>
     (?$BR.(B . ?\x52F3)  ;; <CJK>
     (?$BR/(B . ?\x52F5)  ;; <CJK>
     (?$BR0(B . ?\x52F8)  ;; <CJK>
     (?$BR1(B . ?\x52F9)  ;; <CJK>
     (?$BR2(B . ?\x5306)  ;; <CJK>
     (?$BR3(B . ?\x5308)  ;; <CJK>
     (?$BR4(B . ?\x7538)  ;; <CJK>
     (?$BR5(B . ?\x530D)  ;; <CJK>
     (?$BR6(B . ?\x5310)  ;; <CJK>
     (?$BR7(B . ?\x530F)  ;; <CJK>
     (?$BR8(B . ?\x5315)  ;; <CJK>
     (?$BR9(B . ?\x531A)  ;; <CJK>
     (?$BR:(B . ?\x5323)  ;; <CJK>
     (?$BR;(B . ?\x532F)  ;; <CJK>
     (?$BR<(B . ?\x5331)  ;; <CJK>
     (?$BR=(B . ?\x5333)  ;; <CJK>
     (?$BR>(B . ?\x5338)  ;; <CJK>
     (?$BR?(B . ?\x5340)  ;; <CJK>
     (?$BR@(B . ?\x5346)  ;; <CJK>
     (?$BRA(B . ?\x5345)  ;; <CJK>
     (?$BRB(B . ?\x4E17)  ;; <CJK>
     (?$BRC(B . ?\x5349)  ;; <CJK>
     (?$BRD(B . ?\x534D)  ;; <CJK>
     (?$BRE(B . ?\x51D6)  ;; <CJK>
     (?$BRF(B . ?\x535E)  ;; <CJK>
     (?$BRG(B . ?\x5369)  ;; <CJK>
     (?$BRH(B . ?\x536E)  ;; <CJK>
     (?$BRI(B . ?\x5918)  ;; <CJK>
     (?$BRJ(B . ?\x537B)  ;; <CJK>
     (?$BRK(B . ?\x5377)  ;; <CJK>
     (?$BRL(B . ?\x5382)  ;; <CJK>
     (?$BRM(B . ?\x5396)  ;; <CJK>
     (?$BRN(B . ?\x53A0)  ;; <CJK>
     (?$BRO(B . ?\x53A6)  ;; <CJK>
     (?$BRP(B . ?\x53A5)  ;; <CJK>
     (?$BRQ(B . ?\x53AE)  ;; <CJK>
     (?$BRR(B . ?\x53B0)  ;; <CJK>
     (?$BRS(B . ?\x53B6)  ;; <CJK>
     (?$BRT(B . ?\x53C3)  ;; <CJK>
     (?$BRU(B . ?\x7C12)  ;; <CJK>
     (?$BRV(B . ?\x96D9)  ;; <CJK>
     (?$BRW(B . ?\x53DF)  ;; <CJK>
     (?$BRX(B . ?\x66FC)  ;; <CJK>
     (?$BRY(B . ?\x71EE)  ;; <CJK>
     (?$BRZ(B . ?\x53EE)  ;; <CJK>
     (?$BR[(B . ?\x53E8)  ;; <CJK>
     (?$BR\(B . ?\x53ED)  ;; <CJK>
     (?$BR](B . ?\x53FA)  ;; <CJK>
     (?$BR^(B . ?\x5401)  ;; <CJK>
     (?$BR_(B . ?\x543D)  ;; <CJK>
     (?$BR`(B . ?\x5440)  ;; <CJK>
     (?$BRa(B . ?\x542C)  ;; <CJK>
     (?$BRb(B . ?\x542D)  ;; <CJK>
     (?$BRc(B . ?\x543C)  ;; <CJK>
     (?$BRd(B . ?\x542E)  ;; <CJK>
     (?$BRe(B . ?\x5436)  ;; <CJK>
     (?$BRf(B . ?\x5429)  ;; <CJK>
     (?$BRg(B . ?\x541D)  ;; <CJK>
     (?$BRh(B . ?\x544E)  ;; <CJK>
     (?$BRi(B . ?\x548F)  ;; <CJK>
     (?$BRj(B . ?\x5475)  ;; <CJK>
     (?$BRk(B . ?\x548E)  ;; <CJK>
     (?$BRl(B . ?\x545F)  ;; <CJK>
     (?$BRm(B . ?\x5471)  ;; <CJK>
     (?$BRn(B . ?\x5477)  ;; <CJK>
     (?$BRo(B . ?\x5470)  ;; <CJK>
     (?$BRp(B . ?\x5492)  ;; <CJK>
     (?$BRq(B . ?\x547B)  ;; <CJK>
     (?$BRr(B . ?\x5480)  ;; <CJK>
     (?$BRs(B . ?\x5476)  ;; <CJK>
     (?$BRt(B . ?\x5484)  ;; <CJK>
     (?$BRu(B . ?\x5490)  ;; <CJK>
     (?$BRv(B . ?\x5486)  ;; <CJK>
     (?$BRw(B . ?\x54C7)  ;; <CJK>
     (?$BRx(B . ?\x54A2)  ;; <CJK>
     (?$BRy(B . ?\x54B8)  ;; <CJK>
     (?$BRz(B . ?\x54A5)  ;; <CJK>
     (?$BR{(B . ?\x54AC)  ;; <CJK>
     (?$BR|(B . ?\x54C4)  ;; <CJK>
     (?$BR}(B . ?\x54C8)  ;; <CJK>
     (?$BR~(B . ?\x54A8)  ;; <CJK>
     (?$BS!(B . ?\x54AB)  ;; <CJK>
     (?$BS"(B . ?\x54C2)  ;; <CJK>
     (?$BS#(B . ?\x54A4)  ;; <CJK>
     (?$BS$(B . ?\x54BE)  ;; <CJK>
     (?$BS%(B . ?\x54BC)  ;; <CJK>
     (?$BS&(B . ?\x54D8)  ;; <CJK>
     (?$BS'(B . ?\x54E5)  ;; <CJK>
     (?$BS((B . ?\x54E6)  ;; <CJK>
     (?$BS)(B . ?\x550F)  ;; <CJK>
     (?$BS*(B . ?\x5514)  ;; <CJK>
     (?$BS+(B . ?\x54FD)  ;; <CJK>
     (?$BS,(B . ?\x54EE)  ;; <CJK>
     (?$BS-(B . ?\x54ED)  ;; <CJK>
     (?$BS.(B . ?\x54FA)  ;; <CJK>
     (?$BS/(B . ?\x54E2)  ;; <CJK>
     (?$BS0(B . ?\x5539)  ;; <CJK>
     (?$BS1(B . ?\x5540)  ;; <CJK>
     (?$BS2(B . ?\x5563)  ;; <CJK>
     (?$BS3(B . ?\x554C)  ;; <CJK>
     (?$BS4(B . ?\x552E)  ;; <CJK>
     (?$BS5(B . ?\x555C)  ;; <CJK>
     (?$BS6(B . ?\x5545)  ;; <CJK>
     (?$BS7(B . ?\x5556)  ;; <CJK>
     (?$BS8(B . ?\x5557)  ;; <CJK>
     (?$BS9(B . ?\x5538)  ;; <CJK>
     (?$BS:(B . ?\x5533)  ;; <CJK>
     (?$BS;(B . ?\x555D)  ;; <CJK>
     (?$BS<(B . ?\x5599)  ;; <CJK>
     (?$BS=(B . ?\x5580)  ;; <CJK>
     (?$BS>(B . ?\x54AF)  ;; <CJK>
     (?$BS?(B . ?\x558A)  ;; <CJK>
     (?$BS@(B . ?\x559F)  ;; <CJK>
     (?$BSA(B . ?\x557B)  ;; <CJK>
     (?$BSB(B . ?\x557E)  ;; <CJK>
     (?$BSC(B . ?\x5598)  ;; <CJK>
     (?$BSD(B . ?\x559E)  ;; <CJK>
     (?$BSE(B . ?\x55AE)  ;; <CJK>
     (?$BSF(B . ?\x557C)  ;; <CJK>
     (?$BSG(B . ?\x5583)  ;; <CJK>
     (?$BSH(B . ?\x55A9)  ;; <CJK>
     (?$BSI(B . ?\x5587)  ;; <CJK>
     (?$BSJ(B . ?\x55A8)  ;; <CJK>
     (?$BSK(B . ?\x55DA)  ;; <CJK>
     (?$BSL(B . ?\x55C5)  ;; <CJK>
     (?$BSM(B . ?\x55DF)  ;; <CJK>
     (?$BSN(B . ?\x55C4)  ;; <CJK>
     (?$BSO(B . ?\x55DC)  ;; <CJK>
     (?$BSP(B . ?\x55E4)  ;; <CJK>
     (?$BSQ(B . ?\x55D4)  ;; <CJK>
     (?$BSR(B . ?\x5614)  ;; <CJK>
     (?$BSS(B . ?\x55F7)  ;; <CJK>
     (?$BST(B . ?\x5616)  ;; <CJK>
     (?$BSU(B . ?\x55FE)  ;; <CJK>
     (?$BSV(B . ?\x55FD)  ;; <CJK>
     (?$BSW(B . ?\x561B)  ;; <CJK>
     (?$BSX(B . ?\x55F9)  ;; <CJK>
     (?$BSY(B . ?\x564E)  ;; <CJK>
     (?$BSZ(B . ?\x5650)  ;; <CJK>
     (?$BS[(B . ?\x71DF)  ;; <CJK>
     (?$BS\(B . ?\x5634)  ;; <CJK>
     (?$BS](B . ?\x5636)  ;; <CJK>
     (?$BS^(B . ?\x5632)  ;; <CJK>
     (?$BS_(B . ?\x5638)  ;; <CJK>
     (?$BS`(B . ?\x566B)  ;; <CJK>
     (?$BSa(B . ?\x5664)  ;; <CJK>
     (?$BSb(B . ?\x562F)  ;; <CJK>
     (?$BSc(B . ?\x566C)  ;; <CJK>
     (?$BSd(B . ?\x566A)  ;; <CJK>
     (?$BSe(B . ?\x5686)  ;; <CJK>
     (?$BSf(B . ?\x5680)  ;; <CJK>
     (?$BSg(B . ?\x568A)  ;; <CJK>
     (?$BSh(B . ?\x56A0)  ;; <CJK>
     (?$BSi(B . ?\x5694)  ;; <CJK>
     (?$BSj(B . ?\x568F)  ;; <CJK>
     (?$BSk(B . ?\x56A5)  ;; <CJK>
     (?$BSl(B . ?\x56AE)  ;; <CJK>
     (?$BSm(B . ?\x56B6)  ;; <CJK>
     (?$BSn(B . ?\x56B4)  ;; <CJK>
     (?$BSo(B . ?\x56C2)  ;; <CJK>
     (?$BSp(B . ?\x56BC)  ;; <CJK>
     (?$BSq(B . ?\x56C1)  ;; <CJK>
     (?$BSr(B . ?\x56C3)  ;; <CJK>
     (?$BSs(B . ?\x56C0)  ;; <CJK>
     (?$BSt(B . ?\x56C8)  ;; <CJK>
     (?$BSu(B . ?\x56CE)  ;; <CJK>
     (?$BSv(B . ?\x56D1)  ;; <CJK>
     (?$BSw(B . ?\x56D3)  ;; <CJK>
     (?$BSx(B . ?\x56D7)  ;; <CJK>
     (?$BSy(B . ?\x56EE)  ;; <CJK>
     (?$BSz(B . ?\x56F9)  ;; <CJK>
     (?$BS{(B . ?\x5700)  ;; <CJK>
     (?$BS|(B . ?\x56FF)  ;; <CJK>
     (?$BS}(B . ?\x5704)  ;; <CJK>
     (?$BS~(B . ?\x5709)  ;; <CJK>
     (?$BT!(B . ?\x5708)  ;; <CJK>
     (?$BT"(B . ?\x570B)  ;; <CJK>
     (?$BT#(B . ?\x570D)  ;; <CJK>
     (?$BT$(B . ?\x5713)  ;; <CJK>
     (?$BT%(B . ?\x5718)  ;; <CJK>
     (?$BT&(B . ?\x5716)  ;; <CJK>
     (?$BT'(B . ?\x55C7)  ;; <CJK>
     (?$BT((B . ?\x571C)  ;; <CJK>
     (?$BT)(B . ?\x5726)  ;; <CJK>
     (?$BT*(B . ?\x5737)  ;; <CJK>
     (?$BT+(B . ?\x5738)  ;; <CJK>
     (?$BT,(B . ?\x574E)  ;; <CJK>
     (?$BT-(B . ?\x573B)  ;; <CJK>
     (?$BT.(B . ?\x5740)  ;; <CJK>
     (?$BT/(B . ?\x574F)  ;; <CJK>
     (?$BT0(B . ?\x5769)  ;; <CJK>
     (?$BT1(B . ?\x57C0)  ;; <CJK>
     (?$BT2(B . ?\x5788)  ;; <CJK>
     (?$BT3(B . ?\x5761)  ;; <CJK>
     (?$BT4(B . ?\x577F)  ;; <CJK>
     (?$BT5(B . ?\x5789)  ;; <CJK>
     (?$BT6(B . ?\x5793)  ;; <CJK>
     (?$BT7(B . ?\x57A0)  ;; <CJK>
     (?$BT8(B . ?\x57B3)  ;; <CJK>
     (?$BT9(B . ?\x57A4)  ;; <CJK>
     (?$BT:(B . ?\x57AA)  ;; <CJK>
     (?$BT;(B . ?\x57B0)  ;; <CJK>
     (?$BT<(B . ?\x57C3)  ;; <CJK>
     (?$BT=(B . ?\x57C6)  ;; <CJK>
     (?$BT>(B . ?\x57D4)  ;; <CJK>
     (?$BT?(B . ?\x57D2)  ;; <CJK>
     (?$BT@(B . ?\x57D3)  ;; <CJK>
     (?$BTA(B . ?\x580A)  ;; <CJK>
     (?$BTB(B . ?\x57D6)  ;; <CJK>
     (?$BTC(B . ?\x57E3)  ;; <CJK>
     (?$BTD(B . ?\x580B)  ;; <CJK>
     (?$BTE(B . ?\x5819)  ;; <CJK>
     (?$BTF(B . ?\x581D)  ;; <CJK>
     (?$BTG(B . ?\x5872)  ;; <CJK>
     (?$BTH(B . ?\x5821)  ;; <CJK>
     (?$BTI(B . ?\x5862)  ;; <CJK>
     (?$BTJ(B . ?\x584B)  ;; <CJK>
     (?$BTK(B . ?\x5870)  ;; <CJK>
     (?$BTL(B . ?\x6BC0)  ;; <CJK>
     (?$BTM(B . ?\x5852)  ;; <CJK>
     (?$BTN(B . ?\x583D)  ;; <CJK>
     (?$BTO(B . ?\x5879)  ;; <CJK>
     (?$BTP(B . ?\x5885)  ;; <CJK>
     (?$BTQ(B . ?\x58B9)  ;; <CJK>
     (?$BTR(B . ?\x589F)  ;; <CJK>
     (?$BTS(B . ?\x58AB)  ;; <CJK>
     (?$BTT(B . ?\x58BA)  ;; <CJK>
     (?$BTU(B . ?\x58DE)  ;; <CJK>
     (?$BTV(B . ?\x58BB)  ;; <CJK>
     (?$BTW(B . ?\x58B8)  ;; <CJK>
     (?$BTX(B . ?\x58AE)  ;; <CJK>
     (?$BTY(B . ?\x58C5)  ;; <CJK>
     (?$BTZ(B . ?\x58D3)  ;; <CJK>
     (?$BT[(B . ?\x58D1)  ;; <CJK>
     (?$BT\(B . ?\x58D7)  ;; <CJK>
     (?$BT](B . ?\x58D9)  ;; <CJK>
     (?$BT^(B . ?\x58D8)  ;; <CJK>
     (?$BT_(B . ?\x58E5)  ;; <CJK>
     (?$BT`(B . ?\x58DC)  ;; <CJK>
     (?$BTa(B . ?\x58E4)  ;; <CJK>
     (?$BTb(B . ?\x58DF)  ;; <CJK>
     (?$BTc(B . ?\x58EF)  ;; <CJK>
     (?$BTd(B . ?\x58FA)  ;; <CJK>
     (?$BTe(B . ?\x58F9)  ;; <CJK>
     (?$BTf(B . ?\x58FB)  ;; <CJK>
     (?$BTg(B . ?\x58FC)  ;; <CJK>
     (?$BTh(B . ?\x58FD)  ;; <CJK>
     (?$BTi(B . ?\x5902)  ;; <CJK>
     (?$BTj(B . ?\x590A)  ;; <CJK>
     (?$BTk(B . ?\x5910)  ;; <CJK>
     (?$BTl(B . ?\x591B)  ;; <CJK>
     (?$BTm(B . ?\x68A6)  ;; <CJK>
     (?$BTn(B . ?\x5925)  ;; <CJK>
     (?$BTo(B . ?\x592C)  ;; <CJK>
     (?$BTp(B . ?\x592D)  ;; <CJK>
     (?$BTq(B . ?\x5932)  ;; <CJK>
     (?$BTr(B . ?\x5938)  ;; <CJK>
     (?$BTs(B . ?\x593E)  ;; <CJK>
     (?$BTt(B . ?\x7AD2)  ;; <CJK>
     (?$BTu(B . ?\x5955)  ;; <CJK>
     (?$BTv(B . ?\x5950)  ;; <CJK>
     (?$BTw(B . ?\x594E)  ;; <CJK>
     (?$BTx(B . ?\x595A)  ;; <CJK>
     (?$BTy(B . ?\x5958)  ;; <CJK>
     (?$BTz(B . ?\x5962)  ;; <CJK>
     (?$BT{(B . ?\x5960)  ;; <CJK>
     (?$BT|(B . ?\x5967)  ;; <CJK>
     (?$BT}(B . ?\x596C)  ;; <CJK>
     (?$BT~(B . ?\x5969)  ;; <CJK>
     (?$BU!(B . ?\x5978)  ;; <CJK>
     (?$BU"(B . ?\x5981)  ;; <CJK>
     (?$BU#(B . ?\x599D)  ;; <CJK>
     (?$BU$(B . ?\x4F5E)  ;; <CJK>
     (?$BU%(B . ?\x4FAB)  ;; <CJK>
     (?$BU&(B . ?\x59A3)  ;; <CJK>
     (?$BU'(B . ?\x59B2)  ;; <CJK>
     (?$BU((B . ?\x59C6)  ;; <CJK>
     (?$BU)(B . ?\x59E8)  ;; <CJK>
     (?$BU*(B . ?\x59DC)  ;; <CJK>
     (?$BU+(B . ?\x598D)  ;; <CJK>
     (?$BU,(B . ?\x59D9)  ;; <CJK>
     (?$BU-(B . ?\x59DA)  ;; <CJK>
     (?$BU.(B . ?\x5A25)  ;; <CJK>
     (?$BU/(B . ?\x5A1F)  ;; <CJK>
     (?$BU0(B . ?\x5A11)  ;; <CJK>
     (?$BU1(B . ?\x5A1C)  ;; <CJK>
     (?$BU2(B . ?\x5A09)  ;; <CJK>
     (?$BU3(B . ?\x5A1A)  ;; <CJK>
     (?$BU4(B . ?\x5A40)  ;; <CJK>
     (?$BU5(B . ?\x5A6C)  ;; <CJK>
     (?$BU6(B . ?\x5A49)  ;; <CJK>
     (?$BU7(B . ?\x5A35)  ;; <CJK>
     (?$BU8(B . ?\x5A36)  ;; <CJK>
     (?$BU9(B . ?\x5A62)  ;; <CJK>
     (?$BU:(B . ?\x5A6A)  ;; <CJK>
     (?$BU;(B . ?\x5A9A)  ;; <CJK>
     (?$BU<(B . ?\x5ABC)  ;; <CJK>
     (?$BU=(B . ?\x5ABE)  ;; <CJK>
     (?$BU>(B . ?\x5ACB)  ;; <CJK>
     (?$BU?(B . ?\x5AC2)  ;; <CJK>
     (?$BU@(B . ?\x5ABD)  ;; <CJK>
     (?$BUA(B . ?\x5AE3)  ;; <CJK>
     (?$BUB(B . ?\x5AD7)  ;; <CJK>
     (?$BUC(B . ?\x5AE6)  ;; <CJK>
     (?$BUD(B . ?\x5AE9)  ;; <CJK>
     (?$BUE(B . ?\x5AD6)  ;; <CJK>
     (?$BUF(B . ?\x5AFA)  ;; <CJK>
     (?$BUG(B . ?\x5AFB)  ;; <CJK>
     (?$BUH(B . ?\x5B0C)  ;; <CJK>
     (?$BUI(B . ?\x5B0B)  ;; <CJK>
     (?$BUJ(B . ?\x5B16)  ;; <CJK>
     (?$BUK(B . ?\x5B32)  ;; <CJK>
     (?$BUL(B . ?\x5AD0)  ;; <CJK>
     (?$BUM(B . ?\x5B2A)  ;; <CJK>
     (?$BUN(B . ?\x5B36)  ;; <CJK>
     (?$BUO(B . ?\x5B3E)  ;; <CJK>
     (?$BUP(B . ?\x5B43)  ;; <CJK>
     (?$BUQ(B . ?\x5B45)  ;; <CJK>
     (?$BUR(B . ?\x5B40)  ;; <CJK>
     (?$BUS(B . ?\x5B51)  ;; <CJK>
     (?$BUT(B . ?\x5B55)  ;; <CJK>
     (?$BUU(B . ?\x5B5A)  ;; <CJK>
     (?$BUV(B . ?\x5B5B)  ;; <CJK>
     (?$BUW(B . ?\x5B65)  ;; <CJK>
     (?$BUX(B . ?\x5B69)  ;; <CJK>
     (?$BUY(B . ?\x5B70)  ;; <CJK>
     (?$BUZ(B . ?\x5B73)  ;; <CJK>
     (?$BU[(B . ?\x5B75)  ;; <CJK>
     (?$BU\(B . ?\x5B78)  ;; <CJK>
     (?$BU](B . ?\x6588)  ;; <CJK>
     (?$BU^(B . ?\x5B7A)  ;; <CJK>
     (?$BU_(B . ?\x5B80)  ;; <CJK>
     (?$BU`(B . ?\x5B83)  ;; <CJK>
     (?$BUa(B . ?\x5BA6)  ;; <CJK>
     (?$BUb(B . ?\x5BB8)  ;; <CJK>
     (?$BUc(B . ?\x5BC3)  ;; <CJK>
     (?$BUd(B . ?\x5BC7)  ;; <CJK>
     (?$BUe(B . ?\x5BC9)  ;; <CJK>
     (?$BUf(B . ?\x5BD4)  ;; <CJK>
     (?$BUg(B . ?\x5BD0)  ;; <CJK>
     (?$BUh(B . ?\x5BE4)  ;; <CJK>
     (?$BUi(B . ?\x5BE6)  ;; <CJK>
     (?$BUj(B . ?\x5BE2)  ;; <CJK>
     (?$BUk(B . ?\x5BDE)  ;; <CJK>
     (?$BUl(B . ?\x5BE5)  ;; <CJK>
     (?$BUm(B . ?\x5BEB)  ;; <CJK>
     (?$BUn(B . ?\x5BF0)  ;; <CJK>
     (?$BUo(B . ?\x5BF6)  ;; <CJK>
     (?$BUp(B . ?\x5BF3)  ;; <CJK>
     (?$BUq(B . ?\x5C05)  ;; <CJK>
     (?$BUr(B . ?\x5C07)  ;; <CJK>
     (?$BUs(B . ?\x5C08)  ;; <CJK>
     (?$BUt(B . ?\x5C0D)  ;; <CJK>
     (?$BUu(B . ?\x5C13)  ;; <CJK>
     (?$BUv(B . ?\x5C20)  ;; <CJK>
     (?$BUw(B . ?\x5C22)  ;; <CJK>
     (?$BUx(B . ?\x5C28)  ;; <CJK>
     (?$BUy(B . ?\x5C38)  ;; <CJK>
     (?$BUz(B . ?\x5C39)  ;; <CJK>
     (?$BU{(B . ?\x5C41)  ;; <CJK>
     (?$BU|(B . ?\x5C46)  ;; <CJK>
     (?$BU}(B . ?\x5C4E)  ;; <CJK>
     (?$BU~(B . ?\x5C53)  ;; <CJK>
     (?$BV!(B . ?\x5C50)  ;; <CJK>
     (?$BV"(B . ?\x5C4F)  ;; <CJK>
     (?$BV#(B . ?\x5B71)  ;; <CJK>
     (?$BV$(B . ?\x5C6C)  ;; <CJK>
     (?$BV%(B . ?\x5C6E)  ;; <CJK>
     (?$BV&(B . ?\x4E62)  ;; <CJK>
     (?$BV'(B . ?\x5C76)  ;; <CJK>
     (?$BV((B . ?\x5C79)  ;; <CJK>
     (?$BV)(B . ?\x5C8C)  ;; <CJK>
     (?$BV*(B . ?\x5C91)  ;; <CJK>
     (?$BV+(B . ?\x5C94)  ;; <CJK>
     (?$BV,(B . ?\x599B)  ;; <CJK>
     (?$BV-(B . ?\x5CAB)  ;; <CJK>
     (?$BV.(B . ?\x5CBB)  ;; <CJK>
     (?$BV/(B . ?\x5CB6)  ;; <CJK>
     (?$BV0(B . ?\x5CBC)  ;; <CJK>
     (?$BV1(B . ?\x5CB7)  ;; <CJK>
     (?$BV2(B . ?\x5CC5)  ;; <CJK>
     (?$BV3(B . ?\x5CBE)  ;; <CJK>
     (?$BV4(B . ?\x5CC7)  ;; <CJK>
     (?$BV5(B . ?\x5CD9)  ;; <CJK>
     (?$BV6(B . ?\x5CE9)  ;; <CJK>
     (?$BV7(B . ?\x5CFD)  ;; <CJK>
     (?$BV8(B . ?\x5CFA)  ;; <CJK>
     (?$BV9(B . ?\x5CED)  ;; <CJK>
     (?$BV:(B . ?\x5D8C)  ;; <CJK>
     (?$BV;(B . ?\x5CEA)  ;; <CJK>
     (?$BV<(B . ?\x5D0B)  ;; <CJK>
     (?$BV=(B . ?\x5D15)  ;; <CJK>
     (?$BV>(B . ?\x5D17)  ;; <CJK>
     (?$BV?(B . ?\x5D5C)  ;; <CJK>
     (?$BV@(B . ?\x5D1F)  ;; <CJK>
     (?$BVA(B . ?\x5D1B)  ;; <CJK>
     (?$BVB(B . ?\x5D11)  ;; <CJK>
     (?$BVC(B . ?\x5D14)  ;; <CJK>
     (?$BVD(B . ?\x5D22)  ;; <CJK>
     (?$BVE(B . ?\x5D1A)  ;; <CJK>
     (?$BVF(B . ?\x5D19)  ;; <CJK>
     (?$BVG(B . ?\x5D18)  ;; <CJK>
     (?$BVH(B . ?\x5D4C)  ;; <CJK>
     (?$BVI(B . ?\x5D52)  ;; <CJK>
     (?$BVJ(B . ?\x5D4E)  ;; <CJK>
     (?$BVK(B . ?\x5D4B)  ;; <CJK>
     (?$BVL(B . ?\x5D6C)  ;; <CJK>
     (?$BVM(B . ?\x5D73)  ;; <CJK>
     (?$BVN(B . ?\x5D76)  ;; <CJK>
     (?$BVO(B . ?\x5D87)  ;; <CJK>
     (?$BVP(B . ?\x5D84)  ;; <CJK>
     (?$BVQ(B . ?\x5D82)  ;; <CJK>
     (?$BVR(B . ?\x5DA2)  ;; <CJK>
     (?$BVS(B . ?\x5D9D)  ;; <CJK>
     (?$BVT(B . ?\x5DAC)  ;; <CJK>
     (?$BVU(B . ?\x5DAE)  ;; <CJK>
     (?$BVV(B . ?\x5DBD)  ;; <CJK>
     (?$BVW(B . ?\x5D90)  ;; <CJK>
     (?$BVX(B . ?\x5DB7)  ;; <CJK>
     (?$BVY(B . ?\x5DBC)  ;; <CJK>
     (?$BVZ(B . ?\x5DC9)  ;; <CJK>
     (?$BV[(B . ?\x5DCD)  ;; <CJK>
     (?$BV\(B . ?\x5DD3)  ;; <CJK>
     (?$BV](B . ?\x5DD2)  ;; <CJK>
     (?$BV^(B . ?\x5DD6)  ;; <CJK>
     (?$BV_(B . ?\x5DDB)  ;; <CJK>
     (?$BV`(B . ?\x5DEB)  ;; <CJK>
     (?$BVa(B . ?\x5DF2)  ;; <CJK>
     (?$BVb(B . ?\x5DF5)  ;; <CJK>
     (?$BVc(B . ?\x5E0B)  ;; <CJK>
     (?$BVd(B . ?\x5E1A)  ;; <CJK>
     (?$BVe(B . ?\x5E19)  ;; <CJK>
     (?$BVf(B . ?\x5E11)  ;; <CJK>
     (?$BVg(B . ?\x5E1B)  ;; <CJK>
     (?$BVh(B . ?\x5E36)  ;; <CJK>
     (?$BVi(B . ?\x5E37)  ;; <CJK>
     (?$BVj(B . ?\x5E44)  ;; <CJK>
     (?$BVk(B . ?\x5E43)  ;; <CJK>
     (?$BVl(B . ?\x5E40)  ;; <CJK>
     (?$BVm(B . ?\x5E4E)  ;; <CJK>
     (?$BVn(B . ?\x5E57)  ;; <CJK>
     (?$BVo(B . ?\x5E54)  ;; <CJK>
     (?$BVp(B . ?\x5E5F)  ;; <CJK>
     (?$BVq(B . ?\x5E62)  ;; <CJK>
     (?$BVr(B . ?\x5E64)  ;; <CJK>
     (?$BVs(B . ?\x5E47)  ;; <CJK>
     (?$BVt(B . ?\x5E75)  ;; <CJK>
     (?$BVu(B . ?\x5E76)  ;; <CJK>
     (?$BVv(B . ?\x5E7A)  ;; <CJK>
     (?$BVw(B . ?\x9EBC)  ;; <CJK>
     (?$BVx(B . ?\x5E7F)  ;; <CJK>
     (?$BVy(B . ?\x5EA0)  ;; <CJK>
     (?$BVz(B . ?\x5EC1)  ;; <CJK>
     (?$BV{(B . ?\x5EC2)  ;; <CJK>
     (?$BV|(B . ?\x5EC8)  ;; <CJK>
     (?$BV}(B . ?\x5ED0)  ;; <CJK>
     (?$BV~(B . ?\x5ECF)  ;; <CJK>
     (?$BW!(B . ?\x5ED6)  ;; <CJK>
     (?$BW"(B . ?\x5EE3)  ;; <CJK>
     (?$BW#(B . ?\x5EDD)  ;; <CJK>
     (?$BW$(B . ?\x5EDA)  ;; <CJK>
     (?$BW%(B . ?\x5EDB)  ;; <CJK>
     (?$BW&(B . ?\x5EE2)  ;; <CJK>
     (?$BW'(B . ?\x5EE1)  ;; <CJK>
     (?$BW((B . ?\x5EE8)  ;; <CJK>
     (?$BW)(B . ?\x5EE9)  ;; <CJK>
     (?$BW*(B . ?\x5EEC)  ;; <CJK>
     (?$BW+(B . ?\x5EF1)  ;; <CJK>
     (?$BW,(B . ?\x5EF3)  ;; <CJK>
     (?$BW-(B . ?\x5EF0)  ;; <CJK>
     (?$BW.(B . ?\x5EF4)  ;; <CJK>
     (?$BW/(B . ?\x5EF8)  ;; <CJK>
     (?$BW0(B . ?\x5EFE)  ;; <CJK>
     (?$BW1(B . ?\x5F03)  ;; <CJK>
     (?$BW2(B . ?\x5F09)  ;; <CJK>
     (?$BW3(B . ?\x5F5D)  ;; <CJK>
     (?$BW4(B . ?\x5F5C)  ;; <CJK>
     (?$BW5(B . ?\x5F0B)  ;; <CJK>
     (?$BW6(B . ?\x5F11)  ;; <CJK>
     (?$BW7(B . ?\x5F16)  ;; <CJK>
     (?$BW8(B . ?\x5F29)  ;; <CJK>
     (?$BW9(B . ?\x5F2D)  ;; <CJK>
     (?$BW:(B . ?\x5F38)  ;; <CJK>
     (?$BW;(B . ?\x5F41)  ;; <CJK>
     (?$BW<(B . ?\x5F48)  ;; <CJK>
     (?$BW=(B . ?\x5F4C)  ;; <CJK>
     (?$BW>(B . ?\x5F4E)  ;; <CJK>
     (?$BW?(B . ?\x5F2F)  ;; <CJK>
     (?$BW@(B . ?\x5F51)  ;; <CJK>
     (?$BWA(B . ?\x5F56)  ;; <CJK>
     (?$BWB(B . ?\x5F57)  ;; <CJK>
     (?$BWC(B . ?\x5F59)  ;; <CJK>
     (?$BWD(B . ?\x5F61)  ;; <CJK>
     (?$BWE(B . ?\x5F6D)  ;; <CJK>
     (?$BWF(B . ?\x5F73)  ;; <CJK>
     (?$BWG(B . ?\x5F77)  ;; <CJK>
     (?$BWH(B . ?\x5F83)  ;; <CJK>
     (?$BWI(B . ?\x5F82)  ;; <CJK>
     (?$BWJ(B . ?\x5F7F)  ;; <CJK>
     (?$BWK(B . ?\x5F8A)  ;; <CJK>
     (?$BWL(B . ?\x5F88)  ;; <CJK>
     (?$BWM(B . ?\x5F91)  ;; <CJK>
     (?$BWN(B . ?\x5F87)  ;; <CJK>
     (?$BWO(B . ?\x5F9E)  ;; <CJK>
     (?$BWP(B . ?\x5F99)  ;; <CJK>
     (?$BWQ(B . ?\x5F98)  ;; <CJK>
     (?$BWR(B . ?\x5FA0)  ;; <CJK>
     (?$BWS(B . ?\x5FA8)  ;; <CJK>
     (?$BWT(B . ?\x5FAD)  ;; <CJK>
     (?$BWU(B . ?\x5FBC)  ;; <CJK>
     (?$BWV(B . ?\x5FD6)  ;; <CJK>
     (?$BWW(B . ?\x5FFB)  ;; <CJK>
     (?$BWX(B . ?\x5FE4)  ;; <CJK>
     (?$BWY(B . ?\x5FF8)  ;; <CJK>
     (?$BWZ(B . ?\x5FF1)  ;; <CJK>
     (?$BW[(B . ?\x5FDD)  ;; <CJK>
     (?$BW\(B . ?\x60B3)  ;; <CJK>
     (?$BW](B . ?\x5FFF)  ;; <CJK>
     (?$BW^(B . ?\x6021)  ;; <CJK>
     (?$BW_(B . ?\x6060)  ;; <CJK>
     (?$BW`(B . ?\x6019)  ;; <CJK>
     (?$BWa(B . ?\x6010)  ;; <CJK>
     (?$BWb(B . ?\x6029)  ;; <CJK>
     (?$BWc(B . ?\x600E)  ;; <CJK>
     (?$BWd(B . ?\x6031)  ;; <CJK>
     (?$BWe(B . ?\x601B)  ;; <CJK>
     (?$BWf(B . ?\x6015)  ;; <CJK>
     (?$BWg(B . ?\x602B)  ;; <CJK>
     (?$BWh(B . ?\x6026)  ;; <CJK>
     (?$BWi(B . ?\x600F)  ;; <CJK>
     (?$BWj(B . ?\x603A)  ;; <CJK>
     (?$BWk(B . ?\x605A)  ;; <CJK>
     (?$BWl(B . ?\x6041)  ;; <CJK>
     (?$BWm(B . ?\x606A)  ;; <CJK>
     (?$BWn(B . ?\x6077)  ;; <CJK>
     (?$BWo(B . ?\x605F)  ;; <CJK>
     (?$BWp(B . ?\x604A)  ;; <CJK>
     (?$BWq(B . ?\x6046)  ;; <CJK>
     (?$BWr(B . ?\x604D)  ;; <CJK>
     (?$BWs(B . ?\x6063)  ;; <CJK>
     (?$BWt(B . ?\x6043)  ;; <CJK>
     (?$BWu(B . ?\x6064)  ;; <CJK>
     (?$BWv(B . ?\x6042)  ;; <CJK>
     (?$BWw(B . ?\x606C)  ;; <CJK>
     (?$BWx(B . ?\x606B)  ;; <CJK>
     (?$BWy(B . ?\x6059)  ;; <CJK>
     (?$BWz(B . ?\x6081)  ;; <CJK>
     (?$BW{(B . ?\x608D)  ;; <CJK>
     (?$BW|(B . ?\x60E7)  ;; <CJK>
     (?$BW}(B . ?\x6083)  ;; <CJK>
     (?$BW~(B . ?\x609A)  ;; <CJK>
     (?$BX!(B . ?\x6084)  ;; <CJK>
     (?$BX"(B . ?\x609B)  ;; <CJK>
     (?$BX#(B . ?\x6096)  ;; <CJK>
     (?$BX$(B . ?\x6097)  ;; <CJK>
     (?$BX%(B . ?\x6092)  ;; <CJK>
     (?$BX&(B . ?\x60A7)  ;; <CJK>
     (?$BX'(B . ?\x608B)  ;; <CJK>
     (?$BX((B . ?\x60E1)  ;; <CJK>
     (?$BX)(B . ?\x60B8)  ;; <CJK>
     (?$BX*(B . ?\x60E0)  ;; <CJK>
     (?$BX+(B . ?\x60D3)  ;; <CJK>
     (?$BX,(B . ?\x60B4)  ;; <CJK>
     (?$BX-(B . ?\x5FF0)  ;; <CJK>
     (?$BX.(B . ?\x60BD)  ;; <CJK>
     (?$BX/(B . ?\x60C6)  ;; <CJK>
     (?$BX0(B . ?\x60B5)  ;; <CJK>
     (?$BX1(B . ?\x60D8)  ;; <CJK>
     (?$BX2(B . ?\x614D)  ;; <CJK>
     (?$BX3(B . ?\x6115)  ;; <CJK>
     (?$BX4(B . ?\x6106)  ;; <CJK>
     (?$BX5(B . ?\x60F6)  ;; <CJK>
     (?$BX6(B . ?\x60F7)  ;; <CJK>
     (?$BX7(B . ?\x6100)  ;; <CJK>
     (?$BX8(B . ?\x60F4)  ;; <CJK>
     (?$BX9(B . ?\x60FA)  ;; <CJK>
     (?$BX:(B . ?\x6103)  ;; <CJK>
     (?$BX;(B . ?\x6121)  ;; <CJK>
     (?$BX<(B . ?\x60FB)  ;; <CJK>
     (?$BX=(B . ?\x60F1)  ;; <CJK>
     (?$BX>(B . ?\x610D)  ;; <CJK>
     (?$BX?(B . ?\x610E)  ;; <CJK>
     (?$BX@(B . ?\x6147)  ;; <CJK>
     (?$BXA(B . ?\x613E)  ;; <CJK>
     (?$BXB(B . ?\x6128)  ;; <CJK>
     (?$BXC(B . ?\x6127)  ;; <CJK>
     (?$BXD(B . ?\x614A)  ;; <CJK>
     (?$BXE(B . ?\x613F)  ;; <CJK>
     (?$BXF(B . ?\x613C)  ;; <CJK>
     (?$BXG(B . ?\x612C)  ;; <CJK>
     (?$BXH(B . ?\x6134)  ;; <CJK>
     (?$BXI(B . ?\x613D)  ;; <CJK>
     (?$BXJ(B . ?\x6142)  ;; <CJK>
     (?$BXK(B . ?\x6144)  ;; <CJK>
     (?$BXL(B . ?\x6173)  ;; <CJK>
     (?$BXM(B . ?\x6177)  ;; <CJK>
     (?$BXN(B . ?\x6158)  ;; <CJK>
     (?$BXO(B . ?\x6159)  ;; <CJK>
     (?$BXP(B . ?\x615A)  ;; <CJK>
     (?$BXQ(B . ?\x616B)  ;; <CJK>
     (?$BXR(B . ?\x6174)  ;; <CJK>
     (?$BXS(B . ?\x616F)  ;; <CJK>
     (?$BXT(B . ?\x6165)  ;; <CJK>
     (?$BXU(B . ?\x6171)  ;; <CJK>
     (?$BXV(B . ?\x615F)  ;; <CJK>
     (?$BXW(B . ?\x615D)  ;; <CJK>
     (?$BXX(B . ?\x6153)  ;; <CJK>
     (?$BXY(B . ?\x6175)  ;; <CJK>
     (?$BXZ(B . ?\x6199)  ;; <CJK>
     (?$BX[(B . ?\x6196)  ;; <CJK>
     (?$BX\(B . ?\x6187)  ;; <CJK>
     (?$BX](B . ?\x61AC)  ;; <CJK>
     (?$BX^(B . ?\x6194)  ;; <CJK>
     (?$BX_(B . ?\x619A)  ;; <CJK>
     (?$BX`(B . ?\x618A)  ;; <CJK>
     (?$BXa(B . ?\x6191)  ;; <CJK>
     (?$BXb(B . ?\x61AB)  ;; <CJK>
     (?$BXc(B . ?\x61AE)  ;; <CJK>
     (?$BXd(B . ?\x61CC)  ;; <CJK>
     (?$BXe(B . ?\x61CA)  ;; <CJK>
     (?$BXf(B . ?\x61C9)  ;; <CJK>
     (?$BXg(B . ?\x61F7)  ;; <CJK>
     (?$BXh(B . ?\x61C8)  ;; <CJK>
     (?$BXi(B . ?\x61C3)  ;; <CJK>
     (?$BXj(B . ?\x61C6)  ;; <CJK>
     (?$BXk(B . ?\x61BA)  ;; <CJK>
     (?$BXl(B . ?\x61CB)  ;; <CJK>
     (?$BXm(B . ?\x7F79)  ;; <CJK>
     (?$BXn(B . ?\x61CD)  ;; <CJK>
     (?$BXo(B . ?\x61E6)  ;; <CJK>
     (?$BXp(B . ?\x61E3)  ;; <CJK>
     (?$BXq(B . ?\x61F6)  ;; <CJK>
     (?$BXr(B . ?\x61FA)  ;; <CJK>
     (?$BXs(B . ?\x61F4)  ;; <CJK>
     (?$BXt(B . ?\x61FF)  ;; <CJK>
     (?$BXu(B . ?\x61FD)  ;; <CJK>
     (?$BXv(B . ?\x61FC)  ;; <CJK>
     (?$BXw(B . ?\x61FE)  ;; <CJK>
     (?$BXx(B . ?\x6200)  ;; <CJK>
     (?$BXy(B . ?\x6208)  ;; <CJK>
     (?$BXz(B . ?\x6209)  ;; <CJK>
     (?$BX{(B . ?\x620D)  ;; <CJK>
     (?$BX|(B . ?\x620C)  ;; <CJK>
     (?$BX}(B . ?\x6214)  ;; <CJK>
     (?$BX~(B . ?\x621B)  ;; <CJK>
     (?$BY!(B . ?\x621E)  ;; <CJK>
     (?$BY"(B . ?\x6221)  ;; <CJK>
     (?$BY#(B . ?\x622A)  ;; <CJK>
     (?$BY$(B . ?\x622E)  ;; <CJK>
     (?$BY%(B . ?\x6230)  ;; <CJK>
     (?$BY&(B . ?\x6232)  ;; <CJK>
     (?$BY'(B . ?\x6233)  ;; <CJK>
     (?$BY((B . ?\x6241)  ;; <CJK>
     (?$BY)(B . ?\x624E)  ;; <CJK>
     (?$BY*(B . ?\x625E)  ;; <CJK>
     (?$BY+(B . ?\x6263)  ;; <CJK>
     (?$BY,(B . ?\x625B)  ;; <CJK>
     (?$BY-(B . ?\x6260)  ;; <CJK>
     (?$BY.(B . ?\x6268)  ;; <CJK>
     (?$BY/(B . ?\x627C)  ;; <CJK>
     (?$BY0(B . ?\x6282)  ;; <CJK>
     (?$BY1(B . ?\x6289)  ;; <CJK>
     (?$BY2(B . ?\x627E)  ;; <CJK>
     (?$BY3(B . ?\x6292)  ;; <CJK>
     (?$BY4(B . ?\x6293)  ;; <CJK>
     (?$BY5(B . ?\x6296)  ;; <CJK>
     (?$BY6(B . ?\x62D4)  ;; <CJK>
     (?$BY7(B . ?\x6283)  ;; <CJK>
     (?$BY8(B . ?\x6294)  ;; <CJK>
     (?$BY9(B . ?\x62D7)  ;; <CJK>
     (?$BY:(B . ?\x62D1)  ;; <CJK>
     (?$BY;(B . ?\x62BB)  ;; <CJK>
     (?$BY<(B . ?\x62CF)  ;; <CJK>
     (?$BY=(B . ?\x62FF)  ;; <CJK>
     (?$BY>(B . ?\x62C6)  ;; <CJK>
     (?$BY?(B . ?\x64D4)  ;; <CJK>
     (?$BY@(B . ?\x62C8)  ;; <CJK>
     (?$BYA(B . ?\x62DC)  ;; <CJK>
     (?$BYB(B . ?\x62CC)  ;; <CJK>
     (?$BYC(B . ?\x62CA)  ;; <CJK>
     (?$BYD(B . ?\x62C2)  ;; <CJK>
     (?$BYE(B . ?\x62C7)  ;; <CJK>
     (?$BYF(B . ?\x629B)  ;; <CJK>
     (?$BYG(B . ?\x62C9)  ;; <CJK>
     (?$BYH(B . ?\x630C)  ;; <CJK>
     (?$BYI(B . ?\x62EE)  ;; <CJK>
     (?$BYJ(B . ?\x62F1)  ;; <CJK>
     (?$BYK(B . ?\x6327)  ;; <CJK>
     (?$BYL(B . ?\x6302)  ;; <CJK>
     (?$BYM(B . ?\x6308)  ;; <CJK>
     (?$BYN(B . ?\x62EF)  ;; <CJK>
     (?$BYO(B . ?\x62F5)  ;; <CJK>
     (?$BYP(B . ?\x6350)  ;; <CJK>
     (?$BYQ(B . ?\x633E)  ;; <CJK>
     (?$BYR(B . ?\x634D)  ;; <CJK>
     (?$BYS(B . ?\x641C)  ;; <CJK>
     (?$BYT(B . ?\x634F)  ;; <CJK>
     (?$BYU(B . ?\x6396)  ;; <CJK>
     (?$BYV(B . ?\x638E)  ;; <CJK>
     (?$BYW(B . ?\x6380)  ;; <CJK>
     (?$BYX(B . ?\x63AB)  ;; <CJK>
     (?$BYY(B . ?\x6376)  ;; <CJK>
     (?$BYZ(B . ?\x63A3)  ;; <CJK>
     (?$BY[(B . ?\x638F)  ;; <CJK>
     (?$BY\(B . ?\x6389)  ;; <CJK>
     (?$BY](B . ?\x639F)  ;; <CJK>
     (?$BY^(B . ?\x63B5)  ;; <CJK>
     (?$BY_(B . ?\x636B)  ;; <CJK>
     (?$BY`(B . ?\x6369)  ;; <CJK>
     (?$BYa(B . ?\x63BE)  ;; <CJK>
     (?$BYb(B . ?\x63E9)  ;; <CJK>
     (?$BYc(B . ?\x63C0)  ;; <CJK>
     (?$BYd(B . ?\x63C6)  ;; <CJK>
     (?$BYe(B . ?\x63E3)  ;; <CJK>
     (?$BYf(B . ?\x63C9)  ;; <CJK>
     (?$BYg(B . ?\x63D2)  ;; <CJK>
     (?$BYh(B . ?\x63F6)  ;; <CJK>
     (?$BYi(B . ?\x63C4)  ;; <CJK>
     (?$BYj(B . ?\x6416)  ;; <CJK>
     (?$BYk(B . ?\x6434)  ;; <CJK>
     (?$BYl(B . ?\x6406)  ;; <CJK>
     (?$BYm(B . ?\x6413)  ;; <CJK>
     (?$BYn(B . ?\x6426)  ;; <CJK>
     (?$BYo(B . ?\x6436)  ;; <CJK>
     (?$BYp(B . ?\x651D)  ;; <CJK>
     (?$BYq(B . ?\x6417)  ;; <CJK>
     (?$BYr(B . ?\x6428)  ;; <CJK>
     (?$BYs(B . ?\x640F)  ;; <CJK>
     (?$BYt(B . ?\x6467)  ;; <CJK>
     (?$BYu(B . ?\x646F)  ;; <CJK>
     (?$BYv(B . ?\x6476)  ;; <CJK>
     (?$BYw(B . ?\x644E)  ;; <CJK>
     (?$BYx(B . ?\x652A)  ;; <CJK>
     (?$BYy(B . ?\x6495)  ;; <CJK>
     (?$BYz(B . ?\x6493)  ;; <CJK>
     (?$BY{(B . ?\x64A5)  ;; <CJK>
     (?$BY|(B . ?\x64A9)  ;; <CJK>
     (?$BY}(B . ?\x6488)  ;; <CJK>
     (?$BY~(B . ?\x64BC)  ;; <CJK>
     (?$BZ!(B . ?\x64DA)  ;; <CJK>
     (?$BZ"(B . ?\x64D2)  ;; <CJK>
     (?$BZ#(B . ?\x64C5)  ;; <CJK>
     (?$BZ$(B . ?\x64C7)  ;; <CJK>
     (?$BZ%(B . ?\x64BB)  ;; <CJK>
     (?$BZ&(B . ?\x64D8)  ;; <CJK>
     (?$BZ'(B . ?\x64C2)  ;; <CJK>
     (?$BZ((B . ?\x64F1)  ;; <CJK>
     (?$BZ)(B . ?\x64E7)  ;; <CJK>
     (?$BZ*(B . ?\x8209)  ;; <CJK>
     (?$BZ+(B . ?\x64E0)  ;; <CJK>
     (?$BZ,(B . ?\x64E1)  ;; <CJK>
     (?$BZ-(B . ?\x62AC)  ;; <CJK>
     (?$BZ.(B . ?\x64E3)  ;; <CJK>
     (?$BZ/(B . ?\x64EF)  ;; <CJK>
     (?$BZ0(B . ?\x652C)  ;; <CJK>
     (?$BZ1(B . ?\x64F6)  ;; <CJK>
     (?$BZ2(B . ?\x64F4)  ;; <CJK>
     (?$BZ3(B . ?\x64F2)  ;; <CJK>
     (?$BZ4(B . ?\x64FA)  ;; <CJK>
     (?$BZ5(B . ?\x6500)  ;; <CJK>
     (?$BZ6(B . ?\x64FD)  ;; <CJK>
     (?$BZ7(B . ?\x6518)  ;; <CJK>
     (?$BZ8(B . ?\x651C)  ;; <CJK>
     (?$BZ9(B . ?\x6505)  ;; <CJK>
     (?$BZ:(B . ?\x6524)  ;; <CJK>
     (?$BZ;(B . ?\x6523)  ;; <CJK>
     (?$BZ<(B . ?\x652B)  ;; <CJK>
     (?$BZ=(B . ?\x6534)  ;; <CJK>
     (?$BZ>(B . ?\x6535)  ;; <CJK>
     (?$BZ?(B . ?\x6537)  ;; <CJK>
     (?$BZ@(B . ?\x6536)  ;; <CJK>
     (?$BZA(B . ?\x6538)  ;; <CJK>
     (?$BZB(B . ?\x754B)  ;; <CJK>
     (?$BZC(B . ?\x6548)  ;; <CJK>
     (?$BZD(B . ?\x6556)  ;; <CJK>
     (?$BZE(B . ?\x6555)  ;; <CJK>
     (?$BZF(B . ?\x654D)  ;; <CJK>
     (?$BZG(B . ?\x6558)  ;; <CJK>
     (?$BZH(B . ?\x655E)  ;; <CJK>
     (?$BZI(B . ?\x655D)  ;; <CJK>
     (?$BZJ(B . ?\x6572)  ;; <CJK>
     (?$BZK(B . ?\x6578)  ;; <CJK>
     (?$BZL(B . ?\x6582)  ;; <CJK>
     (?$BZM(B . ?\x6583)  ;; <CJK>
     (?$BZN(B . ?\x8B8A)  ;; <CJK>
     (?$BZO(B . ?\x659B)  ;; <CJK>
     (?$BZP(B . ?\x659F)  ;; <CJK>
     (?$BZQ(B . ?\x65AB)  ;; <CJK>
     (?$BZR(B . ?\x65B7)  ;; <CJK>
     (?$BZS(B . ?\x65C3)  ;; <CJK>
     (?$BZT(B . ?\x65C6)  ;; <CJK>
     (?$BZU(B . ?\x65C1)  ;; <CJK>
     (?$BZV(B . ?\x65C4)  ;; <CJK>
     (?$BZW(B . ?\x65CC)  ;; <CJK>
     (?$BZX(B . ?\x65D2)  ;; <CJK>
     (?$BZY(B . ?\x65DB)  ;; <CJK>
     (?$BZZ(B . ?\x65D9)  ;; <CJK>
     (?$BZ[(B . ?\x65E0)  ;; <CJK>
     (?$BZ\(B . ?\x65E1)  ;; <CJK>
     (?$BZ](B . ?\x65F1)  ;; <CJK>
     (?$BZ^(B . ?\x6772)  ;; <CJK>
     (?$BZ_(B . ?\x660A)  ;; <CJK>
     (?$BZ`(B . ?\x6603)  ;; <CJK>
     (?$BZa(B . ?\x65FB)  ;; <CJK>
     (?$BZb(B . ?\x6773)  ;; <CJK>
     (?$BZc(B . ?\x6635)  ;; <CJK>
     (?$BZd(B . ?\x6636)  ;; <CJK>
     (?$BZe(B . ?\x6634)  ;; <CJK>
     (?$BZf(B . ?\x661C)  ;; <CJK>
     (?$BZg(B . ?\x664F)  ;; <CJK>
     (?$BZh(B . ?\x6644)  ;; <CJK>
     (?$BZi(B . ?\x6649)  ;; <CJK>
     (?$BZj(B . ?\x6641)  ;; <CJK>
     (?$BZk(B . ?\x665E)  ;; <CJK>
     (?$BZl(B . ?\x665D)  ;; <CJK>
     (?$BZm(B . ?\x6664)  ;; <CJK>
     (?$BZn(B . ?\x6667)  ;; <CJK>
     (?$BZo(B . ?\x6668)  ;; <CJK>
     (?$BZp(B . ?\x665F)  ;; <CJK>
     (?$BZq(B . ?\x6662)  ;; <CJK>
     (?$BZr(B . ?\x6670)  ;; <CJK>
     (?$BZs(B . ?\x6683)  ;; <CJK>
     (?$BZt(B . ?\x6688)  ;; <CJK>
     (?$BZu(B . ?\x668E)  ;; <CJK>
     (?$BZv(B . ?\x6689)  ;; <CJK>
     (?$BZw(B . ?\x6684)  ;; <CJK>
     (?$BZx(B . ?\x6698)  ;; <CJK>
     (?$BZy(B . ?\x669D)  ;; <CJK>
     (?$BZz(B . ?\x66C1)  ;; <CJK>
     (?$BZ{(B . ?\x66B9)  ;; <CJK>
     (?$BZ|(B . ?\x66C9)  ;; <CJK>
     (?$BZ}(B . ?\x66BE)  ;; <CJK>
     (?$BZ~(B . ?\x66BC)  ;; <CJK>
     (?$B[!(B . ?\x66C4)  ;; <CJK>
     (?$B["(B . ?\x66B8)  ;; <CJK>
     (?$B[#(B . ?\x66D6)  ;; <CJK>
     (?$B[$(B . ?\x66DA)  ;; <CJK>
     (?$B[%(B . ?\x66E0)  ;; <CJK>
     (?$B[&(B . ?\x663F)  ;; <CJK>
     (?$B['(B . ?\x66E6)  ;; <CJK>
     (?$B[((B . ?\x66E9)  ;; <CJK>
     (?$B[)(B . ?\x66F0)  ;; <CJK>
     (?$B[*(B . ?\x66F5)  ;; <CJK>
     (?$B[+(B . ?\x66F7)  ;; <CJK>
     (?$B[,(B . ?\x670F)  ;; <CJK>
     (?$B[-(B . ?\x6716)  ;; <CJK>
     (?$B[.(B . ?\x671E)  ;; <CJK>
     (?$B[/(B . ?\x6726)  ;; <CJK>
     (?$B[0(B . ?\x6727)  ;; <CJK>
     (?$B[1(B . ?\x9738)  ;; <CJK>
     (?$B[2(B . ?\x672E)  ;; <CJK>
     (?$B[3(B . ?\x673F)  ;; <CJK>
     (?$B[4(B . ?\x6736)  ;; <CJK>
     (?$B[5(B . ?\x6741)  ;; <CJK>
     (?$B[6(B . ?\x6738)  ;; <CJK>
     (?$B[7(B . ?\x6737)  ;; <CJK>
     (?$B[8(B . ?\x6746)  ;; <CJK>
     (?$B[9(B . ?\x675E)  ;; <CJK>
     (?$B[:(B . ?\x6760)  ;; <CJK>
     (?$B[;(B . ?\x6759)  ;; <CJK>
     (?$B[<(B . ?\x6763)  ;; <CJK>
     (?$B[=(B . ?\x6764)  ;; <CJK>
     (?$B[>(B . ?\x6789)  ;; <CJK>
     (?$B[?(B . ?\x6770)  ;; <CJK>
     (?$B[@(B . ?\x67A9)  ;; <CJK>
     (?$B[A(B . ?\x677C)  ;; <CJK>
     (?$B[B(B . ?\x676A)  ;; <CJK>
     (?$B[C(B . ?\x678C)  ;; <CJK>
     (?$B[D(B . ?\x678B)  ;; <CJK>
     (?$B[E(B . ?\x67A6)  ;; <CJK>
     (?$B[F(B . ?\x67A1)  ;; <CJK>
     (?$B[G(B . ?\x6785)  ;; <CJK>
     (?$B[H(B . ?\x67B7)  ;; <CJK>
     (?$B[I(B . ?\x67EF)  ;; <CJK>
     (?$B[J(B . ?\x67B4)  ;; <CJK>
     (?$B[K(B . ?\x67EC)  ;; <CJK>
     (?$B[L(B . ?\x67B3)  ;; <CJK>
     (?$B[M(B . ?\x67E9)  ;; <CJK>
     (?$B[N(B . ?\x67B8)  ;; <CJK>
     (?$B[O(B . ?\x67E4)  ;; <CJK>
     (?$B[P(B . ?\x67DE)  ;; <CJK>
     (?$B[Q(B . ?\x67DD)  ;; <CJK>
     (?$B[R(B . ?\x67E2)  ;; <CJK>
     (?$B[S(B . ?\x67EE)  ;; <CJK>
     (?$B[T(B . ?\x67B9)  ;; <CJK>
     (?$B[U(B . ?\x67CE)  ;; <CJK>
     (?$B[V(B . ?\x67C6)  ;; <CJK>
     (?$B[W(B . ?\x67E7)  ;; <CJK>
     (?$B[X(B . ?\x6A9C)  ;; <CJK>
     (?$B[Y(B . ?\x681E)  ;; <CJK>
     (?$B[Z(B . ?\x6846)  ;; <CJK>
     (?$B[[(B . ?\x6829)  ;; <CJK>
     (?$B[\(B . ?\x6840)  ;; <CJK>
     (?$B[](B . ?\x684D)  ;; <CJK>
     (?$B[^(B . ?\x6832)  ;; <CJK>
     (?$B[_(B . ?\x684E)  ;; <CJK>
     (?$B[`(B . ?\x68B3)  ;; <CJK>
     (?$B[a(B . ?\x682B)  ;; <CJK>
     (?$B[b(B . ?\x6859)  ;; <CJK>
     (?$B[c(B . ?\x6863)  ;; <CJK>
     (?$B[d(B . ?\x6877)  ;; <CJK>
     (?$B[e(B . ?\x687F)  ;; <CJK>
     (?$B[f(B . ?\x689F)  ;; <CJK>
     (?$B[g(B . ?\x688F)  ;; <CJK>
     (?$B[h(B . ?\x68AD)  ;; <CJK>
     (?$B[i(B . ?\x6894)  ;; <CJK>
     (?$B[j(B . ?\x689D)  ;; <CJK>
     (?$B[k(B . ?\x689B)  ;; <CJK>
     (?$B[l(B . ?\x6883)  ;; <CJK>
     (?$B[m(B . ?\x6AAE)  ;; <CJK>
     (?$B[n(B . ?\x68B9)  ;; <CJK>
     (?$B[o(B . ?\x6874)  ;; <CJK>
     (?$B[p(B . ?\x68B5)  ;; <CJK>
     (?$B[q(B . ?\x68A0)  ;; <CJK>
     (?$B[r(B . ?\x68BA)  ;; <CJK>
     (?$B[s(B . ?\x690F)  ;; <CJK>
     (?$B[t(B . ?\x688D)  ;; <CJK>
     (?$B[u(B . ?\x687E)  ;; <CJK>
     (?$B[v(B . ?\x6901)  ;; <CJK>
     (?$B[w(B . ?\x68CA)  ;; <CJK>
     (?$B[x(B . ?\x6908)  ;; <CJK>
     (?$B[y(B . ?\x68D8)  ;; <CJK>
     (?$B[z(B . ?\x6922)  ;; <CJK>
     (?$B[{(B . ?\x6926)  ;; <CJK>
     (?$B[|(B . ?\x68E1)  ;; <CJK>
     (?$B[}(B . ?\x690C)  ;; <CJK>
     (?$B[~(B . ?\x68CD)  ;; <CJK>
     (?$B\!(B . ?\x68D4)  ;; <CJK>
     (?$B\"(B . ?\x68E7)  ;; <CJK>
     (?$B\#(B . ?\x68D5)  ;; <CJK>
     (?$B\$(B . ?\x6936)  ;; <CJK>
     (?$B\%(B . ?\x6912)  ;; <CJK>
     (?$B\&(B . ?\x6904)  ;; <CJK>
     (?$B\'(B . ?\x68D7)  ;; <CJK>
     (?$B\((B . ?\x68E3)  ;; <CJK>
     (?$B\)(B . ?\x6925)  ;; <CJK>
     (?$B\*(B . ?\x68F9)  ;; <CJK>
     (?$B\+(B . ?\x68E0)  ;; <CJK>
     (?$B\,(B . ?\x68EF)  ;; <CJK>
     (?$B\-(B . ?\x6928)  ;; <CJK>
     (?$B\.(B . ?\x692A)  ;; <CJK>
     (?$B\/(B . ?\x691A)  ;; <CJK>
     (?$B\0(B . ?\x6923)  ;; <CJK>
     (?$B\1(B . ?\x6921)  ;; <CJK>
     (?$B\2(B . ?\x68C6)  ;; <CJK>
     (?$B\3(B . ?\x6979)  ;; <CJK>
     (?$B\4(B . ?\x6977)  ;; <CJK>
     (?$B\5(B . ?\x695C)  ;; <CJK>
     (?$B\6(B . ?\x6978)  ;; <CJK>
     (?$B\7(B . ?\x696B)  ;; <CJK>
     (?$B\8(B . ?\x6954)  ;; <CJK>
     (?$B\9(B . ?\x697E)  ;; <CJK>
     (?$B\:(B . ?\x696E)  ;; <CJK>
     (?$B\;(B . ?\x6939)  ;; <CJK>
     (?$B\<(B . ?\x6974)  ;; <CJK>
     (?$B\=(B . ?\x693D)  ;; <CJK>
     (?$B\>(B . ?\x6959)  ;; <CJK>
     (?$B\?(B . ?\x6930)  ;; <CJK>
     (?$B\@(B . ?\x6961)  ;; <CJK>
     (?$B\A(B . ?\x695E)  ;; <CJK>
     (?$B\B(B . ?\x695D)  ;; <CJK>
     (?$B\C(B . ?\x6981)  ;; <CJK>
     (?$B\D(B . ?\x696A)  ;; <CJK>
     (?$B\E(B . ?\x69B2)  ;; <CJK>
     (?$B\F(B . ?\x69AE)  ;; <CJK>
     (?$B\G(B . ?\x69D0)  ;; <CJK>
     (?$B\H(B . ?\x69BF)  ;; <CJK>
     (?$B\I(B . ?\x69C1)  ;; <CJK>
     (?$B\J(B . ?\x69D3)  ;; <CJK>
     (?$B\K(B . ?\x69BE)  ;; <CJK>
     (?$B\L(B . ?\x69CE)  ;; <CJK>
     (?$B\M(B . ?\x5BE8)  ;; <CJK>
     (?$B\N(B . ?\x69CA)  ;; <CJK>
     (?$B\O(B . ?\x69DD)  ;; <CJK>
     (?$B\P(B . ?\x69BB)  ;; <CJK>
     (?$B\Q(B . ?\x69C3)  ;; <CJK>
     (?$B\R(B . ?\x69A7)  ;; <CJK>
     (?$B\S(B . ?\x6A2E)  ;; <CJK>
     (?$B\T(B . ?\x6991)  ;; <CJK>
     (?$B\U(B . ?\x69A0)  ;; <CJK>
     (?$B\V(B . ?\x699C)  ;; <CJK>
     (?$B\W(B . ?\x6995)  ;; <CJK>
     (?$B\X(B . ?\x69B4)  ;; <CJK>
     (?$B\Y(B . ?\x69DE)  ;; <CJK>
     (?$B\Z(B . ?\x69E8)  ;; <CJK>
     (?$B\[(B . ?\x6A02)  ;; <CJK>
     (?$B\\(B . ?\x6A1B)  ;; <CJK>
     (?$B\](B . ?\x69FF)  ;; <CJK>
     (?$B\^(B . ?\x6B0A)  ;; <CJK>
     (?$B\_(B . ?\x69F9)  ;; <CJK>
     (?$B\`(B . ?\x69F2)  ;; <CJK>
     (?$B\a(B . ?\x69E7)  ;; <CJK>
     (?$B\b(B . ?\x6A05)  ;; <CJK>
     (?$B\c(B . ?\x69B1)  ;; <CJK>
     (?$B\d(B . ?\x6A1E)  ;; <CJK>
     (?$B\e(B . ?\x69ED)  ;; <CJK>
     (?$B\f(B . ?\x6A14)  ;; <CJK>
     (?$B\g(B . ?\x69EB)  ;; <CJK>
     (?$B\h(B . ?\x6A0A)  ;; <CJK>
     (?$B\i(B . ?\x6A12)  ;; <CJK>
     (?$B\j(B . ?\x6AC1)  ;; <CJK>
     (?$B\k(B . ?\x6A23)  ;; <CJK>
     (?$B\l(B . ?\x6A13)  ;; <CJK>
     (?$B\m(B . ?\x6A44)  ;; <CJK>
     (?$B\n(B . ?\x6A0C)  ;; <CJK>
     (?$B\o(B . ?\x6A72)  ;; <CJK>
     (?$B\p(B . ?\x6A36)  ;; <CJK>
     (?$B\q(B . ?\x6A78)  ;; <CJK>
     (?$B\r(B . ?\x6A47)  ;; <CJK>
     (?$B\s(B . ?\x6A62)  ;; <CJK>
     (?$B\t(B . ?\x6A59)  ;; <CJK>
     (?$B\u(B . ?\x6A66)  ;; <CJK>
     (?$B\v(B . ?\x6A48)  ;; <CJK>
     (?$B\w(B . ?\x6A38)  ;; <CJK>
     (?$B\x(B . ?\x6A22)  ;; <CJK>
     (?$B\y(B . ?\x6A90)  ;; <CJK>
     (?$B\z(B . ?\x6A8D)  ;; <CJK>
     (?$B\{(B . ?\x6AA0)  ;; <CJK>
     (?$B\|(B . ?\x6A84)  ;; <CJK>
     (?$B\}(B . ?\x6AA2)  ;; <CJK>
     (?$B\~(B . ?\x6AA3)  ;; <CJK>
     (?$B]!(B . ?\x6A97)  ;; <CJK>
     (?$B]"(B . ?\x8617)  ;; <CJK>
     (?$B]#(B . ?\x6ABB)  ;; <CJK>
     (?$B]$(B . ?\x6AC3)  ;; <CJK>
     (?$B]%(B . ?\x6AC2)  ;; <CJK>
     (?$B]&(B . ?\x6AB8)  ;; <CJK>
     (?$B]'(B . ?\x6AB3)  ;; <CJK>
     (?$B]((B . ?\x6AAC)  ;; <CJK>
     (?$B])(B . ?\x6ADE)  ;; <CJK>
     (?$B]*(B . ?\x6AD1)  ;; <CJK>
     (?$B]+(B . ?\x6ADF)  ;; <CJK>
     (?$B],(B . ?\x6AAA)  ;; <CJK>
     (?$B]-(B . ?\x6ADA)  ;; <CJK>
     (?$B].(B . ?\x6AEA)  ;; <CJK>
     (?$B]/(B . ?\x6AFB)  ;; <CJK>
     (?$B]0(B . ?\x6B05)  ;; <CJK>
     (?$B]1(B . ?\x8616)  ;; <CJK>
     (?$B]2(B . ?\x6AFA)  ;; <CJK>
     (?$B]3(B . ?\x6B12)  ;; <CJK>
     (?$B]4(B . ?\x6B16)  ;; <CJK>
     (?$B]5(B . ?\x9B31)  ;; <CJK>
     (?$B]6(B . ?\x6B1F)  ;; <CJK>
     (?$B]7(B . ?\x6B38)  ;; <CJK>
     (?$B]8(B . ?\x6B37)  ;; <CJK>
     (?$B]9(B . ?\x76DC)  ;; <CJK>
     (?$B]:(B . ?\x6B39)  ;; <CJK>
     (?$B];(B . ?\x98EE)  ;; <CJK>
     (?$B]<(B . ?\x6B47)  ;; <CJK>
     (?$B]=(B . ?\x6B43)  ;; <CJK>
     (?$B]>(B . ?\x6B49)  ;; <CJK>
     (?$B]?(B . ?\x6B50)  ;; <CJK>
     (?$B]@(B . ?\x6B59)  ;; <CJK>
     (?$B]A(B . ?\x6B54)  ;; <CJK>
     (?$B]B(B . ?\x6B5B)  ;; <CJK>
     (?$B]C(B . ?\x6B5F)  ;; <CJK>
     (?$B]D(B . ?\x6B61)  ;; <CJK>
     (?$B]E(B . ?\x6B78)  ;; <CJK>
     (?$B]F(B . ?\x6B79)  ;; <CJK>
     (?$B]G(B . ?\x6B7F)  ;; <CJK>
     (?$B]H(B . ?\x6B80)  ;; <CJK>
     (?$B]I(B . ?\x6B84)  ;; <CJK>
     (?$B]J(B . ?\x6B83)  ;; <CJK>
     (?$B]K(B . ?\x6B8D)  ;; <CJK>
     (?$B]L(B . ?\x6B98)  ;; <CJK>
     (?$B]M(B . ?\x6B95)  ;; <CJK>
     (?$B]N(B . ?\x6B9E)  ;; <CJK>
     (?$B]O(B . ?\x6BA4)  ;; <CJK>
     (?$B]P(B . ?\x6BAA)  ;; <CJK>
     (?$B]Q(B . ?\x6BAB)  ;; <CJK>
     (?$B]R(B . ?\x6BAF)  ;; <CJK>
     (?$B]S(B . ?\x6BB2)  ;; <CJK>
     (?$B]T(B . ?\x6BB1)  ;; <CJK>
     (?$B]U(B . ?\x6BB3)  ;; <CJK>
     (?$B]V(B . ?\x6BB7)  ;; <CJK>
     (?$B]W(B . ?\x6BBC)  ;; <CJK>
     (?$B]X(B . ?\x6BC6)  ;; <CJK>
     (?$B]Y(B . ?\x6BCB)  ;; <CJK>
     (?$B]Z(B . ?\x6BD3)  ;; <CJK>
     (?$B][(B . ?\x6BDF)  ;; <CJK>
     (?$B]\(B . ?\x6BEC)  ;; <CJK>
     (?$B]](B . ?\x6BEB)  ;; <CJK>
     (?$B]^(B . ?\x6BF3)  ;; <CJK>
     (?$B]_(B . ?\x6BEF)  ;; <CJK>
     (?$B]`(B . ?\x9EBE)  ;; <CJK>
     (?$B]a(B . ?\x6C08)  ;; <CJK>
     (?$B]b(B . ?\x6C13)  ;; <CJK>
     (?$B]c(B . ?\x6C14)  ;; <CJK>
     (?$B]d(B . ?\x6C1B)  ;; <CJK>
     (?$B]e(B . ?\x6C24)  ;; <CJK>
     (?$B]f(B . ?\x6C23)  ;; <CJK>
     (?$B]g(B . ?\x6C5E)  ;; <CJK>
     (?$B]h(B . ?\x6C55)  ;; <CJK>
     (?$B]i(B . ?\x6C62)  ;; <CJK>
     (?$B]j(B . ?\x6C6A)  ;; <CJK>
     (?$B]k(B . ?\x6C82)  ;; <CJK>
     (?$B]l(B . ?\x6C8D)  ;; <CJK>
     (?$B]m(B . ?\x6C9A)  ;; <CJK>
     (?$B]n(B . ?\x6C81)  ;; <CJK>
     (?$B]o(B . ?\x6C9B)  ;; <CJK>
     (?$B]p(B . ?\x6C7E)  ;; <CJK>
     (?$B]q(B . ?\x6C68)  ;; <CJK>
     (?$B]r(B . ?\x6C73)  ;; <CJK>
     (?$B]s(B . ?\x6C92)  ;; <CJK>
     (?$B]t(B . ?\x6C90)  ;; <CJK>
     (?$B]u(B . ?\x6CC4)  ;; <CJK>
     (?$B]v(B . ?\x6CF1)  ;; <CJK>
     (?$B]w(B . ?\x6CD3)  ;; <CJK>
     (?$B]x(B . ?\x6CBD)  ;; <CJK>
     (?$B]y(B . ?\x6CD7)  ;; <CJK>
     (?$B]z(B . ?\x6CC5)  ;; <CJK>
     (?$B]{(B . ?\x6CDD)  ;; <CJK>
     (?$B]|(B . ?\x6CAE)  ;; <CJK>
     (?$B]}(B . ?\x6CB1)  ;; <CJK>
     (?$B]~(B . ?\x6CBE)  ;; <CJK>
     (?$B^!(B . ?\x6CBA)  ;; <CJK>
     (?$B^"(B . ?\x6CDB)  ;; <CJK>
     (?$B^#(B . ?\x6CEF)  ;; <CJK>
     (?$B^$(B . ?\x6CD9)  ;; <CJK>
     (?$B^%(B . ?\x6CEA)  ;; <CJK>
     (?$B^&(B . ?\x6D1F)  ;; <CJK>
     (?$B^'(B . ?\x884D)  ;; <CJK>
     (?$B^((B . ?\x6D36)  ;; <CJK>
     (?$B^)(B . ?\x6D2B)  ;; <CJK>
     (?$B^*(B . ?\x6D3D)  ;; <CJK>
     (?$B^+(B . ?\x6D38)  ;; <CJK>
     (?$B^,(B . ?\x6D19)  ;; <CJK>
     (?$B^-(B . ?\x6D35)  ;; <CJK>
     (?$B^.(B . ?\x6D33)  ;; <CJK>
     (?$B^/(B . ?\x6D12)  ;; <CJK>
     (?$B^0(B . ?\x6D0C)  ;; <CJK>
     (?$B^1(B . ?\x6D63)  ;; <CJK>
     (?$B^2(B . ?\x6D93)  ;; <CJK>
     (?$B^3(B . ?\x6D64)  ;; <CJK>
     (?$B^4(B . ?\x6D5A)  ;; <CJK>
     (?$B^5(B . ?\x6D79)  ;; <CJK>
     (?$B^6(B . ?\x6D59)  ;; <CJK>
     (?$B^7(B . ?\x6D8E)  ;; <CJK>
     (?$B^8(B . ?\x6D95)  ;; <CJK>
     (?$B^9(B . ?\x6FE4)  ;; <CJK>
     (?$B^:(B . ?\x6D85)  ;; <CJK>
     (?$B^;(B . ?\x6DF9)  ;; <CJK>
     (?$B^<(B . ?\x6E15)  ;; <CJK>
     (?$B^=(B . ?\x6E0A)  ;; <CJK>
     (?$B^>(B . ?\x6DB5)  ;; <CJK>
     (?$B^?(B . ?\x6DC7)  ;; <CJK>
     (?$B^@(B . ?\x6DE6)  ;; <CJK>
     (?$B^A(B . ?\x6DB8)  ;; <CJK>
     (?$B^B(B . ?\x6DC6)  ;; <CJK>
     (?$B^C(B . ?\x6DEC)  ;; <CJK>
     (?$B^D(B . ?\x6DDE)  ;; <CJK>
     (?$B^E(B . ?\x6DCC)  ;; <CJK>
     (?$B^F(B . ?\x6DE8)  ;; <CJK>
     (?$B^G(B . ?\x6DD2)  ;; <CJK>
     (?$B^H(B . ?\x6DC5)  ;; <CJK>
     (?$B^I(B . ?\x6DFA)  ;; <CJK>
     (?$B^J(B . ?\x6DD9)  ;; <CJK>
     (?$B^K(B . ?\x6DE4)  ;; <CJK>
     (?$B^L(B . ?\x6DD5)  ;; <CJK>
     (?$B^M(B . ?\x6DEA)  ;; <CJK>
     (?$B^N(B . ?\x6DEE)  ;; <CJK>
     (?$B^O(B . ?\x6E2D)  ;; <CJK>
     (?$B^P(B . ?\x6E6E)  ;; <CJK>
     (?$B^Q(B . ?\x6E2E)  ;; <CJK>
     (?$B^R(B . ?\x6E19)  ;; <CJK>
     (?$B^S(B . ?\x6E72)  ;; <CJK>
     (?$B^T(B . ?\x6E5F)  ;; <CJK>
     (?$B^U(B . ?\x6E3E)  ;; <CJK>
     (?$B^V(B . ?\x6E23)  ;; <CJK>
     (?$B^W(B . ?\x6E6B)  ;; <CJK>
     (?$B^X(B . ?\x6E2B)  ;; <CJK>
     (?$B^Y(B . ?\x6E76)  ;; <CJK>
     (?$B^Z(B . ?\x6E4D)  ;; <CJK>
     (?$B^[(B . ?\x6E1F)  ;; <CJK>
     (?$B^\(B . ?\x6E43)  ;; <CJK>
     (?$B^](B . ?\x6E3A)  ;; <CJK>
     (?$B^^(B . ?\x6E4E)  ;; <CJK>
     (?$B^_(B . ?\x6E24)  ;; <CJK>
     (?$B^`(B . ?\x6EFF)  ;; <CJK>
     (?$B^a(B . ?\x6E1D)  ;; <CJK>
     (?$B^b(B . ?\x6E38)  ;; <CJK>
     (?$B^c(B . ?\x6E82)  ;; <CJK>
     (?$B^d(B . ?\x6EAA)  ;; <CJK>
     (?$B^e(B . ?\x6E98)  ;; <CJK>
     (?$B^f(B . ?\x6EC9)  ;; <CJK>
     (?$B^g(B . ?\x6EB7)  ;; <CJK>
     (?$B^h(B . ?\x6ED3)  ;; <CJK>
     (?$B^i(B . ?\x6EBD)  ;; <CJK>
     (?$B^j(B . ?\x6EAF)  ;; <CJK>
     (?$B^k(B . ?\x6EC4)  ;; <CJK>
     (?$B^l(B . ?\x6EB2)  ;; <CJK>
     (?$B^m(B . ?\x6ED4)  ;; <CJK>
     (?$B^n(B . ?\x6ED5)  ;; <CJK>
     (?$B^o(B . ?\x6E8F)  ;; <CJK>
     (?$B^p(B . ?\x6EA5)  ;; <CJK>
     (?$B^q(B . ?\x6EC2)  ;; <CJK>
     (?$B^r(B . ?\x6E9F)  ;; <CJK>
     (?$B^s(B . ?\x6F41)  ;; <CJK>
     (?$B^t(B . ?\x6F11)  ;; <CJK>
     (?$B^u(B . ?\x704C)  ;; <CJK>
     (?$B^v(B . ?\x6EEC)  ;; <CJK>
     (?$B^w(B . ?\x6EF8)  ;; <CJK>
     (?$B^x(B . ?\x6EFE)  ;; <CJK>
     (?$B^y(B . ?\x6F3F)  ;; <CJK>
     (?$B^z(B . ?\x6EF2)  ;; <CJK>
     (?$B^{(B . ?\x6F31)  ;; <CJK>
     (?$B^|(B . ?\x6EEF)  ;; <CJK>
     (?$B^}(B . ?\x6F32)  ;; <CJK>
     (?$B^~(B . ?\x6ECC)  ;; <CJK>
     (?$B_!(B . ?\x6F3E)  ;; <CJK>
     (?$B_"(B . ?\x6F13)  ;; <CJK>
     (?$B_#(B . ?\x6EF7)  ;; <CJK>
     (?$B_$(B . ?\x6F86)  ;; <CJK>
     (?$B_%(B . ?\x6F7A)  ;; <CJK>
     (?$B_&(B . ?\x6F78)  ;; <CJK>
     (?$B_'(B . ?\x6F81)  ;; <CJK>
     (?$B_((B . ?\x6F80)  ;; <CJK>
     (?$B_)(B . ?\x6F6F)  ;; <CJK>
     (?$B_*(B . ?\x6F5B)  ;; <CJK>
     (?$B_+(B . ?\x6FF3)  ;; <CJK>
     (?$B_,(B . ?\x6F6D)  ;; <CJK>
     (?$B_-(B . ?\x6F82)  ;; <CJK>
     (?$B_.(B . ?\x6F7C)  ;; <CJK>
     (?$B_/(B . ?\x6F58)  ;; <CJK>
     (?$B_0(B . ?\x6F8E)  ;; <CJK>
     (?$B_1(B . ?\x6F91)  ;; <CJK>
     (?$B_2(B . ?\x6FC2)  ;; <CJK>
     (?$B_3(B . ?\x6F66)  ;; <CJK>
     (?$B_4(B . ?\x6FB3)  ;; <CJK>
     (?$B_5(B . ?\x6FA3)  ;; <CJK>
     (?$B_6(B . ?\x6FA1)  ;; <CJK>
     (?$B_7(B . ?\x6FA4)  ;; <CJK>
     (?$B_8(B . ?\x6FB9)  ;; <CJK>
     (?$B_9(B . ?\x6FC6)  ;; <CJK>
     (?$B_:(B . ?\x6FAA)  ;; <CJK>
     (?$B_;(B . ?\x6FDF)  ;; <CJK>
     (?$B_<(B . ?\x6FD5)  ;; <CJK>
     (?$B_=(B . ?\x6FEC)  ;; <CJK>
     (?$B_>(B . ?\x6FD4)  ;; <CJK>
     (?$B_?(B . ?\x6FD8)  ;; <CJK>
     (?$B_@(B . ?\x6FF1)  ;; <CJK>
     (?$B_A(B . ?\x6FEE)  ;; <CJK>
     (?$B_B(B . ?\x6FDB)  ;; <CJK>
     (?$B_C(B . ?\x7009)  ;; <CJK>
     (?$B_D(B . ?\x700B)  ;; <CJK>
     (?$B_E(B . ?\x6FFA)  ;; <CJK>
     (?$B_F(B . ?\x7011)  ;; <CJK>
     (?$B_G(B . ?\x7001)  ;; <CJK>
     (?$B_H(B . ?\x700F)  ;; <CJK>
     (?$B_I(B . ?\x6FFE)  ;; <CJK>
     (?$B_J(B . ?\x701B)  ;; <CJK>
     (?$B_K(B . ?\x701A)  ;; <CJK>
     (?$B_L(B . ?\x6F74)  ;; <CJK>
     (?$B_M(B . ?\x701D)  ;; <CJK>
     (?$B_N(B . ?\x7018)  ;; <CJK>
     (?$B_O(B . ?\x701F)  ;; <CJK>
     (?$B_P(B . ?\x7030)  ;; <CJK>
     (?$B_Q(B . ?\x703E)  ;; <CJK>
     (?$B_R(B . ?\x7032)  ;; <CJK>
     (?$B_S(B . ?\x7051)  ;; <CJK>
     (?$B_T(B . ?\x7063)  ;; <CJK>
     (?$B_U(B . ?\x7099)  ;; <CJK>
     (?$B_V(B . ?\x7092)  ;; <CJK>
     (?$B_W(B . ?\x70AF)  ;; <CJK>
     (?$B_X(B . ?\x70F1)  ;; <CJK>
     (?$B_Y(B . ?\x70AC)  ;; <CJK>
     (?$B_Z(B . ?\x70B8)  ;; <CJK>
     (?$B_[(B . ?\x70B3)  ;; <CJK>
     (?$B_\(B . ?\x70AE)  ;; <CJK>
     (?$B_](B . ?\x70DF)  ;; <CJK>
     (?$B_^(B . ?\x70CB)  ;; <CJK>
     (?$B__(B . ?\x70DD)  ;; <CJK>
     (?$B_`(B . ?\x70D9)  ;; <CJK>
     (?$B_a(B . ?\x7109)  ;; <CJK>
     (?$B_b(B . ?\x70FD)  ;; <CJK>
     (?$B_c(B . ?\x711C)  ;; <CJK>
     (?$B_d(B . ?\x7119)  ;; <CJK>
     (?$B_e(B . ?\x7165)  ;; <CJK>
     (?$B_f(B . ?\x7155)  ;; <CJK>
     (?$B_g(B . ?\x7188)  ;; <CJK>
     (?$B_h(B . ?\x7166)  ;; <CJK>
     (?$B_i(B . ?\x7162)  ;; <CJK>
     (?$B_j(B . ?\x714C)  ;; <CJK>
     (?$B_k(B . ?\x7156)  ;; <CJK>
     (?$B_l(B . ?\x716C)  ;; <CJK>
     (?$B_m(B . ?\x718F)  ;; <CJK>
     (?$B_n(B . ?\x71FB)  ;; <CJK>
     (?$B_o(B . ?\x7184)  ;; <CJK>
     (?$B_p(B . ?\x7195)  ;; <CJK>
     (?$B_q(B . ?\x71A8)  ;; <CJK>
     (?$B_r(B . ?\x71AC)  ;; <CJK>
     (?$B_s(B . ?\x71D7)  ;; <CJK>
     (?$B_t(B . ?\x71B9)  ;; <CJK>
     (?$B_u(B . ?\x71BE)  ;; <CJK>
     (?$B_v(B . ?\x71D2)  ;; <CJK>
     (?$B_w(B . ?\x71C9)  ;; <CJK>
     (?$B_x(B . ?\x71D4)  ;; <CJK>
     (?$B_y(B . ?\x71CE)  ;; <CJK>
     (?$B_z(B . ?\x71E0)  ;; <CJK>
     (?$B_{(B . ?\x71EC)  ;; <CJK>
     (?$B_|(B . ?\x71E7)  ;; <CJK>
     (?$B_}(B . ?\x71F5)  ;; <CJK>
     (?$B_~(B . ?\x71FC)  ;; <CJK>
     (?$B`!(B . ?\x71F9)  ;; <CJK>
     (?$B`"(B . ?\x71FF)  ;; <CJK>
     (?$B`#(B . ?\x720D)  ;; <CJK>
     (?$B`$(B . ?\x7210)  ;; <CJK>
     (?$B`%(B . ?\x721B)  ;; <CJK>
     (?$B`&(B . ?\x7228)  ;; <CJK>
     (?$B`'(B . ?\x722D)  ;; <CJK>
     (?$B`((B . ?\x722C)  ;; <CJK>
     (?$B`)(B . ?\x7230)  ;; <CJK>
     (?$B`*(B . ?\x7232)  ;; <CJK>
     (?$B`+(B . ?\x723B)  ;; <CJK>
     (?$B`,(B . ?\x723C)  ;; <CJK>
     (?$B`-(B . ?\x723F)  ;; <CJK>
     (?$B`.(B . ?\x7240)  ;; <CJK>
     (?$B`/(B . ?\x7246)  ;; <CJK>
     (?$B`0(B . ?\x724B)  ;; <CJK>
     (?$B`1(B . ?\x7258)  ;; <CJK>
     (?$B`2(B . ?\x7274)  ;; <CJK>
     (?$B`3(B . ?\x727E)  ;; <CJK>
     (?$B`4(B . ?\x7282)  ;; <CJK>
     (?$B`5(B . ?\x7281)  ;; <CJK>
     (?$B`6(B . ?\x7287)  ;; <CJK>
     (?$B`7(B . ?\x7292)  ;; <CJK>
     (?$B`8(B . ?\x7296)  ;; <CJK>
     (?$B`9(B . ?\x72A2)  ;; <CJK>
     (?$B`:(B . ?\x72A7)  ;; <CJK>
     (?$B`;(B . ?\x72B9)  ;; <CJK>
     (?$B`<(B . ?\x72B2)  ;; <CJK>
     (?$B`=(B . ?\x72C3)  ;; <CJK>
     (?$B`>(B . ?\x72C6)  ;; <CJK>
     (?$B`?(B . ?\x72C4)  ;; <CJK>
     (?$B`@(B . ?\x72CE)  ;; <CJK>
     (?$B`A(B . ?\x72D2)  ;; <CJK>
     (?$B`B(B . ?\x72E2)  ;; <CJK>
     (?$B`C(B . ?\x72E0)  ;; <CJK>
     (?$B`D(B . ?\x72E1)  ;; <CJK>
     (?$B`E(B . ?\x72F9)  ;; <CJK>
     (?$B`F(B . ?\x72F7)  ;; <CJK>
     (?$B`G(B . ?\x500F)  ;; <CJK>
     (?$B`H(B . ?\x7317)  ;; <CJK>
     (?$B`I(B . ?\x730A)  ;; <CJK>
     (?$B`J(B . ?\x731C)  ;; <CJK>
     (?$B`K(B . ?\x7316)  ;; <CJK>
     (?$B`L(B . ?\x731D)  ;; <CJK>
     (?$B`M(B . ?\x7334)  ;; <CJK>
     (?$B`N(B . ?\x732F)  ;; <CJK>
     (?$B`O(B . ?\x7329)  ;; <CJK>
     (?$B`P(B . ?\x7325)  ;; <CJK>
     (?$B`Q(B . ?\x733E)  ;; <CJK>
     (?$B`R(B . ?\x734E)  ;; <CJK>
     (?$B`S(B . ?\x734F)  ;; <CJK>
     (?$B`T(B . ?\x9ED8)  ;; <CJK>
     (?$B`U(B . ?\x7357)  ;; <CJK>
     (?$B`V(B . ?\x736A)  ;; <CJK>
     (?$B`W(B . ?\x7368)  ;; <CJK>
     (?$B`X(B . ?\x7370)  ;; <CJK>
     (?$B`Y(B . ?\x7378)  ;; <CJK>
     (?$B`Z(B . ?\x7375)  ;; <CJK>
     (?$B`[(B . ?\x737B)  ;; <CJK>
     (?$B`\(B . ?\x737A)  ;; <CJK>
     (?$B`](B . ?\x73C8)  ;; <CJK>
     (?$B`^(B . ?\x73B3)  ;; <CJK>
     (?$B`_(B . ?\x73CE)  ;; <CJK>
     (?$B``(B . ?\x73BB)  ;; <CJK>
     (?$B`a(B . ?\x73C0)  ;; <CJK>
     (?$B`b(B . ?\x73E5)  ;; <CJK>
     (?$B`c(B . ?\x73EE)  ;; <CJK>
     (?$B`d(B . ?\x73DE)  ;; <CJK>
     (?$B`e(B . ?\x74A2)  ;; <CJK>
     (?$B`f(B . ?\x7405)  ;; <CJK>
     (?$B`g(B . ?\x746F)  ;; <CJK>
     (?$B`h(B . ?\x7425)  ;; <CJK>
     (?$B`i(B . ?\x73F8)  ;; <CJK>
     (?$B`j(B . ?\x7432)  ;; <CJK>
     (?$B`k(B . ?\x743A)  ;; <CJK>
     (?$B`l(B . ?\x7455)  ;; <CJK>
     (?$B`m(B . ?\x743F)  ;; <CJK>
     (?$B`n(B . ?\x745F)  ;; <CJK>
     (?$B`o(B . ?\x7459)  ;; <CJK>
     (?$B`p(B . ?\x7441)  ;; <CJK>
     (?$B`q(B . ?\x745C)  ;; <CJK>
     (?$B`r(B . ?\x7469)  ;; <CJK>
     (?$B`s(B . ?\x7470)  ;; <CJK>
     (?$B`t(B . ?\x7463)  ;; <CJK>
     (?$B`u(B . ?\x746A)  ;; <CJK>
     (?$B`v(B . ?\x7476)  ;; <CJK>
     (?$B`w(B . ?\x747E)  ;; <CJK>
     (?$B`x(B . ?\x748B)  ;; <CJK>
     (?$B`y(B . ?\x749E)  ;; <CJK>
     (?$B`z(B . ?\x74A7)  ;; <CJK>
     (?$B`{(B . ?\x74CA)  ;; <CJK>
     (?$B`|(B . ?\x74CF)  ;; <CJK>
     (?$B`}(B . ?\x74D4)  ;; <CJK>
     (?$B`~(B . ?\x73F1)  ;; <CJK>
     (?$Ba!(B . ?\x74E0)  ;; <CJK>
     (?$Ba"(B . ?\x74E3)  ;; <CJK>
     (?$Ba#(B . ?\x74E7)  ;; <CJK>
     (?$Ba$(B . ?\x74E9)  ;; <CJK>
     (?$Ba%(B . ?\x74EE)  ;; <CJK>
     (?$Ba&(B . ?\x74F2)  ;; <CJK>
     (?$Ba'(B . ?\x74F0)  ;; <CJK>
     (?$Ba((B . ?\x74F1)  ;; <CJK>
     (?$Ba)(B . ?\x74F8)  ;; <CJK>
     (?$Ba*(B . ?\x74F7)  ;; <CJK>
     (?$Ba+(B . ?\x7504)  ;; <CJK>
     (?$Ba,(B . ?\x7503)  ;; <CJK>
     (?$Ba-(B . ?\x7505)  ;; <CJK>
     (?$Ba.(B . ?\x750C)  ;; <CJK>
     (?$Ba/(B . ?\x750E)  ;; <CJK>
     (?$Ba0(B . ?\x750D)  ;; <CJK>
     (?$Ba1(B . ?\x7515)  ;; <CJK>
     (?$Ba2(B . ?\x7513)  ;; <CJK>
     (?$Ba3(B . ?\x751E)  ;; <CJK>
     (?$Ba4(B . ?\x7526)  ;; <CJK>
     (?$Ba5(B . ?\x752C)  ;; <CJK>
     (?$Ba6(B . ?\x753C)  ;; <CJK>
     (?$Ba7(B . ?\x7544)  ;; <CJK>
     (?$Ba8(B . ?\x754D)  ;; <CJK>
     (?$Ba9(B . ?\x754A)  ;; <CJK>
     (?$Ba:(B . ?\x7549)  ;; <CJK>
     (?$Ba;(B . ?\x755B)  ;; <CJK>
     (?$Ba<(B . ?\x7546)  ;; <CJK>
     (?$Ba=(B . ?\x755A)  ;; <CJK>
     (?$Ba>(B . ?\x7569)  ;; <CJK>
     (?$Ba?(B . ?\x7564)  ;; <CJK>
     (?$Ba@(B . ?\x7567)  ;; <CJK>
     (?$BaA(B . ?\x756B)  ;; <CJK>
     (?$BaB(B . ?\x756D)  ;; <CJK>
     (?$BaC(B . ?\x7578)  ;; <CJK>
     (?$BaD(B . ?\x7576)  ;; <CJK>
     (?$BaE(B . ?\x7586)  ;; <CJK>
     (?$BaF(B . ?\x7587)  ;; <CJK>
     (?$BaG(B . ?\x7574)  ;; <CJK>
     (?$BaH(B . ?\x758A)  ;; <CJK>
     (?$BaI(B . ?\x7589)  ;; <CJK>
     (?$BaJ(B . ?\x7582)  ;; <CJK>
     (?$BaK(B . ?\x7594)  ;; <CJK>
     (?$BaL(B . ?\x759A)  ;; <CJK>
     (?$BaM(B . ?\x759D)  ;; <CJK>
     (?$BaN(B . ?\x75A5)  ;; <CJK>
     (?$BaO(B . ?\x75A3)  ;; <CJK>
     (?$BaP(B . ?\x75C2)  ;; <CJK>
     (?$BaQ(B . ?\x75B3)  ;; <CJK>
     (?$BaR(B . ?\x75C3)  ;; <CJK>
     (?$BaS(B . ?\x75B5)  ;; <CJK>
     (?$BaT(B . ?\x75BD)  ;; <CJK>
     (?$BaU(B . ?\x75B8)  ;; <CJK>
     (?$BaV(B . ?\x75BC)  ;; <CJK>
     (?$BaW(B . ?\x75B1)  ;; <CJK>
     (?$BaX(B . ?\x75CD)  ;; <CJK>
     (?$BaY(B . ?\x75CA)  ;; <CJK>
     (?$BaZ(B . ?\x75D2)  ;; <CJK>
     (?$Ba[(B . ?\x75D9)  ;; <CJK>
     (?$Ba\(B . ?\x75E3)  ;; <CJK>
     (?$Ba](B . ?\x75DE)  ;; <CJK>
     (?$Ba^(B . ?\x75FE)  ;; <CJK>
     (?$Ba_(B . ?\x75FF)  ;; <CJK>
     (?$Ba`(B . ?\x75FC)  ;; <CJK>
     (?$Baa(B . ?\x7601)  ;; <CJK>
     (?$Bab(B . ?\x75F0)  ;; <CJK>
     (?$Bac(B . ?\x75FA)  ;; <CJK>
     (?$Bad(B . ?\x75F2)  ;; <CJK>
     (?$Bae(B . ?\x75F3)  ;; <CJK>
     (?$Baf(B . ?\x760B)  ;; <CJK>
     (?$Bag(B . ?\x760D)  ;; <CJK>
     (?$Bah(B . ?\x7609)  ;; <CJK>
     (?$Bai(B . ?\x761F)  ;; <CJK>
     (?$Baj(B . ?\x7627)  ;; <CJK>
     (?$Bak(B . ?\x7620)  ;; <CJK>
     (?$Bal(B . ?\x7621)  ;; <CJK>
     (?$Bam(B . ?\x7622)  ;; <CJK>
     (?$Ban(B . ?\x7624)  ;; <CJK>
     (?$Bao(B . ?\x7634)  ;; <CJK>
     (?$Bap(B . ?\x7630)  ;; <CJK>
     (?$Baq(B . ?\x763B)  ;; <CJK>
     (?$Bar(B . ?\x7647)  ;; <CJK>
     (?$Bas(B . ?\x7648)  ;; <CJK>
     (?$Bat(B . ?\x7646)  ;; <CJK>
     (?$Bau(B . ?\x765C)  ;; <CJK>
     (?$Bav(B . ?\x7658)  ;; <CJK>
     (?$Baw(B . ?\x7661)  ;; <CJK>
     (?$Bax(B . ?\x7662)  ;; <CJK>
     (?$Bay(B . ?\x7668)  ;; <CJK>
     (?$Baz(B . ?\x7669)  ;; <CJK>
     (?$Ba{(B . ?\x766A)  ;; <CJK>
     (?$Ba|(B . ?\x7667)  ;; <CJK>
     (?$Ba}(B . ?\x766C)  ;; <CJK>
     (?$Ba~(B . ?\x7670)  ;; <CJK>
     (?$Bb!(B . ?\x7672)  ;; <CJK>
     (?$Bb"(B . ?\x7676)  ;; <CJK>
     (?$Bb#(B . ?\x7678)  ;; <CJK>
     (?$Bb$(B . ?\x767C)  ;; <CJK>
     (?$Bb%(B . ?\x7680)  ;; <CJK>
     (?$Bb&(B . ?\x7683)  ;; <CJK>
     (?$Bb'(B . ?\x7688)  ;; <CJK>
     (?$Bb((B . ?\x768B)  ;; <CJK>
     (?$Bb)(B . ?\x768E)  ;; <CJK>
     (?$Bb*(B . ?\x7696)  ;; <CJK>
     (?$Bb+(B . ?\x7693)  ;; <CJK>
     (?$Bb,(B . ?\x7699)  ;; <CJK>
     (?$Bb-(B . ?\x769A)  ;; <CJK>
     (?$Bb.(B . ?\x76B0)  ;; <CJK>
     (?$Bb/(B . ?\x76B4)  ;; <CJK>
     (?$Bb0(B . ?\x76B8)  ;; <CJK>
     (?$Bb1(B . ?\x76B9)  ;; <CJK>
     (?$Bb2(B . ?\x76BA)  ;; <CJK>
     (?$Bb3(B . ?\x76C2)  ;; <CJK>
     (?$Bb4(B . ?\x76CD)  ;; <CJK>
     (?$Bb5(B . ?\x76D6)  ;; <CJK>
     (?$Bb6(B . ?\x76D2)  ;; <CJK>
     (?$Bb7(B . ?\x76DE)  ;; <CJK>
     (?$Bb8(B . ?\x76E1)  ;; <CJK>
     (?$Bb9(B . ?\x76E5)  ;; <CJK>
     (?$Bb:(B . ?\x76E7)  ;; <CJK>
     (?$Bb;(B . ?\x76EA)  ;; <CJK>
     (?$Bb<(B . ?\x862F)  ;; <CJK>
     (?$Bb=(B . ?\x76FB)  ;; <CJK>
     (?$Bb>(B . ?\x7708)  ;; <CJK>
     (?$Bb?(B . ?\x7707)  ;; <CJK>
     (?$Bb@(B . ?\x7704)  ;; <CJK>
     (?$BbA(B . ?\x7729)  ;; <CJK>
     (?$BbB(B . ?\x7724)  ;; <CJK>
     (?$BbC(B . ?\x771E)  ;; <CJK>
     (?$BbD(B . ?\x7725)  ;; <CJK>
     (?$BbE(B . ?\x7726)  ;; <CJK>
     (?$BbF(B . ?\x771B)  ;; <CJK>
     (?$BbG(B . ?\x7737)  ;; <CJK>
     (?$BbH(B . ?\x7738)  ;; <CJK>
     (?$BbI(B . ?\x7747)  ;; <CJK>
     (?$BbJ(B . ?\x775A)  ;; <CJK>
     (?$BbK(B . ?\x7768)  ;; <CJK>
     (?$BbL(B . ?\x776B)  ;; <CJK>
     (?$BbM(B . ?\x775B)  ;; <CJK>
     (?$BbN(B . ?\x7765)  ;; <CJK>
     (?$BbO(B . ?\x777F)  ;; <CJK>
     (?$BbP(B . ?\x777E)  ;; <CJK>
     (?$BbQ(B . ?\x7779)  ;; <CJK>
     (?$BbR(B . ?\x778E)  ;; <CJK>
     (?$BbS(B . ?\x778B)  ;; <CJK>
     (?$BbT(B . ?\x7791)  ;; <CJK>
     (?$BbU(B . ?\x77A0)  ;; <CJK>
     (?$BbV(B . ?\x779E)  ;; <CJK>
     (?$BbW(B . ?\x77B0)  ;; <CJK>
     (?$BbX(B . ?\x77B6)  ;; <CJK>
     (?$BbY(B . ?\x77B9)  ;; <CJK>
     (?$BbZ(B . ?\x77BF)  ;; <CJK>
     (?$Bb[(B . ?\x77BC)  ;; <CJK>
     (?$Bb\(B . ?\x77BD)  ;; <CJK>
     (?$Bb](B . ?\x77BB)  ;; <CJK>
     (?$Bb^(B . ?\x77C7)  ;; <CJK>
     (?$Bb_(B . ?\x77CD)  ;; <CJK>
     (?$Bb`(B . ?\x77D7)  ;; <CJK>
     (?$Bba(B . ?\x77DA)  ;; <CJK>
     (?$Bbb(B . ?\x77DC)  ;; <CJK>
     (?$Bbc(B . ?\x77E3)  ;; <CJK>
     (?$Bbd(B . ?\x77EE)  ;; <CJK>
     (?$Bbe(B . ?\x77FC)  ;; <CJK>
     (?$Bbf(B . ?\x780C)  ;; <CJK>
     (?$Bbg(B . ?\x7812)  ;; <CJK>
     (?$Bbh(B . ?\x7926)  ;; <CJK>
     (?$Bbi(B . ?\x7820)  ;; <CJK>
     (?$Bbj(B . ?\x792A)  ;; <CJK>
     (?$Bbk(B . ?\x7845)  ;; <CJK>
     (?$Bbl(B . ?\x788E)  ;; <CJK>
     (?$Bbm(B . ?\x7874)  ;; <CJK>
     (?$Bbn(B . ?\x7886)  ;; <CJK>
     (?$Bbo(B . ?\x787C)  ;; <CJK>
     (?$Bbp(B . ?\x789A)  ;; <CJK>
     (?$Bbq(B . ?\x788C)  ;; <CJK>
     (?$Bbr(B . ?\x78A3)  ;; <CJK>
     (?$Bbs(B . ?\x78B5)  ;; <CJK>
     (?$Bbt(B . ?\x78AA)  ;; <CJK>
     (?$Bbu(B . ?\x78AF)  ;; <CJK>
     (?$Bbv(B . ?\x78D1)  ;; <CJK>
     (?$Bbw(B . ?\x78C6)  ;; <CJK>
     (?$Bbx(B . ?\x78CB)  ;; <CJK>
     (?$Bby(B . ?\x78D4)  ;; <CJK>
     (?$Bbz(B . ?\x78BE)  ;; <CJK>
     (?$Bb{(B . ?\x78BC)  ;; <CJK>
     (?$Bb|(B . ?\x78C5)  ;; <CJK>
     (?$Bb}(B . ?\x78CA)  ;; <CJK>
     (?$Bb~(B . ?\x78EC)  ;; <CJK>
     (?$Bc!(B . ?\x78E7)  ;; <CJK>
     (?$Bc"(B . ?\x78DA)  ;; <CJK>
     (?$Bc#(B . ?\x78FD)  ;; <CJK>
     (?$Bc$(B . ?\x78F4)  ;; <CJK>
     (?$Bc%(B . ?\x7907)  ;; <CJK>
     (?$Bc&(B . ?\x7912)  ;; <CJK>
     (?$Bc'(B . ?\x7911)  ;; <CJK>
     (?$Bc((B . ?\x7919)  ;; <CJK>
     (?$Bc)(B . ?\x792C)  ;; <CJK>
     (?$Bc*(B . ?\x792B)  ;; <CJK>
     (?$Bc+(B . ?\x7940)  ;; <CJK>
     (?$Bc,(B . ?\x7960)  ;; <CJK>
     (?$Bc-(B . ?\x7957)  ;; <CJK>
     (?$Bc.(B . ?\x795F)  ;; <CJK>
     (?$Bc/(B . ?\x795A)  ;; <CJK>
     (?$Bc0(B . ?\x7955)  ;; <CJK>
     (?$Bc1(B . ?\x7953)  ;; <CJK>
     (?$Bc2(B . ?\x797A)  ;; <CJK>
     (?$Bc3(B . ?\x797F)  ;; <CJK>
     (?$Bc4(B . ?\x798A)  ;; <CJK>
     (?$Bc5(B . ?\x799D)  ;; <CJK>
     (?$Bc6(B . ?\x79A7)  ;; <CJK>
     (?$Bc7(B . ?\x9F4B)  ;; <CJK>
     (?$Bc8(B . ?\x79AA)  ;; <CJK>
     (?$Bc9(B . ?\x79AE)  ;; <CJK>
     (?$Bc:(B . ?\x79B3)  ;; <CJK>
     (?$Bc;(B . ?\x79B9)  ;; <CJK>
     (?$Bc<(B . ?\x79BA)  ;; <CJK>
     (?$Bc=(B . ?\x79C9)  ;; <CJK>
     (?$Bc>(B . ?\x79D5)  ;; <CJK>
     (?$Bc?(B . ?\x79E7)  ;; <CJK>
     (?$Bc@(B . ?\x79EC)  ;; <CJK>
     (?$BcA(B . ?\x79E1)  ;; <CJK>
     (?$BcB(B . ?\x79E3)  ;; <CJK>
     (?$BcC(B . ?\x7A08)  ;; <CJK>
     (?$BcD(B . ?\x7A0D)  ;; <CJK>
     (?$BcE(B . ?\x7A18)  ;; <CJK>
     (?$BcF(B . ?\x7A19)  ;; <CJK>
     (?$BcG(B . ?\x7A20)  ;; <CJK>
     (?$BcH(B . ?\x7A1F)  ;; <CJK>
     (?$BcI(B . ?\x7980)  ;; <CJK>
     (?$BcJ(B . ?\x7A31)  ;; <CJK>
     (?$BcK(B . ?\x7A3B)  ;; <CJK>
     (?$BcL(B . ?\x7A3E)  ;; <CJK>
     (?$BcM(B . ?\x7A37)  ;; <CJK>
     (?$BcN(B . ?\x7A43)  ;; <CJK>
     (?$BcO(B . ?\x7A57)  ;; <CJK>
     (?$BcP(B . ?\x7A49)  ;; <CJK>
     (?$BcQ(B . ?\x7A61)  ;; <CJK>
     (?$BcR(B . ?\x7A62)  ;; <CJK>
     (?$BcS(B . ?\x7A69)  ;; <CJK>
     (?$BcT(B . ?\x9F9D)  ;; <CJK>
     (?$BcU(B . ?\x7A70)  ;; <CJK>
     (?$BcV(B . ?\x7A79)  ;; <CJK>
     (?$BcW(B . ?\x7A7D)  ;; <CJK>
     (?$BcX(B . ?\x7A88)  ;; <CJK>
     (?$BcY(B . ?\x7A97)  ;; <CJK>
     (?$BcZ(B . ?\x7A95)  ;; <CJK>
     (?$Bc[(B . ?\x7A98)  ;; <CJK>
     (?$Bc\(B . ?\x7A96)  ;; <CJK>
     (?$Bc](B . ?\x7AA9)  ;; <CJK>
     (?$Bc^(B . ?\x7AC8)  ;; <CJK>
     (?$Bc_(B . ?\x7AB0)  ;; <CJK>
     (?$Bc`(B . ?\x7AB6)  ;; <CJK>
     (?$Bca(B . ?\x7AC5)  ;; <CJK>
     (?$Bcb(B . ?\x7AC4)  ;; <CJK>
     (?$Bcc(B . ?\x7ABF)  ;; <CJK>
     (?$Bcd(B . ?\x9083)  ;; <CJK>
     (?$Bce(B . ?\x7AC7)  ;; <CJK>
     (?$Bcf(B . ?\x7ACA)  ;; <CJK>
     (?$Bcg(B . ?\x7ACD)  ;; <CJK>
     (?$Bch(B . ?\x7ACF)  ;; <CJK>
     (?$Bci(B . ?\x7AD5)  ;; <CJK>
     (?$Bcj(B . ?\x7AD3)  ;; <CJK>
     (?$Bck(B . ?\x7AD9)  ;; <CJK>
     (?$Bcl(B . ?\x7ADA)  ;; <CJK>
     (?$Bcm(B . ?\x7ADD)  ;; <CJK>
     (?$Bcn(B . ?\x7AE1)  ;; <CJK>
     (?$Bco(B . ?\x7AE2)  ;; <CJK>
     (?$Bcp(B . ?\x7AE6)  ;; <CJK>
     (?$Bcq(B . ?\x7AED)  ;; <CJK>
     (?$Bcr(B . ?\x7AF0)  ;; <CJK>
     (?$Bcs(B . ?\x7B02)  ;; <CJK>
     (?$Bct(B . ?\x7B0F)  ;; <CJK>
     (?$Bcu(B . ?\x7B0A)  ;; <CJK>
     (?$Bcv(B . ?\x7B06)  ;; <CJK>
     (?$Bcw(B . ?\x7B33)  ;; <CJK>
     (?$Bcx(B . ?\x7B18)  ;; <CJK>
     (?$Bcy(B . ?\x7B19)  ;; <CJK>
     (?$Bcz(B . ?\x7B1E)  ;; <CJK>
     (?$Bc{(B . ?\x7B35)  ;; <CJK>
     (?$Bc|(B . ?\x7B28)  ;; <CJK>
     (?$Bc}(B . ?\x7B36)  ;; <CJK>
     (?$Bc~(B . ?\x7B50)  ;; <CJK>
     (?$Bd!(B . ?\x7B7A)  ;; <CJK>
     (?$Bd"(B . ?\x7B04)  ;; <CJK>
     (?$Bd#(B . ?\x7B4D)  ;; <CJK>
     (?$Bd$(B . ?\x7B0B)  ;; <CJK>
     (?$Bd%(B . ?\x7B4C)  ;; <CJK>
     (?$Bd&(B . ?\x7B45)  ;; <CJK>
     (?$Bd'(B . ?\x7B75)  ;; <CJK>
     (?$Bd((B . ?\x7B65)  ;; <CJK>
     (?$Bd)(B . ?\x7B74)  ;; <CJK>
     (?$Bd*(B . ?\x7B67)  ;; <CJK>
     (?$Bd+(B . ?\x7B70)  ;; <CJK>
     (?$Bd,(B . ?\x7B71)  ;; <CJK>
     (?$Bd-(B . ?\x7B6C)  ;; <CJK>
     (?$Bd.(B . ?\x7B6E)  ;; <CJK>
     (?$Bd/(B . ?\x7B9D)  ;; <CJK>
     (?$Bd0(B . ?\x7B98)  ;; <CJK>
     (?$Bd1(B . ?\x7B9F)  ;; <CJK>
     (?$Bd2(B . ?\x7B8D)  ;; <CJK>
     (?$Bd3(B . ?\x7B9C)  ;; <CJK>
     (?$Bd4(B . ?\x7B9A)  ;; <CJK>
     (?$Bd5(B . ?\x7B8B)  ;; <CJK>
     (?$Bd6(B . ?\x7B92)  ;; <CJK>
     (?$Bd7(B . ?\x7B8F)  ;; <CJK>
     (?$Bd8(B . ?\x7B5D)  ;; <CJK>
     (?$Bd9(B . ?\x7B99)  ;; <CJK>
     (?$Bd:(B . ?\x7BCB)  ;; <CJK>
     (?$Bd;(B . ?\x7BC1)  ;; <CJK>
     (?$Bd<(B . ?\x7BCC)  ;; <CJK>
     (?$Bd=(B . ?\x7BCF)  ;; <CJK>
     (?$Bd>(B . ?\x7BB4)  ;; <CJK>
     (?$Bd?(B . ?\x7BC6)  ;; <CJK>
     (?$Bd@(B . ?\x7BDD)  ;; <CJK>
     (?$BdA(B . ?\x7BE9)  ;; <CJK>
     (?$BdB(B . ?\x7C11)  ;; <CJK>
     (?$BdC(B . ?\x7C14)  ;; <CJK>
     (?$BdD(B . ?\x7BE6)  ;; <CJK>
     (?$BdE(B . ?\x7BE5)  ;; <CJK>
     (?$BdF(B . ?\x7C60)  ;; <CJK>
     (?$BdG(B . ?\x7C00)  ;; <CJK>
     (?$BdH(B . ?\x7C07)  ;; <CJK>
     (?$BdI(B . ?\x7C13)  ;; <CJK>
     (?$BdJ(B . ?\x7BF3)  ;; <CJK>
     (?$BdK(B . ?\x7BF7)  ;; <CJK>
     (?$BdL(B . ?\x7C17)  ;; <CJK>
     (?$BdM(B . ?\x7C0D)  ;; <CJK>
     (?$BdN(B . ?\x7BF6)  ;; <CJK>
     (?$BdO(B . ?\x7C23)  ;; <CJK>
     (?$BdP(B . ?\x7C27)  ;; <CJK>
     (?$BdQ(B . ?\x7C2A)  ;; <CJK>
     (?$BdR(B . ?\x7C1F)  ;; <CJK>
     (?$BdS(B . ?\x7C37)  ;; <CJK>
     (?$BdT(B . ?\x7C2B)  ;; <CJK>
     (?$BdU(B . ?\x7C3D)  ;; <CJK>
     (?$BdV(B . ?\x7C4C)  ;; <CJK>
     (?$BdW(B . ?\x7C43)  ;; <CJK>
     (?$BdX(B . ?\x7C54)  ;; <CJK>
     (?$BdY(B . ?\x7C4F)  ;; <CJK>
     (?$BdZ(B . ?\x7C40)  ;; <CJK>
     (?$Bd[(B . ?\x7C50)  ;; <CJK>
     (?$Bd\(B . ?\x7C58)  ;; <CJK>
     (?$Bd](B . ?\x7C5F)  ;; <CJK>
     (?$Bd^(B . ?\x7C64)  ;; <CJK>
     (?$Bd_(B . ?\x7C56)  ;; <CJK>
     (?$Bd`(B . ?\x7C65)  ;; <CJK>
     (?$Bda(B . ?\x7C6C)  ;; <CJK>
     (?$Bdb(B . ?\x7C75)  ;; <CJK>
     (?$Bdc(B . ?\x7C83)  ;; <CJK>
     (?$Bdd(B . ?\x7C90)  ;; <CJK>
     (?$Bde(B . ?\x7CA4)  ;; <CJK>
     (?$Bdf(B . ?\x7CAD)  ;; <CJK>
     (?$Bdg(B . ?\x7CA2)  ;; <CJK>
     (?$Bdh(B . ?\x7CAB)  ;; <CJK>
     (?$Bdi(B . ?\x7CA1)  ;; <CJK>
     (?$Bdj(B . ?\x7CA8)  ;; <CJK>
     (?$Bdk(B . ?\x7CB3)  ;; <CJK>
     (?$Bdl(B . ?\x7CB2)  ;; <CJK>
     (?$Bdm(B . ?\x7CB1)  ;; <CJK>
     (?$Bdn(B . ?\x7CAE)  ;; <CJK>
     (?$Bdo(B . ?\x7CB9)  ;; <CJK>
     (?$Bdp(B . ?\x7CBD)  ;; <CJK>
     (?$Bdq(B . ?\x7CC0)  ;; <CJK>
     (?$Bdr(B . ?\x7CC5)  ;; <CJK>
     (?$Bds(B . ?\x7CC2)  ;; <CJK>
     (?$Bdt(B . ?\x7CD8)  ;; <CJK>
     (?$Bdu(B . ?\x7CD2)  ;; <CJK>
     (?$Bdv(B . ?\x7CDC)  ;; <CJK>
     (?$Bdw(B . ?\x7CE2)  ;; <CJK>
     (?$Bdx(B . ?\x9B3B)  ;; <CJK>
     (?$Bdy(B . ?\x7CEF)  ;; <CJK>
     (?$Bdz(B . ?\x7CF2)  ;; <CJK>
     (?$Bd{(B . ?\x7CF4)  ;; <CJK>
     (?$Bd|(B . ?\x7CF6)  ;; <CJK>
     (?$Bd}(B . ?\x7CFA)  ;; <CJK>
     (?$Bd~(B . ?\x7D06)  ;; <CJK>
     (?$Be!(B . ?\x7D02)  ;; <CJK>
     (?$Be"(B . ?\x7D1C)  ;; <CJK>
     (?$Be#(B . ?\x7D15)  ;; <CJK>
     (?$Be$(B . ?\x7D0A)  ;; <CJK>
     (?$Be%(B . ?\x7D45)  ;; <CJK>
     (?$Be&(B . ?\x7D4B)  ;; <CJK>
     (?$Be'(B . ?\x7D2E)  ;; <CJK>
     (?$Be((B . ?\x7D32)  ;; <CJK>
     (?$Be)(B . ?\x7D3F)  ;; <CJK>
     (?$Be*(B . ?\x7D35)  ;; <CJK>
     (?$Be+(B . ?\x7D46)  ;; <CJK>
     (?$Be,(B . ?\x7D73)  ;; <CJK>
     (?$Be-(B . ?\x7D56)  ;; <CJK>
     (?$Be.(B . ?\x7D4E)  ;; <CJK>
     (?$Be/(B . ?\x7D72)  ;; <CJK>
     (?$Be0(B . ?\x7D68)  ;; <CJK>
     (?$Be1(B . ?\x7D6E)  ;; <CJK>
     (?$Be2(B . ?\x7D4F)  ;; <CJK>
     (?$Be3(B . ?\x7D63)  ;; <CJK>
     (?$Be4(B . ?\x7D93)  ;; <CJK>
     (?$Be5(B . ?\x7D89)  ;; <CJK>
     (?$Be6(B . ?\x7D5B)  ;; <CJK>
     (?$Be7(B . ?\x7D8F)  ;; <CJK>
     (?$Be8(B . ?\x7D7D)  ;; <CJK>
     (?$Be9(B . ?\x7D9B)  ;; <CJK>
     (?$Be:(B . ?\x7DBA)  ;; <CJK>
     (?$Be;(B . ?\x7DAE)  ;; <CJK>
     (?$Be<(B . ?\x7DA3)  ;; <CJK>
     (?$Be=(B . ?\x7DB5)  ;; <CJK>
     (?$Be>(B . ?\x7DC7)  ;; <CJK>
     (?$Be?(B . ?\x7DBD)  ;; <CJK>
     (?$Be@(B . ?\x7DAB)  ;; <CJK>
     (?$BeA(B . ?\x7E3D)  ;; <CJK>
     (?$BeB(B . ?\x7DA2)  ;; <CJK>
     (?$BeC(B . ?\x7DAF)  ;; <CJK>
     (?$BeD(B . ?\x7DDC)  ;; <CJK>
     (?$BeE(B . ?\x7DB8)  ;; <CJK>
     (?$BeF(B . ?\x7D9F)  ;; <CJK>
     (?$BeG(B . ?\x7DB0)  ;; <CJK>
     (?$BeH(B . ?\x7DD8)  ;; <CJK>
     (?$BeI(B . ?\x7DDD)  ;; <CJK>
     (?$BeJ(B . ?\x7DE4)  ;; <CJK>
     (?$BeK(B . ?\x7DDE)  ;; <CJK>
     (?$BeL(B . ?\x7DFB)  ;; <CJK>
     (?$BeM(B . ?\x7DF2)  ;; <CJK>
     (?$BeN(B . ?\x7DE1)  ;; <CJK>
     (?$BeO(B . ?\x7E05)  ;; <CJK>
     (?$BeP(B . ?\x7E0A)  ;; <CJK>
     (?$BeQ(B . ?\x7E23)  ;; <CJK>
     (?$BeR(B . ?\x7E21)  ;; <CJK>
     (?$BeS(B . ?\x7E12)  ;; <CJK>
     (?$BeT(B . ?\x7E31)  ;; <CJK>
     (?$BeU(B . ?\x7E1F)  ;; <CJK>
     (?$BeV(B . ?\x7E09)  ;; <CJK>
     (?$BeW(B . ?\x7E0B)  ;; <CJK>
     (?$BeX(B . ?\x7E22)  ;; <CJK>
     (?$BeY(B . ?\x7E46)  ;; <CJK>
     (?$BeZ(B . ?\x7E66)  ;; <CJK>
     (?$Be[(B . ?\x7E3B)  ;; <CJK>
     (?$Be\(B . ?\x7E35)  ;; <CJK>
     (?$Be](B . ?\x7E39)  ;; <CJK>
     (?$Be^(B . ?\x7E43)  ;; <CJK>
     (?$Be_(B . ?\x7E37)  ;; <CJK>
     (?$Be`(B . ?\x7E32)  ;; <CJK>
     (?$Bea(B . ?\x7E3A)  ;; <CJK>
     (?$Beb(B . ?\x7E67)  ;; <CJK>
     (?$Bec(B . ?\x7E5D)  ;; <CJK>
     (?$Bed(B . ?\x7E56)  ;; <CJK>
     (?$Bee(B . ?\x7E5E)  ;; <CJK>
     (?$Bef(B . ?\x7E59)  ;; <CJK>
     (?$Beg(B . ?\x7E5A)  ;; <CJK>
     (?$Beh(B . ?\x7E79)  ;; <CJK>
     (?$Bei(B . ?\x7E6A)  ;; <CJK>
     (?$Bej(B . ?\x7E69)  ;; <CJK>
     (?$Bek(B . ?\x7E7C)  ;; <CJK>
     (?$Bel(B . ?\x7E7B)  ;; <CJK>
     (?$Bem(B . ?\x7E83)  ;; <CJK>
     (?$Ben(B . ?\x7DD5)  ;; <CJK>
     (?$Beo(B . ?\x7E7D)  ;; <CJK>
     (?$Bep(B . ?\x8FAE)  ;; <CJK>
     (?$Beq(B . ?\x7E7F)  ;; <CJK>
     (?$Ber(B . ?\x7E88)  ;; <CJK>
     (?$Bes(B . ?\x7E89)  ;; <CJK>
     (?$Bet(B . ?\x7E8C)  ;; <CJK>
     (?$Beu(B . ?\x7E92)  ;; <CJK>
     (?$Bev(B . ?\x7E90)  ;; <CJK>
     (?$Bew(B . ?\x7E93)  ;; <CJK>
     (?$Bex(B . ?\x7E94)  ;; <CJK>
     (?$Bey(B . ?\x7E96)  ;; <CJK>
     (?$Bez(B . ?\x7E8E)  ;; <CJK>
     (?$Be{(B . ?\x7E9B)  ;; <CJK>
     (?$Be|(B . ?\x7E9C)  ;; <CJK>
     (?$Be}(B . ?\x7F38)  ;; <CJK>
     (?$Be~(B . ?\x7F3A)  ;; <CJK>
     (?$Bf!(B . ?\x7F45)  ;; <CJK>
     (?$Bf"(B . ?\x7F4C)  ;; <CJK>
     (?$Bf#(B . ?\x7F4D)  ;; <CJK>
     (?$Bf$(B . ?\x7F4E)  ;; <CJK>
     (?$Bf%(B . ?\x7F50)  ;; <CJK>
     (?$Bf&(B . ?\x7F51)  ;; <CJK>
     (?$Bf'(B . ?\x7F55)  ;; <CJK>
     (?$Bf((B . ?\x7F54)  ;; <CJK>
     (?$Bf)(B . ?\x7F58)  ;; <CJK>
     (?$Bf*(B . ?\x7F5F)  ;; <CJK>
     (?$Bf+(B . ?\x7F60)  ;; <CJK>
     (?$Bf,(B . ?\x7F68)  ;; <CJK>
     (?$Bf-(B . ?\x7F69)  ;; <CJK>
     (?$Bf.(B . ?\x7F67)  ;; <CJK>
     (?$Bf/(B . ?\x7F78)  ;; <CJK>
     (?$Bf0(B . ?\x7F82)  ;; <CJK>
     (?$Bf1(B . ?\x7F86)  ;; <CJK>
     (?$Bf2(B . ?\x7F83)  ;; <CJK>
     (?$Bf3(B . ?\x7F88)  ;; <CJK>
     (?$Bf4(B . ?\x7F87)  ;; <CJK>
     (?$Bf5(B . ?\x7F8C)  ;; <CJK>
     (?$Bf6(B . ?\x7F94)  ;; <CJK>
     (?$Bf7(B . ?\x7F9E)  ;; <CJK>
     (?$Bf8(B . ?\x7F9D)  ;; <CJK>
     (?$Bf9(B . ?\x7F9A)  ;; <CJK>
     (?$Bf:(B . ?\x7FA3)  ;; <CJK>
     (?$Bf;(B . ?\x7FAF)  ;; <CJK>
     (?$Bf<(B . ?\x7FB2)  ;; <CJK>
     (?$Bf=(B . ?\x7FB9)  ;; <CJK>
     (?$Bf>(B . ?\x7FAE)  ;; <CJK>
     (?$Bf?(B . ?\x7FB6)  ;; <CJK>
     (?$Bf@(B . ?\x7FB8)  ;; <CJK>
     (?$BfA(B . ?\x8B71)  ;; <CJK>
     (?$BfB(B . ?\x7FC5)  ;; <CJK>
     (?$BfC(B . ?\x7FC6)  ;; <CJK>
     (?$BfD(B . ?\x7FCA)  ;; <CJK>
     (?$BfE(B . ?\x7FD5)  ;; <CJK>
     (?$BfF(B . ?\x7FD4)  ;; <CJK>
     (?$BfG(B . ?\x7FE1)  ;; <CJK>
     (?$BfH(B . ?\x7FE6)  ;; <CJK>
     (?$BfI(B . ?\x7FE9)  ;; <CJK>
     (?$BfJ(B . ?\x7FF3)  ;; <CJK>
     (?$BfK(B . ?\x7FF9)  ;; <CJK>
     (?$BfL(B . ?\x98DC)  ;; <CJK>
     (?$BfM(B . ?\x8006)  ;; <CJK>
     (?$BfN(B . ?\x8004)  ;; <CJK>
     (?$BfO(B . ?\x800B)  ;; <CJK>
     (?$BfP(B . ?\x8012)  ;; <CJK>
     (?$BfQ(B . ?\x8018)  ;; <CJK>
     (?$BfR(B . ?\x8019)  ;; <CJK>
     (?$BfS(B . ?\x801C)  ;; <CJK>
     (?$BfT(B . ?\x8021)  ;; <CJK>
     (?$BfU(B . ?\x8028)  ;; <CJK>
     (?$BfV(B . ?\x803F)  ;; <CJK>
     (?$BfW(B . ?\x803B)  ;; <CJK>
     (?$BfX(B . ?\x804A)  ;; <CJK>
     (?$BfY(B . ?\x8046)  ;; <CJK>
     (?$BfZ(B . ?\x8052)  ;; <CJK>
     (?$Bf[(B . ?\x8058)  ;; <CJK>
     (?$Bf\(B . ?\x805A)  ;; <CJK>
     (?$Bf](B . ?\x805F)  ;; <CJK>
     (?$Bf^(B . ?\x8062)  ;; <CJK>
     (?$Bf_(B . ?\x8068)  ;; <CJK>
     (?$Bf`(B . ?\x8073)  ;; <CJK>
     (?$Bfa(B . ?\x8072)  ;; <CJK>
     (?$Bfb(B . ?\x8070)  ;; <CJK>
     (?$Bfc(B . ?\x8076)  ;; <CJK>
     (?$Bfd(B . ?\x8079)  ;; <CJK>
     (?$Bfe(B . ?\x807D)  ;; <CJK>
     (?$Bff(B . ?\x807F)  ;; <CJK>
     (?$Bfg(B . ?\x8084)  ;; <CJK>
     (?$Bfh(B . ?\x8086)  ;; <CJK>
     (?$Bfi(B . ?\x8085)  ;; <CJK>
     (?$Bfj(B . ?\x809B)  ;; <CJK>
     (?$Bfk(B . ?\x8093)  ;; <CJK>
     (?$Bfl(B . ?\x809A)  ;; <CJK>
     (?$Bfm(B . ?\x80AD)  ;; <CJK>
     (?$Bfn(B . ?\x5190)  ;; <CJK>
     (?$Bfo(B . ?\x80AC)  ;; <CJK>
     (?$Bfp(B . ?\x80DB)  ;; <CJK>
     (?$Bfq(B . ?\x80E5)  ;; <CJK>
     (?$Bfr(B . ?\x80D9)  ;; <CJK>
     (?$Bfs(B . ?\x80DD)  ;; <CJK>
     (?$Bft(B . ?\x80C4)  ;; <CJK>
     (?$Bfu(B . ?\x80DA)  ;; <CJK>
     (?$Bfv(B . ?\x80D6)  ;; <CJK>
     (?$Bfw(B . ?\x8109)  ;; <CJK>
     (?$Bfx(B . ?\x80EF)  ;; <CJK>
     (?$Bfy(B . ?\x80F1)  ;; <CJK>
     (?$Bfz(B . ?\x811B)  ;; <CJK>
     (?$Bf{(B . ?\x8129)  ;; <CJK>
     (?$Bf|(B . ?\x8123)  ;; <CJK>
     (?$Bf}(B . ?\x812F)  ;; <CJK>
     (?$Bf~(B . ?\x814B)  ;; <CJK>
     (?$Bg!(B . ?\x968B)  ;; <CJK>
     (?$Bg"(B . ?\x8146)  ;; <CJK>
     (?$Bg#(B . ?\x813E)  ;; <CJK>
     (?$Bg$(B . ?\x8153)  ;; <CJK>
     (?$Bg%(B . ?\x8151)  ;; <CJK>
     (?$Bg&(B . ?\x80FC)  ;; <CJK>
     (?$Bg'(B . ?\x8171)  ;; <CJK>
     (?$Bg((B . ?\x816E)  ;; <CJK>
     (?$Bg)(B . ?\x8165)  ;; <CJK>
     (?$Bg*(B . ?\x8166)  ;; <CJK>
     (?$Bg+(B . ?\x8174)  ;; <CJK>
     (?$Bg,(B . ?\x8183)  ;; <CJK>
     (?$Bg-(B . ?\x8188)  ;; <CJK>
     (?$Bg.(B . ?\x818A)  ;; <CJK>
     (?$Bg/(B . ?\x8180)  ;; <CJK>
     (?$Bg0(B . ?\x8182)  ;; <CJK>
     (?$Bg1(B . ?\x81A0)  ;; <CJK>
     (?$Bg2(B . ?\x8195)  ;; <CJK>
     (?$Bg3(B . ?\x81A4)  ;; <CJK>
     (?$Bg4(B . ?\x81A3)  ;; <CJK>
     (?$Bg5(B . ?\x815F)  ;; <CJK>
     (?$Bg6(B . ?\x8193)  ;; <CJK>
     (?$Bg7(B . ?\x81A9)  ;; <CJK>
     (?$Bg8(B . ?\x81B0)  ;; <CJK>
     (?$Bg9(B . ?\x81B5)  ;; <CJK>
     (?$Bg:(B . ?\x81BE)  ;; <CJK>
     (?$Bg;(B . ?\x81B8)  ;; <CJK>
     (?$Bg<(B . ?\x81BD)  ;; <CJK>
     (?$Bg=(B . ?\x81C0)  ;; <CJK>
     (?$Bg>(B . ?\x81C2)  ;; <CJK>
     (?$Bg?(B . ?\x81BA)  ;; <CJK>
     (?$Bg@(B . ?\x81C9)  ;; <CJK>
     (?$BgA(B . ?\x81CD)  ;; <CJK>
     (?$BgB(B . ?\x81D1)  ;; <CJK>
     (?$BgC(B . ?\x81D9)  ;; <CJK>
     (?$BgD(B . ?\x81D8)  ;; <CJK>
     (?$BgE(B . ?\x81C8)  ;; <CJK>
     (?$BgF(B . ?\x81DA)  ;; <CJK>
     (?$BgG(B . ?\x81DF)  ;; <CJK>
     (?$BgH(B . ?\x81E0)  ;; <CJK>
     (?$BgI(B . ?\x81E7)  ;; <CJK>
     (?$BgJ(B . ?\x81FA)  ;; <CJK>
     (?$BgK(B . ?\x81FB)  ;; <CJK>
     (?$BgL(B . ?\x81FE)  ;; <CJK>
     (?$BgM(B . ?\x8201)  ;; <CJK>
     (?$BgN(B . ?\x8202)  ;; <CJK>
     (?$BgO(B . ?\x8205)  ;; <CJK>
     (?$BgP(B . ?\x8207)  ;; <CJK>
     (?$BgQ(B . ?\x820A)  ;; <CJK>
     (?$BgR(B . ?\x820D)  ;; <CJK>
     (?$BgS(B . ?\x8210)  ;; <CJK>
     (?$BgT(B . ?\x8216)  ;; <CJK>
     (?$BgU(B . ?\x8229)  ;; <CJK>
     (?$BgV(B . ?\x822B)  ;; <CJK>
     (?$BgW(B . ?\x8238)  ;; <CJK>
     (?$BgX(B . ?\x8233)  ;; <CJK>
     (?$BgY(B . ?\x8240)  ;; <CJK>
     (?$BgZ(B . ?\x8259)  ;; <CJK>
     (?$Bg[(B . ?\x8258)  ;; <CJK>
     (?$Bg\(B . ?\x825D)  ;; <CJK>
     (?$Bg](B . ?\x825A)  ;; <CJK>
     (?$Bg^(B . ?\x825F)  ;; <CJK>
     (?$Bg_(B . ?\x8264)  ;; <CJK>
     (?$Bg`(B . ?\x8262)  ;; <CJK>
     (?$Bga(B . ?\x8268)  ;; <CJK>
     (?$Bgb(B . ?\x826A)  ;; <CJK>
     (?$Bgc(B . ?\x826B)  ;; <CJK>
     (?$Bgd(B . ?\x822E)  ;; <CJK>
     (?$Bge(B . ?\x8271)  ;; <CJK>
     (?$Bgf(B . ?\x8277)  ;; <CJK>
     (?$Bgg(B . ?\x8278)  ;; <CJK>
     (?$Bgh(B . ?\x827E)  ;; <CJK>
     (?$Bgi(B . ?\x828D)  ;; <CJK>
     (?$Bgj(B . ?\x8292)  ;; <CJK>
     (?$Bgk(B . ?\x82AB)  ;; <CJK>
     (?$Bgl(B . ?\x829F)  ;; <CJK>
     (?$Bgm(B . ?\x82BB)  ;; <CJK>
     (?$Bgn(B . ?\x82AC)  ;; <CJK>
     (?$Bgo(B . ?\x82E1)  ;; <CJK>
     (?$Bgp(B . ?\x82E3)  ;; <CJK>
     (?$Bgq(B . ?\x82DF)  ;; <CJK>
     (?$Bgr(B . ?\x82D2)  ;; <CJK>
     (?$Bgs(B . ?\x82F4)  ;; <CJK>
     (?$Bgt(B . ?\x82F3)  ;; <CJK>
     (?$Bgu(B . ?\x82FA)  ;; <CJK>
     (?$Bgv(B . ?\x8393)  ;; <CJK>
     (?$Bgw(B . ?\x8303)  ;; <CJK>
     (?$Bgx(B . ?\x82FB)  ;; <CJK>
     (?$Bgy(B . ?\x82F9)  ;; <CJK>
     (?$Bgz(B . ?\x82DE)  ;; <CJK>
     (?$Bg{(B . ?\x8306)  ;; <CJK>
     (?$Bg|(B . ?\x82DC)  ;; <CJK>
     (?$Bg}(B . ?\x8309)  ;; <CJK>
     (?$Bg~(B . ?\x82D9)  ;; <CJK>
     (?$Bh!(B . ?\x8335)  ;; <CJK>
     (?$Bh"(B . ?\x8334)  ;; <CJK>
     (?$Bh#(B . ?\x8316)  ;; <CJK>
     (?$Bh$(B . ?\x8332)  ;; <CJK>
     (?$Bh%(B . ?\x8331)  ;; <CJK>
     (?$Bh&(B . ?\x8340)  ;; <CJK>
     (?$Bh'(B . ?\x8339)  ;; <CJK>
     (?$Bh((B . ?\x8350)  ;; <CJK>
     (?$Bh)(B . ?\x8345)  ;; <CJK>
     (?$Bh*(B . ?\x832F)  ;; <CJK>
     (?$Bh+(B . ?\x832B)  ;; <CJK>
     (?$Bh,(B . ?\x8317)  ;; <CJK>
     (?$Bh-(B . ?\x8318)  ;; <CJK>
     (?$Bh.(B . ?\x8385)  ;; <CJK>
     (?$Bh/(B . ?\x839A)  ;; <CJK>
     (?$Bh0(B . ?\x83AA)  ;; <CJK>
     (?$Bh1(B . ?\x839F)  ;; <CJK>
     (?$Bh2(B . ?\x83A2)  ;; <CJK>
     (?$Bh3(B . ?\x8396)  ;; <CJK>
     (?$Bh4(B . ?\x8323)  ;; <CJK>
     (?$Bh5(B . ?\x838E)  ;; <CJK>
     (?$Bh6(B . ?\x8387)  ;; <CJK>
     (?$Bh7(B . ?\x838A)  ;; <CJK>
     (?$Bh8(B . ?\x837C)  ;; <CJK>
     (?$Bh9(B . ?\x83B5)  ;; <CJK>
     (?$Bh:(B . ?\x8373)  ;; <CJK>
     (?$Bh;(B . ?\x8375)  ;; <CJK>
     (?$Bh<(B . ?\x83A0)  ;; <CJK>
     (?$Bh=(B . ?\x8389)  ;; <CJK>
     (?$Bh>(B . ?\x83A8)  ;; <CJK>
     (?$Bh?(B . ?\x83F4)  ;; <CJK>
     (?$Bh@(B . ?\x8413)  ;; <CJK>
     (?$BhA(B . ?\x83EB)  ;; <CJK>
     (?$BhB(B . ?\x83CE)  ;; <CJK>
     (?$BhC(B . ?\x83FD)  ;; <CJK>
     (?$BhD(B . ?\x8403)  ;; <CJK>
     (?$BhE(B . ?\x83D8)  ;; <CJK>
     (?$BhF(B . ?\x840B)  ;; <CJK>
     (?$BhG(B . ?\x83C1)  ;; <CJK>
     (?$BhH(B . ?\x83F7)  ;; <CJK>
     (?$BhI(B . ?\x8407)  ;; <CJK>
     (?$BhJ(B . ?\x83E0)  ;; <CJK>
     (?$BhK(B . ?\x83F2)  ;; <CJK>
     (?$BhL(B . ?\x840D)  ;; <CJK>
     (?$BhM(B . ?\x8422)  ;; <CJK>
     (?$BhN(B . ?\x8420)  ;; <CJK>
     (?$BhO(B . ?\x83BD)  ;; <CJK>
     (?$BhP(B . ?\x8438)  ;; <CJK>
     (?$BhQ(B . ?\x8506)  ;; <CJK>
     (?$BhR(B . ?\x83FB)  ;; <CJK>
     (?$BhS(B . ?\x846D)  ;; <CJK>
     (?$BhT(B . ?\x842A)  ;; <CJK>
     (?$BhU(B . ?\x843C)  ;; <CJK>
     (?$BhV(B . ?\x855A)  ;; <CJK>
     (?$BhW(B . ?\x8484)  ;; <CJK>
     (?$BhX(B . ?\x8477)  ;; <CJK>
     (?$BhY(B . ?\x846B)  ;; <CJK>
     (?$BhZ(B . ?\x84AD)  ;; <CJK>
     (?$Bh[(B . ?\x846E)  ;; <CJK>
     (?$Bh\(B . ?\x8482)  ;; <CJK>
     (?$Bh](B . ?\x8469)  ;; <CJK>
     (?$Bh^(B . ?\x8446)  ;; <CJK>
     (?$Bh_(B . ?\x842C)  ;; <CJK>
     (?$Bh`(B . ?\x846F)  ;; <CJK>
     (?$Bha(B . ?\x8479)  ;; <CJK>
     (?$Bhb(B . ?\x8435)  ;; <CJK>
     (?$Bhc(B . ?\x84CA)  ;; <CJK>
     (?$Bhd(B . ?\x8462)  ;; <CJK>
     (?$Bhe(B . ?\x84B9)  ;; <CJK>
     (?$Bhf(B . ?\x84BF)  ;; <CJK>
     (?$Bhg(B . ?\x849F)  ;; <CJK>
     (?$Bhh(B . ?\x84D9)  ;; <CJK>
     (?$Bhi(B . ?\x84CD)  ;; <CJK>
     (?$Bhj(B . ?\x84BB)  ;; <CJK>
     (?$Bhk(B . ?\x84DA)  ;; <CJK>
     (?$Bhl(B . ?\x84D0)  ;; <CJK>
     (?$Bhm(B . ?\x84C1)  ;; <CJK>
     (?$Bhn(B . ?\x84C6)  ;; <CJK>
     (?$Bho(B . ?\x84D6)  ;; <CJK>
     (?$Bhp(B . ?\x84A1)  ;; <CJK>
     (?$Bhq(B . ?\x8521)  ;; <CJK>
     (?$Bhr(B . ?\x84FF)  ;; <CJK>
     (?$Bhs(B . ?\x84F4)  ;; <CJK>
     (?$Bht(B . ?\x8517)  ;; <CJK>
     (?$Bhu(B . ?\x8518)  ;; <CJK>
     (?$Bhv(B . ?\x852C)  ;; <CJK>
     (?$Bhw(B . ?\x851F)  ;; <CJK>
     (?$Bhx(B . ?\x8515)  ;; <CJK>
     (?$Bhy(B . ?\x8514)  ;; <CJK>
     (?$Bhz(B . ?\x84FC)  ;; <CJK>
     (?$Bh{(B . ?\x8540)  ;; <CJK>
     (?$Bh|(B . ?\x8563)  ;; <CJK>
     (?$Bh}(B . ?\x8558)  ;; <CJK>
     (?$Bh~(B . ?\x8548)  ;; <CJK>
     (?$Bi!(B . ?\x8541)  ;; <CJK>
     (?$Bi"(B . ?\x8602)  ;; <CJK>
     (?$Bi#(B . ?\x854B)  ;; <CJK>
     (?$Bi$(B . ?\x8555)  ;; <CJK>
     (?$Bi%(B . ?\x8580)  ;; <CJK>
     (?$Bi&(B . ?\x85A4)  ;; <CJK>
     (?$Bi'(B . ?\x8588)  ;; <CJK>
     (?$Bi((B . ?\x8591)  ;; <CJK>
     (?$Bi)(B . ?\x858A)  ;; <CJK>
     (?$Bi*(B . ?\x85A8)  ;; <CJK>
     (?$Bi+(B . ?\x856D)  ;; <CJK>
     (?$Bi,(B . ?\x8594)  ;; <CJK>
     (?$Bi-(B . ?\x859B)  ;; <CJK>
     (?$Bi.(B . ?\x85EA)  ;; <CJK>
     (?$Bi/(B . ?\x8587)  ;; <CJK>
     (?$Bi0(B . ?\x859C)  ;; <CJK>
     (?$Bi1(B . ?\x8577)  ;; <CJK>
     (?$Bi2(B . ?\x857E)  ;; <CJK>
     (?$Bi3(B . ?\x8590)  ;; <CJK>
     (?$Bi4(B . ?\x85C9)  ;; <CJK>
     (?$Bi5(B . ?\x85BA)  ;; <CJK>
     (?$Bi6(B . ?\x85CF)  ;; <CJK>
     (?$Bi7(B . ?\x85B9)  ;; <CJK>
     (?$Bi8(B . ?\x85D0)  ;; <CJK>
     (?$Bi9(B . ?\x85D5)  ;; <CJK>
     (?$Bi:(B . ?\x85DD)  ;; <CJK>
     (?$Bi;(B . ?\x85E5)  ;; <CJK>
     (?$Bi<(B . ?\x85DC)  ;; <CJK>
     (?$Bi=(B . ?\x85F9)  ;; <CJK>
     (?$Bi>(B . ?\x860A)  ;; <CJK>
     (?$Bi?(B . ?\x8613)  ;; <CJK>
     (?$Bi@(B . ?\x860B)  ;; <CJK>
     (?$BiA(B . ?\x85FE)  ;; <CJK>
     (?$BiB(B . ?\x85FA)  ;; <CJK>
     (?$BiC(B . ?\x8606)  ;; <CJK>
     (?$BiD(B . ?\x8622)  ;; <CJK>
     (?$BiE(B . ?\x861A)  ;; <CJK>
     (?$BiF(B . ?\x8630)  ;; <CJK>
     (?$BiG(B . ?\x863F)  ;; <CJK>
     (?$BiH(B . ?\x864D)  ;; <CJK>
     (?$BiI(B . ?\x4E55)  ;; <CJK>
     (?$BiJ(B . ?\x8654)  ;; <CJK>
     (?$BiK(B . ?\x865F)  ;; <CJK>
     (?$BiL(B . ?\x8667)  ;; <CJK>
     (?$BiM(B . ?\x8671)  ;; <CJK>
     (?$BiN(B . ?\x8693)  ;; <CJK>
     (?$BiO(B . ?\x86A3)  ;; <CJK>
     (?$BiP(B . ?\x86A9)  ;; <CJK>
     (?$BiQ(B . ?\x86AA)  ;; <CJK>
     (?$BiR(B . ?\x868B)  ;; <CJK>
     (?$BiS(B . ?\x868C)  ;; <CJK>
     (?$BiT(B . ?\x86B6)  ;; <CJK>
     (?$BiU(B . ?\x86AF)  ;; <CJK>
     (?$BiV(B . ?\x86C4)  ;; <CJK>
     (?$BiW(B . ?\x86C6)  ;; <CJK>
     (?$BiX(B . ?\x86B0)  ;; <CJK>
     (?$BiY(B . ?\x86C9)  ;; <CJK>
     (?$BiZ(B . ?\x8823)  ;; <CJK>
     (?$Bi[(B . ?\x86AB)  ;; <CJK>
     (?$Bi\(B . ?\x86D4)  ;; <CJK>
     (?$Bi](B . ?\x86DE)  ;; <CJK>
     (?$Bi^(B . ?\x86E9)  ;; <CJK>
     (?$Bi_(B . ?\x86EC)  ;; <CJK>
     (?$Bi`(B . ?\x86DF)  ;; <CJK>
     (?$Bia(B . ?\x86DB)  ;; <CJK>
     (?$Bib(B . ?\x86EF)  ;; <CJK>
     (?$Bic(B . ?\x8712)  ;; <CJK>
     (?$Bid(B . ?\x8706)  ;; <CJK>
     (?$Bie(B . ?\x8708)  ;; <CJK>
     (?$Bif(B . ?\x8700)  ;; <CJK>
     (?$Big(B . ?\x8703)  ;; <CJK>
     (?$Bih(B . ?\x86FB)  ;; <CJK>
     (?$Bii(B . ?\x8711)  ;; <CJK>
     (?$Bij(B . ?\x8709)  ;; <CJK>
     (?$Bik(B . ?\x870D)  ;; <CJK>
     (?$Bil(B . ?\x86F9)  ;; <CJK>
     (?$Bim(B . ?\x870A)  ;; <CJK>
     (?$Bin(B . ?\x8734)  ;; <CJK>
     (?$Bio(B . ?\x873F)  ;; <CJK>
     (?$Bip(B . ?\x8737)  ;; <CJK>
     (?$Biq(B . ?\x873B)  ;; <CJK>
     (?$Bir(B . ?\x8725)  ;; <CJK>
     (?$Bis(B . ?\x8729)  ;; <CJK>
     (?$Bit(B . ?\x871A)  ;; <CJK>
     (?$Biu(B . ?\x8760)  ;; <CJK>
     (?$Biv(B . ?\x875F)  ;; <CJK>
     (?$Biw(B . ?\x8778)  ;; <CJK>
     (?$Bix(B . ?\x874C)  ;; <CJK>
     (?$Biy(B . ?\x874E)  ;; <CJK>
     (?$Biz(B . ?\x8774)  ;; <CJK>
     (?$Bi{(B . ?\x8757)  ;; <CJK>
     (?$Bi|(B . ?\x8768)  ;; <CJK>
     (?$Bi}(B . ?\x876E)  ;; <CJK>
     (?$Bi~(B . ?\x8759)  ;; <CJK>
     (?$Bj!(B . ?\x8753)  ;; <CJK>
     (?$Bj"(B . ?\x8763)  ;; <CJK>
     (?$Bj#(B . ?\x876A)  ;; <CJK>
     (?$Bj$(B . ?\x8805)  ;; <CJK>
     (?$Bj%(B . ?\x87A2)  ;; <CJK>
     (?$Bj&(B . ?\x879F)  ;; <CJK>
     (?$Bj'(B . ?\x8782)  ;; <CJK>
     (?$Bj((B . ?\x87AF)  ;; <CJK>
     (?$Bj)(B . ?\x87CB)  ;; <CJK>
     (?$Bj*(B . ?\x87BD)  ;; <CJK>
     (?$Bj+(B . ?\x87C0)  ;; <CJK>
     (?$Bj,(B . ?\x87D0)  ;; <CJK>
     (?$Bj-(B . ?\x96D6)  ;; <CJK>
     (?$Bj.(B . ?\x87AB)  ;; <CJK>
     (?$Bj/(B . ?\x87C4)  ;; <CJK>
     (?$Bj0(B . ?\x87B3)  ;; <CJK>
     (?$Bj1(B . ?\x87C7)  ;; <CJK>
     (?$Bj2(B . ?\x87C6)  ;; <CJK>
     (?$Bj3(B . ?\x87BB)  ;; <CJK>
     (?$Bj4(B . ?\x87EF)  ;; <CJK>
     (?$Bj5(B . ?\x87F2)  ;; <CJK>
     (?$Bj6(B . ?\x87E0)  ;; <CJK>
     (?$Bj7(B . ?\x880F)  ;; <CJK>
     (?$Bj8(B . ?\x880D)  ;; <CJK>
     (?$Bj9(B . ?\x87FE)  ;; <CJK>
     (?$Bj:(B . ?\x87F6)  ;; <CJK>
     (?$Bj;(B . ?\x87F7)  ;; <CJK>
     (?$Bj<(B . ?\x880E)  ;; <CJK>
     (?$Bj=(B . ?\x87D2)  ;; <CJK>
     (?$Bj>(B . ?\x8811)  ;; <CJK>
     (?$Bj?(B . ?\x8816)  ;; <CJK>
     (?$Bj@(B . ?\x8815)  ;; <CJK>
     (?$BjA(B . ?\x8822)  ;; <CJK>
     (?$BjB(B . ?\x8821)  ;; <CJK>
     (?$BjC(B . ?\x8831)  ;; <CJK>
     (?$BjD(B . ?\x8836)  ;; <CJK>
     (?$BjE(B . ?\x8839)  ;; <CJK>
     (?$BjF(B . ?\x8827)  ;; <CJK>
     (?$BjG(B . ?\x883B)  ;; <CJK>
     (?$BjH(B . ?\x8844)  ;; <CJK>
     (?$BjI(B . ?\x8842)  ;; <CJK>
     (?$BjJ(B . ?\x8852)  ;; <CJK>
     (?$BjK(B . ?\x8859)  ;; <CJK>
     (?$BjL(B . ?\x885E)  ;; <CJK>
     (?$BjM(B . ?\x8862)  ;; <CJK>
     (?$BjN(B . ?\x886B)  ;; <CJK>
     (?$BjO(B . ?\x8881)  ;; <CJK>
     (?$BjP(B . ?\x887E)  ;; <CJK>
     (?$BjQ(B . ?\x889E)  ;; <CJK>
     (?$BjR(B . ?\x8875)  ;; <CJK>
     (?$BjS(B . ?\x887D)  ;; <CJK>
     (?$BjT(B . ?\x88B5)  ;; <CJK>
     (?$BjU(B . ?\x8872)  ;; <CJK>
     (?$BjV(B . ?\x8882)  ;; <CJK>
     (?$BjW(B . ?\x8897)  ;; <CJK>
     (?$BjX(B . ?\x8892)  ;; <CJK>
     (?$BjY(B . ?\x88AE)  ;; <CJK>
     (?$BjZ(B . ?\x8899)  ;; <CJK>
     (?$Bj[(B . ?\x88A2)  ;; <CJK>
     (?$Bj\(B . ?\x888D)  ;; <CJK>
     (?$Bj](B . ?\x88A4)  ;; <CJK>
     (?$Bj^(B . ?\x88B0)  ;; <CJK>
     (?$Bj_(B . ?\x88BF)  ;; <CJK>
     (?$Bj`(B . ?\x88B1)  ;; <CJK>
     (?$Bja(B . ?\x88C3)  ;; <CJK>
     (?$Bjb(B . ?\x88C4)  ;; <CJK>
     (?$Bjc(B . ?\x88D4)  ;; <CJK>
     (?$Bjd(B . ?\x88D8)  ;; <CJK>
     (?$Bje(B . ?\x88D9)  ;; <CJK>
     (?$Bjf(B . ?\x88DD)  ;; <CJK>
     (?$Bjg(B . ?\x88F9)  ;; <CJK>
     (?$Bjh(B . ?\x8902)  ;; <CJK>
     (?$Bji(B . ?\x88FC)  ;; <CJK>
     (?$Bjj(B . ?\x88F4)  ;; <CJK>
     (?$Bjk(B . ?\x88E8)  ;; <CJK>
     (?$Bjl(B . ?\x88F2)  ;; <CJK>
     (?$Bjm(B . ?\x8904)  ;; <CJK>
     (?$Bjn(B . ?\x890C)  ;; <CJK>
     (?$Bjo(B . ?\x890A)  ;; <CJK>
     (?$Bjp(B . ?\x8913)  ;; <CJK>
     (?$Bjq(B . ?\x8943)  ;; <CJK>
     (?$Bjr(B . ?\x891E)  ;; <CJK>
     (?$Bjs(B . ?\x8925)  ;; <CJK>
     (?$Bjt(B . ?\x892A)  ;; <CJK>
     (?$Bju(B . ?\x892B)  ;; <CJK>
     (?$Bjv(B . ?\x8941)  ;; <CJK>
     (?$Bjw(B . ?\x8944)  ;; <CJK>
     (?$Bjx(B . ?\x893B)  ;; <CJK>
     (?$Bjy(B . ?\x8936)  ;; <CJK>
     (?$Bjz(B . ?\x8938)  ;; <CJK>
     (?$Bj{(B . ?\x894C)  ;; <CJK>
     (?$Bj|(B . ?\x891D)  ;; <CJK>
     (?$Bj}(B . ?\x8960)  ;; <CJK>
     (?$Bj~(B . ?\x895E)  ;; <CJK>
     (?$Bk!(B . ?\x8966)  ;; <CJK>
     (?$Bk"(B . ?\x8964)  ;; <CJK>
     (?$Bk#(B . ?\x896D)  ;; <CJK>
     (?$Bk$(B . ?\x896A)  ;; <CJK>
     (?$Bk%(B . ?\x896F)  ;; <CJK>
     (?$Bk&(B . ?\x8974)  ;; <CJK>
     (?$Bk'(B . ?\x8977)  ;; <CJK>
     (?$Bk((B . ?\x897E)  ;; <CJK>
     (?$Bk)(B . ?\x8983)  ;; <CJK>
     (?$Bk*(B . ?\x8988)  ;; <CJK>
     (?$Bk+(B . ?\x898A)  ;; <CJK>
     (?$Bk,(B . ?\x8993)  ;; <CJK>
     (?$Bk-(B . ?\x8998)  ;; <CJK>
     (?$Bk.(B . ?\x89A1)  ;; <CJK>
     (?$Bk/(B . ?\x89A9)  ;; <CJK>
     (?$Bk0(B . ?\x89A6)  ;; <CJK>
     (?$Bk1(B . ?\x89AC)  ;; <CJK>
     (?$Bk2(B . ?\x89AF)  ;; <CJK>
     (?$Bk3(B . ?\x89B2)  ;; <CJK>
     (?$Bk4(B . ?\x89BA)  ;; <CJK>
     (?$Bk5(B . ?\x89BD)  ;; <CJK>
     (?$Bk6(B . ?\x89BF)  ;; <CJK>
     (?$Bk7(B . ?\x89C0)  ;; <CJK>
     (?$Bk8(B . ?\x89DA)  ;; <CJK>
     (?$Bk9(B . ?\x89DC)  ;; <CJK>
     (?$Bk:(B . ?\x89DD)  ;; <CJK>
     (?$Bk;(B . ?\x89E7)  ;; <CJK>
     (?$Bk<(B . ?\x89F4)  ;; <CJK>
     (?$Bk=(B . ?\x89F8)  ;; <CJK>
     (?$Bk>(B . ?\x8A03)  ;; <CJK>
     (?$Bk?(B . ?\x8A16)  ;; <CJK>
     (?$Bk@(B . ?\x8A10)  ;; <CJK>
     (?$BkA(B . ?\x8A0C)  ;; <CJK>
     (?$BkB(B . ?\x8A1B)  ;; <CJK>
     (?$BkC(B . ?\x8A1D)  ;; <CJK>
     (?$BkD(B . ?\x8A25)  ;; <CJK>
     (?$BkE(B . ?\x8A36)  ;; <CJK>
     (?$BkF(B . ?\x8A41)  ;; <CJK>
     (?$BkG(B . ?\x8A5B)  ;; <CJK>
     (?$BkH(B . ?\x8A52)  ;; <CJK>
     (?$BkI(B . ?\x8A46)  ;; <CJK>
     (?$BkJ(B . ?\x8A48)  ;; <CJK>
     (?$BkK(B . ?\x8A7C)  ;; <CJK>
     (?$BkL(B . ?\x8A6D)  ;; <CJK>
     (?$BkM(B . ?\x8A6C)  ;; <CJK>
     (?$BkN(B . ?\x8A62)  ;; <CJK>
     (?$BkO(B . ?\x8A85)  ;; <CJK>
     (?$BkP(B . ?\x8A82)  ;; <CJK>
     (?$BkQ(B . ?\x8A84)  ;; <CJK>
     (?$BkR(B . ?\x8AA8)  ;; <CJK>
     (?$BkS(B . ?\x8AA1)  ;; <CJK>
     (?$BkT(B . ?\x8A91)  ;; <CJK>
     (?$BkU(B . ?\x8AA5)  ;; <CJK>
     (?$BkV(B . ?\x8AA6)  ;; <CJK>
     (?$BkW(B . ?\x8A9A)  ;; <CJK>
     (?$BkX(B . ?\x8AA3)  ;; <CJK>
     (?$BkY(B . ?\x8AC4)  ;; <CJK>
     (?$BkZ(B . ?\x8ACD)  ;; <CJK>
     (?$Bk[(B . ?\x8AC2)  ;; <CJK>
     (?$Bk\(B . ?\x8ADA)  ;; <CJK>
     (?$Bk](B . ?\x8AEB)  ;; <CJK>
     (?$Bk^(B . ?\x8AF3)  ;; <CJK>
     (?$Bk_(B . ?\x8AE7)  ;; <CJK>
     (?$Bk`(B . ?\x8AE4)  ;; <CJK>
     (?$Bka(B . ?\x8AF1)  ;; <CJK>
     (?$Bkb(B . ?\x8B14)  ;; <CJK>
     (?$Bkc(B . ?\x8AE0)  ;; <CJK>
     (?$Bkd(B . ?\x8AE2)  ;; <CJK>
     (?$Bke(B . ?\x8AF7)  ;; <CJK>
     (?$Bkf(B . ?\x8ADE)  ;; <CJK>
     (?$Bkg(B . ?\x8ADB)  ;; <CJK>
     (?$Bkh(B . ?\x8B0C)  ;; <CJK>
     (?$Bki(B . ?\x8B07)  ;; <CJK>
     (?$Bkj(B . ?\x8B1A)  ;; <CJK>
     (?$Bkk(B . ?\x8AE1)  ;; <CJK>
     (?$Bkl(B . ?\x8B16)  ;; <CJK>
     (?$Bkm(B . ?\x8B10)  ;; <CJK>
     (?$Bkn(B . ?\x8B17)  ;; <CJK>
     (?$Bko(B . ?\x8B20)  ;; <CJK>
     (?$Bkp(B . ?\x8B33)  ;; <CJK>
     (?$Bkq(B . ?\x97AB)  ;; <CJK>
     (?$Bkr(B . ?\x8B26)  ;; <CJK>
     (?$Bks(B . ?\x8B2B)  ;; <CJK>
     (?$Bkt(B . ?\x8B3E)  ;; <CJK>
     (?$Bku(B . ?\x8B28)  ;; <CJK>
     (?$Bkv(B . ?\x8B41)  ;; <CJK>
     (?$Bkw(B . ?\x8B4C)  ;; <CJK>
     (?$Bkx(B . ?\x8B4F)  ;; <CJK>
     (?$Bky(B . ?\x8B4E)  ;; <CJK>
     (?$Bkz(B . ?\x8B49)  ;; <CJK>
     (?$Bk{(B . ?\x8B56)  ;; <CJK>
     (?$Bk|(B . ?\x8B5B)  ;; <CJK>
     (?$Bk}(B . ?\x8B5A)  ;; <CJK>
     (?$Bk~(B . ?\x8B6B)  ;; <CJK>
     (?$Bl!(B . ?\x8B5F)  ;; <CJK>
     (?$Bl"(B . ?\x8B6C)  ;; <CJK>
     (?$Bl#(B . ?\x8B6F)  ;; <CJK>
     (?$Bl$(B . ?\x8B74)  ;; <CJK>
     (?$Bl%(B . ?\x8B7D)  ;; <CJK>
     (?$Bl&(B . ?\x8B80)  ;; <CJK>
     (?$Bl'(B . ?\x8B8C)  ;; <CJK>
     (?$Bl((B . ?\x8B8E)  ;; <CJK>
     (?$Bl)(B . ?\x8B92)  ;; <CJK>
     (?$Bl*(B . ?\x8B93)  ;; <CJK>
     (?$Bl+(B . ?\x8B96)  ;; <CJK>
     (?$Bl,(B . ?\x8B99)  ;; <CJK>
     (?$Bl-(B . ?\x8B9A)  ;; <CJK>
     (?$Bl.(B . ?\x8C3A)  ;; <CJK>
     (?$Bl/(B . ?\x8C41)  ;; <CJK>
     (?$Bl0(B . ?\x8C3F)  ;; <CJK>
     (?$Bl1(B . ?\x8C48)  ;; <CJK>
     (?$Bl2(B . ?\x8C4C)  ;; <CJK>
     (?$Bl3(B . ?\x8C4E)  ;; <CJK>
     (?$Bl4(B . ?\x8C50)  ;; <CJK>
     (?$Bl5(B . ?\x8C55)  ;; <CJK>
     (?$Bl6(B . ?\x8C62)  ;; <CJK>
     (?$Bl7(B . ?\x8C6C)  ;; <CJK>
     (?$Bl8(B . ?\x8C78)  ;; <CJK>
     (?$Bl9(B . ?\x8C7A)  ;; <CJK>
     (?$Bl:(B . ?\x8C82)  ;; <CJK>
     (?$Bl;(B . ?\x8C89)  ;; <CJK>
     (?$Bl<(B . ?\x8C85)  ;; <CJK>
     (?$Bl=(B . ?\x8C8A)  ;; <CJK>
     (?$Bl>(B . ?\x8C8D)  ;; <CJK>
     (?$Bl?(B . ?\x8C8E)  ;; <CJK>
     (?$Bl@(B . ?\x8C94)  ;; <CJK>
     (?$BlA(B . ?\x8C7C)  ;; <CJK>
     (?$BlB(B . ?\x8C98)  ;; <CJK>
     (?$BlC(B . ?\x621D)  ;; <CJK>
     (?$BlD(B . ?\x8CAD)  ;; <CJK>
     (?$BlE(B . ?\x8CAA)  ;; <CJK>
     (?$BlF(B . ?\x8CBD)  ;; <CJK>
     (?$BlG(B . ?\x8CB2)  ;; <CJK>
     (?$BlH(B . ?\x8CB3)  ;; <CJK>
     (?$BlI(B . ?\x8CAE)  ;; <CJK>
     (?$BlJ(B . ?\x8CB6)  ;; <CJK>
     (?$BlK(B . ?\x8CC8)  ;; <CJK>
     (?$BlL(B . ?\x8CC1)  ;; <CJK>
     (?$BlM(B . ?\x8CE4)  ;; <CJK>
     (?$BlN(B . ?\x8CE3)  ;; <CJK>
     (?$BlO(B . ?\x8CDA)  ;; <CJK>
     (?$BlP(B . ?\x8CFD)  ;; <CJK>
     (?$BlQ(B . ?\x8CFA)  ;; <CJK>
     (?$BlR(B . ?\x8CFB)  ;; <CJK>
     (?$BlS(B . ?\x8D04)  ;; <CJK>
     (?$BlT(B . ?\x8D05)  ;; <CJK>
     (?$BlU(B . ?\x8D0A)  ;; <CJK>
     (?$BlV(B . ?\x8D07)  ;; <CJK>
     (?$BlW(B . ?\x8D0F)  ;; <CJK>
     (?$BlX(B . ?\x8D0D)  ;; <CJK>
     (?$BlY(B . ?\x8D10)  ;; <CJK>
     (?$BlZ(B . ?\x9F4E)  ;; <CJK>
     (?$Bl[(B . ?\x8D13)  ;; <CJK>
     (?$Bl\(B . ?\x8CCD)  ;; <CJK>
     (?$Bl](B . ?\x8D14)  ;; <CJK>
     (?$Bl^(B . ?\x8D16)  ;; <CJK>
     (?$Bl_(B . ?\x8D67)  ;; <CJK>
     (?$Bl`(B . ?\x8D6D)  ;; <CJK>
     (?$Bla(B . ?\x8D71)  ;; <CJK>
     (?$Blb(B . ?\x8D73)  ;; <CJK>
     (?$Blc(B . ?\x8D81)  ;; <CJK>
     (?$Bld(B . ?\x8D99)  ;; <CJK>
     (?$Ble(B . ?\x8DC2)  ;; <CJK>
     (?$Blf(B . ?\x8DBE)  ;; <CJK>
     (?$Blg(B . ?\x8DBA)  ;; <CJK>
     (?$Blh(B . ?\x8DCF)  ;; <CJK>
     (?$Bli(B . ?\x8DDA)  ;; <CJK>
     (?$Blj(B . ?\x8DD6)  ;; <CJK>
     (?$Blk(B . ?\x8DCC)  ;; <CJK>
     (?$Bll(B . ?\x8DDB)  ;; <CJK>
     (?$Blm(B . ?\x8DCB)  ;; <CJK>
     (?$Bln(B . ?\x8DEA)  ;; <CJK>
     (?$Blo(B . ?\x8DEB)  ;; <CJK>
     (?$Blp(B . ?\x8DDF)  ;; <CJK>
     (?$Blq(B . ?\x8DE3)  ;; <CJK>
     (?$Blr(B . ?\x8DFC)  ;; <CJK>
     (?$Bls(B . ?\x8E08)  ;; <CJK>
     (?$Blt(B . ?\x8E09)  ;; <CJK>
     (?$Blu(B . ?\x8DFF)  ;; <CJK>
     (?$Blv(B . ?\x8E1D)  ;; <CJK>
     (?$Blw(B . ?\x8E1E)  ;; <CJK>
     (?$Blx(B . ?\x8E10)  ;; <CJK>
     (?$Bly(B . ?\x8E1F)  ;; <CJK>
     (?$Blz(B . ?\x8E42)  ;; <CJK>
     (?$Bl{(B . ?\x8E35)  ;; <CJK>
     (?$Bl|(B . ?\x8E30)  ;; <CJK>
     (?$Bl}(B . ?\x8E34)  ;; <CJK>
     (?$Bl~(B . ?\x8E4A)  ;; <CJK>
     (?$Bm!(B . ?\x8E47)  ;; <CJK>
     (?$Bm"(B . ?\x8E49)  ;; <CJK>
     (?$Bm#(B . ?\x8E4C)  ;; <CJK>
     (?$Bm$(B . ?\x8E50)  ;; <CJK>
     (?$Bm%(B . ?\x8E48)  ;; <CJK>
     (?$Bm&(B . ?\x8E59)  ;; <CJK>
     (?$Bm'(B . ?\x8E64)  ;; <CJK>
     (?$Bm((B . ?\x8E60)  ;; <CJK>
     (?$Bm)(B . ?\x8E2A)  ;; <CJK>
     (?$Bm*(B . ?\x8E63)  ;; <CJK>
     (?$Bm+(B . ?\x8E55)  ;; <CJK>
     (?$Bm,(B . ?\x8E76)  ;; <CJK>
     (?$Bm-(B . ?\x8E72)  ;; <CJK>
     (?$Bm.(B . ?\x8E7C)  ;; <CJK>
     (?$Bm/(B . ?\x8E81)  ;; <CJK>
     (?$Bm0(B . ?\x8E87)  ;; <CJK>
     (?$Bm1(B . ?\x8E85)  ;; <CJK>
     (?$Bm2(B . ?\x8E84)  ;; <CJK>
     (?$Bm3(B . ?\x8E8B)  ;; <CJK>
     (?$Bm4(B . ?\x8E8A)  ;; <CJK>
     (?$Bm5(B . ?\x8E93)  ;; <CJK>
     (?$Bm6(B . ?\x8E91)  ;; <CJK>
     (?$Bm7(B . ?\x8E94)  ;; <CJK>
     (?$Bm8(B . ?\x8E99)  ;; <CJK>
     (?$Bm9(B . ?\x8EAA)  ;; <CJK>
     (?$Bm:(B . ?\x8EA1)  ;; <CJK>
     (?$Bm;(B . ?\x8EAC)  ;; <CJK>
     (?$Bm<(B . ?\x8EB0)  ;; <CJK>
     (?$Bm=(B . ?\x8EC6)  ;; <CJK>
     (?$Bm>(B . ?\x8EB1)  ;; <CJK>
     (?$Bm?(B . ?\x8EBE)  ;; <CJK>
     (?$Bm@(B . ?\x8EC5)  ;; <CJK>
     (?$BmA(B . ?\x8EC8)  ;; <CJK>
     (?$BmB(B . ?\x8ECB)  ;; <CJK>
     (?$BmC(B . ?\x8EDB)  ;; <CJK>
     (?$BmD(B . ?\x8EE3)  ;; <CJK>
     (?$BmE(B . ?\x8EFC)  ;; <CJK>
     (?$BmF(B . ?\x8EFB)  ;; <CJK>
     (?$BmG(B . ?\x8EEB)  ;; <CJK>
     (?$BmH(B . ?\x8EFE)  ;; <CJK>
     (?$BmI(B . ?\x8F0A)  ;; <CJK>
     (?$BmJ(B . ?\x8F05)  ;; <CJK>
     (?$BmK(B . ?\x8F15)  ;; <CJK>
     (?$BmL(B . ?\x8F12)  ;; <CJK>
     (?$BmM(B . ?\x8F19)  ;; <CJK>
     (?$BmN(B . ?\x8F13)  ;; <CJK>
     (?$BmO(B . ?\x8F1C)  ;; <CJK>
     (?$BmP(B . ?\x8F1F)  ;; <CJK>
     (?$BmQ(B . ?\x8F1B)  ;; <CJK>
     (?$BmR(B . ?\x8F0C)  ;; <CJK>
     (?$BmS(B . ?\x8F26)  ;; <CJK>
     (?$BmT(B . ?\x8F33)  ;; <CJK>
     (?$BmU(B . ?\x8F3B)  ;; <CJK>
     (?$BmV(B . ?\x8F39)  ;; <CJK>
     (?$BmW(B . ?\x8F45)  ;; <CJK>
     (?$BmX(B . ?\x8F42)  ;; <CJK>
     (?$BmY(B . ?\x8F3E)  ;; <CJK>
     (?$BmZ(B . ?\x8F4C)  ;; <CJK>
     (?$Bm[(B . ?\x8F49)  ;; <CJK>
     (?$Bm\(B . ?\x8F46)  ;; <CJK>
     (?$Bm](B . ?\x8F4E)  ;; <CJK>
     (?$Bm^(B . ?\x8F57)  ;; <CJK>
     (?$Bm_(B . ?\x8F5C)  ;; <CJK>
     (?$Bm`(B . ?\x8F62)  ;; <CJK>
     (?$Bma(B . ?\x8F63)  ;; <CJK>
     (?$Bmb(B . ?\x8F64)  ;; <CJK>
     (?$Bmc(B . ?\x8F9C)  ;; <CJK>
     (?$Bmd(B . ?\x8F9F)  ;; <CJK>
     (?$Bme(B . ?\x8FA3)  ;; <CJK>
     (?$Bmf(B . ?\x8FAD)  ;; <CJK>
     (?$Bmg(B . ?\x8FAF)  ;; <CJK>
     (?$Bmh(B . ?\x8FB7)  ;; <CJK>
     (?$Bmi(B . ?\x8FDA)  ;; <CJK>
     (?$Bmj(B . ?\x8FE5)  ;; <CJK>
     (?$Bmk(B . ?\x8FE2)  ;; <CJK>
     (?$Bml(B . ?\x8FEA)  ;; <CJK>
     (?$Bmm(B . ?\x8FEF)  ;; <CJK>
     (?$Bmn(B . ?\x9087)  ;; <CJK>
     (?$Bmo(B . ?\x8FF4)  ;; <CJK>
     (?$Bmp(B . ?\x9005)  ;; <CJK>
     (?$Bmq(B . ?\x8FF9)  ;; <CJK>
     (?$Bmr(B . ?\x8FFA)  ;; <CJK>
     (?$Bms(B . ?\x9011)  ;; <CJK>
     (?$Bmt(B . ?\x9015)  ;; <CJK>
     (?$Bmu(B . ?\x9021)  ;; <CJK>
     (?$Bmv(B . ?\x900D)  ;; <CJK>
     (?$Bmw(B . ?\x901E)  ;; <CJK>
     (?$Bmx(B . ?\x9016)  ;; <CJK>
     (?$Bmy(B . ?\x900B)  ;; <CJK>
     (?$Bmz(B . ?\x9027)  ;; <CJK>
     (?$Bm{(B . ?\x9036)  ;; <CJK>
     (?$Bm|(B . ?\x9035)  ;; <CJK>
     (?$Bm}(B . ?\x9039)  ;; <CJK>
     (?$Bm~(B . ?\x8FF8)  ;; <CJK>
     (?$Bn!(B . ?\x904F)  ;; <CJK>
     (?$Bn"(B . ?\x9050)  ;; <CJK>
     (?$Bn#(B . ?\x9051)  ;; <CJK>
     (?$Bn$(B . ?\x9052)  ;; <CJK>
     (?$Bn%(B . ?\x900E)  ;; <CJK>
     (?$Bn&(B . ?\x9049)  ;; <CJK>
     (?$Bn'(B . ?\x903E)  ;; <CJK>
     (?$Bn((B . ?\x9056)  ;; <CJK>
     (?$Bn)(B . ?\x9058)  ;; <CJK>
     (?$Bn*(B . ?\x905E)  ;; <CJK>
     (?$Bn+(B . ?\x9068)  ;; <CJK>
     (?$Bn,(B . ?\x906F)  ;; <CJK>
     (?$Bn-(B . ?\x9076)  ;; <CJK>
     (?$Bn.(B . ?\x96A8)  ;; <CJK>
     (?$Bn/(B . ?\x9072)  ;; <CJK>
     (?$Bn0(B . ?\x9082)  ;; <CJK>
     (?$Bn1(B . ?\x907D)  ;; <CJK>
     (?$Bn2(B . ?\x9081)  ;; <CJK>
     (?$Bn3(B . ?\x9080)  ;; <CJK>
     (?$Bn4(B . ?\x908A)  ;; <CJK>
     (?$Bn5(B . ?\x9089)  ;; <CJK>
     (?$Bn6(B . ?\x908F)  ;; <CJK>
     (?$Bn7(B . ?\x90A8)  ;; <CJK>
     (?$Bn8(B . ?\x90AF)  ;; <CJK>
     (?$Bn9(B . ?\x90B1)  ;; <CJK>
     (?$Bn:(B . ?\x90B5)  ;; <CJK>
     (?$Bn;(B . ?\x90E2)  ;; <CJK>
     (?$Bn<(B . ?\x90E4)  ;; <CJK>
     (?$Bn=(B . ?\x6248)  ;; <CJK>
     (?$Bn>(B . ?\x90DB)  ;; <CJK>
     (?$Bn?(B . ?\x9102)  ;; <CJK>
     (?$Bn@(B . ?\x9112)  ;; <CJK>
     (?$BnA(B . ?\x9119)  ;; <CJK>
     (?$BnB(B . ?\x9132)  ;; <CJK>
     (?$BnC(B . ?\x9130)  ;; <CJK>
     (?$BnD(B . ?\x914A)  ;; <CJK>
     (?$BnE(B . ?\x9156)  ;; <CJK>
     (?$BnF(B . ?\x9158)  ;; <CJK>
     (?$BnG(B . ?\x9163)  ;; <CJK>
     (?$BnH(B . ?\x9165)  ;; <CJK>
     (?$BnI(B . ?\x9169)  ;; <CJK>
     (?$BnJ(B . ?\x9173)  ;; <CJK>
     (?$BnK(B . ?\x9172)  ;; <CJK>
     (?$BnL(B . ?\x918B)  ;; <CJK>
     (?$BnM(B . ?\x9189)  ;; <CJK>
     (?$BnN(B . ?\x9182)  ;; <CJK>
     (?$BnO(B . ?\x91A2)  ;; <CJK>
     (?$BnP(B . ?\x91AB)  ;; <CJK>
     (?$BnQ(B . ?\x91AF)  ;; <CJK>
     (?$BnR(B . ?\x91AA)  ;; <CJK>
     (?$BnS(B . ?\x91B5)  ;; <CJK>
     (?$BnT(B . ?\x91B4)  ;; <CJK>
     (?$BnU(B . ?\x91BA)  ;; <CJK>
     (?$BnV(B . ?\x91C0)  ;; <CJK>
     (?$BnW(B . ?\x91C1)  ;; <CJK>
     (?$BnX(B . ?\x91C9)  ;; <CJK>
     (?$BnY(B . ?\x91CB)  ;; <CJK>
     (?$BnZ(B . ?\x91D0)  ;; <CJK>
     (?$Bn[(B . ?\x91D6)  ;; <CJK>
     (?$Bn\(B . ?\x91DF)  ;; <CJK>
     (?$Bn](B . ?\x91E1)  ;; <CJK>
     (?$Bn^(B . ?\x91DB)  ;; <CJK>
     (?$Bn_(B . ?\x91FC)  ;; <CJK>
     (?$Bn`(B . ?\x91F5)  ;; <CJK>
     (?$Bna(B . ?\x91F6)  ;; <CJK>
     (?$Bnb(B . ?\x921E)  ;; <CJK>
     (?$Bnc(B . ?\x91FF)  ;; <CJK>
     (?$Bnd(B . ?\x9214)  ;; <CJK>
     (?$Bne(B . ?\x922C)  ;; <CJK>
     (?$Bnf(B . ?\x9215)  ;; <CJK>
     (?$Bng(B . ?\x9211)  ;; <CJK>
     (?$Bnh(B . ?\x925E)  ;; <CJK>
     (?$Bni(B . ?\x9257)  ;; <CJK>
     (?$Bnj(B . ?\x9245)  ;; <CJK>
     (?$Bnk(B . ?\x9249)  ;; <CJK>
     (?$Bnl(B . ?\x9264)  ;; <CJK>
     (?$Bnm(B . ?\x9248)  ;; <CJK>
     (?$Bnn(B . ?\x9295)  ;; <CJK>
     (?$Bno(B . ?\x923F)  ;; <CJK>
     (?$Bnp(B . ?\x924B)  ;; <CJK>
     (?$Bnq(B . ?\x9250)  ;; <CJK>
     (?$Bnr(B . ?\x929C)  ;; <CJK>
     (?$Bns(B . ?\x9296)  ;; <CJK>
     (?$Bnt(B . ?\x9293)  ;; <CJK>
     (?$Bnu(B . ?\x929B)  ;; <CJK>
     (?$Bnv(B . ?\x925A)  ;; <CJK>
     (?$Bnw(B . ?\x92CF)  ;; <CJK>
     (?$Bnx(B . ?\x92B9)  ;; <CJK>
     (?$Bny(B . ?\x92B7)  ;; <CJK>
     (?$Bnz(B . ?\x92E9)  ;; <CJK>
     (?$Bn{(B . ?\x930F)  ;; <CJK>
     (?$Bn|(B . ?\x92FA)  ;; <CJK>
     (?$Bn}(B . ?\x9344)  ;; <CJK>
     (?$Bn~(B . ?\x932E)  ;; <CJK>
     (?$Bo!(B . ?\x9319)  ;; <CJK>
     (?$Bo"(B . ?\x9322)  ;; <CJK>
     (?$Bo#(B . ?\x931A)  ;; <CJK>
     (?$Bo$(B . ?\x9323)  ;; <CJK>
     (?$Bo%(B . ?\x933A)  ;; <CJK>
     (?$Bo&(B . ?\x9335)  ;; <CJK>
     (?$Bo'(B . ?\x933B)  ;; <CJK>
     (?$Bo((B . ?\x935C)  ;; <CJK>
     (?$Bo)(B . ?\x9360)  ;; <CJK>
     (?$Bo*(B . ?\x937C)  ;; <CJK>
     (?$Bo+(B . ?\x936E)  ;; <CJK>
     (?$Bo,(B . ?\x9356)  ;; <CJK>
     (?$Bo-(B . ?\x93B0)  ;; <CJK>
     (?$Bo.(B . ?\x93AC)  ;; <CJK>
     (?$Bo/(B . ?\x93AD)  ;; <CJK>
     (?$Bo0(B . ?\x9394)  ;; <CJK>
     (?$Bo1(B . ?\x93B9)  ;; <CJK>
     (?$Bo2(B . ?\x93D6)  ;; <CJK>
     (?$Bo3(B . ?\x93D7)  ;; <CJK>
     (?$Bo4(B . ?\x93E8)  ;; <CJK>
     (?$Bo5(B . ?\x93E5)  ;; <CJK>
     (?$Bo6(B . ?\x93D8)  ;; <CJK>
     (?$Bo7(B . ?\x93C3)  ;; <CJK>
     (?$Bo8(B . ?\x93DD)  ;; <CJK>
     (?$Bo9(B . ?\x93D0)  ;; <CJK>
     (?$Bo:(B . ?\x93C8)  ;; <CJK>
     (?$Bo;(B . ?\x93E4)  ;; <CJK>
     (?$Bo<(B . ?\x941A)  ;; <CJK>
     (?$Bo=(B . ?\x9414)  ;; <CJK>
     (?$Bo>(B . ?\x9413)  ;; <CJK>
     (?$Bo?(B . ?\x9403)  ;; <CJK>
     (?$Bo@(B . ?\x9407)  ;; <CJK>
     (?$BoA(B . ?\x9410)  ;; <CJK>
     (?$BoB(B . ?\x9436)  ;; <CJK>
     (?$BoC(B . ?\x942B)  ;; <CJK>
     (?$BoD(B . ?\x9435)  ;; <CJK>
     (?$BoE(B . ?\x9421)  ;; <CJK>
     (?$BoF(B . ?\x943A)  ;; <CJK>
     (?$BoG(B . ?\x9441)  ;; <CJK>
     (?$BoH(B . ?\x9452)  ;; <CJK>
     (?$BoI(B . ?\x9444)  ;; <CJK>
     (?$BoJ(B . ?\x945B)  ;; <CJK>
     (?$BoK(B . ?\x9460)  ;; <CJK>
     (?$BoL(B . ?\x9462)  ;; <CJK>
     (?$BoM(B . ?\x945E)  ;; <CJK>
     (?$BoN(B . ?\x946A)  ;; <CJK>
     (?$BoO(B . ?\x9229)  ;; <CJK>
     (?$BoP(B . ?\x9470)  ;; <CJK>
     (?$BoQ(B . ?\x9475)  ;; <CJK>
     (?$BoR(B . ?\x9477)  ;; <CJK>
     (?$BoS(B . ?\x947D)  ;; <CJK>
     (?$BoT(B . ?\x945A)  ;; <CJK>
     (?$BoU(B . ?\x947C)  ;; <CJK>
     (?$BoV(B . ?\x947E)  ;; <CJK>
     (?$BoW(B . ?\x9481)  ;; <CJK>
     (?$BoX(B . ?\x947F)  ;; <CJK>
     (?$BoY(B . ?\x9582)  ;; <CJK>
     (?$BoZ(B . ?\x9587)  ;; <CJK>
     (?$Bo[(B . ?\x958A)  ;; <CJK>
     (?$Bo\(B . ?\x9594)  ;; <CJK>
     (?$Bo](B . ?\x9596)  ;; <CJK>
     (?$Bo^(B . ?\x9598)  ;; <CJK>
     (?$Bo_(B . ?\x9599)  ;; <CJK>
     (?$Bo`(B . ?\x95A0)  ;; <CJK>
     (?$Boa(B . ?\x95A8)  ;; <CJK>
     (?$Bob(B . ?\x95A7)  ;; <CJK>
     (?$Boc(B . ?\x95AD)  ;; <CJK>
     (?$Bod(B . ?\x95BC)  ;; <CJK>
     (?$Boe(B . ?\x95BB)  ;; <CJK>
     (?$Bof(B . ?\x95B9)  ;; <CJK>
     (?$Bog(B . ?\x95BE)  ;; <CJK>
     (?$Boh(B . ?\x95CA)  ;; <CJK>
     (?$Boi(B . ?\x6FF6)  ;; <CJK>
     (?$Boj(B . ?\x95C3)  ;; <CJK>
     (?$Bok(B . ?\x95CD)  ;; <CJK>
     (?$Bol(B . ?\x95CC)  ;; <CJK>
     (?$Bom(B . ?\x95D5)  ;; <CJK>
     (?$Bon(B . ?\x95D4)  ;; <CJK>
     (?$Boo(B . ?\x95D6)  ;; <CJK>
     (?$Bop(B . ?\x95DC)  ;; <CJK>
     (?$Boq(B . ?\x95E1)  ;; <CJK>
     (?$Bor(B . ?\x95E5)  ;; <CJK>
     (?$Bos(B . ?\x95E2)  ;; <CJK>
     (?$Bot(B . ?\x9621)  ;; <CJK>
     (?$Bou(B . ?\x9628)  ;; <CJK>
     (?$Bov(B . ?\x962E)  ;; <CJK>
     (?$Bow(B . ?\x962F)  ;; <CJK>
     (?$Box(B . ?\x9642)  ;; <CJK>
     (?$Boy(B . ?\x964C)  ;; <CJK>
     (?$Boz(B . ?\x964F)  ;; <CJK>
     (?$Bo{(B . ?\x964B)  ;; <CJK>
     (?$Bo|(B . ?\x9677)  ;; <CJK>
     (?$Bo}(B . ?\x965C)  ;; <CJK>
     (?$Bo~(B . ?\x965E)  ;; <CJK>
     (?$Bp!(B . ?\x965D)  ;; <CJK>
     (?$Bp"(B . ?\x965F)  ;; <CJK>
     (?$Bp#(B . ?\x9666)  ;; <CJK>
     (?$Bp$(B . ?\x9672)  ;; <CJK>
     (?$Bp%(B . ?\x966C)  ;; <CJK>
     (?$Bp&(B . ?\x968D)  ;; <CJK>
     (?$Bp'(B . ?\x9698)  ;; <CJK>
     (?$Bp((B . ?\x9695)  ;; <CJK>
     (?$Bp)(B . ?\x9697)  ;; <CJK>
     (?$Bp*(B . ?\x96AA)  ;; <CJK>
     (?$Bp+(B . ?\x96A7)  ;; <CJK>
     (?$Bp,(B . ?\x96B1)  ;; <CJK>
     (?$Bp-(B . ?\x96B2)  ;; <CJK>
     (?$Bp.(B . ?\x96B0)  ;; <CJK>
     (?$Bp/(B . ?\x96B4)  ;; <CJK>
     (?$Bp0(B . ?\x96B6)  ;; <CJK>
     (?$Bp1(B . ?\x96B8)  ;; <CJK>
     (?$Bp2(B . ?\x96B9)  ;; <CJK>
     (?$Bp3(B . ?\x96CE)  ;; <CJK>
     (?$Bp4(B . ?\x96CB)  ;; <CJK>
     (?$Bp5(B . ?\x96C9)  ;; <CJK>
     (?$Bp6(B . ?\x96CD)  ;; <CJK>
     (?$Bp7(B . ?\x894D)  ;; <CJK>
     (?$Bp8(B . ?\x96DC)  ;; <CJK>
     (?$Bp9(B . ?\x970D)  ;; <CJK>
     (?$Bp:(B . ?\x96D5)  ;; <CJK>
     (?$Bp;(B . ?\x96F9)  ;; <CJK>
     (?$Bp<(B . ?\x9704)  ;; <CJK>
     (?$Bp=(B . ?\x9706)  ;; <CJK>
     (?$Bp>(B . ?\x9708)  ;; <CJK>
     (?$Bp?(B . ?\x9713)  ;; <CJK>
     (?$Bp@(B . ?\x970E)  ;; <CJK>
     (?$BpA(B . ?\x9711)  ;; <CJK>
     (?$BpB(B . ?\x970F)  ;; <CJK>
     (?$BpC(B . ?\x9716)  ;; <CJK>
     (?$BpD(B . ?\x9719)  ;; <CJK>
     (?$BpE(B . ?\x9724)  ;; <CJK>
     (?$BpF(B . ?\x972A)  ;; <CJK>
     (?$BpG(B . ?\x9730)  ;; <CJK>
     (?$BpH(B . ?\x9739)  ;; <CJK>
     (?$BpI(B . ?\x973D)  ;; <CJK>
     (?$BpJ(B . ?\x973E)  ;; <CJK>
     (?$BpK(B . ?\x9744)  ;; <CJK>
     (?$BpL(B . ?\x9746)  ;; <CJK>
     (?$BpM(B . ?\x9748)  ;; <CJK>
     (?$BpN(B . ?\x9742)  ;; <CJK>
     (?$BpO(B . ?\x9749)  ;; <CJK>
     (?$BpP(B . ?\x975C)  ;; <CJK>
     (?$BpQ(B . ?\x9760)  ;; <CJK>
     (?$BpR(B . ?\x9764)  ;; <CJK>
     (?$BpS(B . ?\x9766)  ;; <CJK>
     (?$BpT(B . ?\x9768)  ;; <CJK>
     (?$BpU(B . ?\x52D2)  ;; <CJK>
     (?$BpV(B . ?\x976B)  ;; <CJK>
     (?$BpW(B . ?\x9771)  ;; <CJK>
     (?$BpX(B . ?\x9779)  ;; <CJK>
     (?$BpY(B . ?\x9785)  ;; <CJK>
     (?$BpZ(B . ?\x977C)  ;; <CJK>
     (?$Bp[(B . ?\x9781)  ;; <CJK>
     (?$Bp\(B . ?\x977A)  ;; <CJK>
     (?$Bp](B . ?\x9786)  ;; <CJK>
     (?$Bp^(B . ?\x978B)  ;; <CJK>
     (?$Bp_(B . ?\x978F)  ;; <CJK>
     (?$Bp`(B . ?\x9790)  ;; <CJK>
     (?$Bpa(B . ?\x979C)  ;; <CJK>
     (?$Bpb(B . ?\x97A8)  ;; <CJK>
     (?$Bpc(B . ?\x97A6)  ;; <CJK>
     (?$Bpd(B . ?\x97A3)  ;; <CJK>
     (?$Bpe(B . ?\x97B3)  ;; <CJK>
     (?$Bpf(B . ?\x97B4)  ;; <CJK>
     (?$Bpg(B . ?\x97C3)  ;; <CJK>
     (?$Bph(B . ?\x97C6)  ;; <CJK>
     (?$Bpi(B . ?\x97C8)  ;; <CJK>
     (?$Bpj(B . ?\x97CB)  ;; <CJK>
     (?$Bpk(B . ?\x97DC)  ;; <CJK>
     (?$Bpl(B . ?\x97ED)  ;; <CJK>
     (?$Bpm(B . ?\x9F4F)  ;; <CJK>
     (?$Bpn(B . ?\x97F2)  ;; <CJK>
     (?$Bpo(B . ?\x7ADF)  ;; <CJK>
     (?$Bpp(B . ?\x97F6)  ;; <CJK>
     (?$Bpq(B . ?\x97F5)  ;; <CJK>
     (?$Bpr(B . ?\x980F)  ;; <CJK>
     (?$Bps(B . ?\x980C)  ;; <CJK>
     (?$Bpt(B . ?\x9838)  ;; <CJK>
     (?$Bpu(B . ?\x9824)  ;; <CJK>
     (?$Bpv(B . ?\x9821)  ;; <CJK>
     (?$Bpw(B . ?\x9837)  ;; <CJK>
     (?$Bpx(B . ?\x983D)  ;; <CJK>
     (?$Bpy(B . ?\x9846)  ;; <CJK>
     (?$Bpz(B . ?\x984F)  ;; <CJK>
     (?$Bp{(B . ?\x984B)  ;; <CJK>
     (?$Bp|(B . ?\x986B)  ;; <CJK>
     (?$Bp}(B . ?\x986F)  ;; <CJK>
     (?$Bp~(B . ?\x9870)  ;; <CJK>
     (?$Bq!(B . ?\x9871)  ;; <CJK>
     (?$Bq"(B . ?\x9874)  ;; <CJK>
     (?$Bq#(B . ?\x9873)  ;; <CJK>
     (?$Bq$(B . ?\x98AA)  ;; <CJK>
     (?$Bq%(B . ?\x98AF)  ;; <CJK>
     (?$Bq&(B . ?\x98B1)  ;; <CJK>
     (?$Bq'(B . ?\x98B6)  ;; <CJK>
     (?$Bq((B . ?\x98C4)  ;; <CJK>
     (?$Bq)(B . ?\x98C3)  ;; <CJK>
     (?$Bq*(B . ?\x98C6)  ;; <CJK>
     (?$Bq+(B . ?\x98E9)  ;; <CJK>
     (?$Bq,(B . ?\x98EB)  ;; <CJK>
     (?$Bq-(B . ?\x9903)  ;; <CJK>
     (?$Bq.(B . ?\x9909)  ;; <CJK>
     (?$Bq/(B . ?\x9912)  ;; <CJK>
     (?$Bq0(B . ?\x9914)  ;; <CJK>
     (?$Bq1(B . ?\x9918)  ;; <CJK>
     (?$Bq2(B . ?\x9921)  ;; <CJK>
     (?$Bq3(B . ?\x991D)  ;; <CJK>
     (?$Bq4(B . ?\x991E)  ;; <CJK>
     (?$Bq5(B . ?\x9924)  ;; <CJK>
     (?$Bq6(B . ?\x9920)  ;; <CJK>
     (?$Bq7(B . ?\x992C)  ;; <CJK>
     (?$Bq8(B . ?\x992E)  ;; <CJK>
     (?$Bq9(B . ?\x993D)  ;; <CJK>
     (?$Bq:(B . ?\x993E)  ;; <CJK>
     (?$Bq;(B . ?\x9942)  ;; <CJK>
     (?$Bq<(B . ?\x9949)  ;; <CJK>
     (?$Bq=(B . ?\x9945)  ;; <CJK>
     (?$Bq>(B . ?\x9950)  ;; <CJK>
     (?$Bq?(B . ?\x994B)  ;; <CJK>
     (?$Bq@(B . ?\x9951)  ;; <CJK>
     (?$BqA(B . ?\x9952)  ;; <CJK>
     (?$BqB(B . ?\x994C)  ;; <CJK>
     (?$BqC(B . ?\x9955)  ;; <CJK>
     (?$BqD(B . ?\x9997)  ;; <CJK>
     (?$BqE(B . ?\x9998)  ;; <CJK>
     (?$BqF(B . ?\x99A5)  ;; <CJK>
     (?$BqG(B . ?\x99AD)  ;; <CJK>
     (?$BqH(B . ?\x99AE)  ;; <CJK>
     (?$BqI(B . ?\x99BC)  ;; <CJK>
     (?$BqJ(B . ?\x99DF)  ;; <CJK>
     (?$BqK(B . ?\x99DB)  ;; <CJK>
     (?$BqL(B . ?\x99DD)  ;; <CJK>
     (?$BqM(B . ?\x99D8)  ;; <CJK>
     (?$BqN(B . ?\x99D1)  ;; <CJK>
     (?$BqO(B . ?\x99ED)  ;; <CJK>
     (?$BqP(B . ?\x99EE)  ;; <CJK>
     (?$BqQ(B . ?\x99F1)  ;; <CJK>
     (?$BqR(B . ?\x99F2)  ;; <CJK>
     (?$BqS(B . ?\x99FB)  ;; <CJK>
     (?$BqT(B . ?\x99F8)  ;; <CJK>
     (?$BqU(B . ?\x9A01)  ;; <CJK>
     (?$BqV(B . ?\x9A0F)  ;; <CJK>
     (?$BqW(B . ?\x9A05)  ;; <CJK>
     (?$BqX(B . ?\x99E2)  ;; <CJK>
     (?$BqY(B . ?\x9A19)  ;; <CJK>
     (?$BqZ(B . ?\x9A2B)  ;; <CJK>
     (?$Bq[(B . ?\x9A37)  ;; <CJK>
     (?$Bq\(B . ?\x9A45)  ;; <CJK>
     (?$Bq](B . ?\x9A42)  ;; <CJK>
     (?$Bq^(B . ?\x9A40)  ;; <CJK>
     (?$Bq_(B . ?\x9A43)  ;; <CJK>
     (?$Bq`(B . ?\x9A3E)  ;; <CJK>
     (?$Bqa(B . ?\x9A55)  ;; <CJK>
     (?$Bqb(B . ?\x9A4D)  ;; <CJK>
     (?$Bqc(B . ?\x9A5B)  ;; <CJK>
     (?$Bqd(B . ?\x9A57)  ;; <CJK>
     (?$Bqe(B . ?\x9A5F)  ;; <CJK>
     (?$Bqf(B . ?\x9A62)  ;; <CJK>
     (?$Bqg(B . ?\x9A65)  ;; <CJK>
     (?$Bqh(B . ?\x9A64)  ;; <CJK>
     (?$Bqi(B . ?\x9A69)  ;; <CJK>
     (?$Bqj(B . ?\x9A6B)  ;; <CJK>
     (?$Bqk(B . ?\x9A6A)  ;; <CJK>
     (?$Bql(B . ?\x9AAD)  ;; <CJK>
     (?$Bqm(B . ?\x9AB0)  ;; <CJK>
     (?$Bqn(B . ?\x9ABC)  ;; <CJK>
     (?$Bqo(B . ?\x9AC0)  ;; <CJK>
     (?$Bqp(B . ?\x9ACF)  ;; <CJK>
     (?$Bqq(B . ?\x9AD1)  ;; <CJK>
     (?$Bqr(B . ?\x9AD3)  ;; <CJK>
     (?$Bqs(B . ?\x9AD4)  ;; <CJK>
     (?$Bqt(B . ?\x9ADE)  ;; <CJK>
     (?$Bqu(B . ?\x9ADF)  ;; <CJK>
     (?$Bqv(B . ?\x9AE2)  ;; <CJK>
     (?$Bqw(B . ?\x9AE3)  ;; <CJK>
     (?$Bqx(B . ?\x9AE6)  ;; <CJK>
     (?$Bqy(B . ?\x9AEF)  ;; <CJK>
     (?$Bqz(B . ?\x9AEB)  ;; <CJK>
     (?$Bq{(B . ?\x9AEE)  ;; <CJK>
     (?$Bq|(B . ?\x9AF4)  ;; <CJK>
     (?$Bq}(B . ?\x9AF1)  ;; <CJK>
     (?$Bq~(B . ?\x9AF7)  ;; <CJK>
     (?$Br!(B . ?\x9AFB)  ;; <CJK>
     (?$Br"(B . ?\x9B06)  ;; <CJK>
     (?$Br#(B . ?\x9B18)  ;; <CJK>
     (?$Br$(B . ?\x9B1A)  ;; <CJK>
     (?$Br%(B . ?\x9B1F)  ;; <CJK>
     (?$Br&(B . ?\x9B22)  ;; <CJK>
     (?$Br'(B . ?\x9B23)  ;; <CJK>
     (?$Br((B . ?\x9B25)  ;; <CJK>
     (?$Br)(B . ?\x9B27)  ;; <CJK>
     (?$Br*(B . ?\x9B28)  ;; <CJK>
     (?$Br+(B . ?\x9B29)  ;; <CJK>
     (?$Br,(B . ?\x9B2A)  ;; <CJK>
     (?$Br-(B . ?\x9B2E)  ;; <CJK>
     (?$Br.(B . ?\x9B2F)  ;; <CJK>
     (?$Br/(B . ?\x9B32)  ;; <CJK>
     (?$Br0(B . ?\x9B44)  ;; <CJK>
     (?$Br1(B . ?\x9B43)  ;; <CJK>
     (?$Br2(B . ?\x9B4F)  ;; <CJK>
     (?$Br3(B . ?\x9B4D)  ;; <CJK>
     (?$Br4(B . ?\x9B4E)  ;; <CJK>
     (?$Br5(B . ?\x9B51)  ;; <CJK>
     (?$Br6(B . ?\x9B58)  ;; <CJK>
     (?$Br7(B . ?\x9B74)  ;; <CJK>
     (?$Br8(B . ?\x9B93)  ;; <CJK>
     (?$Br9(B . ?\x9B83)  ;; <CJK>
     (?$Br:(B . ?\x9B91)  ;; <CJK>
     (?$Br;(B . ?\x9B96)  ;; <CJK>
     (?$Br<(B . ?\x9B97)  ;; <CJK>
     (?$Br=(B . ?\x9B9F)  ;; <CJK>
     (?$Br>(B . ?\x9BA0)  ;; <CJK>
     (?$Br?(B . ?\x9BA8)  ;; <CJK>
     (?$Br@(B . ?\x9BB4)  ;; <CJK>
     (?$BrA(B . ?\x9BC0)  ;; <CJK>
     (?$BrB(B . ?\x9BCA)  ;; <CJK>
     (?$BrC(B . ?\x9BB9)  ;; <CJK>
     (?$BrD(B . ?\x9BC6)  ;; <CJK>
     (?$BrE(B . ?\x9BCF)  ;; <CJK>
     (?$BrF(B . ?\x9BD1)  ;; <CJK>
     (?$BrG(B . ?\x9BD2)  ;; <CJK>
     (?$BrH(B . ?\x9BE3)  ;; <CJK>
     (?$BrI(B . ?\x9BE2)  ;; <CJK>
     (?$BrJ(B . ?\x9BE4)  ;; <CJK>
     (?$BrK(B . ?\x9BD4)  ;; <CJK>
     (?$BrL(B . ?\x9BE1)  ;; <CJK>
     (?$BrM(B . ?\x9C3A)  ;; <CJK>
     (?$BrN(B . ?\x9BF2)  ;; <CJK>
     (?$BrO(B . ?\x9BF1)  ;; <CJK>
     (?$BrP(B . ?\x9BF0)  ;; <CJK>
     (?$BrQ(B . ?\x9C15)  ;; <CJK>
     (?$BrR(B . ?\x9C14)  ;; <CJK>
     (?$BrS(B . ?\x9C09)  ;; <CJK>
     (?$BrT(B . ?\x9C13)  ;; <CJK>
     (?$BrU(B . ?\x9C0C)  ;; <CJK>
     (?$BrV(B . ?\x9C06)  ;; <CJK>
     (?$BrW(B . ?\x9C08)  ;; <CJK>
     (?$BrX(B . ?\x9C12)  ;; <CJK>
     (?$BrY(B . ?\x9C0A)  ;; <CJK>
     (?$BrZ(B . ?\x9C04)  ;; <CJK>
     (?$Br[(B . ?\x9C2E)  ;; <CJK>
     (?$Br\(B . ?\x9C1B)  ;; <CJK>
     (?$Br](B . ?\x9C25)  ;; <CJK>
     (?$Br^(B . ?\x9C24)  ;; <CJK>
     (?$Br_(B . ?\x9C21)  ;; <CJK>
     (?$Br`(B . ?\x9C30)  ;; <CJK>
     (?$Bra(B . ?\x9C47)  ;; <CJK>
     (?$Brb(B . ?\x9C32)  ;; <CJK>
     (?$Brc(B . ?\x9C46)  ;; <CJK>
     (?$Brd(B . ?\x9C3E)  ;; <CJK>
     (?$Bre(B . ?\x9C5A)  ;; <CJK>
     (?$Brf(B . ?\x9C60)  ;; <CJK>
     (?$Brg(B . ?\x9C67)  ;; <CJK>
     (?$Brh(B . ?\x9C76)  ;; <CJK>
     (?$Bri(B . ?\x9C78)  ;; <CJK>
     (?$Brj(B . ?\x9CE7)  ;; <CJK>
     (?$Brk(B . ?\x9CEC)  ;; <CJK>
     (?$Brl(B . ?\x9CF0)  ;; <CJK>
     (?$Brm(B . ?\x9D09)  ;; <CJK>
     (?$Brn(B . ?\x9D08)  ;; <CJK>
     (?$Bro(B . ?\x9CEB)  ;; <CJK>
     (?$Brp(B . ?\x9D03)  ;; <CJK>
     (?$Brq(B . ?\x9D06)  ;; <CJK>
     (?$Brr(B . ?\x9D2A)  ;; <CJK>
     (?$Brs(B . ?\x9D26)  ;; <CJK>
     (?$Brt(B . ?\x9DAF)  ;; <CJK>
     (?$Bru(B . ?\x9D23)  ;; <CJK>
     (?$Brv(B . ?\x9D1F)  ;; <CJK>
     (?$Brw(B . ?\x9D44)  ;; <CJK>
     (?$Brx(B . ?\x9D15)  ;; <CJK>
     (?$Bry(B . ?\x9D12)  ;; <CJK>
     (?$Brz(B . ?\x9D41)  ;; <CJK>
     (?$Br{(B . ?\x9D3F)  ;; <CJK>
     (?$Br|(B . ?\x9D3E)  ;; <CJK>
     (?$Br}(B . ?\x9D46)  ;; <CJK>
     (?$Br~(B . ?\x9D48)  ;; <CJK>
     (?$Bs!(B . ?\x9D5D)  ;; <CJK>
     (?$Bs"(B . ?\x9D5E)  ;; <CJK>
     (?$Bs#(B . ?\x9D64)  ;; <CJK>
     (?$Bs$(B . ?\x9D51)  ;; <CJK>
     (?$Bs%(B . ?\x9D50)  ;; <CJK>
     (?$Bs&(B . ?\x9D59)  ;; <CJK>
     (?$Bs'(B . ?\x9D72)  ;; <CJK>
     (?$Bs((B . ?\x9D89)  ;; <CJK>
     (?$Bs)(B . ?\x9D87)  ;; <CJK>
     (?$Bs*(B . ?\x9DAB)  ;; <CJK>
     (?$Bs+(B . ?\x9D6F)  ;; <CJK>
     (?$Bs,(B . ?\x9D7A)  ;; <CJK>
     (?$Bs-(B . ?\x9D9A)  ;; <CJK>
     (?$Bs.(B . ?\x9DA4)  ;; <CJK>
     (?$Bs/(B . ?\x9DA9)  ;; <CJK>
     (?$Bs0(B . ?\x9DB2)  ;; <CJK>
     (?$Bs1(B . ?\x9DC4)  ;; <CJK>
     (?$Bs2(B . ?\x9DC1)  ;; <CJK>
     (?$Bs3(B . ?\x9DBB)  ;; <CJK>
     (?$Bs4(B . ?\x9DB8)  ;; <CJK>
     (?$Bs5(B . ?\x9DBA)  ;; <CJK>
     (?$Bs6(B . ?\x9DC6)  ;; <CJK>
     (?$Bs7(B . ?\x9DCF)  ;; <CJK>
     (?$Bs8(B . ?\x9DC2)  ;; <CJK>
     (?$Bs9(B . ?\x9DD9)  ;; <CJK>
     (?$Bs:(B . ?\x9DD3)  ;; <CJK>
     (?$Bs;(B . ?\x9DF8)  ;; <CJK>
     (?$Bs<(B . ?\x9DE6)  ;; <CJK>
     (?$Bs=(B . ?\x9DED)  ;; <CJK>
     (?$Bs>(B . ?\x9DEF)  ;; <CJK>
     (?$Bs?(B . ?\x9DFD)  ;; <CJK>
     (?$Bs@(B . ?\x9E1A)  ;; <CJK>
     (?$BsA(B . ?\x9E1B)  ;; <CJK>
     (?$BsB(B . ?\x9E1E)  ;; <CJK>
     (?$BsC(B . ?\x9E75)  ;; <CJK>
     (?$BsD(B . ?\x9E79)  ;; <CJK>
     (?$BsE(B . ?\x9E7D)  ;; <CJK>
     (?$BsF(B . ?\x9E81)  ;; <CJK>
     (?$BsG(B . ?\x9E88)  ;; <CJK>
     (?$BsH(B . ?\x9E8B)  ;; <CJK>
     (?$BsI(B . ?\x9E8C)  ;; <CJK>
     (?$BsJ(B . ?\x9E92)  ;; <CJK>
     (?$BsK(B . ?\x9E95)  ;; <CJK>
     (?$BsL(B . ?\x9E91)  ;; <CJK>
     (?$BsM(B . ?\x9E9D)  ;; <CJK>
     (?$BsN(B . ?\x9EA5)  ;; <CJK>
     (?$BsO(B . ?\x9EA9)  ;; <CJK>
     (?$BsP(B . ?\x9EB8)  ;; <CJK>
     (?$BsQ(B . ?\x9EAA)  ;; <CJK>
     (?$BsR(B . ?\x9EAD)  ;; <CJK>
     (?$BsS(B . ?\x9761)  ;; <CJK>
     (?$BsT(B . ?\x9ECC)  ;; <CJK>
     (?$BsU(B . ?\x9ECE)  ;; <CJK>
     (?$BsV(B . ?\x9ECF)  ;; <CJK>
     (?$BsW(B . ?\x9ED0)  ;; <CJK>
     (?$BsX(B . ?\x9ED4)  ;; <CJK>
     (?$BsY(B . ?\x9EDC)  ;; <CJK>
     (?$BsZ(B . ?\x9EDE)  ;; <CJK>
     (?$Bs[(B . ?\x9EDD)  ;; <CJK>
     (?$Bs\(B . ?\x9EE0)  ;; <CJK>
     (?$Bs](B . ?\x9EE5)  ;; <CJK>
     (?$Bs^(B . ?\x9EE8)  ;; <CJK>
     (?$Bs_(B . ?\x9EEF)  ;; <CJK>
     (?$Bs`(B . ?\x9EF4)  ;; <CJK>
     (?$Bsa(B . ?\x9EF6)  ;; <CJK>
     (?$Bsb(B . ?\x9EF7)  ;; <CJK>
     (?$Bsc(B . ?\x9EF9)  ;; <CJK>
     (?$Bsd(B . ?\x9EFB)  ;; <CJK>
     (?$Bse(B . ?\x9EFC)  ;; <CJK>
     (?$Bsf(B . ?\x9EFD)  ;; <CJK>
     (?$Bsg(B . ?\x9F07)  ;; <CJK>
     (?$Bsh(B . ?\x9F08)  ;; <CJK>
     (?$Bsi(B . ?\x76B7)  ;; <CJK>
     (?$Bsj(B . ?\x9F15)  ;; <CJK>
     (?$Bsk(B . ?\x9F21)  ;; <CJK>
     (?$Bsl(B . ?\x9F2C)  ;; <CJK>
     (?$Bsm(B . ?\x9F3E)  ;; <CJK>
     (?$Bsn(B . ?\x9F4A)  ;; <CJK>
     (?$Bso(B . ?\x9F52)  ;; <CJK>
     (?$Bsp(B . ?\x9F54)  ;; <CJK>
     (?$Bsq(B . ?\x9F63)  ;; <CJK>
     (?$Bsr(B . ?\x9F5F)  ;; <CJK>
     (?$Bss(B . ?\x9F60)  ;; <CJK>
     (?$Bst(B . ?\x9F61)  ;; <CJK>
     (?$Bsu(B . ?\x9F66)  ;; <CJK>
     (?$Bsv(B . ?\x9F67)  ;; <CJK>
     (?$Bsw(B . ?\x9F6C)  ;; <CJK>
     (?$Bsx(B . ?\x9F6A)  ;; <CJK>
     (?$Bsy(B . ?\x9F77)  ;; <CJK>
     (?$Bsz(B . ?\x9F72)  ;; <CJK>
     (?$Bs{(B . ?\x9F76)  ;; <CJK>
     (?$Bs|(B . ?\x9F95)  ;; <CJK>
     (?$Bs}(B . ?\x9F9C)  ;; <CJK>
     (?$Bs~(B . ?\x9FA0)  ;; <CJK>
     (?$Bt!(B . ?\x582F)  ;; <CJK>
     (?$Bt"(B . ?\x69C7)  ;; <CJK>
     (?$Bt#(B . ?\x9059)  ;; <CJK>
     (?$Bt$(B . ?\x7464)  ;; <CJK>
     (?$Bt%(B . ?\x51DC)  ;; <CJK>
     (?$Bt&(B . ?\x7199)  ;; <CJK>
     )))
 
(defvar jis-x-0208-vs-unicode-assoc jis-x-0208-1990-vs-unicode-assoc)

(provide 'ujisx0208)
 