#ifndef __MAD_H
#define __MAD_H

#include <stdlib.h>
#include <stdio.h>

#ifdef HAVE_MAD
#   define INLINE 
#else
#   ifndef INLINE
#       define INLINE inline
#   endif
#endif

#ifdef HAVE_MAD

/* The Memory Allocation Debugging system */

/* GNU headers define this as macros */
#ifdef malloc
#   undef malloc
#endif

#ifdef calloc
#   undef calloc
#endif

#define malloc(x)	mad_alloc (x, __FILE__, __LINE__)
#define calloc(x, y)	mad_alloc (x * y, __FILE__, __LINE__)
#define realloc(x, y)	mad_realloc (x, y, __FILE__, __LINE__)
#define xmalloc(x, y)	mad_alloc (x, __FILE__, __LINE__)
#define strdup(x)	mad_strdup (x, __FILE__, __LINE__)
#define tempnam(x, y)	mad_tempnam (x, y, __FILE__, __LINE__)
#define free(x)		mad_free (x, __FILE__, __LINE__)

#ifdef MAD_FILEOPS
#define fopen(x,y)	mad_fopen (x, y, __FILE__, __LINE__)
#define fclose(x)	mad_fclose (x, __FILE__, __LINE__)
#define open(x,y)	mad_open (x, y, __FILE__, __LINE__)
#define creat(x,y)	mad_creat (x, y, __FILE__, __LINE__)
#define close(x)	mad_close (x, __FILE__, __LINE__)
#endif

void mad_check (char *file, int line);
void *mad_alloc (int size, char *file, int line);
void *mad_realloc (void *ptr, int newsize, char *file, int line);
char *mad_strdup (const char *s, char *file, int line);
char *mad_tempnam (const char *d, const char *p, char *file, int line);
void mad_free (void *ptr, char *file, int line);
void mad_finalize (char *file, int line);

#ifdef MAD_FILEOPS
FILE *mad_fopen (const char *path, const char *mode, char *file, int line);
int mad_fclose (FILE * stream, char *file, int line);
int mad_open (const char *path, int mode, char *file, int line);
int mad_creat (const char *path, mode_t mode, char *file, int line);
int mad_close (int fd, char *file, int line);
#endif

#else

#define mad_finalize(x, y)
#define mad_check(file,line)

#endif /* HAVE_MAD */

#endif /* __MAD_H */
