/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : pan.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitPan
|
| Description : DSPKitPan
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char pan_cc [] = "$Id$";

#include "pan.h"

long DSPKitPan::setInput (DSPKitProcessor *ip)
{
  if (DSPKitProcessor::setInput (ip) != 0) return -1;
  inputSample = 0.0;
  channel     = 0;
  endOfInput  = 0;
  modInput    = 0;
  return 0;
}

long DSPKitPan::setModInput (DSPKitProcessor *mip)
{
  modInput = mip;
  modInput->setOutput (this);
  return 1;
}

long DSPKitPan::getSample (double &outputSample)
{
  if (channel >= 2) channel = 0;
  if (channel++ == 0)
  {
    if (input->getSample (inputSample) == 0)
    {
      endOfInput = 1;
      return 0;
    }

    if (!modInput || modInput->getSample (modSample) == 0)
    {
      modSample = 0.0;
    }
    else
    {
      if (modSample > 1.0) modSample = 1.0;
      else if (modSample < -1.0) modSample = -1.0;
    }

    if (modSample > 0.0)
    {
      rgain = 1.0;
      lgain = 1.0 - modSample;
    }
    else
    {
      lgain = 1.0;
      rgain = 1.0 + modSample;
    }
  }

  if (endOfInput) return 0;

  if (channel == 1) outputSample = lgain * inputSample;
  else outputSample = rgain * inputSample;

  return 1;
}

/***************************************************************************/
