/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : jamrever.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitJAMReverb
|
| Description : DSPKitJAMReverb
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_JAMREVERB_H_
#define _DSPKIT_JAMREVERB_H_

#include "processo.h"
#include "delay.h"
#include "mux.h"
#include "amp.h"
#include "z1lpf.h"
#include "sum.h"
#include "stdrever.h"

class DSPKitJAMReverb : public DSPKitProcessor
{
  public:

    long setInput (DSPKitProcessor *ip);
    long setInput (DSPKitProcessor *ip,double size,double spread);
    void setReverbTime (double rt);
    void setReverbLevel (double level);

  protected:

    // tap delay line:
    DSPKitDelay     pd1,pd2,pd3,pd4,pd5,pd6,pd7,pd8,pd9,
                    pd10,pd11,pd12,pd13,pd14,pd15,pd16,pd17,pd18;
    DSPKitMux       m0,m1,m2,m3,m4,m5,m6,m7,m8,m9,m10,
                    m11,m12,m13,m14,m15,m16,m17;
    DSPKitAmp       a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,
                    a11,a12,a13,a14,a15,a16,a17,a18;
    DSPKitStdReverb reverb;
    DSPKitSum       pdsum;
    DSPKitMux       pdmux;
    DSPKitDelay     rd;
    DSPKitAmp       ra;
    DSPKitSum       outsum;
};

inline void DSPKitJAMReverb::setReverbTime (double rt)
{
  reverb.setReverbTime (rt);
}

inline void DSPKitJAMReverb::setReverbLevel (double level)
{
  ra.setGain (level);
}

#endif

/***************************************************************************/
