/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : dynamics.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitDynamicsProcessor
|
| Description : DSPKitDynamicsProcessor
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_DYNAMICSPROCESSOR_H_
#define _DSPKIT_DYNAMICSPROCESSOR_H_

#include "processo.h"

class DSPKitDynamicsProcessor : public DSPKitProcessor
{
  public:

    virtual long setInputAndEstimationTime (DSPKitProcessor *ip, double et);
    virtual void setThreshold (double value);
    long getSample (double &outputSample);
    virtual double getThreshold () const;

  protected:

    virtual void scaleBuffer () = 0;
    
    double *sampleBuffer;
    double absMax1;
    double absMax2;
    long   bufSize;
    long   halfInputBufSize;
    long   inputBufSize;
    long   readIndex;
    long   writeIndex;
    long   processIndex;
    double threshold;
    long   endOfInput;
    long   firstTime;
};

inline void DSPKitDynamicsProcessor::setThreshold (double value)
{
  if (value <= 0.0)
    value = 0.00001;

  threshold = value;
}

inline double DSPKitDynamicsProcessor::getThreshold () const
{
  return threshold;
}

#endif

/***************************************************************************/
