/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: trt_lookup.c,v 1.1 1998/05/19 11:08:28 tiggr Exp $  */

#include "trt.h"

int_imp
trt_lookup (tom_object self, selector cmd)
{
  unsigned int sid = cmd->sel_id;

#if defined (DEBUG) || defined (ALWAYS_CHECK_NIL_RECEIVER)
  extern int_imp trt_lookup_nil (selector);

  if (!self)
    return trt_lookup_nil (cmd);
#endif
#if DEBUG_MESSAGE_MONITORING
  if (trt_msg_monitor)
    trt_monitor_message (self, cmd);
#endif

  return (self->isa->info.mdt
	  ->b[sid / TRT_BUCKET_SIZE]->m[sid % TRT_BUCKET_SIZE]);
}

int_imp
trt_lookup_super (struct trt_class *super, selector cmd)
{
  unsigned int sid = cmd->sel_id;

  return super->info.mdt->b[sid / TRT_BUCKET_SIZE]->m[sid % TRT_BUCKET_SIZE];
}
