/* Header file to TLL subroutines.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: subr.h,v 1.2 1998/01/08 17:03:48 tiggr Exp $  */

#import "TLLSubroutine.h"
#import "TLFDStream.h"
#import "config.h"

/* Initialize subroutines.  */
void tll_subr_init (void);

@class TLSymbol;
/* Symbols of subroutines whose name is ever referenced within the Library
   in Objective-C code.  */
extern TLSymbol *Qquote;

id Fadd (id args, int num_args);
id Fand (id args);
id Fcar (id cons);
id Fcdr (id cons);
id Fcond (id args);
id Fcons (id car, id cdr);
id Fdefun (id args);
id Fdiv (id args, int num_args);
id Feq (id arg1, id arg2);
id Feval_string (id string);
id Fexit (id <TLNumber> val);
TLFDStream *Ffd_stream (id <TLString> name, TLCons *mode,
			id <TLNumber> protection);
id Fformac (id args);
id Fgarbage_collect (id <TLNumber> usec);
id Fge (id a1, id a2);
id Fgetenv (id <TLString> n);
id Fgt (id a1, id a2);
id Fif (id args);
TLSymbol *Fintern (id <TLString> name);
id Flambda (id args);
id Fle (id a1, id a2);
id Flet (id args);
id Flet_star (id args);
id Flt (id a1, id a2);
id Fmapcar (id sym, id seq);
id Fminusminus (id arg);
id Fmul (id args, int num_args);
id Fnconc (id argvec, int num_args);
id Fne (id a1, id a2);
id Fnot (id args);
id Fnumeric_eq (id a1, id a2);
id Foneminus (id arg);
id Foneplus (id arg);
id For (id args);
id Fperform (id args, int num_args);
id Fplusplus (id arg);
id Fprogn (id args);
id Fputenv (id <TLString> viv);
id Fquote (id args);
id Frandom (void);
id Frange (id start, id length, id end);
id Fselector_type (id <TLString> sel_name);
id Fsetq (id args);
id Fsleep (id <TLNumber> seconds);
id Fsub (id args, int num_args);
id Ftime (id args);
id Fvector (id args, int num_args);
id Fwhile (id args);
