/* Interface to simple, fast hashtable.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: rchash.h,v 1.1 1998/01/08 16:13:52 tiggr Exp $  */

typedef struct rch_bucket
{
  struct rch_bucket *next;
  void *key;
  union
  {
    int i;
  } value;
} rch_bucket;

typedef struct rch_table
{
  int num, cap;
  rch_bucket **table;
} rch_table;

rch_table *rch_create (int cap);
rch_bucket *rch_bucket_for_key (rch_table *table, void *key, int create_p);
void rch_remove_key (rch_table *table, void *key);
