/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTInstance.m,v 1.4 1998/01/05 00:58:06 tiggr Exp $  */

#define LTTINSTANCE_DECLARE_PRIVATE_METHODS
#import "LTTInstance.h"

TLVector *ltt_instances;

@implementation LTTInstance

+initialize
{
  if (!ltt_instances)
    {
      ltt_instances = [TLVector vector];
      [ltt_instances gcLock];
    }

  return self;
} /* +initialize */

+(id <TLEnumerator>) instances
{
  return [ltt_instances enumerator];
} /* +instances */

+(id) metaWithName: (id <TLString>) n unit: (LTTUnit *) u;
{
  LTTMeta *m = [super metaWithName: n unit: u];

  if (m)
    [ltt_instances addElement: m];

  return m;
} /* +metaWithName:unit: */

@end
