/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: trt_send.S,v 1.5 1998/01/05 00:43:27 tiggr Exp $  */

#include <tom/trt.h>

/* The idea of trt_send is:

   return_type
   trt_send (tom_State_c_ref self, selector *_cmd)
   {
     int sel_id = _cmd->sel_id;
     int bucket_idx = sel_id / TRT_BUCKET_SIZE;
     int imp_idx = sel_id % TRT_BUCKET_SIZE;

     jump (self->isa->mdt->b[bucket_idx].m[imp_idx]);
   }
 */
	.SPACE $PRIVATE$
	.SUBSPA $DATA$,QUAD=1,ALIGN=8,ACCESS=31
	.SUBSPA $BSS$,QUAD=1,ALIGN=8,ACCESS=31,ZERO,SORT=82
	.SPACE $TEXT$
	.SUBSPA $LIT$,QUAD=0,ALIGN=8,ACCESS=44
	.SUBSPA $CODE$,QUAD=0,ALIGN=8,ACCESS=44,CODE_ONLY
	.IMPORT $global$,DATA
	.IMPORT $$dyncall,MILLICODE
	.IMPORT trt_send_nil,CODE
	.SPACE $TEXT$
	.SUBSPA $CODE$

/* This is a fast version, but it does not work when invoked through an
   export stub, from dynamically loaded code.  The reason is that the
   return-link register is saved in the _caller's_ frame...  */

	.align 4
	.EXPORT trt_send,ENTRY,PRIV_LEV=3,ARGW0=GR,ARGW1=GR,RTNVAL=GR
trt_send
	.PROC
	.CALLINFO FRAME=0, NO_CALLS
	.ENTRY

	movb,=	%r26, %r26, L$0020	/* !self */
	ldw	0(0, %r25), %ret0	/* sid = selector->sel_id */
	ldw	0(0, %r26), %ret1	/* self->isa */
	ldw	8(0, %ret1), %ret1	/* self->isa->mdt */
	extru	%ret0, 27, 28, %r20
	sh2addl	%r20, %ret1, %ret1
	ldw	8(0, %ret1), %ret1
	extru	%ret0, 31, 4, %ret0
	ldwx,s	%ret0(0, %ret1), %ret0
	b	$$dyncall
	copy	%ret0, %r22
L$0020
	b	trt_send_nil
	nop

	.EXIT
	.PROCEND
