/* ---------------------------------------------------------------------
*
*  -- ScaLAPACK routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     November 17, 1996
*
*  ---------------------------------------------------------------------
*/
/*
*  Include files
*/
#include "pblas.h"

void pberror_( ctxt, mess, info )
/*
*  .. Scalar Arguments ..
*/
   int         * ctxt, * info;
/* ..
*  .. Array Arguments ..
*/
   char        * mess;
{
/*
*  Purpose
*  =======
*
*  pberror_ is an error handler of the PBLAS routines, displays an error
*  message on stderr, and stops the running program.
*
* ======================================================================
*
*  .. Parameters ..
*/
#define DESCMULT      100
#define BIGNUM      10000
/* ..
*  .. Local Scalars ..
*/
   int         iinfo, mycol, myrow, npcol, nprow;
/* ..
*  .. External Functions ..
*/
   void        blacs_abort_();
   void        blacs_gridinfo_();
/* ..
*  .. Executable Statements ..
*/
   blacs_gridinfo_( ctxt, &nprow, &npcol, &myrow, &mycol );

   iinfo = *info;
   if( iinfo < 0 )
   {
      iinfo = -iinfo;
      if( iinfo < DESCMULT )
      {
         fprintf( stderr, "{%5d,%5d}: On entry to %s ", myrow, mycol,
                  mess );
         fprintf( stderr, "parameter number %2d had an illegal value\n",
                  iinfo );
      }
      else
      {
         fprintf( stderr, "{%5d,%5d}: On entry to %s ", myrow, mycol,
                  mess );
         fprintf( stderr, "parameter number %2d had an illegal value\n",
                  iinfo / DESCMULT );
         fprintf( stderr, "entry # %2d had an illegal value\n",
                  iinfo % DESCMULT );
      }
   }
   else
   {
      fprintf( stderr,
               "{%5d,%5d}: Positive error code %2d returned by %s !!!\n", 
               myrow, mycol, iinfo, mess );
   }
   blacs_abort_( ctxt, &iinfo );
}
