/*
  Copyright (C) 1997,1998 Shigeru Chiba, University of Tsukuba.

  Permission to use, copy, distribute and modify this software and   
  its documentation for any purpose is hereby granted without fee,        
  provided that the above copyright notice appear in all copies and that 
  both that copyright notice and this permission notice appear in 
  supporting documentation.

  Shigeru Chiba makes no representations about the suitability of this 
  software for any purpose.  It is provided "as is" without express or
  implied warranty.

  July 1997: rewritten by Toru Takimoto for version 2.5.
*/
/*
  Copyright (c) 1995, 1996 Xerox Corporation.
  All Rights Reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted. Any copy of this software or
  of any derivative work must include the above copyright notice of
  Xerox Corporation, this paragraph and the one after it.  Any
  distribution of this software or derivative works must comply with all
  applicable United States export control laws.

  This software is made available AS IS, and XEROX CORPORATION DISCLAIMS
  ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
  LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
  EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
  NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
  OF THE POSSIBILITY OF SUCH DAMAGES.
*/

/*
  RtmopClass implements a runtime MOP similar to OpenC++ version 1.
  The programmer can define runtime metaobjects to control objects.
  In this example, we deal with three levels: compile-time meta,
  runtime meta, and base.

  See also "metaobj.h" and "metaobj-test.cc".
*/

#ifndef __rtmop_h
#define __rtmop_h

#include "mop.h"

// Compile-time Meta Level

class RtmopClass : public Class {
public:
    void InitializeInstance(Ptree* def, Ptree* margs);
    void TranslateClass(Environment*);

    Ptree* MakeDispatcher();
    Ptree* LoadArgument(int, TypeInfo&);
    Ptree* StoreReterunValue(TypeInfo&, Ptree*, int);

    Ptree* TranslateMemberCall(Environment*, Ptree*, Ptree*, Ptree*, Ptree*);
    Ptree* StoreArgument(Environment*, TypeInfo&, Ptree*);

private:
    Ptree* rt_metaclass;
};

#endif  /* __rtmop_h */
