
/*
 * Copyright (c) 1998 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: relxpr.m,v 1.6 1999/11/01 17:54:42 stes Exp $
 */

#include "config.h"
#include <stdlib.h>
#include <assert.h>
#ifndef __OBJECT_INCLUDED__
#define __OBJECT_INCLUDED__
#include <stdio.h> /* FILE */
#include "Object.h" /* Stepstone Object.h assumes #import */
#endif
#include "node.h"
#include "expr.h"
#include "binxpr.h"
#include "relxpr.h"
#include "type.h"
#include "var.h"
#include "scalar.h"

@implementation RelationExpr

- typesynth
{
  type = t_int;
  return self;
}

- go
{
  int s;
  id a,b,r;
  a = [lhs go];
  b = [rhs go];
  r = [Scalar new];
  [r type:t_int];
  if (strcmp(op,"<")  == 0) s = [a u_int] < [b u_int];
  else if (strcmp(op,">")  == 0) s = [a u_int] > [b u_int];
  else if (strcmp(op,"==") == 0) s = [a u_int] == [b u_int];
  else if (strcmp(op,"!=") == 0) s = [a u_int] != [b u_int];
  else if (strcmp(op,">=") == 0) s = [a u_int] >= [b u_int];
  else if (strcmp(op,"<=") == 0) s = [a u_int] <= [b u_int];
  else [self notImplemented:_cmd];
  return [r u_int:s];
}

@end
 
