
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: vector.h,v 1.2 1999/07/06 19:48:12 stes Exp $
 */

#ifndef __CAVECTOR_HEADER__
#define __CAVECTOR_HEADER__

#include "cobject.h"

@interface Vector : CAObject
{
  id carrier;
  id scalarZero;
}
- check;

+ collection:aCltn;
- scalarZero:aScalarZero numScalars:(int)numScalars;
- _setUpScalarZero:aScalarZero numScalars:(int)numScalars;
+ scalarZero:aScalarZero numScalars:(int)numScalars;
- copy;
- deepCopy;
- numScalars:(int)numScalars;
- capacity:(int)aCapacity;
- collection:aCltn;
- clone;
- over:aCarrier;

- scalarZero;
- (int) numScalars;
- carrier;
- (unsigned) hash;
- (BOOL) isEqual:b;
- (BOOL) notEqual:b;

- insertScalar:aScalar;
- insertScalar:aScalar at:(int)i;

- removeScalar;
- removeScalarAt:(int)i;

- placeScalar:aScalar at:(int)i;
- replaceScalarAt:(int)i with:aScalar;
- asCollection;
- asNumerical;
- asModp:(unsigned short)p;
- commonDenominator;
- onCommonDenominator:(id *)denominator;
- asIntegral;
- asFractional;

- eachScalar;
- (float) floatValueAt:(int)i;
- (int) intValueAt:(int)i;

- zero;
- (BOOL) isZero;
- (BOOL) notZero;
- (BOOL) isOpposite:b;
- (BOOL) notOpposite:b;
- negate;
- negateSelf;
- _double:(int)v;
- _doubleSelf:(int)v;
- double;
- doubleSelf;
- _add:(int)v:b:(int)w;
- _addSelf:(int)v:b:(int)w;
- add:b;
- addSelf:b;
- subtract:b;
- subtractSelf:b;
- addScalar:s at:(int)i;
- subtractScalar:s at:(int)i;

- multiplyScalar:s;
- multiplySelfScalar:s;
- divideScalar:s;
- divideSelfScalar:s;
- _add:(int)v:B multiplyScalar:b:(int)w;
- _addSelf:(int)v:B multiplyScalar:b:(int)w;
- _multiplyScalar:a:(int)v add:B:(int)w;
- _multiplySelfScalar:a:(int)v add:B:(int)w;
- _multiplyScalar:a:(int)v add:B multiplyScalar:b:(int)w;
- _multiplySelfScalar:a:(int)v add:B multiplyScalar:b:(int)w;

- dotSquare;
- dotMultiply:aVector;
- multiplyLeftMatrix:aMatrix;
- multiplySelfLeftMatrix:aMatrix;
- divideLeftMatrix:aMatrix;
- divideSelfLeftMatrix:aMatrix;

- printOn:(IOD)aFile;
@end

#endif /* __CAVECTOR_HEADER__ */
 
