
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: drspolc.m,v 1.2 1999/07/06 19:48:09 stes Exp $
 */

#include "cakit.h"

@implementation vardnsrecdegsps_polynomial
+ scalarZero:aScalar
{
  return [self error:"Can't create variable dense polynomial without cltn of symbols"];
}

+ scalarZero:aScalar coefficientZero:aCoef symbols:aCltn
{
  return [self subclassResponsibility:_cmd];
}

- scalarZero:aScalar coefficientZero:aCoef symbols:aCltn
{
  return [self notImplemented:_cmd];
}

+ scalarZero:aScalar symbols:aCltn
{
  id aCoef, aClass;
  int n = [aCltn size];

  assert ([aScalar isZero] && n >= 1);

  if (n == 1)
    {
      aCoef = aScalar;
    }
  else
    {
      id cltn = [aCltn copy];
      [cltn removeLast];
      aCoef = [self scalarZero:aScalar symbols:cltn];
      aCoef = [Polynomial over:aCoef];
    }

  aClass = [aCoef class_vardnsrecdegsps_polynomial];
  return [aClass scalarZero:aScalar coefficientZero:aCoef symbols:aCltn];
}

- scalarZero
{
  return [self subclassResponsibility:_cmd];
}

- symbols
{
  return [self subclassResponsibility:_cmd];
}

- (BOOL) sameClass:b
{
  id aScalar = [self scalarZero];
  id aSymbols = [self symbols];
  id bScalar = [b scalarZero];
  id bSymbols = [b symbols];

  if ([super sameClass:b] == NO)
    return NO;
  if (aScalar != bScalar && [aScalar notEqual:bScalar])
    return NO;
  if (aSymbols != bSymbols && [aSymbols notEqual:bSymbols])
    return NO;

  return YES;
}

- (BOOL)isVariableDense		
{
  return YES;
}
- (BOOL)isVariableSparse	
{
  return NO;
}
- (BOOL)isRecursive		
{
  return YES;
}
- (BOOL)isExpanded		
{
  return NO;
}
- (BOOL)isDegreeDense		
{
  return NO;
}
- (BOOL)isDegreeSparse		
{
  return YES;
}

- emptyScalarZero:aZero
{
  id symbols = [self symbols];
  id classCarrier = [aZero class_vardnsrecdegsps_polynomial];

  return [classCarrier scalarZero:aZero symbols:symbols];
}

- emptyVariableDense:aCltn
{
  id classCarrier;
  id scalarZero = [self scalarZero];

  classCarrier = [scalarZero class_vardnsrecdegsps_polynomial];
  assert (classCarrier == isa || classCarrier != isa);
  assert ([aCltn size] == [[self symbols] size]);
  return [classCarrier scalarZero:scalarZero symbols:aCltn];
}

- emptyVariableSparse
{
  id classCarrier;
  id scalarZero = [self scalarZero];

  classCarrier = [scalarZero class_varspsrecdegsps_polynomial];
  return [classCarrier scalarZero:scalarZero];
}

- emptyExpanded
{
  id classCarrier;
  id symbols = [self symbols];
  id scalarZero = [self scalarZero];

  classCarrier = [scalarZero class_vardnsexpdegsps_polynomial];
  return [classCarrier scalarZero:scalarZero symbols:symbols];
}

- emptyRecursive
{
  return [self empty];
}

- emptyDegreeSparse
{
  return [self empty];
}

- emptyDegreeDense
{
  id classCarrier;
  id symbols = [self symbols];
  id scalarZero = [self scalarZero];

  classCarrier = [scalarZero class_vardnsrecdegdns_polynomial];
  return [classCarrier scalarZero:scalarZero symbols:symbols];
}

@end
 
