
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: ccltnsqr.m,v 1.2 1999/07/06 19:48:08 stes Exp $
 */

#include "cakit.h"

@implementation CACollectionSequenceReversed
- _setUpContent:aCollection
{
  content = aCollection;
  size = [content size];
  return self;
}

+ content:aCollection
{
  return [[super new] _setUpContent:aCollection];
}

- copy
{
  self = [super copy];
  assert (-1 <= index && index <= size);
  return self;
}

- (unsigned) size
{
  return size;
}

- (BOOL) isEmpty
{
  return size == 0;
}

- toFirst
{
  index = size;
  return self;
}

- toLast
{
  index = -1;
  return self;
}

- toElementAt:(int)i
{
  index = size - i;
  return self;
}

- next
{
  index = (index < 0) ? -1 : index - 1;
  return (0 <= index && index < size) ? [content at : index]:nil;
}

- previous
{
  index = (index > size) ? size : index + 1;
  return (0 <= index && index < size) ? [content at : index]:nil;
}

@end
 
