
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: vector.h,v 1.2 1999/07/06 19:47:59 stes Exp $
 */

#ifndef __CAVECTOR_HEADER__
#define __CAVECTOR_HEADER__

#include "cobject.h"

@interface Vector : CAObject
{
  id carrier;
  id scalarZero;
}

+ collection:aCltn;
+ scalarZero:aScalarZero numScalars:(int)numScalars;
- copy;
- deepCopy;

- scalarZero;
- (int) numScalars;
- (unsigned) hash;
- (BOOL) isEqual:b;

- insertScalar:aScalar;
- insertScalar:aScalar at:(int)i;

- removeScalar;
- removeScalarAt:(int)i;

- placeScalar:aScalar at:(int)i;
- replaceScalarAt:(int)i with:aScalar;
- asCollection;
- asNumerical;
- asModp:(unsigned short)p;
- onCommonDenominator:(id *)denominator;

- eachScalar;
- (float) floatValueAt:(int)i;
- (int) intValueAt:(int)i;

- zero;
- (BOOL) isZero;
- (BOOL) isOpposite:b;
- negate;
- double;
- add:b;
- subtract:b;
- addScalar:s at:(int)i;
- subtractScalar:s at:(int)i;

- multiplyScalar:s;
- divideScalar:s;

- dotSquare;
- dotMultiply:aVector;
- multiplyLeftMatrix:aMatrix;

- printOn:(IOD)aFile;
@end

#endif /* __CAVECTOR_HEADER__ */
 
