#include <stdio.h>


static char *sTestArgs[]={"mkdata", "rcx.nqh", "rcx_data.h", "rcxData" };


int main(int argc, char **argv)
{
	FILE *src;
	FILE *dst;
	int c;
	int n;
	
	if (argc == 0)
	{
		// special case for debugging under the Metrowerks console
		argv = sTestArgs;
		argc = sizeof(sTestArgs) / sizeof(char *);
	}

	if (argc != 4)
	{
		fprintf(stderr, "Usage: mkdata sourceFile destFile arrayName\n");
		return -1;
	}
	
	src = fopen(argv[1], "r");
	if (!src)
	{
		fprintf(stderr, "Error: could not open %s\n", argv[1]);
		return -1;
	}
	
	dst = fopen(argv[2], "w");
	if (!dst)
	{
		fprintf(stderr, "Error: could not create %s\n", argv[2]);
		fclose(src);
		return -1;
	}
	
	fprintf(dst,"static const char %s[]={\n", argv[3]);
	
	n = 0;
	while((c=fgetc(src)) != EOF)
	{
		if (c=='\n')
			fputs("\'\\n\',", dst);
		else
			fprintf(dst,"%d,", c);

		if (++n == 16)
		{
			n = 0;
			fputs("\n", dst);
		}
	}
	
	fprintf(dst,"};\n");

	fclose(src);
	fclose(dst);
	
	return 0;
}
