/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */


#ifndef __parse_util_h
#define __parse_util_h

#ifndef __RCX_Constants_h
#include "RCX_Constants.h"
#endif

class Expr;
class Stmt;
class Clause;
class Condition;
class Symbol;

extern Expr *MakeBinaryExpr(Expr *lhs, int op, Expr *rhs);
extern Expr *MakeUnaryExpr(int op, Expr *arg);
extern Expr *MakeValueExpr(Expr *e);
extern int GetConstantValue(const Expr *e);
extern int GetLValue(const Expr *e);

extern Stmt* MakeCall(Symbol *name, const struct LexLocation &loc);

#endif
