/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __Program_h
#define __Program_h

#ifndef __PListS_h
#include "PListS.h"
#endif

#ifndef __RCX_Constants_h
#include "RCX_Constants.h"
#endif

#ifndef __Scope_h
#include "Scope.h"
#endif

#ifndef __Variable_h
#include "Variable.h"
#endif


class Fragment;
class Function;
class Symbol;
class RCX_Image;
class Stmt;
class BlockStmt;
class VarPool;

class Program : private Context
{
public:
			Program();
			~Program();
			
	int		AddMainTask(Fragment *f);
	int		AddTask(Fragment *f);
	int		AddSubroutine(Fragment *f);

	void	AddFunction(Function *f);
	void	AddInitStmt(Stmt *s);
	
	RCX_Image	*CreateImage(bool targetCM);
	
	// variable allocation, etc.	
	void		SetContext(Context *c)		{ fContext = c; }
	void		DefaultContext()			{ fContext = this; }
	int			CreateVar(Symbol *name);
	int			GetVar(const Symbol *name);
	void		ExclusiveVar()				{ fVarNext = fVarCount; }
	
	// adding tasks and other stuff...
	Fragment*	GetTask(const Symbol *name);
	Fragment*	GetSub(const Symbol *name);
	Function*	GetFunction(const Symbol *name);

	// check all symbols (tasks, variables, etc)
	bool		Defined(const Symbol *name) const;
	
	Scope*		PushScope();
	void		PopScope();	
		
	void		SetInitName(Symbol *name)	{ fInitName = name; }
	
private:
	// Context virtuals
	int			AllocateVar(const Symbol *name);
	int			GetMark() const;
	void		SetMark(int mark);
	
	void		CheckName(const Symbol *name);
	bool		SetMainTask();
	bool		Check(bool targetCM, VarPool &varPool);

	bool		fMainAdded;
	PListS<Fragment>	fTasks;
	PListS<Fragment>	fSubs;
	PListS<Function>	fFunctions;
	
	int			fCounts[2];
	const Symbol*		fVarNames[kRCX_MaxVars];
	int			fVarCount;
	int			fVarNext;
	
	Context*	fContext;
	PListS<Scope>	fScopes;
	Symbol*		fInitName;
	BlockStmt*	fInitStmts;
};


extern Program *gProgram;

#endif
