/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */

#include "Mapping.h"
#include "Expr.h"

Mapping::Mapping(int count)
{
	fCount = count;
	fValues = new Expr*[count];
	fLocals = new int[count];
	
	for(int i=0; i<count; i++)
	{
		fValues[i] = 0;
		fLocals[i] = kIllegalVar;
	}
}

Mapping::~Mapping()
{
	for(int i=0; i<fCount; i++)
		delete fValues[i];
	delete [] fValues;
	delete [] fLocals;
}

const Expr* Mapping::Get(int i) const
{
	if (i >= 0 && i< fCount)
		return fValues[i];
	else
		return 0;
}

int Mapping::GetLocal(int i) const
{
	if (i >= 0 && i< fCount)
		return fLocals[i];
	else
		return kIllegalVar;
}


void Mapping::Set(int i, Expr *e, int local)
{
	if (i >= 0 && i< fCount)
	{
		fValues[i] = e;
		fLocals[i] = local;
	}
}


int Mapping::Translate(int var) const
{
	if (var == kIllegalVar) return kIllegalVar;
	if (!(var & kLocalVarBase)) return var;
	if (var & kLocalReadOnlyFlag) return kIllegalVar;	

	const Expr *e = Get(var & kLocalVarMask);
	if (!e) return kIllegalVar;
	
	return e->GetLValue();	
}
