/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */

#ifndef __Clause_h
#define __Clause_h

#include "parser.h"

#ifndef __Expr_h
#include "Expr.h"
#endif

class Mapping;

class Clause : public AutoFree
{
public:
				Clause(Expr *e, const LexLocation &loc) : fExpr(e), fLocation(loc) {}
				~Clause()	{ delete fExpr; }

	const Expr*	GetExpr() const	{ return fExpr; }
	const LexLocation*	GetLoc() const	{ return &fLocation; }

	RCX_Value	EmitAny(Bytecode &b) const	{ return fExpr->EmitAny(b, &fLocation); }
	bool		EmitTo(Bytecode &b, int dst) const	{ return fExpr->EmitTo(b, dst, &fLocation); }
	RCX_Value	EmitConstrained(Bytecode &b, long mask) const {
					return fExpr->EmitConstrained(b, mask, &fLocation); }
	bool		EmitSide(Bytecode &b) const	{ return fExpr->EmitSide(b, &fLocation); }
	
	Clause*		Clone(Mapping *b) const	{ return new Clause(fExpr->Clone(b), fLocation); }

private:
	Expr*		fExpr;
	LexLocation	fLocation;
};



#endif
