/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.html;

import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.html.StyleSheet;
import com.sun.java.swing.text.html.Utilities;
import java.awt.Color;
import java.util.StringTokenizer;

class StyleXlater {
    public static final String BACKGROUND_COLOR = "background-color";
    public static final String BORDER_TOP = "border-top";
    public static final String BORDER_BOTTOM = "border-bottom";
    public static final String BORDER_LEFT = "border-left";
    public static final String BORDER_RIGHT = "border-right";
    public static final String COLOR = "color";
    public static final String FONT_FAMILY = "font-family";
    public static final String FONT_SIZE = "font-size";
    public static final String FONT_SIZES = "font-sizes";
    public static final String FONT_STYLE = "font-style";
    public static final String FONT_WEIGHT = "font-weight";
    public static final String LIST_STYLE_IMAGE = "list-style-image";
    public static final String LIST_STYLE_TYPE = "list-style-type";
    public static final String MARGIN_TOP = "margin-top";
    public static final String MARGIN_BOTTOM = "margin-bottom";
    public static final String MARGIN_LEFT = "margin-left";
    public static final String MARGIN_RIGHT = "margin-right";
    public static final String TEXT_DECORATION = "text-decoration";
    public static final String TEXT_ALIGN = "text-align";
    public static final String VERTICAL_ALIGN = "vertical-align";

    public static void translateProperty(StyleSheet styleSheet, Style style, String string, String string2) {
        String string3 = Utilities.removeSurroundingQuotes(string2);
        if (string.equalsIgnoreCase(FONT_FAMILY)) {
            if (string3.equalsIgnoreCase("monospace") || string3.equalsIgnoreCase("monospaced") || string3.equalsIgnoreCase("typewriter")) {
                StyleConstants.setFontFamily(style, "Monospaced");
                return;
            }
            StyleConstants.setFontFamily(style, string3);
            return;
        }
        if (string.equalsIgnoreCase(FONT_SIZE)) {
            StyleXlater.setFontSize(string3, style, styleSheet);
            return;
        }
        if (string.equalsIgnoreCase(FONT_WEIGHT)) {
            StyleXlater.setFontStyle(string3, style);
            return;
        }
        if (string.equalsIgnoreCase(FONT_STYLE)) {
            StyleXlater.setFontStyle(string3, style);
            return;
        }
        if (string.equalsIgnoreCase(MARGIN_TOP)) {
            StyleConstants.setSpaceAbove(style, Integer.valueOf(string3).intValue());
            return;
        }
        if (string.equalsIgnoreCase(MARGIN_BOTTOM)) {
            StyleConstants.setSpaceBelow(style, Integer.valueOf(string3).intValue());
            return;
        }
        if (string.equalsIgnoreCase(MARGIN_LEFT)) {
            StyleConstants.setLeftIndent(style, Integer.valueOf(string3).intValue());
            return;
        }
        if (string.equalsIgnoreCase(MARGIN_RIGHT)) {
            StyleConstants.setRightIndent(style, Integer.valueOf(string3).intValue());
            return;
        }
        if (string.equalsIgnoreCase(TEXT_DECORATION)) {
            StyleXlater.setTextDecoration(string3, style);
            return;
        }
        if (string.equalsIgnoreCase(TEXT_ALIGN)) {
            StyleXlater.setTextAlignment(string3, style);
            return;
        }
        if (string.equalsIgnoreCase(COLOR)) {
            StyleXlater.setForegroundColor(string3, style);
            return;
        }
        if (string.equalsIgnoreCase(LIST_STYLE_TYPE) || string.equalsIgnoreCase(LIST_STYLE_IMAGE)) {
            style.addAttribute(string.toLowerCase(), string3);
            return;
        }
        if (string.equalsIgnoreCase(FONT_SIZES)) {
            styleSheet.setFontSizes(string3);
            return;
        }
        style.addAttribute(string.toLowerCase(), string3);
    }

    static String convertFontSizeString(String string) {
        if (string.equalsIgnoreCase("xx-small") || string.equalsIgnoreCase("xxsmall")) {
            return "-3";
        }
        if (string.equalsIgnoreCase("x-small") || string.equalsIgnoreCase("xsmall")) {
            return "-2";
        }
        if (string.equalsIgnoreCase("small")) {
            return "-1";
        }
        if (string.equalsIgnoreCase("medium")) {
            return "+0";
        }
        if (string.equalsIgnoreCase("large")) {
            return "+1";
        }
        if (string.equalsIgnoreCase("x-large") || string.equalsIgnoreCase("xlarge")) {
            return "+2";
        }
        if (string.equalsIgnoreCase("xx-large") || string.equalsIgnoreCase("xxlarge")) {
            return "+3";
        }
        System.out.println("StyleXlater.convertFontSizeString - Warning!  Unimplemented font size value: " + string);
        return "0";
    }

    static void setFontStyle(String string, Style style) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("bold") || string.equals("bolder")) {
            StyleConstants.setBold(style, true);
            return;
        }
        if (string.equalsIgnoreCase("italic")) {
            StyleConstants.setItalic(style, true);
            return;
        }
        if (string.equalsIgnoreCase("typewriter") || string.equalsIgnoreCase("monospace") || string.equalsIgnoreCase("monospaced")) {
            StyleConstants.setFontFamily(style, "Monospaced");
            return;
        }
        if (string.equalsIgnoreCase("bolditalic")) {
            StyleConstants.setBold(style, true);
            StyleConstants.setItalic(style, true);
            return;
        }
        if (!string.equalsIgnoreCase("normal")) {
            boolean bl = string.equalsIgnoreCase("light") || string.equals("lighter") || string.equalsIgnoreCase("oblique");
        }
    }

    static void setTextDecoration(String string, Style style) {
        if (string.equalsIgnoreCase("underline")) {
            StyleConstants.setUnderline(style, true);
        }
    }

    static void setTextAlignment(String string, Style style) {
        if (string.equalsIgnoreCase("left")) {
            StyleConstants.setAlignment(style, 0);
            return;
        }
        if (string.equalsIgnoreCase("center")) {
            StyleConstants.setAlignment(style, 1);
            return;
        }
        if (string.equalsIgnoreCase("right")) {
            StyleConstants.setAlignment(style, 2);
            return;
        }
        if (string.equalsIgnoreCase("justify")) {
            StyleConstants.setAlignment(style, 3);
            return;
        }
        System.out.println("HTMXlater.translateProperty:  Unsupported property value: " + string);
    }

    static void setForegroundColor(String string, Style style) {
        if (string.startsWith("#")) {
            Color color = Utilities.stringToColor(string);
            StyleConstants.setForeground(style, color);
            return;
        }
        if (string.startsWith("rgb") || string.startsWith("RGB")) {
            int n = string.indexOf("(");
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1, string.length() - 1), ", \t \n");
            int n2 = 0;
            int[] nArray = new int[3];
            while (n2 < nArray.length && stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                nArray[n2] = string2.endsWith("%") ? Integer.valueOf(string2.substring(0, string2.length() - 1)) * 255 / 100 : Integer.valueOf(string2);
                ++n2;
            }
            if (n2 == 3) {
                Color color = new Color(nArray[0], nArray[1], nArray[2]);
                StyleConstants.setForeground(style, color);
                return;
            }
        } else {
            Color color = Utilities.stringToColor(string);
            StyleConstants.setForeground(style, color);
        }
    }

    static void setFontSize(String string, Style style, StyleSheet styleSheet) {
        String string2;
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "0123456789");
        if (stringTokenizer.countTokens() == 0) {
            n = Integer.valueOf(string);
            StyleConstants.setFontSize(style, n);
        } else if ((string.startsWith("+") || string.startsWith("-")) && string.endsWith("pt")) {
            System.out.println("StyleXlater.translateAttribute: Unimplemented font-size value " + string);
        } else if (string.toLowerCase().endsWith("pt")) {
            n = Integer.valueOf(string.substring(0, string.length() - 2));
            StyleConstants.setFontSize(style, n);
        } else {
            string2 = StyleXlater.convertFontSizeString(string);
            n = styleSheet.getPtSize(string2);
            StyleConstants.setFontSize(style, n);
        }
        string2 = (String)style.getAttribute(AttributeSet.NameAttribute);
        if (n != 0 && string2 != null && (string2.equals("body") || string2.equals("default"))) {
            styleSheet.setPtSize(n);
        }
    }
}

