/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.Icon;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.View;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class IconView
extends View {
    private Icon c;

    public IconView(Element element) {
        super(element);
        AttributeSet attributeSet = element.getAttributes();
        this.c = StyleConstants.getIcon(attributeSet);
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.c.paintIcon(this.getContainer(), graphics, rectangle.x, rectangle.y);
    }

    public float getPreferredSpan(int n) {
        switch (n) {
            case 0: {
                return this.c.getIconWidth();
            }
            case 1: {
                return this.c.getIconHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float getAlignment(int n) {
        switch (n) {
            case 1: {
                return 1.0f;
            }
        }
        return super.getAlignment(n);
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n >= n2 && n < n3) {
            Rectangle rectangle = new Rectangle(shape.getBounds());
            rectangle.width = 0;
            return rectangle;
        }
        return null;
    }

    public int viewToModel(float f, float f2, Shape shape) {
        shape.getBounds();
        return this.getStartOffset();
    }

    public void setSize(float f, float f2) {
    }
}

